/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LocalRdbmsProperties {
    public static final String DRIVER_PROPERTY = "rdbms.driver";
    public static final String EXTRA_DRIVER_PROPERTIES_PROPERTY = "rdbms.extra.properties";
    public static final String JDBC_CONNECTION_URL_STRING_PROPERTY = "rdbms.url";
    public static final String JDBC_CONNECTION_DATABASE_PROPERTY = "rdbms.database";
    public static final String JDBC_CONNECTION_USER_PROPERTY = "rdbms.user";
    public static final String JDBC_CONNECTION_PASSWORD_PROPERTY = "rdbms.password";
    public static final String HOSTED_CLIENT_FACTORY_PROPERTY = "rdbms.hosted.client.factory";
    private static final String DEFAULT_HOSTED_CLIENT_FACTORY = "com.google.cloud.sql.jdbc.internal.googleapi.GoogleApiClientFactory";
    public static final String HOSTED_DRIVER_JAR_FILE_PROPERTY = "rdbms.hosted.jar.file";
    public static final String HOSTED_INSTANCE_PROPERTY = "rdbms.hosted.instance";
    private final Map<String, String> properties;

    LocalRdbmsProperties(Map<String, String> properties) {
        this.properties = Collections.unmodifiableMap(properties);
    }

    String getDriverClassName() {
        return this.properties.get(DRIVER_PROPERTY);
    }

    String getUrl() {
        return this.properties.get(JDBC_CONNECTION_URL_STRING_PROPERTY);
    }

    String getDatabase() {
        return this.properties.get(JDBC_CONNECTION_DATABASE_PROPERTY);
    }

    String getUser() {
        return this.properties.get(JDBC_CONNECTION_USER_PROPERTY);
    }

    String getPassword() {
        return this.properties.get(JDBC_CONNECTION_PASSWORD_PROPERTY);
    }

    String getHostedClientFactoryClass() {
        String clientFactory = this.properties.get(HOSTED_CLIENT_FACTORY_PROPERTY);
        return clientFactory != null ? clientFactory : DEFAULT_HOSTED_CLIENT_FACTORY;
    }

    Map<String, String> getExtraProperties() {
        String props = this.properties.get(EXTRA_DRIVER_PROPERTIES_PROPERTY);
        if (props == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : props.split(",")) {
            String[] parts = line.split("=", 2);
            if (parts.length != 2) continue;
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    String getHostedInstance(String requestInstanceName) {
        String defaultHostedInstance = this.properties.get(HOSTED_INSTANCE_PROPERTY);
        return defaultHostedInstance != null ? defaultHostedInstance : requestInstanceName;
    }

    public String toString() {
        return this.properties.toString();
    }
}

