/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.dev.LuceneQueryTreeContext;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.query.ParserUtils;
import com.google.appengine.api.search.query.QueryTreeVisitor;
import com.google.appengine.api.search.query.QueryTreeWalker;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import com.google.apphosting.api.search.DocumentPb;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

class LuceneQueryTreeVisitor
implements QueryTreeVisitor<LuceneQueryTreeContext> {
    private final Map<String, Set<DocumentPb.FieldValue.ContentType>> allFieldTypes;
    private final DateFormat dateFormatter;

    public LuceneQueryTreeVisitor(Map<String, Set<DocumentPb.FieldValue.ContentType>> allFieldTypes) {
        this.allFieldTypes = allFieldTypes;
        this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void visitConjunction(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setQuery(this.visitBooleanQueryChildren(new BooleanQuery(), BooleanClause.Occur.MUST, walker, node, context));
    }

    public void visitDisjunction(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setQuery(this.visitBooleanQueryChildren(new BooleanQuery(), BooleanClause.Occur.SHOULD, walker, node, context));
    }

    public void visitNegation(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        BooleanQuery query = new BooleanQuery();
        query.add(LuceneUtils.getMatchAnyDocumentQuery(), BooleanClause.Occur.MUST);
        context.setQuery(this.visitBooleanQueryChildren(query, BooleanClause.Occur.MUST_NOT, walker, node, context));
    }

    private Query visitBooleanQueryChildren(BooleanQuery parentQuery, BooleanClause.Occur occur, QueryTreeWalker<LuceneQueryTreeContext> walker, Tree parentNode, LuceneQueryTreeContext context) {
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            LuceneQueryTreeContext childContext = context.derived();
            walker.walk(parentNode.getChild(i), (Object)childContext);
            parentQuery.add(childContext.getQuery(), occur);
        }
        return parentQuery;
    }

    public void visitRestriction(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        Tree fieldToken = node.getChild(0);
        String fieldName = 11 == fieldToken.getType() ? null : fieldToken.getText();
        context.setFieldName(fieldName);
        walker.walk(node.getChild(1), (Object)context);
    }

    public void visitFuzzy(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setRewritable(true);
        walker.walk(node.getChild(0), (Object)context);
    }

    public void visitLiteral(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setRewritable(false);
        walker.walk(node.getChild(0), (Object)context);
    }

    public void visitLessThan(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setComparisonOp(LuceneQueryTreeContext.ComparisonOp.LT);
        walker.walk(node.getChild(0), (Object)context);
    }

    public void visitLessOrEqual(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setComparisonOp(LuceneQueryTreeContext.ComparisonOp.LE);
        walker.walk(node.getChild(0), (Object)context);
    }

    public void visitGreaterThan(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setComparisonOp(LuceneQueryTreeContext.ComparisonOp.GT);
        walker.walk(node.getChild(0), (Object)context);
    }

    public void visitGreaterOrEqual(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setComparisonOp(LuceneQueryTreeContext.ComparisonOp.GE);
        walker.walk(node.getChild(0), (Object)context);
    }

    public void visitEqual(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setComparisonOp(LuceneQueryTreeContext.ComparisonOp.EQ);
        walker.walk(node.getChild(0), (Object)context);
    }

    public void visitContains(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        context.setComparisonOp(LuceneQueryTreeContext.ComparisonOp.HAS);
        walker.walk(node.getChild(0), (Object)context);
    }

    public void visitValue(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        String textToMatch = node.getChild(1).getText().toLowerCase();
        int tokenType = node.getChild(0).getType();
        if (!context.hasFieldName()) {
            context.setQuery(LuceneQueryTreeVisitor.newTextQuery(context.getComparisonOp(), "_GLOBAL", textToMatch, tokenType));
        } else {
            String fieldName = context.getFieldName();
            Set<DocumentPb.FieldValue.ContentType> typeSet = this.allFieldTypes.get(fieldName);
            if (typeSet == null || typeSet.isEmpty()) {
                context.setQuery(LuceneUtils.getMatchNoneQuery());
            } else if (typeSet.size() == 1) {
                DocumentPb.FieldValue.ContentType fieldType = typeSet.iterator().next();
                fieldName = LuceneUtils.makeLuceneFieldNameWithExtractedText(fieldName, fieldType);
                context.setQuery(this.newQuery(fieldType, fieldName, context.getComparisonOp(), textToMatch, tokenType));
            } else {
                BooleanQuery query = new BooleanQuery();
                for (DocumentPb.FieldValue.ContentType fieldType : typeSet) {
                    if (LuceneQueryTreeVisitor.isTextual(fieldType) && !LuceneQueryTreeContext.ComparisonOp.HAS.equals((Object)context.getComparisonOp()) && !LuceneQueryTreeContext.ComparisonOp.HAS.equals((Object)context.getComparisonOp())) continue;
                    String luceneFieldName = LuceneUtils.makeLuceneFieldNameWithExtractedText(fieldName, fieldType);
                    Query typeMatchQuery = this.newQuery(fieldType, luceneFieldName, context.getComparisonOp(), textToMatch, tokenType);
                    query.add(typeMatchQuery, BooleanClause.Occur.SHOULD);
                }
                context.setQuery(query);
            }
        }
    }

    public void visitOther(QueryTreeWalker<LuceneQueryTreeContext> walker, Tree node, LuceneQueryTreeContext context) {
        throw new IllegalArgumentException("Unhandled tree node " + node);
    }

    private Query newQuery(DocumentPb.FieldValue.ContentType fieldType, String fieldName, LuceneQueryTreeContext.ComparisonOp op, String textToMatch, int tokenType) {
        if (LuceneQueryTreeVisitor.isTextual(fieldType)) {
            return LuceneQueryTreeVisitor.newTextQuery(op, fieldName, textToMatch, tokenType);
        }
        if (DocumentPb.FieldValue.ContentType.NUMBER.equals((Object)fieldType)) {
            return LuceneQueryTreeVisitor.newNumericQuery(fieldName, op, textToMatch);
        }
        if (DocumentPb.FieldValue.ContentType.DATE.equals((Object)fieldType)) {
            return this.newDateQuery(fieldName, op, textToMatch);
        }
        throw new SearchQueryException("Unknown field type " + fieldType.name());
    }

    private static Query newNumericQuery(String fieldName, LuceneQueryTreeContext.ComparisonOp op, String textToMatch) {
        try {
            double value = Double.parseDouble(textToMatch);
            boolean minInclusive = true;
            boolean maxInclusive = true;
            double min = value;
            double max = value;
            switch (op) {
                case EQ: 
                case HAS: {
                    break;
                }
                case LT: {
                    maxInclusive = false;
                    min = Double.MIN_VALUE;
                    break;
                }
                case LE: {
                    maxInclusive = true;
                    min = Double.MIN_VALUE;
                    break;
                }
                case GT: {
                    minInclusive = false;
                    max = Double.MAX_VALUE;
                    break;
                }
                case GE: {
                    minInclusive = true;
                    max = Double.MAX_VALUE;
                    break;
                }
                default: {
                    return LuceneUtils.getMatchNoneQuery();
                }
            }
            return NumericRangeQuery.newDoubleRange(fieldName, min, max, minInclusive, maxInclusive);
        }
        catch (NumberFormatException e) {
            throw new SearchQueryException(textToMatch);
        }
    }

    private Query newDateQuery(String fieldName, LuceneQueryTreeContext.ComparisonOp op, String textToMatch) {
        long time;
        try {
            time = this.dateFormatter.parse(textToMatch).getTime();
        }
        catch (ParseException e) {
            throw new SearchQueryException("Could not parse date");
        }
        boolean minInclusive = true;
        boolean maxInclusive = true;
        long min = time;
        long max = time;
        switch (op) {
            case EQ: 
            case HAS: {
                break;
            }
            case LT: {
                maxInclusive = false;
                min = Long.MIN_VALUE;
                break;
            }
            case LE: {
                maxInclusive = true;
                min = Long.MIN_VALUE;
                break;
            }
            case GT: {
                minInclusive = false;
                max = Long.MAX_VALUE;
                break;
            }
            case GE: {
                minInclusive = true;
                max = Long.MAX_VALUE;
                break;
            }
            default: {
                return LuceneUtils.getMatchNoneQuery();
            }
        }
        return NumericRangeQuery.newLongRange(fieldName, min, max, minInclusive, maxInclusive);
    }

    private static Query newTextQuery(LuceneQueryTreeContext.ComparisonOp op, String fieldName, String textToMatch, int valueType) {
        switch (op) {
            case EQ: 
            case HAS: {
                return LuceneQueryTreeVisitor.newTextMatchQuery(fieldName, textToMatch, valueType);
            }
            case NE: {
                BooleanQuery boolQuery = new BooleanQuery();
                boolQuery.add(LuceneUtils.getMatchAnyDocumentQuery(), BooleanClause.Occur.MUST);
                boolQuery.add(LuceneQueryTreeVisitor.newTextMatchQuery(fieldName, textToMatch, valueType), BooleanClause.Occur.MUST_NOT);
                return boolQuery;
            }
        }
        return LuceneUtils.getMatchNoneQuery();
    }

    private static Query newTextMatchQuery(String fieldName, String textToMatch, int valueType) {
        if (valueType != 14) {
            return new TermQuery(new Term(fieldName, textToMatch));
        }
        textToMatch = ParserUtils.normalizePhrase((String)textToMatch);
        PhraseQuery phraseQuery = new PhraseQuery();
        StringTokenizer st = new StringTokenizer(textToMatch);
        while (st.hasMoreTokens()) {
            phraseQuery.add(new Term(fieldName, st.nextToken()));
        }
        return phraseQuery;
    }

    private static boolean isTextual(DocumentPb.FieldValue.ContentType type) {
        return DocumentPb.FieldValue.ContentType.TEXT.equals((Object)type) || DocumentPb.FieldValue.ContentType.ATOM.equals((Object)type) || DocumentPb.FieldValue.ContentType.HTML.equals((Object)type);
    }
}

