/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class FieldExpression
extends NumericExpression {
    private final Map<DocumentPb.FieldValue.ContentType, String> luceneFields;
    private final List<DocumentPb.FieldValue.ContentType> typePriority;
    private final List<DocumentPb.FieldValue.ContentType> typePriorityWithoutNumeric;
    private final boolean hasNumericFields;

    public FieldExpression(String fieldName, Set<DocumentPb.FieldValue.ContentType> fieldTypes) {
        this.luceneFields = new HashMap<DocumentPb.FieldValue.ContentType, String>(fieldTypes.size());
        this.typePriority = new ArrayList<DocumentPb.FieldValue.ContentType>(fieldTypes.size());
        this.typePriorityWithoutNumeric = new ArrayList<DocumentPb.FieldValue.ContentType>(fieldTypes.size());
        for (DocumentPb.FieldValue.ContentType type : fieldTypes) {
            this.luceneFields.put(type, LuceneUtils.makeLuceneFieldName(fieldName, type));
        }
        for (DocumentPb.FieldValue.ContentType type : new DocumentPb.FieldValue.ContentType[]{DocumentPb.FieldValue.ContentType.NUMBER, DocumentPb.FieldValue.ContentType.DATE, DocumentPb.FieldValue.ContentType.TEXT, DocumentPb.FieldValue.ContentType.HTML, DocumentPb.FieldValue.ContentType.ATOM}) {
            if (!fieldTypes.contains(type)) continue;
            this.typePriority.add(type);
        }
        for (DocumentPb.FieldValue.ContentType type : new DocumentPb.FieldValue.ContentType[]{DocumentPb.FieldValue.ContentType.DATE, DocumentPb.FieldValue.ContentType.TEXT, DocumentPb.FieldValue.ContentType.HTML, DocumentPb.FieldValue.ContentType.ATOM}) {
            if (!fieldTypes.contains(type)) continue;
            this.typePriorityWithoutNumeric.add(type);
        }
        this.hasNumericFields = fieldTypes.contains(DocumentPb.FieldValue.ContentType.NUMBER);
    }

    public static FieldExpression makeFieldExpression(String fieldName, Set<DocumentPb.FieldValue.ContentType> fieldTypes) {
        if (fieldTypes == null) {
            throw new IllegalArgumentException("Unknown field:" + fieldName);
        }
        return new FieldExpression(fieldName, fieldTypes);
    }

    @Override
    public double evalDouble(Document doc) throws EvaluationException {
        String luceneFieldName = this.luceneFields.get(DocumentPb.FieldValue.ContentType.NUMBER);
        if (luceneFieldName == null) {
            throw new EvaluationException("incorrect field type");
        }
        Field[] fields = doc.getFields(luceneFieldName);
        if (fields.length == 0) {
            throw new EvaluationException("numeric field was not found");
        }
        return LuceneUtils.numericFieldToDouble(fields[0]);
    }

    @Override
    public DocumentPb.FieldValue eval(Document doc) throws EvaluationException {
        return this.evalWithTypePriority(doc, this.typePriority);
    }

    public DocumentPb.FieldValue evalWithTypePriority(Document doc, List<DocumentPb.FieldValue.ContentType> typePriority) throws EvaluationException {
        for (DocumentPb.FieldValue.ContentType type : typePriority) {
            String fieldName = this.luceneFields.get(type);
            Field[] fields = doc.getFields(fieldName);
            if (fields.length == 0) continue;
            return FieldExpression.makeValue(type, String.valueOf(LuceneUtils.luceneFieldToValue(fields[0], type)));
        }
        throw new EvaluationException("field was not found");
    }

    void checkType(DocumentPb.FieldValue.ContentType type) {
        if (this.luceneFields.get(type) == null) {
            throw new IllegalArgumentException("Field type mismatch");
        }
    }

    @Override
    public List<Expression.Sorter> getSorters(final int sign, double defaultValueNumeric, final String defaultValueText) {
        ArrayList<Expression.Sorter> sorters = new ArrayList<Expression.Sorter>(1);
        if (this.hasNumericFields) {
            sorters.add(this.getNumericSorter(sign, defaultValueNumeric));
        }
        if (!this.typePriorityWithoutNumeric.isEmpty()) {
            sorters.add(new Expression.Sorter(){

                @Override
                public Object eval(Document doc) {
                    try {
                        return FieldExpression.this.evalWithTypePriority(doc, FieldExpression.this.typePriorityWithoutNumeric).getStringValue();
                    }
                    catch (EvaluationException e) {
                        return defaultValueText;
                    }
                }

                @Override
                public int compare(Object left, Object right) {
                    String leftString = (String)left;
                    String rightString = (String)right;
                    return sign * leftString.compareToIgnoreCase(rightString);
                }
            });
        }
        return sorters;
    }
}

