/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.ExpressionBuilder;
import com.google.appengine.api.search.dev.FieldGenerator;
import com.google.appengine.api.search.dev.LuceneDirectoryMap;
import com.google.appengine.api.search.dev.LuceneQueryBuilder;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.Scorer;
import com.google.appengine.api.search.dev.WordSeparatorAnalyzer;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.search.DocumentPb;
import com.google.apphosting.utils.config.GenerationDirectory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

@ServiceProvider(value=LocalRpcService.class)
public class LocalSearchService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "search";
    public static final String USE_RAM_DIRECTORY = "LocalSearchService.useRamDirectory";
    static final Logger LOG = Logger.getLogger(LocalSearchService.class.getCanonicalName());
    public static final String SEARCH_LOG_LEVEL_PROPERTY = "LocalSearchService.LogLevel";
    private static final Level DEFAULT_LOG_LEVEL = Level.INFO;
    private static final Version VERSION = Version.LUCENE_29;
    private static final IndexWriter.MaxFieldLength MAX_FIELD_LENGTH = IndexWriter.MaxFieldLength.LIMITED;
    private LuceneDirectoryMap dirMap;
    private final Analyzer analyzer = new WordSeparatorAnalyzer();
    private static Map<Directory, IndexWriter> indexWriters = new HashMap<Directory, IndexWriter>();

    public LocalSearchService() {
        LOG.info("Local search service created");
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String logLevelStr = properties.get(SEARCH_LOG_LEVEL_PROPERTY);
        if (logLevelStr != null) {
            LOG.setLevel(Level.parse(logLevelStr));
        } else {
            LOG.setLevel(DEFAULT_LOG_LEVEL);
        }
        if ("true".equals(properties.get(USE_RAM_DIRECTORY))) {
            LOG.warning("Using RAM directory; results are not preserved");
            this.dirMap = new LuceneDirectoryMap.RamBased();
        } else {
            File dir = GenerationDirectory.getGenerationDirectory((File)context.getLocalServerEnvironment().getAppDir());
            dir.mkdirs();
            if (dir.exists()) {
                this.dirMap = new LuceneDirectoryMap.FileBased(new File(dir.getAbsolutePath(), "indexes"));
            } else {
                LOG.warning("Failed to create data directory, using RAM directory instead; results are not preserved");
                this.dirMap = new LuceneDirectoryMap.RamBased();
            }
        }
        LOG.info(this.getPackage() + " initialized");
    }

    public void start() {
        LOG.info(this.getPackage() + " started");
    }

    public void stop() {
        for (IndexWriter writer : indexWriters.values()) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close index writer", e);
            }
        }
        if (this.dirMap != null) {
            try {
                this.dirMap.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close local directory", e);
            }
        }
        LOG.info(this.getPackage() + " stopped");
    }

    public SearchServicePb.IndexDocumentResponse indexDocument(LocalRpcService.Status status, SearchServicePb.IndexDocumentRequest req) {
        IndexWriter indexWriter;
        SearchServicePb.IndexDocumentResponse.Builder respBuilder = SearchServicePb.IndexDocumentResponse.newBuilder();
        SearchServicePb.IndexDocumentParams indexDocumentParams = req.getParams();
        int docsToIndex = indexDocumentParams.getDocumentCount();
        if (this.dirMap == null) {
            LOG.severe("Index documents called before local search service was initialized");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToIndex, SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        String appId = LocalSearchService.getAppId();
        try {
            indexWriter = this.getIndexWriter(this.dirMap.getDirectory(appId, indexDocumentParams.getIndexSpec()), true);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to access index", e);
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToIndex, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
        for (DocumentPb.Document d : indexDocumentParams.getDocumentList()) {
            try {
                String id = d.getId();
                if (Util.isNullOrEmpty((String)d.getId())) {
                    id = UUID.randomUUID().toString();
                    respBuilder.addDocId(id);
                } else {
                    respBuilder.addDocId(d.getId());
                }
                Document doc = LuceneUtils.toLuceneDocument(id, d);
                indexWriter.updateDocument(new Term("_DOCID", id), doc);
                respBuilder.addStatus(SearchServicePb.RequestStatus.newBuilder().setCode(SearchServicePb.SearchServiceError.ErrorCode.OK));
            }
            catch (IOException e) {
                respBuilder.addStatus(SearchServicePb.RequestStatus.newBuilder().setCode(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR));
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            try {
                LOG.fine(String.format("Added %d documents. Index %s holds %d documents", indexDocumentParams.getDocumentCount(), indexDocumentParams.getIndexSpec().getName(), indexWriter.numDocs()));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.commitChangesToIndexWriter(indexWriter);
        return respBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchServicePb.DeleteDocumentResponse deleteDocument(LocalRpcService.Status status, SearchServicePb.DeleteDocumentRequest req) {
        SearchServicePb.DeleteDocumentResponse.Builder respBuilder = SearchServicePb.DeleteDocumentResponse.newBuilder();
        SearchServicePb.DeleteDocumentParams deleteParams = req.getParams();
        int docsToDelete = deleteParams.getDocIdCount();
        if (this.dirMap == null) {
            LOG.severe("Delete documents called before local search service was initialized");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        if (docsToDelete <= 0) {
            LOG.info("Request to delete 0 documents; ignoring");
            return respBuilder.build();
        }
        String appId = LocalSearchService.getAppId();
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.getIndexWriter(this.dirMap.getDirectory(appId, deleteParams.getIndexSpec()), false);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to access index directory", e);
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
        if (indexWriter == null) {
            LOG.info("Request to delete documents from non-existing index; ignoring");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.OK)).build();
        }
        Term[] deleteTerms = new Term[docsToDelete];
        int termIndex = 0;
        for (String docId : deleteParams.getDocIdList()) {
            deleteTerms[termIndex++] = LuceneUtils.newDeleteTerm(docId);
        }
        try {
            indexWriter.deleteDocuments(deleteTerms);
            SearchServicePb.DeleteDocumentResponse i$ = respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.OK)).build();
            return i$;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to delete documents", e);
            SearchServicePb.DeleteDocumentResponse deleteDocumentResponse = respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
            return deleteDocumentResponse;
        }
        finally {
            this.commitChangesToIndexWriter(indexWriter);
        }
    }

    public SearchServicePb.ListIndexesResponse listIndexes(LocalRpcService.Status status, SearchServicePb.ListIndexesRequest req) {
        SearchServicePb.ListIndexesResponse.Builder respBuilder = SearchServicePb.ListIndexesResponse.newBuilder();
        if (this.dirMap == null) {
            LOG.severe("List indexes called before local search service was initialized");
            return respBuilder.setStatus(LocalSearchService.newStatus(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        List<SearchServicePb.IndexMetadata.Builder> indexMetadatas = this.dirMap.listIndexes(LocalSearchService.getAppId(), req.getParams());
        for (SearchServicePb.IndexMetadata.Builder builder : indexMetadatas) {
            if (req.getParams().getFetchSchema()) {
                try {
                    Map<String, Set<DocumentPb.FieldValue.ContentType>> schema = this.getFieldTypes(this.dirMap.getDirectory(LocalSearchService.getAppId(), builder.getIndexSpec()));
                    for (String fieldName : schema.keySet()) {
                        builder.addField(DocumentPb.FieldTypes.newBuilder().setName(fieldName).addAllType((Iterable)schema.get(fieldName)));
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Unable to access index to retrieve schema", e);
                }
            }
            respBuilder.addIndexMetadata(builder);
        }
        return respBuilder.setStatus(LocalSearchService.newStatus(SearchServicePb.SearchServiceError.ErrorCode.OK)).build();
    }

    public SearchServicePb.ListDocumentsResponse listDocuments(LocalRpcService.Status status, SearchServicePb.ListDocumentsRequest req) {
        SearchServicePb.ListDocumentsResponse.Builder respBuilder = SearchServicePb.ListDocumentsResponse.newBuilder();
        if (this.dirMap == null) {
            LOG.severe("listDocuments called before local search service was initialized");
            return respBuilder.setStatus(LocalSearchService.newStatus(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        SearchServicePb.ListDocumentsParams params = req.getParams();
        IndexSearcher indexSearcher = null;
        try {
            String appId = LocalSearchService.getAppId();
            Directory directory = this.dirMap.getDirectory(appId, params.getIndexSpec());
            indexSearcher = new IndexSearcher(directory, true);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to access index", e);
            return respBuilder.setStatus(LocalSearchService.newStatus(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
        if (indexSearcher == null) {
            LOG.info("Operation on an empty or non-existing index; ignoring");
            return respBuilder.setStatus(LocalSearchService.newStatus(SearchServicePb.SearchServiceError.ErrorCode.OK)).build();
        }
        try {
            TopFieldDocs topDocs = indexSearcher.search(new TermRangeQuery("_DOCID", params.getStartDocId(), Character.toString('\u007f'), params.getIncludeStartDoc(), true), null, params.getLimit(), new Sort(new SortField("_DOCID", 11)));
            if (params.getKeysOnly()) {
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    respBuilder.addDocument(LuceneUtils.toAppengineDocumentId(indexSearcher.doc(scoreDoc.doc)));
                }
            } else {
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    respBuilder.addDocument(LuceneUtils.toAppengineDocument(indexSearcher.doc(scoreDoc.doc)));
                }
            }
            respBuilder.setStatus(LocalSearchService.newStatus(SearchServicePb.SearchServiceError.ErrorCode.OK));
            return respBuilder.build();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to list documents", e);
            return respBuilder.setStatus(LocalSearchService.newStatus(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchServicePb.SearchResponse search(LocalRpcService.Status status, SearchServicePb.SearchRequest req) {
        SearchServicePb.SearchResponse searchResponse;
        SearchServicePb.SearchResponse.Builder respBuilder = SearchServicePb.SearchResponse.newBuilder();
        if (this.dirMap == null) {
            LOG.severe("Search called before local search service was initialized");
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, respBuilder);
        }
        SearchServicePb.SearchParams searchParams = req.getParams();
        IndexSearcher indexSearcher = null;
        Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes = null;
        try {
            String appId = LocalSearchService.getAppId();
            Directory directory = this.dirMap.getDirectory(appId, searchParams.getIndexSpec());
            if (IndexReader.indexExists(directory)) {
                fieldTypes = this.getFieldTypes(directory);
                indexSearcher = new IndexSearcher(directory, true);
                indexSearcher.setDefaultFieldSortScoring(true, false);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to access index", e);
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, respBuilder);
        }
        if (indexSearcher == null) {
            LOG.info("Search on an empty or non-existing index; ignoring");
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.OK, respBuilder);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Index %s holds %d documents", searchParams.getIndexSpec().getName(), indexSearcher.getIndexReader().numDocs()));
        }
        try {
            int offset;
            Query q = new LuceneQueryBuilder(fieldTypes).parse(searchParams.getQuery());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Query " + searchParams.getQuery() + " translated to " + q.toString());
            }
            if ((offset = LocalSearchService.getOffset(searchParams)) == -1) {
                LOG.severe("Unable to extract valid offset " + searchParams.getCursor());
                SearchServicePb.SearchResponse searchResponse2 = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, respBuilder);
                return searchResponse2;
            }
            List<FieldGenerator> fieldGenerators = LocalSearchService.createFieldGenerators(searchParams, fieldTypes);
            Scorer scorer = Scorer.newInstance(searchParams, fieldTypes);
            Set<String> fieldFilter = LocalSearchService.createFilter(searchParams);
            int limit = searchParams.getLimit();
            Scorer.SearchResults results = scorer.search(indexSearcher, q, offset, limit);
            DocumentPb.FieldValue defaultExpressionValue = Expression.makeValue(DocumentPb.FieldValue.ContentType.TEXT, "");
            int docIndex = offset;
            for (Scorer.Result result : results.results) {
                SearchServicePb.SearchResult.Builder resultBuilder = SearchServicePb.SearchResult.newBuilder();
                DocumentPb.Document fullDoc = LuceneUtils.toAppengineDocument(result.doc);
                for (FieldGenerator fieldGenerator : fieldGenerators) {
                    DocumentPb.FieldValue fieldValue = defaultExpressionValue;
                    try {
                        fieldValue = fieldGenerator.getExpression().eval(result.doc);
                    }
                    catch (EvaluationException e) {
                        // empty catch block
                    }
                    resultBuilder.addExpression(DocumentPb.Field.newBuilder().setName(fieldGenerator.getName()).setValue(fieldValue));
                }
                result.addScores(resultBuilder);
                resultBuilder.setDocument(LocalSearchService.filterDocument(fullDoc, fieldFilter));
                if (SearchServicePb.SearchParams.CursorType.PER_RESULT.equals((Object)searchParams.getCursorType())) {
                    resultBuilder.setCursor(Integer.toString(docIndex + 1));
                }
                respBuilder.addResult(resultBuilder);
                ++docIndex;
            }
            respBuilder.setStatus(LocalSearchService.newStatus(SearchServicePb.SearchServiceError.ErrorCode.OK)).setMatchedCount((long)results.totalHits);
            if (SearchServicePb.SearchParams.CursorType.SINGLE.equals((Object)searchParams.getCursorType()) && results.totalHits > limit) {
                respBuilder.setCursor(Integer.toString(offset + limit));
            }
            SearchServicePb.SearchResponse searchResponse3 = respBuilder.build();
            return searchResponse3;
        }
        catch (SearchQueryException e) {
            LOG.log(Level.SEVERE, "Failed to parse query", e);
            searchResponse = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, respBuilder);
            return searchResponse;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to execute search", e);
            searchResponse = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, respBuilder);
            return searchResponse;
        }
        finally {
            LocalSearchService.closeIndexSearcher(indexSearcher);
        }
    }

    private SearchServicePb.SearchResponse replyWith(SearchServicePb.SearchServiceError.ErrorCode code, SearchServicePb.SearchResponse.Builder respBuilder) {
        return respBuilder.setStatus(LocalSearchService.newStatus(code)).setMatchedCount(0L).build();
    }

    private static void closeIndexSearcher(IndexSearcher indexSearcher) {
        if (indexSearcher != null) {
            try {
                indexSearcher.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close index searcher", e);
            }
        }
    }

    private Map<String, Set<DocumentPb.FieldValue.ContentType>> getFieldTypes(Directory directory) {
        IndexReader reader;
        TreeMap<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes = new TreeMap<String, Set<DocumentPb.FieldValue.ContentType>>();
        try {
            reader = IndexReader.open(directory, true);
        }
        catch (CorruptIndexException e) {
            LOG.log(Level.SEVERE, "Failed to read index", e);
            return fieldTypes;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to read index", e);
            return fieldTypes;
        }
        Collection fields = reader.getFieldNames(IndexReader.FieldOption.ALL);
        for (Object o : fields) {
            LuceneUtils.LuceneFieldName fieldName;
            String f = (String)o;
            if (f.startsWith("_") || (fieldName = LuceneUtils.splitLuceneFieldName(f)) == null) continue;
            TreeSet<DocumentPb.FieldValue.ContentType> types = (TreeSet<DocumentPb.FieldValue.ContentType>)fieldTypes.get(fieldName.name);
            if (types == null) {
                types = new TreeSet<DocumentPb.FieldValue.ContentType>();
                fieldTypes.put(fieldName.name, types);
            }
            types.add(fieldName.type);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to close index reader", e);
        }
        return fieldTypes;
    }

    private static Iterable<SearchServicePb.RequestStatus> newRepeatedStatus(int count, SearchServicePb.SearchServiceError.ErrorCode errorCode) {
        ArrayList<SearchServicePb.RequestStatus> statusList = new ArrayList<SearchServicePb.RequestStatus>();
        for (int i = 0; i < count; ++i) {
            statusList.add(LocalSearchService.newStatus(errorCode));
        }
        return statusList;
    }

    private static SearchServicePb.RequestStatus newStatus(SearchServicePb.SearchServiceError.ErrorCode errorCode) {
        return SearchServicePb.RequestStatus.newBuilder().setCode(errorCode).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter(Directory directory, boolean createIfNotPresent) throws IOException {
        Map<Directory, IndexWriter> map = indexWriters;
        synchronized (map) {
            IndexWriter writer = indexWriters.get(directory);
            if (writer != null) {
                return writer;
            }
            if (IndexReader.indexExists(directory)) {
                writer = new IndexWriter(directory, this.analyzer, false, MAX_FIELD_LENGTH);
            } else {
                if (!createIfNotPresent) {
                    return null;
                }
                writer = new IndexWriter(directory, this.analyzer, true, MAX_FIELD_LENGTH);
            }
            indexWriters.put(directory, writer);
            return writer;
        }
    }

    private void commitChangesToIndexWriter(IndexWriter indexWriter) {
        if (indexWriter != null) {
            try {
                indexWriter.commit();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to commit changes to an index", e);
            }
        }
    }

    private static int getOffset(SearchServicePb.SearchParams searchParams) {
        if (searchParams.hasOffset() && searchParams.hasCursor()) {
            LOG.severe("Both offset and cursor are set");
            return -1;
        }
        if (searchParams.hasOffset()) {
            return searchParams.getOffset();
        }
        if (!searchParams.hasCursor()) {
            return 0;
        }
        try {
            return Integer.parseInt(searchParams.getCursor());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static Set<String> createFilter(SearchServicePb.SearchParams searchParams) {
        if (searchParams.getKeysOnly()) {
            return new HashSet<String>();
        }
        if (!searchParams.hasFieldSpec() || searchParams.getFieldSpec().getNameList().isEmpty()) {
            return null;
        }
        return new HashSet<String>(searchParams.getFieldSpec().getNameList());
    }

    private static DocumentPb.Document filterDocument(DocumentPb.Document fullDoc, Set<String> fieldFilter) {
        if (fieldFilter == null) {
            return fullDoc;
        }
        DocumentPb.Document.Builder docBuilder = DocumentPb.Document.newBuilder();
        docBuilder.setId(fullDoc.getId());
        for (DocumentPb.Field field : fullDoc.getFieldList()) {
            if (!fieldFilter.contains(field.getName())) continue;
            docBuilder.addField(field);
        }
        return docBuilder.build();
    }

    private static List<FieldGenerator> createFieldGenerators(SearchServicePb.SearchParams searchParams, Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        ExpressionBuilder exprBuilder = new ExpressionBuilder(fieldTypes);
        ArrayList<FieldGenerator> fieldGenerators = new ArrayList<FieldGenerator>();
        for (SearchServicePb.FieldSpec.Expression exprSpec : searchParams.getFieldSpec().getExpressionList()) {
            Expression expr = exprBuilder.parse(exprSpec.getExpression());
            fieldGenerators.add(new FieldGenerator(exprSpec.getName(), expr));
        }
        return fieldGenerators;
    }

    private static String getAppId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            LOG.severe("Unable to retrieve information about the calling application. Aborting!");
            throw new ApiProxy.ApiProxyException("Failed to access application environment");
        }
        String appId = environment.getAppId();
        if (appId == null) {
            LOG.severe("Unable to read application ID. Aborting!");
            throw new ApiProxy.ApplicationException(3, "Failed to retrieve application ID");
        }
        return appId;
    }
}

