/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.impl.nio.ssl;

import com.google.appengine.repackaged.org.apache.http.HttpResponseFactory;
import com.google.appengine.repackaged.org.apache.http.impl.DefaultHttpResponseFactory;
import com.google.appengine.repackaged.org.apache.http.impl.nio.DefaultNHttpClientConnection;
import com.google.appengine.repackaged.org.apache.http.impl.nio.reactor.SSLIOSession;
import com.google.appengine.repackaged.org.apache.http.impl.nio.reactor.SSLMode;
import com.google.appengine.repackaged.org.apache.http.impl.nio.reactor.SSLSetupHandler;
import com.google.appengine.repackaged.org.apache.http.nio.NHttpClientConnection;
import com.google.appengine.repackaged.org.apache.http.nio.NHttpClientHandler;
import com.google.appengine.repackaged.org.apache.http.nio.NHttpClientIOTarget;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.IOEventDispatch;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.IOSession;
import com.google.appengine.repackaged.org.apache.http.nio.util.ByteBufferAllocator;
import com.google.appengine.repackaged.org.apache.http.nio.util.HeapByteBufferAllocator;
import com.google.appengine.repackaged.org.apache.http.params.HttpParams;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

public class SSLClientIOEventDispatch
implements IOEventDispatch {
    private static final String SSL_SESSION = "http.nio.ssl-session";
    private final NHttpClientHandler handler;
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final HttpParams params;

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (sslcontext == null) {
            throw new IllegalArgumentException("SSL context may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.handler = handler;
        this.params = params;
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
    }

    public SSLClientIOEventDispatch(NHttpClientHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    protected ByteBufferAllocator createByteBufferAllocator() {
        return new HeapByteBufferAllocator();
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return new DefaultHttpResponseFactory();
    }

    protected NHttpClientIOTarget createConnection(IOSession session) {
        return new DefaultNHttpClientConnection(session, this.createHttpResponseFactory(), this.createByteBufferAllocator(), this.params);
    }

    protected SSLIOSession createSSLIOSession(IOSession session, SSLContext sslcontext, SSLSetupHandler sslHandler) {
        return new SSLIOSession(session, sslcontext, sslHandler);
    }

    public void connected(IOSession session) {
        SSLIOSession sslSession = this.createSSLIOSession(session, this.sslcontext, this.sslHandler);
        NHttpClientIOTarget conn = this.createConnection(sslSession);
        session.setAttribute("http.connection", conn);
        session.setAttribute(SSL_SESSION, sslSession);
        Object attachment = session.getAttribute("http.session.attachment");
        this.handler.connected(conn, attachment);
        try {
            sslSession.bind(SSLMode.CLIENT, this.params);
        }
        catch (SSLException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    public void disconnected(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        if (conn != null) {
            this.handler.closed(conn);
        }
    }

    private void ensureNotNull(NHttpClientIOTarget conn) {
        if (conn == null) {
            throw new IllegalStateException("HTTP connection is null");
        }
    }

    private void ensureNotNull(SSLIOSession ssliosession) {
        if (ssliosession == null) {
            throw new IllegalStateException("SSL I/O session is null");
        }
    }

    public void inputReady(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.ensureNotNull(sslSession);
        try {
            if (sslSession.isAppInputReady()) {
                conn.consumeInput(this.handler);
            }
            sslSession.inboundTransport();
        }
        catch (IOException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    public void outputReady(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.ensureNotNull(sslSession);
        try {
            if (sslSession.isAppOutputReady()) {
                conn.produceOutput(this.handler);
            }
            sslSession.outboundTransport();
        }
        catch (IOException ex) {
            this.handler.exception((NHttpClientConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.ensureNotNull(sslSession);
        this.handler.timeout(conn);
        SSLIOSession sSLIOSession = sslSession;
        synchronized (sSLIOSession) {
            if (sslSession.isOutboundDone() && !sslSession.isInboundDone()) {
                sslSession.shutdown();
            }
        }
    }
}

