/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.CreationCostAnalysis;
import com.google.appengine.api.datastore.dev.DefaultHighRepJobPolicy;
import com.google.appengine.api.datastore.dev.EntityGroupPseudoKind;
import com.google.appengine.api.datastore.dev.HighRepJobPolicy;
import com.google.appengine.api.datastore.dev.KindPseudoKind;
import com.google.appengine.api.datastore.dev.LocalCompositeIndexManager;
import com.google.appengine.api.datastore.dev.LocalDatastoreCostAnalysis;
import com.google.appengine.api.datastore.dev.LocalDatastoreJob;
import com.google.appengine.api.datastore.dev.LocalFullTextIndex;
import com.google.appengine.api.datastore.dev.NamespacePseudoKind;
import com.google.appengine.api.datastore.dev.PropertyPseudoKind;
import com.google.appengine.api.datastore.dev.PseudoKinds;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.appengine.api.datastore.dev.WriteLatencyAdjuster;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalDatastoreService
extends AbstractLocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalDatastoreService.class.getName());
    static final int DEFAULT_BATCH_SIZE = 20;
    public static final int MAXIMUM_RESULTS_SIZE = 300;
    public static final String PACKAGE = "datastore_v3";
    public static final String MAX_QUERY_LIFETIME_PROPERTY = "datastore.max_query_lifetime";
    private static final int DEFAULT_MAX_QUERY_LIFETIME = 30000;
    public static final String MAX_TRANSACTION_LIFETIME_PROPERTY = "datastore.max_txn_lifetime";
    private static final int DEFAULT_MAX_TRANSACTION_LIFETIME = 300000;
    public static final String STORE_DELAY_PROPERTY = "datastore.store_delay";
    static final int DEFAULT_STORE_DELAY_MS = 30000;
    static final int MAX_STRING_LENGTH = 500;
    static final int MAX_LINK_LENGTH = 2038;
    public static final int MAX_EG_PER_TXN = 5;
    public static final String BACKING_STORE_PROPERTY = "datastore.backing_store";
    private static final long CURRENT_STORAGE_VERSION = 1L;
    public static final String NO_INDEX_AUTO_GEN_PROP = "datastore.no_index_auto_gen";
    public static final String NO_STORAGE_PROPERTY = "datastore.no_storage";
    public static final String HIGH_REP_JOB_POLICY_CLASS_PROPERTY = "datastore.high_replication_job_policy_class";
    private static final Pattern RESERVED_NAME = Pattern.compile("^__.*__$");
    private static final Set<String> RESERVED_NAME_WHITELIST = new HashSet<String>(Arrays.asList("__BlobUploadSession__", "__BlobInfo__", "__ProspectiveSearchSubscriptions__", "__BlobFileIndex__", "__GsFileInfo__", "__BlobServingUrl__"));
    static final String ENTITY_GROUP_MESSAGE = "cross-group transaction need to be explicitly specified, see TransactionOptions.Builder.withXG";
    static final String TOO_MANY_ENTITY_GROUP_MESSAGE = "operating on too many entity groups in a single transaction.";
    static final String MULTI_EG_TXN_NOT_ALLOWED = "transactions on multiple entity groups only allowed in High Replication applications";
    static final String CONTENTION_MESSAGE = "too much contention on these datastore entities. please try again.";
    static final String TRANSACTION_CLOSED = "transaction closed";
    static final String TRANSACTION_NOT_FOUND = "transaction has expired or is invalid";
    static final String NAME_TOO_LONG = "name in key path element must be under 500 characters";
    static final String QUERY_NOT_FOUND = "query has expired or is invalid. Please restart it with the last cursor to read more results.";
    private static final long SCATTERED_ID_BIT = 0x4000000000000000L;
    private static final long MAX_SCATTERED_ID_COUNTER = 0x2000000000000000L;
    public static final String AUTO_ID_ALLOCATION_POLICY_PROPERTY = "datastore.auto_id_allocation_policy";
    private final AtomicLong entityIdSequential = new AtomicLong(1L);
    private final AtomicLong entityIdScattered = new AtomicLong(1L);
    private AutoIdAllocationPolicy autoIdAllocationPolicy = AutoIdAllocationPolicy.SEQUENTIAL;
    private final AtomicLong queryId = new AtomicLong(0L);
    private String backingStore;
    private Map<String, Profile> profiles = Collections.synchronizedMap(new HashMap());
    private Map<String, SpecialProperty> specialPropertyMap = Maps.newHashMap();
    private Clock clock;
    private static final long MAX_BATCH_GET_KEYS = 1000000000L;
    private static final long MAX_ACTIONS_PER_TXN = 5L;
    private int maxQueryLifetimeMs;
    private int maxTransactionLifetimeMs;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final RemoveStaleQueries removeStaleQueriesTask = new RemoveStaleQueries();
    private final RemoveStaleTransactions removeStaleTransactionsTask = new RemoveStaleTransactions();
    private final PersistDatastore persistDatastoreTask = new PersistDatastore();
    private final AtomicInteger transactionHandleProvider = new AtomicInteger(0);
    private int storeDelayMs;
    private volatile boolean dirty;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean noStorage;
    private Thread shutdownHook;
    private PseudoKinds pseudoKinds;
    private HighRepJobPolicy highRepJobPolicy;
    private boolean isHighRep;
    private LocalDatastoreCostAnalysis costAnalysis;

    public void clearProfiles() {
        for (Profile profile : this.profiles.values()) {
            LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
            if (fullTextIndex == null) continue;
            fullTextIndex.close();
        }
        this.profiles.clear();
    }

    public void clearQueryHistory() {
        LocalCompositeIndexManager.getInstance().clearQueryHistory();
    }

    public LocalDatastoreService() {
        this.setMaxQueryLifetime(30000);
        this.setMaxTransactionLifetime(300000);
        this.setStoreDelay(30000);
        this.enableScatterProperty(true);
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.clock = context.getClock();
        String storeFile = properties.get(BACKING_STORE_PROPERTY);
        String noStorageProp = properties.get(NO_STORAGE_PROPERTY);
        if (noStorageProp != null) {
            this.noStorage = Boolean.valueOf(noStorageProp);
        }
        if (storeFile == null && !this.noStorage) {
            File dir = GenerationDirectory.getGenerationDirectory((File)context.getLocalServerEnvironment().getAppDir());
            dir.mkdirs();
            storeFile = dir.getAbsolutePath() + File.separator + "local_db.bin";
        }
        this.setBackingStore(storeFile);
        String storeDelayTime = properties.get(STORE_DELAY_PROPERTY);
        this.storeDelayMs = LocalDatastoreService.parseInt(storeDelayTime, this.storeDelayMs, STORE_DELAY_PROPERTY);
        String maxQueryLifetime = properties.get(MAX_QUERY_LIFETIME_PROPERTY);
        this.maxQueryLifetimeMs = LocalDatastoreService.parseInt(maxQueryLifetime, this.maxQueryLifetimeMs, MAX_QUERY_LIFETIME_PROPERTY);
        String maxTxnLifetime = properties.get(MAX_TRANSACTION_LIFETIME_PROPERTY);
        this.maxTransactionLifetimeMs = LocalDatastoreService.parseInt(maxTxnLifetime, this.maxTransactionLifetimeMs, MAX_TRANSACTION_LIFETIME_PROPERTY);
        String autoIdAllocationPolicyString = properties.get(AUTO_ID_ALLOCATION_POLICY_PROPERTY);
        if (autoIdAllocationPolicyString != null) {
            try {
                this.autoIdAllocationPolicy = AutoIdAllocationPolicy.valueOf(autoIdAllocationPolicyString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(String.format("Invalid value \"%s\" for property \"%s\"", autoIdAllocationPolicyString, AUTO_ID_ALLOCATION_POLICY_PROPERTY), e);
            }
        }
        LocalCompositeIndexManager.getInstance().setAppDir(context.getLocalServerEnvironment().getAppDir());
        LocalCompositeIndexManager.getInstance().setClock(this.clock);
        String noIndexAutoGenProp = properties.get(NO_INDEX_AUTO_GEN_PROP);
        if (noIndexAutoGenProp != null) {
            LocalCompositeIndexManager.getInstance().setNoIndexAutoGen(Boolean.valueOf(noIndexAutoGenProp));
        }
        this.initHighRepJobPolicy(properties);
        this.pseudoKinds = new PseudoKinds();
        this.pseudoKinds.register(new KindPseudoKind(this));
        this.pseudoKinds.register(new PropertyPseudoKind(this));
        this.pseudoKinds.register(new NamespacePseudoKind(this));
        if (this.isHighRep()) {
            this.pseudoKinds.register(new EntityGroupPseudoKind());
        }
        this.costAnalysis = new LocalDatastoreCostAnalysis(LocalCompositeIndexManager.getInstance());
        logger.info(String.format("Local Datastore initialized: \n\tType: %s\n\tStorage: %s", this.isHighRep() ? "High Replication" : "Master/Slave", this.noStorage ? "In-memory" : this.backingStore));
    }

    boolean isHighRep() {
        return this.isHighRep;
    }

    private void initHighRepJobPolicy(Map<String, String> properties) {
        String highRepJobPolicyStr = properties.get(HIGH_REP_JOB_POLICY_CLASS_PROPERTY);
        if (highRepJobPolicyStr == null) {
            DefaultHighRepJobPolicy defaultPolicy = new DefaultHighRepJobPolicy(properties);
            this.isHighRep = defaultPolicy.unappliedJobCutoff > 0;
            this.highRepJobPolicy = defaultPolicy;
        } else {
            this.isHighRep = true;
            try {
                Class<?> highRepJobPolicyCls = Class.forName(highRepJobPolicyStr);
                Constructor<?> ctor = highRepJobPolicyCls.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                this.highRepJobPolicy = (HighRepJobPolicy)ctor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static int parseInt(String valStr, int defaultVal, String propName) {
        if (valStr != null) {
            try {
                return Integer.parseInt(valStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Expected a numeric value for property " + propName + "but received, " + valStr + ". Resetting property to the default.");
            }
        }
        return defaultVal;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalDatastoreService.this.startInternal();
                return null;
            }
        });
    }

    private void startInternal() {
        this.load();
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleQueriesTask, this.maxQueryLifetimeMs * 5, this.maxQueryLifetimeMs * 5, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleTransactionsTask, this.maxTransactionLifetimeMs * 5, this.maxTransactionLifetimeMs * 5, TimeUnit.MILLISECONDS);
        if (!this.noStorage) {
            this.scheduler.scheduleWithFixedDelay(this.persistDatastoreTask, this.storeDelayMs, this.storeDelayMs, TimeUnit.MILLISECONDS);
        }
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                LocalDatastoreService.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop() {
        this.scheduler.shutdown();
        if (!this.noStorage) {
            this.rollForwardAllUnappliedJobs();
            this.persistDatastoreTask.run();
        }
        this.clearProfiles();
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void rollForwardAllUnappliedJobs() {
        for (Profile profile : this.profiles.values()) {
            if (profile.getGroups() == null) continue;
            for (Profile.EntityGroup eg : profile.getGroups().values()) {
                eg.rollForwardUnappliedJobs();
            }
        }
    }

    public void setMaxQueryLifetime(int milliseconds) {
        this.maxQueryLifetimeMs = milliseconds;
    }

    public void setMaxTransactionLifetime(int milliseconds) {
        this.maxTransactionLifetimeMs = milliseconds;
    }

    public void setBackingStore(String backingStore) {
        this.backingStore = backingStore;
    }

    public void setStoreDelay(int delayMs) {
        this.storeDelayMs = delayMs;
    }

    public void setNoStorage(boolean noStorage) {
        this.noStorage = noStorage;
    }

    public void enableScatterProperty(boolean enable) {
        if (enable) {
            this.specialPropertyMap.put("__scatter__", SpecialProperty.SCATTER);
        } else {
            this.specialPropertyMap.remove("__scatter__");
        }
    }

    public String getPackage() {
        return PACKAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=10)
    public DatastoreV3Pb.GetResponse get(LocalRpcService.Status status, DatastoreV3Pb.GetRequest request) {
        DatastoreV3Pb.GetResponse response = new DatastoreV3Pb.GetResponse();
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            Profile profile;
            String app = key.getApp();
            OnestoreEntity.Path groupPath = this.getGroup(key);
            DatastoreV3Pb.GetResponse.Entity responseEntity = response.addEntity();
            Profile profile2 = profile = this.getOrCreateProfile(app);
            synchronized (profile2) {
                boolean eventualConsistency;
                OnestoreEntity.EntityProto entity;
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn);
                }
                if ((entity = this.pseudoKinds.get(liveTxn, eg, key, eventualConsistency = request.hasFailoverMs() && liveTxn == null)) == PseudoKinds.NOT_A_PSEUDO_KIND) {
                    entity = eg.get(liveTxn, key, eventualConsistency);
                }
                if (entity != null) {
                    responseEntity.getMutableEntity().copyFrom((ProtocolMessage)entity);
                    this.processEntityForSpecialProperties(responseEntity.getMutableEntity(), false);
                } else {
                    responseEntity.getMutableKey().copyFrom((ProtocolMessage)key);
                }
                profile.groom();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=30, dynamicAdjuster=WriteLatencyAdjuster.class)
    public DatastoreV3Pb.PutResponse put(LocalRpcService.Status status, DatastoreV3Pb.PutRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastoreV3Pb.PutResponse putResponse = this.putImpl(status, request);
            return putResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private void processEntityForSpecialProperties(OnestoreEntity.EntityProto entity, boolean store) {
        Iterator iter = entity.propertyIterator();
        while (iter.hasNext()) {
            if (!this.specialPropertyMap.containsKey(((OnestoreEntity.Property)iter.next()).getName())) continue;
            iter.remove();
        }
        for (SpecialProperty specialProp : this.specialPropertyMap.values()) {
            OnestoreEntity.PropertyValue value;
            if (!(store ? specialProp.isStored() : specialProp.isVisible()) || (value = specialProp.getValue(entity)) == null) continue;
            entity.addProperty(specialProp.getProperty(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreV3Pb.PutResponse putImpl(LocalRpcService.Status status, DatastoreV3Pb.PutRequest request) {
        Profile profile;
        DatastoreV3Pb.PutResponse response = new DatastoreV3Pb.PutResponse();
        if (request.entitySize() == 0) {
            return response;
        }
        DatastoreV3Pb.Cost totalCost = response.getMutableCost();
        String app = request.entitys().get(0).getKey().getApp();
        ArrayList<OnestoreEntity.EntityProto> clones = new ArrayList<OnestoreEntity.EntityProto>();
        for (OnestoreEntity.EntityProto entity : request.entitys()) {
            this.validateAndProcessEntityProto(entity);
            OnestoreEntity.EntityProto clone = (OnestoreEntity.EntityProto)entity.clone();
            clones.add(clone);
            Preconditions.checkArgument((boolean)clone.hasKey());
            OnestoreEntity.Reference key = clone.getKey();
            Preconditions.checkArgument((key.getPath().elementSize() > 0 ? 1 : 0) != 0);
            clone.getMutableKey().setApp(app);
            OnestoreEntity.Path.Element lastPath = Utils.getLastElement(key);
            if (lastPath.getId() == 0L && !lastPath.hasName()) {
                if (this.autoIdAllocationPolicy == AutoIdAllocationPolicy.SEQUENTIAL) {
                    lastPath.setId(this.entityIdSequential.getAndIncrement());
                } else {
                    lastPath.setId(LocalDatastoreService.toScatteredId(this.entityIdScattered.getAndIncrement()));
                }
            }
            this.processEntityForSpecialProperties(clone, true);
            if (clone.getEntityGroup().elementSize() == 0) {
                OnestoreEntity.Path path = clone.getMutableEntityGroup();
                OnestoreEntity.Path.Element root = (OnestoreEntity.Path.Element)key.getPath().elements().get(0);
                OnestoreEntity.Path.Element pathElement = path.addElement();
                pathElement.setType(root.getType());
                if (root.hasName()) {
                    pathElement.setName(root.getName());
                    continue;
                }
                pathElement.setId(root.getId());
                continue;
            }
            Preconditions.checkState((clone.hasEntityGroup() && clone.getEntityGroup().elementSize() > 0 ? 1 : 0) != 0);
        }
        LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.EntityProto>> entitiesByEntityGroup = new LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.EntityProto>>();
        Profile profile2 = profile = this.getOrCreateProfile(app);
        synchronized (profile2) {
            Profile.EntityGroup eg;
            LiveTxn liveTxn = null;
            for (OnestoreEntity.EntityProto entityProto : clones) {
                eg = profile.getGroup(entityProto.getEntityGroup());
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn).addWrittenEntity(entityProto);
                } else {
                    ArrayList<OnestoreEntity.EntityProto> entities = (ArrayList<OnestoreEntity.EntityProto>)entitiesByEntityGroup.get(entityProto.getEntityGroup());
                    if (entities == null) {
                        entities = new ArrayList<OnestoreEntity.EntityProto>();
                        entitiesByEntityGroup.put(entityProto.getEntityGroup(), entities);
                    }
                    entities.add(entityProto);
                }
                response.mutableKeys().add(entityProto.getKey());
            }
            for (final Map.Entry entry : entitiesByEntityGroup.entrySet()) {
                eg = profile.getGroup((OnestoreEntity.Path)entry.getKey());
                eg.incrementVersion();
                LocalDatastoreJob job = new LocalDatastoreJob(this.highRepJobPolicy, eg.pathAsKey()){

                    @Override
                    DatastoreV3Pb.Cost calculateJobCost() {
                        return LocalDatastoreService.this.calculatePutCost(false, profile, (Collection)entry.getValue());
                    }

                    @Override
                    DatastoreV3Pb.Cost applyInternal() {
                        return LocalDatastoreService.this.calculatePutCost(true, profile, (Collection)entry.getValue());
                    }
                };
                LocalDatastoreService.addTo(totalCost, eg.addJob(job));
            }
        }
        if (!request.hasTransaction()) {
            logger.fine("put: " + request.entitySize() + " entities");
        }
        response.setCost(totalCost);
        return response;
    }

    private void validateAndProcessEntityProto(OnestoreEntity.EntityProto entity) {
        this.validatePathForPut(entity.getKey());
        for (OnestoreEntity.Property prop : entity.propertys()) {
            this.validateAndProcessProperty(prop);
            this.validateLengthLimit(prop);
        }
        for (OnestoreEntity.Property prop : entity.rawPropertys()) {
            this.validateAndProcessProperty(prop);
        }
    }

    private void validatePathForPut(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        for (OnestoreEntity.Path.Element ele : path.elements()) {
            String type = ele.getType();
            if (RESERVED_NAME.matcher(type).matches() && !RESERVED_NAME_WHITELIST.contains(type)) {
                throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, String.format("illegal key.path.element.type: %s", ele.getType()));
            }
            if (!ele.hasName() || ele.getName().length() <= 500) continue;
            throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, NAME_TOO_LONG);
        }
    }

    private void validateAndProcessProperty(OnestoreEntity.Property prop) {
        if (RESERVED_NAME.matcher(prop.getName()).matches()) {
            throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, String.format("illegal property.name: %s", prop.getName()));
        }
        OnestoreEntity.PropertyValue val = prop.getMutableValue();
        if (val.hasUserValue()) {
            OnestoreEntity.PropertyValue.UserValue userVal = val.getMutableUserValue();
            userVal.setObfuscatedGaiaid(Integer.toString(userVal.getEmail().hashCode()));
        }
    }

    private void validateLengthLimit(OnestoreEntity.Property property) {
        String name = property.getName();
        OnestoreEntity.PropertyValue value = property.getValue();
        if (value.hasStringValue()) {
            if (property.hasMeaning() && property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ATOM_LINK) {
                if (value.getStringValue().length() > 2038) {
                    throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "Link property " + name + " is too long. Use TEXT for links over " + 2038 + " characters.");
                }
            } else if (value.getStringValue().length() > 500) {
                throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "string property " + name + " is too long.  It cannot exceed " + 500 + " characters.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=40, dynamicAdjuster=WriteLatencyAdjuster.class)
    public DatastoreV3Pb.DeleteResponse delete(LocalRpcService.Status status, DatastoreV3Pb.DeleteRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastoreV3Pb.DeleteResponse deleteResponse = this.deleteImpl(status, request);
            return deleteResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=1)
    public ApiBasePb.VoidProto addActions(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest request) {
        try {
            this.globalLock.readLock().lock();
            this.addActionsImpl(status, request);
        }
        finally {
            this.globalLock.readLock().unlock();
        }
        return new ApiBasePb.VoidProto();
    }

    private OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreV3Pb.DeleteResponse deleteImpl(LocalRpcService.Status status, DatastoreV3Pb.DeleteRequest request) {
        DatastoreV3Pb.DeleteResponse response = new DatastoreV3Pb.DeleteResponse();
        if (request.keySize() == 0) {
            return response;
        }
        DatastoreV3Pb.Cost totalCost = response.getMutableCost();
        String app = request.keys().get(0).getApp();
        final Profile profile = this.getOrCreateProfile(app);
        LiveTxn liveTxn = null;
        LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.Reference>> keysByEntityGroup = new LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.Reference>>();
        Profile profile2 = profile;
        synchronized (profile2) {
            for (OnestoreEntity.Reference reference : request.keys()) {
                OnestoreEntity.Path group = this.getGroup(reference);
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    Profile.EntityGroup eg = profile.getGroup(group);
                    eg.addTransaction(liveTxn).addDeletedEntity(reference);
                    continue;
                }
                ArrayList<OnestoreEntity.Reference> keysToDelete = (ArrayList<OnestoreEntity.Reference>)keysByEntityGroup.get(group);
                if (keysToDelete == null) {
                    keysToDelete = new ArrayList<OnestoreEntity.Reference>();
                    keysByEntityGroup.put(group, keysToDelete);
                }
                keysToDelete.add(reference);
            }
            for (final Map.Entry entry : keysByEntityGroup.entrySet()) {
                Profile.EntityGroup eg = profile.getGroup((OnestoreEntity.Path)entry.getKey());
                eg.incrementVersion();
                LocalDatastoreJob job = new LocalDatastoreJob(this.highRepJobPolicy, eg.pathAsKey()){

                    @Override
                    DatastoreV3Pb.Cost calculateJobCost() {
                        return LocalDatastoreService.this.calculateDeleteCost(false, profile, (Collection)entry.getValue());
                    }

                    @Override
                    public DatastoreV3Pb.Cost applyInternal() {
                        return LocalDatastoreService.this.calculateDeleteCost(true, profile, (Collection)entry.getValue());
                    }
                };
                LocalDatastoreService.addTo(totalCost, eg.addJob(job));
            }
        }
        return response;
    }

    private void addActionsImpl(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest request) {
        if (request.addRequestSize() == 0) {
            return;
        }
        ArrayList<TaskQueuePb.TaskQueueAddRequest> addRequests = new ArrayList<TaskQueuePb.TaskQueueAddRequest>(request.addRequestSize());
        for (TaskQueuePb.TaskQueueAddRequest addRequest : request.addRequests()) {
            addRequests.add(((TaskQueuePb.TaskQueueAddRequest)addRequest.clone()).clearTransaction());
        }
        Profile profile = this.profiles.get(((TaskQueuePb.TaskQueueAddRequest)request.addRequests().get(0)).getTransaction().getApp());
        LiveTxn liveTxn = profile.getTxn(((TaskQueuePb.TaskQueueAddRequest)request.addRequests().get(0)).getTransaction().getHandle());
        liveTxn.addActions(addRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=20)
    public DatastoreV3Pb.QueryResult runQuery(LocalRpcService.Status status, DatastoreV3Pb.Query query) {
        Profile profile;
        final LocalCompositeIndexManager.ValidatedQuery validatedQuery = new LocalCompositeIndexManager.ValidatedQuery(query);
        query = validatedQuery.getV3Query();
        String app = query.getApp();
        Profile profile2 = profile = this.getOrCreateProfile(app);
        synchronized (profile2) {
            if (query.hasTransaction() || query.hasAncestor()) {
                OnestoreEntity.Path groupPath = this.getGroup(query.getAncestor());
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                if (query.hasTransaction()) {
                    if (!app.equals(query.getTransaction().getApp())) {
                        throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.INTERNAL_ERROR, "Can't query app " + app + "in a transaction on app " + query.getTransaction().getApp());
                    }
                    LiveTxn liveTxn = profile.getTxn(query.getTransaction().getHandle());
                    eg.addTransaction(liveTxn);
                    profile = eg.getSnapshot(liveTxn);
                }
                if (query.hasAncestor() && (query.hasTransaction() || !query.hasFailoverMs())) {
                    eg.rollForwardUnappliedJobs();
                }
            }
            LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
            if (query.hasSearchQuery() && fullTextIndex == null) {
                throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "full-text search unsupported");
            }
            List<Object> queryEntities = this.pseudoKinds.runQuery(query);
            if (queryEntities == null) {
                Map<String, Extent> extents = profile.getExtents();
                Extent extent = extents.get(query.getKind());
                if (!query.hasSearchQuery()) {
                    if (extent != null) {
                        queryEntities = new ArrayList<OnestoreEntity.EntityProto>(extent.getEntities().values());
                    } else if (!query.hasKind()) {
                        queryEntities = profile.getAllEntities();
                        if (query.orderSize() == 0) {
                            query.addOrder(new DatastoreV3Pb.Query.Order().setDirection(DatastoreV3Pb.Query.Order.Direction.ASCENDING).setProperty("__key__"));
                        }
                    }
                } else {
                    List<OnestoreEntity.Reference> keys = fullTextIndex.search(query.getKind(), query.getSearchQuery());
                    ArrayList<OnestoreEntity.EntityProto> entities = new ArrayList<OnestoreEntity.EntityProto>(keys.size());
                    for (OnestoreEntity.Reference key : keys) {
                        entities.add(extent.getEntities().get(key));
                    }
                    queryEntities = entities;
                }
            }
            profile.groom();
            if (queryEntities == null) {
                queryEntities = Collections.emptyList();
            }
            ArrayList<Object> predicates = new ArrayList<Object>();
            if (query.hasAncestor()) {
                final List ancestorPath = query.getAncestor().getPath().elements();
                predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                    public boolean apply(OnestoreEntity.EntityProto entity) {
                        List path = entity.getKey().getPath().elements();
                        return path.size() >= ancestorPath.size() && ((Object)path.subList(0, ancestorPath.size())).equals(ancestorPath);
                    }
                });
            }
            final boolean hasNamespace = query.hasNameSpace();
            final String namespace = query.getNameSpace();
            predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    OnestoreEntity.Reference ref = entity.getKey();
                    return !(hasNamespace ? !ref.hasNameSpace() || !namespace.equals(ref.getNameSpace()) : ref.hasNameSpace());
                }
            });
            final EntityProtoComparators.EntityProtoComparator entityComparator = new EntityProtoComparators.EntityProtoComparator(validatedQuery.getQuery().orders(), validatedQuery.getQuery().filters());
            predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    return entityComparator.matches(entity);
                }
            });
            Predicate queryPredicate = Predicates.not((Predicate)Predicates.and(predicates));
            Iterators.removeIf(queryEntities.iterator(), (Predicate)queryPredicate);
            if (query.propertyNameSize() > 0) {
                queryEntities = this.createIndexOnlyQueryResults(queryEntities, entityComparator);
            }
            Collections.sort(queryEntities, entityComparator);
            LiveQuery liveQuery = new LiveQuery(queryEntities, query, entityComparator, this.clock);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    LocalCompositeIndexManager.getInstance().processQuery(validatedQuery.getV3Query());
                    return null;
                }
            });
            int count = query.hasCount() ? query.getCount() : (query.hasLimit() ? query.getLimit() : 20);
            DatastoreV3Pb.QueryResult result = liveQuery.nextResult(query.hasOffset() ? Integer.valueOf(query.getOffset()) : null, query.hasCount() ? Integer.valueOf(query.getCount()) : null, query.isCompile());
            if (query.isCompile()) {
                result.setCompiledQuery(liveQuery.compileQuery());
            }
            if (result.isMoreResults()) {
                long cursor = this.queryId.getAndIncrement();
                profile.addQuery(cursor, liveQuery);
                result.getMutableCursor().setApp(query.getApp()).setCursor(cursor);
            }
            for (OnestoreEntity.Index index : LocalCompositeIndexManager.getInstance().queryIndexList(query)) {
                result.addIndex(this.wrapIndexInCompositeIndex(app, index));
            }
            return result;
        }
    }

    private List<OnestoreEntity.EntityProto> createIndexOnlyQueryResults(List<OnestoreEntity.EntityProto> queryEntities, EntityProtoComparators.EntityProtoComparator entityComparator) {
        HashSet postfixProps = Sets.newHashSetWithExpectedSize((int)entityComparator.getAdjustedOrders().size());
        for (DatastorePb.Query.Order order : entityComparator.getAdjustedOrders()) {
            postfixProps.add(order.getProperty());
        }
        ArrayList results = Lists.newArrayListWithExpectedSize((int)queryEntities.size());
        for (OnestoreEntity.EntityProto entity : queryEntities) {
            List<OnestoreEntity.EntityProto> indexEntities = this.createIndexEntities(entity, postfixProps, entityComparator);
            results.addAll(indexEntities);
        }
        return results;
    }

    private List<OnestoreEntity.EntityProto> createIndexEntities(OnestoreEntity.EntityProto entity, Set<String> postfixProps, EntityProtoComparators.EntityProtoComparator entityComparator) {
        HashMultimap toSplit = HashMultimap.create((int)postfixProps.size(), (int)1);
        HashSet seen = Sets.newHashSet();
        boolean splitRequired = false;
        for (OnestoreEntity.Property prop : entity.propertys()) {
            if (!postfixProps.contains(prop.getName())) continue;
            splitRequired |= !seen.add(prop.getName());
            if (!entityComparator.matches(prop)) continue;
            toSplit.put((Object)prop.getName(), (Object)prop.getValue());
        }
        if (!splitRequired) {
            return Collections.singletonList(entity);
        }
        OnestoreEntity.EntityProto clone = new OnestoreEntity.EntityProto();
        clone.getMutableKey().copyFrom((ProtocolMessage)entity.getKey());
        clone.getMutableEntityGroup();
        ArrayList results = Lists.newArrayList((Object[])new OnestoreEntity.EntityProto[]{clone});
        for (Map.Entry entry : toSplit.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                for (OnestoreEntity.EntityProto result : results) {
                    result.addProperty().setName((String)entry.getKey()).setMeaning(OnestoreEntity.Property.Meaning.INDEX_VALUE).getMutableValue().copyFrom((ProtocolMessage)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue())));
                }
                continue;
            }
            ArrayList splitResults = Lists.newArrayListWithCapacity((int)(results.size() * ((Collection)entry.getValue()).size()));
            for (OnestoreEntity.PropertyValue value : (Collection)entry.getValue()) {
                for (OnestoreEntity.EntityProto result : results) {
                    OnestoreEntity.EntityProto split = (OnestoreEntity.EntityProto)result.clone();
                    split.addProperty().setName((String)entry.getKey()).setMeaning(OnestoreEntity.Property.Meaning.INDEX_VALUE).getMutableValue().copyFrom((ProtocolMessage)value);
                    splitResults.add(split);
                }
            }
            results = splitResults;
        }
        return results;
    }

    private static <T> T safeGetFromExpiringMap(Map<Long, T> map, long key, String errorMsg) {
        T value = map.get(key);
        if (value == null) {
            throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, errorMsg);
        }
        return value;
    }

    @LatencyPercentiles(latency50th=50)
    public DatastoreV3Pb.QueryResult next(LocalRpcService.Status status, DatastoreV3Pb.NextRequest request) {
        Profile profile = this.profiles.get(request.getCursor().getApp());
        LiveQuery liveQuery = profile.getQuery(request.getCursor().getCursor());
        int count = request.hasCount() ? request.getCount() : 20;
        DatastoreV3Pb.QueryResult result = liveQuery.nextResult(request.hasOffset() ? Integer.valueOf(request.getOffset()) : null, request.hasCount() ? Integer.valueOf(request.getCount()) : null, request.isCompile());
        if (result.isMoreResults()) {
            result.setCursor(request.getCursor());
        } else {
            profile.removeQuery(request.getCursor().getCursor());
        }
        return result;
    }

    public ApiBasePb.VoidProto deleteCursor(LocalRpcService.Status status, DatastoreV3Pb.Cursor request) {
        Profile profile = this.profiles.get(request.getApp());
        profile.removeQuery(request.getCursor());
        return new ApiBasePb.VoidProto();
    }

    @LatencyPercentiles(latency50th=1)
    public DatastoreV3Pb.Transaction beginTransaction(LocalRpcService.Status status, DatastoreV3Pb.BeginTransactionRequest req) {
        Profile profile = this.getOrCreateProfile(req.getApp());
        DatastoreV3Pb.Transaction txn = new DatastoreV3Pb.Transaction().setApp(req.getApp()).setHandle(this.transactionHandleProvider.getAndIncrement());
        if (req.isAllowMultipleEg() && !this.isHighRep()) {
            throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, MULTI_EG_TXN_NOT_ALLOWED);
        }
        profile.addTxn(txn.getHandle(), new LiveTxn(this.clock, req.isAllowMultipleEg()));
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=20, dynamicAdjuster=WriteLatencyAdjuster.class)
    public DatastoreV3Pb.CommitResponse commit(LocalRpcService.Status status, DatastoreV3Pb.Transaction req) {
        Profile profile = this.profiles.get(req.getApp());
        DatastoreV3Pb.CommitResponse response = new DatastoreV3Pb.CommitResponse();
        Profile profile2 = profile;
        synchronized (profile2) {
            LiveTxn liveTxn = profile.removeTxn(req.getHandle());
            if (liveTxn.isDirty()) {
                try {
                    this.globalLock.readLock().lock();
                    response.setCost(this.commitImpl(liveTxn, profile));
                }
                finally {
                    this.globalLock.readLock().unlock();
                }
            } else {
                response.setCost(new DatastoreV3Pb.Cost().setEntityWrites(0).setIndexWrites(0));
            }
            for (TaskQueuePb.TaskQueueAddRequest action : liveTxn.getActions()) {
                try {
                    ApiProxy.makeSyncCall((String)"taskqueue", (String)"Add", (byte[])action.toByteArray());
                }
                catch (ApiProxy.ApplicationException e) {
                    logger.log(Level.WARNING, "Transactional task: " + action + " has been dropped.", e);
                }
            }
        }
        return response;
    }

    private DatastoreV3Pb.Cost commitImpl(LiveTxn liveTxn, final Profile profile) {
        for (EntityGroupTracker tracker : liveTxn.getAllTrackers()) {
            tracker.checkEntityGroupVersion();
        }
        int deleted = 0;
        int written = 0;
        DatastoreV3Pb.Cost totalCost = new DatastoreV3Pb.Cost();
        for (EntityGroupTracker tracker : liveTxn.getAllTrackers()) {
            Profile.EntityGroup eg = tracker.getEntityGroup();
            eg.incrementVersion();
            final Collection<OnestoreEntity.EntityProto> writtenEntities = tracker.getWrittenEntities();
            final Collection<OnestoreEntity.Reference> deletedKeys = tracker.getDeletedKeys();
            LocalDatastoreJob job = new LocalDatastoreJob(this.highRepJobPolicy, eg.pathAsKey()){

                private DatastoreV3Pb.Cost calculateJobCost(boolean apply) {
                    DatastoreV3Pb.Cost cost = LocalDatastoreService.this.calculatePutCost(apply, profile, writtenEntities);
                    LocalDatastoreService.addTo(cost, LocalDatastoreService.this.calculateDeleteCost(apply, profile, deletedKeys));
                    return cost;
                }

                @Override
                DatastoreV3Pb.Cost calculateJobCost() {
                    return this.calculateJobCost(false);
                }

                @Override
                DatastoreV3Pb.Cost applyInternal() {
                    return this.calculateJobCost(true);
                }
            };
            LocalDatastoreService.addTo(totalCost, eg.addJob(job));
            deleted += deletedKeys.size();
            written += writtenEntities.size();
        }
        logger.fine("committed: " + written + " puts, " + deleted + " deletes in " + liveTxn.getAllTrackers().size() + " entity groups");
        return totalCost;
    }

    @LatencyPercentiles(latency50th=1)
    public ApiBasePb.VoidProto rollback(LocalRpcService.Status status, DatastoreV3Pb.Transaction req) {
        this.profiles.get(req.getApp()).removeTxn(req.getHandle());
        return new ApiBasePb.VoidProto();
    }

    public ApiBasePb.Integer64Proto createIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto updateIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    private OnestoreEntity.CompositeIndex wrapIndexInCompositeIndex(String app, OnestoreEntity.Index index) {
        OnestoreEntity.CompositeIndex ci = new OnestoreEntity.CompositeIndex().setAppId(app).setState(OnestoreEntity.CompositeIndex.State.READ_WRITE);
        if (index != null) {
            ci.setDefinition(index);
        }
        return ci;
    }

    public DatastoreV3Pb.CompositeIndices getIndices(LocalRpcService.Status status, ApiBasePb.StringProto req) {
        Set<OnestoreEntity.Index> indexSet = LocalCompositeIndexManager.getInstance().getIndices();
        DatastoreV3Pb.CompositeIndices answer = new DatastoreV3Pb.CompositeIndices();
        for (OnestoreEntity.Index index : indexSet) {
            OnestoreEntity.CompositeIndex ci = this.wrapIndexInCompositeIndex(req.getValue(), index);
            answer.addIndex(ci);
        }
        return answer;
    }

    public ApiBasePb.VoidProto deleteIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=1)
    public DatastoreV3Pb.AllocateIdsResponse allocateIds(LocalRpcService.Status status, DatastoreV3Pb.AllocateIdsRequest req) {
        try {
            this.globalLock.readLock().lock();
            DatastoreV3Pb.AllocateIdsResponse allocateIdsResponse = this.allocateIdsImpl(req);
            return allocateIdsResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private DatastoreV3Pb.AllocateIdsResponse allocateIdsImpl(DatastoreV3Pb.AllocateIdsRequest req) {
        if (req.hasSize()) {
            if (req.getSize() > 1000000000L) {
                throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "cannot get more than 1000000000 keys in a single call");
            }
            long start = this.entityIdSequential.getAndAdd(req.getSize());
            return new DatastoreV3Pb.AllocateIdsResponse().setStart(start).setEnd(start + req.getSize() - 1L);
        }
        long current = this.entityIdSequential.get();
        while (current <= req.getMax() && !this.entityIdSequential.compareAndSet(current, req.getMax() + 1L)) {
            current = this.entityIdSequential.get();
        }
        return new DatastoreV3Pb.AllocateIdsResponse().setStart(current).setEnd(Math.max(req.getMax(), current - 1L));
    }

    private static long toScatteredId(long counter) {
        if (counter >= 0x2000000000000000L) {
            throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.INTERNAL_ERROR, "Maximum scattered ID counter value exceeded");
        }
        return Long.reverse(counter << 3) | 0x4000000000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Profile getOrCreateProfile(String app) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            Preconditions.checkArgument((app != null && app.length() > 0 ? 1 : 0) != 0, (Object)"appId not set");
            Profile profile = this.profiles.get(app);
            if (profile == null) {
                profile = new Profile();
                this.profiles.put(app, profile);
            }
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Extent getOrCreateExtent(Profile profile, String kind) {
        Map<String, Extent> extents;
        Map<String, Extent> map = extents = profile.getExtents();
        synchronized (map) {
            Extent e = extents.get(kind);
            if (e == null) {
                e = new Extent();
                extents.put(kind, e);
            }
            return e;
        }
    }

    private void load() {
        if (this.noStorage) {
            return;
        }
        File backingStoreFile = new File(this.backingStore);
        String path = backingStoreFile.getAbsolutePath();
        if (!backingStoreFile.exists()) {
            logger.log(Level.INFO, "The backing store, " + path + ", does not exist. " + "It will be created.");
            return;
        }
        try {
            Map profilesOnDisk;
            long start = this.clock.getCurrentTime();
            ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.backingStore)));
            long version = -objectIn.readLong();
            if (version < 0L) {
                this.entityIdSequential.set(-version);
            } else {
                this.entityIdSequential.set(objectIn.readLong());
                this.entityIdScattered.set(objectIn.readLong());
            }
            this.profiles = profilesOnDisk = (Map)objectIn.readObject();
            objectIn.close();
            long end = this.clock.getCurrentTime();
            logger.log(Level.INFO, "Time to load datastore: " + (end - start) + " ms");
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to find the backing store, " + path);
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
    }

    static void pruneHasCreationTimeMap(long now, int maxLifetimeMs, Map<Long, ? extends HasCreationTime> hasCreationTimeMap) {
        long deadline = now - (long)maxLifetimeMs;
        Iterator<Map.Entry<Long, ? extends HasCreationTime>> queryIt = hasCreationTimeMap.entrySet().iterator();
        while (queryIt.hasNext()) {
            Map.Entry<Long, ? extends HasCreationTime> entry = queryIt.next();
            HasCreationTime query = entry.getValue();
            if (query.getCreationTime() >= deadline) continue;
            queryIt.remove();
        }
    }

    Map<String, SpecialProperty> getSpecialPropertyMap() {
        return Collections.unmodifiableMap(this.specialPropertyMap);
    }

    void removeStaleQueriesNow() {
        this.removeStaleQueriesTask.run();
    }

    void removeStaleTxnsNow() {
        this.removeStaleTransactionsTask.run();
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public CreationCostAnalysis getCreationCostAnalysis(Entity e) {
        return this.costAnalysis.getCreationCostAnalysis(EntityTranslator.convertToPb((Entity)e));
    }

    private static void addTo(DatastoreV3Pb.Cost target, DatastoreV3Pb.Cost addMe) {
        target.setEntityWrites(target.getEntityWrites() + addMe.getEntityWrites());
        target.setIndexWrites(target.getIndexWrites() + addMe.getIndexWrites());
    }

    private DatastoreV3Pb.Cost calculatePutCost(boolean apply, Profile profile, Collection<OnestoreEntity.EntityProto> entities) {
        DatastoreV3Pb.Cost totalCost = new DatastoreV3Pb.Cost();
        for (OnestoreEntity.EntityProto entityProto : entities) {
            OnestoreEntity.EntityProto oldEntity;
            String kind = Utils.getKind(entityProto.getKey());
            Extent extent = this.getOrCreateExtent(profile, kind);
            if (apply) {
                oldEntity = extent.getEntities().put(entityProto.getKey(), entityProto);
                LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
                if (fullTextIndex != null) {
                    fullTextIndex.write(entityProto);
                }
            } else {
                oldEntity = extent.getEntities().get(entityProto.getKey());
            }
            LocalDatastoreService.addTo(totalCost, this.costAnalysis.getWriteOps(oldEntity, entityProto));
        }
        if (apply) {
            this.dirty = true;
        }
        return totalCost;
    }

    private DatastoreV3Pb.Cost calculateDeleteCost(boolean apply, Profile profile, Collection<OnestoreEntity.Reference> keys) {
        DatastoreV3Pb.Cost totalCost = new DatastoreV3Pb.Cost();
        for (OnestoreEntity.Reference key : keys) {
            OnestoreEntity.EntityProto oldEntity;
            String kind = Utils.getKind(key);
            Map<String, Extent> extents = profile.getExtents();
            Extent extent = extents.get(kind);
            if (extent == null) continue;
            if (apply) {
                oldEntity = extent.getEntities().remove(key);
                LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
                if (fullTextIndex != null) {
                    fullTextIndex.delete(key);
                }
            } else {
                oldEntity = extent.getEntities().get(key);
            }
            if (oldEntity == null) continue;
            LocalDatastoreService.addTo(totalCost, this.costAnalysis.getWriteCost(oldEntity));
        }
        if (apply) {
            this.dirty = true;
        }
        return totalCost;
    }

    private class PersistDatastore
    implements Runnable {
        private PersistDatastore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LocalDatastoreService.this.globalLock.writeLock().lock();
                this.privilegedPersist();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to save the datastore", e);
            }
            finally {
                LocalDatastoreService.this.globalLock.writeLock().unlock();
            }
        }

        private void privilegedPersist() throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        PersistDatastore.this.persist();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t);
            }
        }

        private void persist() throws IOException {
            if (LocalDatastoreService.this.noStorage || !LocalDatastoreService.this.dirty) {
                return;
            }
            long start = LocalDatastoreService.this.clock.getCurrentTime();
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(LocalDatastoreService.this.backingStore)));
            objectOut.writeLong(-1L);
            objectOut.writeLong(LocalDatastoreService.this.entityIdSequential.get());
            objectOut.writeLong(LocalDatastoreService.this.entityIdScattered.get());
            objectOut.writeObject(LocalDatastoreService.this.profiles);
            objectOut.close();
            LocalDatastoreService.this.dirty = false;
            long end = LocalDatastoreService.this.clock.getCurrentTime();
            logger.log(Level.INFO, "Time to persist datastore: " + (end - start) + " ms");
        }
    }

    static enum SpecialProperty {
        SCATTER(false, true){
            private static final int SMALL_LENGTH = 2;

            @Override
            OnestoreEntity.PropertyValue getValue(OnestoreEntity.EntityProto entity) {
                int hashCode = 0;
                for (OnestoreEntity.Path.Element elem : entity.getKey().getPath().elements()) {
                    if (elem.hasId()) {
                        hashCode = (int)((long)hashCode ^ elem.getId());
                        continue;
                    }
                    if (elem.hasName()) {
                        hashCode ^= elem.getName().hashCode();
                        continue;
                    }
                    throw new IllegalStateException("Couldn't find name or id for entity " + entity.getKey());
                }
                try {
                    byte[] digest = MessageDigest.getInstance("MD5").digest(("" + hashCode).getBytes());
                    byte[] miniDigest = new byte[2];
                    System.arraycopy(digest, 0, miniDigest, 0, 2);
                    if ((miniDigest[0] & 1) != 0) {
                        OnestoreEntity.PropertyValue value = new OnestoreEntity.PropertyValue();
                        value.setStringValueAsBytes(miniDigest);
                        return value;
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    Logger logger = Logger.getLogger(SpecialProperty.class.getName());
                    logger.log(Level.WARNING, "Your JDK doesn't have an MD5 implementation, which is required for scatter  property support.");
                }
                return null;
            }
        };

        private final String name = "__" + this.name().toLowerCase() + "__";
        private final boolean isVisible;
        private final boolean isStored;

        private SpecialProperty(boolean isVisible, boolean isStored) {
            this.isVisible = isVisible;
            this.isStored = isStored;
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isVisible() {
            return this.isVisible;
        }

        final boolean isStored() {
            return this.isStored;
        }

        OnestoreEntity.PropertyValue getValue(OnestoreEntity.EntityProto entity) {
            throw new UnsupportedOperationException();
        }

        OnestoreEntity.Property getProperty(OnestoreEntity.PropertyValue value) {
            OnestoreEntity.Property processedProp = new OnestoreEntity.Property();
            processedProp.setName(this.getName());
            processedProp.setValue(value);
            processedProp.setMultiple(false);
            return processedProp;
        }
    }

    private class RemoveStaleTransactions
    implements Runnable {
        private RemoveStaleTransactions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (Profile profile : LocalDatastoreService.this.profiles.values()) {
                Map map = profile.getTxns();
                synchronized (map) {
                    LocalDatastoreService.pruneHasCreationTimeMap(LocalDatastoreService.this.clock.getCurrentTime(), LocalDatastoreService.this.maxTransactionLifetimeMs, profile.getTxns());
                }
            }
        }
    }

    private class RemoveStaleQueries
    implements Runnable {
        private RemoveStaleQueries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (Profile profile : LocalDatastoreService.this.profiles.values()) {
                Map map = profile.getQueries();
                synchronized (map) {
                    LocalDatastoreService.pruneHasCreationTimeMap(LocalDatastoreService.this.clock.getCurrentTime(), LocalDatastoreService.this.maxQueryLifetimeMs, profile.getQueries());
                }
            }
        }
    }

    static class EntityGroupTracker {
        private Profile.EntityGroup entityGroup;
        private Long entityGroupVersion;
        private final Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> written = new HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
        private final Set<OnestoreEntity.Reference> deleted = new HashSet<OnestoreEntity.Reference>();

        EntityGroupTracker(Profile.EntityGroup entityGroup) {
            this.entityGroup = entityGroup;
            this.entityGroupVersion = entityGroup.getVersion();
        }

        synchronized Profile.EntityGroup getEntityGroup() {
            return this.entityGroup;
        }

        synchronized void checkEntityGroupVersion() {
            if (!this.entityGroupVersion.equals(this.entityGroup.getVersion())) {
                throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.CONCURRENT_TRANSACTION, LocalDatastoreService.CONTENTION_MESSAGE);
            }
        }

        synchronized Long getEntityGroupVersion() {
            return this.entityGroupVersion;
        }

        synchronized void addWrittenEntity(OnestoreEntity.EntityProto entity) {
            OnestoreEntity.Reference key = entity.getKey();
            this.written.put(key, entity);
            this.deleted.remove(key);
        }

        synchronized void addDeletedEntity(OnestoreEntity.Reference key) {
            this.deleted.add(key);
            this.written.remove(key);
        }

        synchronized Collection<OnestoreEntity.EntityProto> getWrittenEntities() {
            return new ArrayList<OnestoreEntity.EntityProto>(this.written.values());
        }

        synchronized Collection<OnestoreEntity.Reference> getDeletedKeys() {
            return new ArrayList<OnestoreEntity.Reference>(this.deleted);
        }

        synchronized boolean isDirty() {
            return this.written.size() + this.deleted.size() > 0;
        }
    }

    static class LiveTxn
    extends HasCreationTime {
        private final Map<Profile.EntityGroup, EntityGroupTracker> entityGroups = new HashMap<Profile.EntityGroup, EntityGroupTracker>();
        private final List<TaskQueuePb.TaskQueueAddRequest> actions = new ArrayList<TaskQueuePb.TaskQueueAddRequest>();
        private final boolean allowMultipleEg;
        private boolean failed = false;

        LiveTxn(Clock clock, boolean allowMultipleEg) {
            super(clock.getCurrentTime());
            this.allowMultipleEg = allowMultipleEg;
        }

        synchronized EntityGroupTracker trackEntityGroup(Profile.EntityGroup newEntityGroup) {
            if (newEntityGroup == null) {
                throw new NullPointerException("entityGroup cannot be null");
            }
            this.checkFailed();
            EntityGroupTracker tracker = this.entityGroups.get(newEntityGroup);
            if (tracker == null) {
                if (this.allowMultipleEg) {
                    if (this.entityGroups.size() >= 5) {
                        throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, LocalDatastoreService.TOO_MANY_ENTITY_GROUP_MESSAGE);
                    }
                } else if (this.entityGroups.size() >= 1) {
                    Profile.EntityGroup entityGroup = this.entityGroups.keySet().iterator().next();
                    throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "cross-group transaction need to be explicitly specified, see TransactionOptions.Builder.withXGfound both " + entityGroup + " and " + newEntityGroup);
                }
                for (EntityGroupTracker other : this.getAllTrackers()) {
                    try {
                        other.checkEntityGroupVersion();
                    }
                    catch (ApiProxy.ApplicationException e) {
                        this.failed = true;
                        throw e;
                    }
                }
                tracker = new EntityGroupTracker(newEntityGroup);
                this.entityGroups.put(newEntityGroup, tracker);
            }
            return tracker;
        }

        synchronized Collection<EntityGroupTracker> getAllTrackers() {
            return this.entityGroups.values();
        }

        synchronized void addActions(Collection<TaskQueuePb.TaskQueueAddRequest> newActions) {
            this.checkFailed();
            if ((long)(this.actions.size() + newActions.size()) > 5L) {
                throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "Too many messages, maximum allowed: 5");
            }
            this.actions.addAll(newActions);
        }

        synchronized Collection<TaskQueuePb.TaskQueueAddRequest> getActions() {
            return new ArrayList<TaskQueuePb.TaskQueueAddRequest>(this.actions);
        }

        synchronized boolean isDirty() {
            this.checkFailed();
            for (EntityGroupTracker tracker : this.getAllTrackers()) {
                if (!tracker.isDirty()) continue;
                return true;
            }
            return false;
        }

        synchronized void close() {
            for (EntityGroupTracker tracker : this.getAllTrackers()) {
                tracker.getEntityGroup().removeTransaction(this);
            }
        }

        private void checkFailed() {
            if (this.failed) {
                throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, LocalDatastoreService.TRANSACTION_CLOSED);
            }
        }
    }

    class LiveQuery
    extends HasCreationTime {
        private final Set<String> orderProperties;
        private final Set<String> projectedProperties;
        private final Set<String> groupByProperties;
        private final DatastoreV3Pb.Query query;
        private List<OnestoreEntity.EntityProto> entities;
        private OnestoreEntity.EntityProto lastResult;
        private int remainingOffset;

        public LiveQuery(List<OnestoreEntity.EntityProto> entities, DatastoreV3Pb.Query query, EntityProtoComparators.EntityProtoComparator entityComparator, Clock clock) {
            int toIndex;
            super(clock.getCurrentTime());
            this.lastResult = null;
            this.remainingOffset = 0;
            if (entities == null) {
                throw new NullPointerException("entities cannot be null");
            }
            this.query = query;
            this.remainingOffset = query.getOffset();
            this.orderProperties = new HashSet<String>();
            for (DatastorePb.Query.Order order : entityComparator.getAdjustedOrders()) {
                if ("__key__".equals(order.getProperty())) continue;
                this.orderProperties.add(order.getProperty());
            }
            this.groupByProperties = Sets.newHashSet(query.groupByPropertyNames());
            this.projectedProperties = Sets.newHashSet(query.propertyNames());
            if (this.groupByProperties.isEmpty()) {
                this.entities = Lists.newArrayList(entities);
            } else {
                HashSet distinctEntities = Sets.newHashSet();
                ArrayList results = Lists.newArrayList();
                for (OnestoreEntity.EntityProto entity : entities) {
                    OnestoreEntity.EntityProto groupByResult = new OnestoreEntity.EntityProto();
                    for (OnestoreEntity.Property prop : entity.propertys()) {
                        if (!this.groupByProperties.contains(prop.getName())) continue;
                        groupByResult.addProperty().setName(prop.getName()).setValue(prop.getValue());
                    }
                    if (!distinctEntities.add(groupByResult)) continue;
                    results.add(entity);
                }
                this.entities = results;
            }
            DecompiledCursor startCursor = new DecompiledCursor(query.getCompiledCursor());
            this.lastResult = startCursor.getCursorEntity();
            int endCursorPos = new DecompiledCursor(query.getEndCompiledCursor()).getPosition(entityComparator, this.entities.size());
            int startCursorPos = Math.min(endCursorPos, startCursor.getPosition(entityComparator, 0));
            if (endCursorPos < this.entities.size()) {
                this.entities.subList(endCursorPos, this.entities.size()).clear();
            }
            this.entities.subList(0, startCursorPos).clear();
            if (query.hasLimit() && (toIndex = query.getLimit() + query.getOffset()) < this.entities.size()) {
                this.entities.subList(toIndex, this.entities.size()).clear();
            }
        }

        private int offsetResults(int offset) {
            int realOffset = Math.min(Math.min(offset, this.entities.size()), 300);
            if (realOffset > 0) {
                this.lastResult = this.entities.get(realOffset - 1);
                this.entities.subList(0, realOffset).clear();
                this.remainingOffset -= realOffset;
            }
            return realOffset;
        }

        public DatastoreV3Pb.QueryResult nextResult(Integer offset, Integer count, boolean compile) {
            DatastoreV3Pb.QueryResult result = new DatastoreV3Pb.QueryResult();
            if (count == null) {
                count = this.query.hasCount() ? Integer.valueOf(this.query.getCount()) : Integer.valueOf(20);
            }
            if (this.query.isPersistOffset()) {
                if (offset != null && offset != this.remainingOffset) {
                    throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "offset mismatch");
                }
                offset = this.remainingOffset;
            } else if (offset == null) {
                offset = 0;
            }
            if (offset > 0) {
                result.setSkippedResults(this.offsetResults(offset));
            }
            if (offset.intValue() == result.getSkippedResults()) {
                result.mutableResults().addAll(this.removeEntities(Math.min(300, count)));
            }
            result.setMoreResults(this.entities.size() > 0);
            result.setKeysOnly(this.query.isKeysOnly());
            if (compile) {
                result.getMutableCompiledCursor().addPosition(this.compilePosition());
            }
            return result;
        }

        private List<OnestoreEntity.EntityProto> removeEntities(int count) {
            List<OnestoreEntity.EntityProto> subList = this.entities.subList(0, Math.min(count, this.entities.size()));
            if (subList.size() > 0) {
                this.lastResult = subList.get(subList.size() - 1);
            }
            ArrayList<OnestoreEntity.EntityProto> results = new ArrayList<OnestoreEntity.EntityProto>(subList.size());
            for (OnestoreEntity.EntityProto entity : subList) {
                OnestoreEntity.EntityProto result;
                if (!this.projectedProperties.isEmpty()) {
                    result = new OnestoreEntity.EntityProto();
                    result.getMutableKey().copyFrom((ProtocolMessage)entity.getKey());
                    result.getMutableEntityGroup();
                    HashSet seenProps = Sets.newHashSetWithExpectedSize((int)this.query.propertyNameSize());
                    for (OnestoreEntity.Property prop : entity.propertys()) {
                        if (!this.projectedProperties.contains(prop.getName())) continue;
                        if (!seenProps.add(prop.getName())) {
                            throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.INTERNAL_ERROR, "LocalDatstoreServer produced invalude results.");
                        }
                        result.addProperty().setName(prop.getName()).setMeaning(OnestoreEntity.Property.Meaning.INDEX_VALUE).setMultiple(false).getMutableValue().copyFrom((ProtocolMessage)prop.getValue());
                    }
                } else if (this.query.isKeysOnly()) {
                    result = new OnestoreEntity.EntityProto();
                    result.getMutableKey().copyFrom((ProtocolMessage)entity.getKey());
                    result.getMutableEntityGroup();
                } else {
                    result = (OnestoreEntity.EntityProto)entity.clone();
                }
                LocalDatastoreService.this.processEntityForSpecialProperties(result, false);
                results.add(result);
            }
            subList.clear();
            return results;
        }

        private OnestoreEntity.EntityProto decompilePosition(DatastoreV3Pb.CompiledCursor.Position position) {
            OnestoreEntity.EntityProto result = new OnestoreEntity.EntityProto();
            if (position.hasKey()) {
                if (this.query.hasKind() && !this.query.getKind().equals(((OnestoreEntity.Path.Element)Iterables.getLast((Iterable)position.getKey().getPath().elements())).getType())) {
                    throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "Cursor does not match query.");
                }
                result.setKey(position.getKey());
            }
            Set<String> cursorProperties = this.groupByProperties.isEmpty() ? this.orderProperties : this.groupByProperties;
            HashSet<String> remainingProperties = new HashSet<String>(cursorProperties);
            for (DatastoreV3Pb.CompiledCursor.PositionIndexValue prop : position.indexValues()) {
                if (!cursorProperties.contains(prop.getProperty())) {
                    throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "Cursor does not match query.");
                }
                remainingProperties.remove(prop.getProperty());
                result.addProperty().setName(prop.getProperty()).setValue(prop.getValue());
            }
            if (!remainingProperties.isEmpty()) {
                throw Utils.newError(DatastoreV3Pb.Error.ErrorCode.BAD_REQUEST, "Cursor does not match query.");
            }
            return result;
        }

        private DatastoreV3Pb.CompiledCursor.Position compilePosition() {
            DatastoreV3Pb.CompiledCursor.Position position = new DatastoreV3Pb.CompiledCursor.Position();
            if (this.lastResult != null) {
                HashSet cursorProperties;
                if (this.groupByProperties.isEmpty()) {
                    cursorProperties = Sets.newHashSet(this.orderProperties);
                    cursorProperties.add("__key__");
                    position.setKey(this.lastResult.getKey());
                } else {
                    cursorProperties = this.groupByProperties;
                }
                for (OnestoreEntity.Property prop : this.lastResult.propertys()) {
                    if (!cursorProperties.contains(prop.getName())) continue;
                    position.addIndexValue().setProperty(prop.getName()).setValue(prop.getValue());
                }
                position.setStartInclusive(false);
            }
            return position;
        }

        public DatastoreV3Pb.CompiledQuery compileQuery() {
            DatastoreV3Pb.CompiledQuery result = new DatastoreV3Pb.CompiledQuery();
            DatastoreV3Pb.CompiledQuery.PrimaryScan scan = result.getMutablePrimaryScan();
            scan.setIndexNameAsBytes(this.query.toByteArray());
            return result;
        }

        class DecompiledCursor {
            final OnestoreEntity.EntityProto cursorEntity;
            final boolean inclusive;

            public DecompiledCursor(DatastoreV3Pb.CompiledCursor compiledCursor) {
                if (compiledCursor == null || compiledCursor.positionSize() == 0) {
                    this.cursorEntity = null;
                    this.inclusive = false;
                    return;
                }
                DatastoreV3Pb.CompiledCursor.Position position = compiledCursor.getPosition(0);
                if (!position.hasStartKey() && !position.hasKey() && position.indexValueSize() <= 0) {
                    this.cursorEntity = null;
                    this.inclusive = false;
                    return;
                }
                this.cursorEntity = LiveQuery.this.decompilePosition(position);
                this.inclusive = position.isStartInclusive();
            }

            public int getPosition(EntityProtoComparators.EntityProtoComparator entityComparator, int defaultValue) {
                if (this.cursorEntity == null) {
                    return defaultValue;
                }
                int loc = Collections.binarySearch(LiveQuery.this.entities, this.cursorEntity, entityComparator);
                if (loc < 0) {
                    return -(loc + 1);
                }
                return this.inclusive ? loc : loc + 1;
            }

            public OnestoreEntity.EntityProto getCursorEntity() {
                return this.cursorEntity;
            }
        }
    }

    static class HasCreationTime {
        private final long creationTime;

        HasCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }

        long getCreationTime() {
            return this.creationTime;
        }
    }

    static class Extent
    implements Serializable {
        private Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = new LinkedHashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();

        Extent() {
        }

        public Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> getEntities() {
            return this.entities;
        }
    }

    static class Profile
    implements Serializable {
        private final Map<String, Extent> extents = Collections.synchronizedMap(new HashMap());
        private transient Map<OnestoreEntity.Path, EntityGroup> groups;
        private transient Set<OnestoreEntity.Path> groupsWithUnappliedJobs;
        private transient Map<Long, LiveQuery> queries;
        private transient Map<Long, LiveTxn> txns;
        private final LocalFullTextIndex fullTextIndex = this.createFullTextIndex();

        public synchronized List<OnestoreEntity.EntityProto> getAllEntities() {
            ArrayList<OnestoreEntity.EntityProto> entities = new ArrayList<OnestoreEntity.EntityProto>();
            for (Extent extent : this.extents.values()) {
                entities.addAll(extent.getEntities().values());
            }
            return entities;
        }

        private LocalFullTextIndex createFullTextIndex() {
            Class<LocalFullTextIndex> indexClass = this.getFullTextIndexClass();
            if (indexClass == null) {
                return null;
            }
            try {
                return indexClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private Class<LocalFullTextIndex> getFullTextIndexClass() {
            try {
                return Class.forName("com.google.appengine.api.datastore.dev.LuceneFullTextIndex");
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
        }

        public Map<String, Extent> getExtents() {
            return this.extents;
        }

        public synchronized EntityGroup getGroup(OnestoreEntity.Path path) {
            Map<OnestoreEntity.Path, EntityGroup> map = this.getGroups();
            EntityGroup group = map.get(path);
            if (group == null) {
                group = new EntityGroup(path);
                map.put(path, group);
            }
            return group;
        }

        private synchronized void groom() {
            for (OnestoreEntity.Path path : new HashSet<OnestoreEntity.Path>(this.getGroupsWithUnappliedJobs())) {
                EntityGroup eg = this.getGroup(path);
                eg.maybeRollForwardUnappliedJobs();
            }
        }

        public synchronized LiveQuery getQuery(long cursor) {
            return (LiveQuery)LocalDatastoreService.safeGetFromExpiringMap(this.getQueries(), cursor, LocalDatastoreService.QUERY_NOT_FOUND);
        }

        public synchronized void addQuery(long cursor, LiveQuery query) {
            this.getQueries().put(cursor, query);
        }

        private synchronized LiveQuery removeQuery(long cursor) {
            LiveQuery query = this.getQuery(cursor);
            this.queries.remove(cursor);
            return query;
        }

        private synchronized Map<Long, LiveQuery> getQueries() {
            if (this.queries == null) {
                this.queries = new HashMap<Long, LiveQuery>();
            }
            return this.queries;
        }

        public synchronized LiveTxn getTxn(long handle) {
            return (LiveTxn)LocalDatastoreService.safeGetFromExpiringMap(this.getTxns(), handle, LocalDatastoreService.TRANSACTION_NOT_FOUND);
        }

        public LocalFullTextIndex getFullTextIndex() {
            return this.fullTextIndex;
        }

        public synchronized void addTxn(long handle, LiveTxn txn) {
            this.getTxns().put(handle, txn);
        }

        private synchronized LiveTxn removeTxn(long handle) {
            LiveTxn txn = this.getTxn(handle);
            txn.close();
            this.txns.remove(handle);
            return txn;
        }

        private synchronized Map<Long, LiveTxn> getTxns() {
            if (this.txns == null) {
                this.txns = new HashMap<Long, LiveTxn>();
            }
            return this.txns;
        }

        private synchronized Map<OnestoreEntity.Path, EntityGroup> getGroups() {
            if (this.groups == null) {
                this.groups = new LinkedHashMap<OnestoreEntity.Path, EntityGroup>();
            }
            return this.groups;
        }

        private synchronized Set<OnestoreEntity.Path> getGroupsWithUnappliedJobs() {
            if (this.groupsWithUnappliedJobs == null) {
                this.groupsWithUnappliedJobs = new LinkedHashSet<OnestoreEntity.Path>();
            }
            return this.groupsWithUnappliedJobs;
        }

        class EntityGroup {
            private final OnestoreEntity.Path path;
            private final AtomicLong version = new AtomicLong();
            private final WeakHashMap<LiveTxn, Profile> snapshots = new WeakHashMap();
            private final LinkedList<LocalDatastoreJob> unappliedJobs = new LinkedList();

            private EntityGroup(OnestoreEntity.Path path) {
                this.path = path;
            }

            public long getVersion() {
                return this.version.get();
            }

            public void incrementVersion() {
                long oldVersion = this.version.getAndIncrement();
                Profile snapshot = null;
                for (LiveTxn txn : this.snapshots.keySet()) {
                    if (txn.trackEntityGroup(this).getEntityGroupVersion() != oldVersion) continue;
                    if (snapshot == null) {
                        snapshot = this.takeSnapshot();
                    }
                    this.snapshots.put(txn, snapshot);
                }
            }

            public OnestoreEntity.EntityProto get(LiveTxn liveTxn, OnestoreEntity.Reference key, boolean eventualConsistency) {
                Profile profile;
                Map<String, Extent> extents;
                Extent extent;
                if (!eventualConsistency) {
                    this.rollForwardUnappliedJobs();
                }
                if ((extent = (extents = (profile = this.getSnapshot(liveTxn)).getExtents()).get(Utils.getKind(key))) != null) {
                    Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = extent.getEntities();
                    return entities.get(key);
                }
                return null;
            }

            public EntityGroupTracker addTransaction(LiveTxn txn) {
                EntityGroupTracker tracker = txn.trackEntityGroup(this);
                if (!this.snapshots.containsKey(txn)) {
                    this.snapshots.put(txn, null);
                }
                return tracker;
            }

            public void removeTransaction(LiveTxn txn) {
                this.snapshots.remove(txn);
            }

            private Profile getSnapshot(LiveTxn txn) {
                if (txn == null) {
                    return Profile.this;
                }
                Profile snapshot = this.snapshots.get(txn);
                if (snapshot == null) {
                    return Profile.this;
                }
                return snapshot;
            }

            private Profile takeSnapshot() {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(Profile.this);
                    oos.close();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    return (Profile)ois.readObject();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
            }

            public String toString() {
                return this.path.toString();
            }

            public DatastoreV3Pb.Cost addJob(LocalDatastoreJob job) {
                this.unappliedJobs.addLast(job);
                Profile.this.getGroupsWithUnappliedJobs().add(this.path);
                return this.maybeRollForwardUnappliedJobs();
            }

            public void rollForwardUnappliedJobs() {
                if (!this.unappliedJobs.isEmpty()) {
                    for (LocalDatastoreJob applyJob : this.unappliedJobs) {
                        applyJob.apply();
                    }
                    this.unappliedJobs.clear();
                    Profile.this.getGroupsWithUnappliedJobs().remove(this.path);
                    logger.fine("Rolled forward unapplied jobs for " + this.path);
                }
            }

            public DatastoreV3Pb.Cost maybeRollForwardUnappliedJobs() {
                int jobsAtStart = this.unappliedJobs.size();
                logger.fine(String.format("Maybe rolling forward %d unapplied jobs for %s.", jobsAtStart, this.path));
                int applied = 0;
                DatastoreV3Pb.Cost totalCost = new DatastoreV3Pb.Cost();
                Iterator iter = this.unappliedJobs.iterator();
                while (iter.hasNext()) {
                    LocalDatastoreJob.TryApplyResult result = ((LocalDatastoreJob)iter.next()).tryApply();
                    LocalDatastoreService.addTo(totalCost, result.cost);
                    if (!result.applied) break;
                    iter.remove();
                    ++applied;
                }
                if (this.unappliedJobs.isEmpty()) {
                    Profile.this.getGroupsWithUnappliedJobs().remove(this.path);
                }
                logger.fine(String.format("Rolled forward %d of %d jobs for %s", applied, jobsAtStart, this.path));
                return totalCost;
            }

            public Key pathAsKey() {
                OnestoreEntity.Reference entityGroupRef = new OnestoreEntity.Reference();
                entityGroupRef.setPath(this.path);
                return LocalCompositeIndexManager.KeyTranslator.createFromPb((OnestoreEntity.Reference)entityGroupRef);
            }
        }
    }

    public static enum AutoIdAllocationPolicy {
        SEQUENTIAL,
        SCATTERED;

    }
}

