/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.PublicDatastoreProtoConverter;
import com.google.storage.onestore.v3.OnestoreEntity;

@ServiceProvider(value=LocalRpcService.class)
public class LocalDatastoreV4Service
extends AbstractLocalRpcService {
    public static final String PACKAGE = "datastore_v4";
    private static final PublicDatastoreProtoConverter CONVERTER = new PublicDatastoreProtoConverter(){

        @Override
        protected String getKeyPropertyName() {
            return "__key__";
        }

        @Override
        public DatastoreV3Pb.Transaction toV3Transaction(ByteString v4Transaction) throws InvalidConversionException {
            try {
                return (DatastoreV3Pb.Transaction)((Object)DatastoreV3Pb.Transaction.PARSER.parseFrom(v4Transaction));
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toV4Transaction(DatastoreV3Pb.Transaction v3Transaction) {
            return v3Transaction.toByteString();
        }

        @Override
        public DatastoreV3Pb.CompiledCursor toV3CompiledCursor(ByteString queryCursor) throws InvalidConversionException {
            try {
                return (DatastoreV3Pb.CompiledCursor)((Object)DatastoreV3Pb.CompiledCursor.PARSER.parseFrom(queryCursor));
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toV4QueryCursor(DatastoreV3Pb.CompiledCursor compiledCursor) {
            return compiledCursor.toByteString();
        }

        @Override
        public DatastoreV3Pb.BeginTransactionRequest toV3BeginTransactionRequest(DatastoreV4.BeginTransactionRequestOrBuilder req) {
            DatastoreV3Pb.BeginTransactionRequest reqV3 = new DatastoreV3Pb.BeginTransactionRequest();
            reqV3.setApp(ApiProxy.getCurrentEnvironment().getAppId());
            reqV3.setAllowMultipleEg(req.getCrossGroup());
            return reqV3;
        }

        @Override
        public DatastoreV3Pb.Cursor toV3Cursor(ByteString v4QueryHandle) throws InvalidConversionException {
            try {
                return (DatastoreV3Pb.Cursor)((Object)DatastoreV3Pb.Cursor.PARSER.parseFrom(v4QueryHandle));
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toV4QueryHandle(DatastoreV3Pb.Cursor v3Cursor) {
            return v3Cursor.toByteString();
        }
    };

    public String getPackage() {
        return PACKAGE;
    }

    public DatastoreV4.BeginTransactionResponse beginTransaction(LocalRpcService.Status status, DatastoreV4.BeginTransactionRequest req) {
        try {
            return CONVERTER.toV4BeginTransactionResponse(this.makeV3Call("beginTransaction", (MessageLite)CONVERTER.toV3BeginTransactionRequest((DatastoreV4.BeginTransactionRequestOrBuilder)req), DatastoreV3Pb.Transaction.PARSER)).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    public DatastoreV4.CommitResponse commit(LocalRpcService.Status status, DatastoreV4.CommitRequest req) {
        DatastoreV4.CommitResponse.Builder builder = DatastoreV4.CommitResponse.newBuilder();
        try {
            builder.setMutationResult(this.applyMutation((DatastoreV4.MutationOrBuilder)req.getMutation(), req.getTransaction()));
            builder.getMutationResultBuilder().setIndexUpdates(builder.getMutationResultOrBuilder().getIndexUpdates() + this.makeV3Call("commit", (MessageLite)CONVERTER.toV3Transaction(req.getTransaction()), DatastoreV3Pb.CommitResponse.PARSER).getCost().getIndexWrites());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        return builder.build();
    }

    public DatastoreV4.RollbackResponse rollback(LocalRpcService.Status status, DatastoreV4.RollbackRequest req) {
        try {
            this.makeV3Call("rollback", (MessageLite)CONVERTER.toV3Transaction((DatastoreV4.RollbackRequestOrBuilder)req), ApiBasePb.VoidProto.PARSER);
            return DatastoreV4.RollbackResponse.getDefaultInstance();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    public DatastoreV4.GetResponse get(LocalRpcService.Status status, DatastoreV4.GetRequest request) {
        try {
            return CONVERTER.toV4GetResponse(this.makeV3Call("get", (MessageLite)CONVERTER.toV3GetRequest((DatastoreV4.GetRequestOrBuilder)request), DatastoreV3Pb.GetResponse.PARSER)).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    public DatastoreV4.WriteResponse write(LocalRpcService.Status status, DatastoreV4.WriteRequest request) {
        try {
            return DatastoreV4.WriteResponse.newBuilder().setMutationResult(this.applyMutation((DatastoreV4.MutationOrBuilder)request.getMutation(), null)).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    public DatastoreV4.RunQueryResponse runQuery(LocalRpcService.Status status, DatastoreV4.RunQueryRequest request) {
        try {
            return CONVERTER.toV4RunQueryResponse(this.makeV3Call("runQuery", (MessageLite)CONVERTER.toV3Query((DatastoreV4.RunQueryRequestOrBuilder)request), DatastoreV3Pb.QueryResult.PARSER)).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    public DatastoreV4.ContinueQueryResponse continueQuery(LocalRpcService.Status status, DatastoreV4.ContinueQueryRequest request) {
        try {
            return CONVERTER.toV4ContinueQueryResponse(this.makeV3Call("next", (MessageLite)CONVERTER.toV3NextRequest((DatastoreV4.ContinueQueryRequestOrBuilder)request), DatastoreV3Pb.QueryResult.PARSER)).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    private int insert(OnestoreEntity.EntityProto entity, DatastoreV3Pb.Transaction txn) throws InvalidConversionException {
        if (txn == null) {
            txn = this.makeV3Call("beginTransaction", (MessageLite)new DatastoreV3Pb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastoreV3Pb.Transaction.PARSER);
            this.insert(entity, txn);
            return this.makeV3Call("commit", (MessageLite)txn, DatastoreV3Pb.CommitResponse.PARSER).getCost().getIndexWrites();
        }
        DatastoreV3Pb.GetRequest get = new DatastoreV3Pb.GetRequest().setTransaction(txn);
        get.addKey(entity.getKey());
        DatastoreV3Pb.GetResponse res = this.makeV3Call("get", (MessageLite)get, DatastoreV3Pb.GetResponse.PARSER);
        if (res.getEntity(0).hasEntity()) {
            throw new ApiProxy.ApplicationException(1, "entity already exists");
        }
        DatastoreV3Pb.PutRequest put = new DatastoreV3Pb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return this.makeV3Call("put", (MessageLite)put, DatastoreV3Pb.PutResponse.PARSER).getCost().getIndexWrites();
    }

    private int update(OnestoreEntity.EntityProto entity, DatastoreV3Pb.Transaction txn) throws InvalidConversionException {
        if (txn == null) {
            txn = this.makeV3Call("beginTransaction", (MessageLite)new DatastoreV3Pb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastoreV3Pb.Transaction.PARSER);
            this.update(entity, txn);
            return this.makeV3Call("commit", (MessageLite)txn, DatastoreV3Pb.CommitResponse.PARSER).getCost().getIndexWrites();
        }
        DatastoreV3Pb.GetRequest get = new DatastoreV3Pb.GetRequest().setTransaction(txn);
        get.addKey(entity.getKey());
        DatastoreV3Pb.GetResponse res = this.makeV3Call("get", (MessageLite)get, DatastoreV3Pb.GetResponse.PARSER);
        if (!res.getEntity(0).hasEntity()) {
            throw new ApiProxy.ApplicationException(1, "entity already exists");
        }
        DatastoreV3Pb.PutRequest put = new DatastoreV3Pb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return this.makeV3Call("put", (MessageLite)put, DatastoreV3Pb.PutResponse.PARSER).getCost().getIndexWrites();
    }

    private DatastoreV4.MutationResult.Builder applyMutation(DatastoreV4.MutationOrBuilder mutation, ByteString v4Txn) throws InvalidConversionException {
        DatastoreV3Pb.Transaction txn = v4Txn == null ? null : CONVERTER.toV3Transaction(v4Txn);
        int indexWrites = 0;
        for (OnestoreEntity.EntityProto entity : mutation.getInsertList()) {
            indexWrites += this.insert(CONVERTER.toV3Entity(entity), txn);
        }
        for (OnestoreEntity.EntityProto entity : mutation.getUpdateList()) {
            indexWrites += this.update(CONVERTER.toV3Entity(entity), txn);
        }
        DatastoreV3Pb.PutRequest putReq = new DatastoreV3Pb.PutRequest();
        DatastoreV3Pb.DeleteRequest deleteReq = new DatastoreV3Pb.DeleteRequest();
        if (txn != null) {
            putReq.setTransaction(txn);
            deleteReq.setTransaction(txn);
        }
        for (OnestoreEntity.EntityProto entity : mutation.getInsertAutoIdList()) {
            putReq.addEntity(CONVERTER.toV3Entity(entity));
        }
        DatastoreV3Pb.PutResponse insertAutoResp = this.makeV3Call("put", (MessageLite)putReq, DatastoreV3Pb.PutResponse.PARSER);
        indexWrites += insertAutoResp.getCost().getIndexWrites();
        putReq.clearEntity();
        for (OnestoreEntity.EntityProto entity : mutation.getUpsertList()) {
            putReq.addEntity(CONVERTER.toV3Entity(entity));
        }
        indexWrites += this.makeV3Call("put", (MessageLite)putReq, DatastoreV3Pb.PutResponse.PARSER).getCost().getIndexWrites();
        for (OnestoreEntity.Reference key : mutation.getDeleteList()) {
            deleteReq.addKey(CONVERTER.toV3Reference(key));
        }
        DatastoreV4.MutationResult.Builder builder = DatastoreV4.MutationResult.newBuilder();
        builder.addAllInsertAutoIdKey(CONVERTER.toV4Reference(insertAutoResp.keys()));
        builder.setIndexUpdates(indexWrites += this.makeV3Call("delete", (MessageLite)deleteReq, DatastoreV3Pb.DeleteResponse.PARSER).getCost().getIndexWrites());
        return builder;
    }

    private <T> T makeV3Call(String method, MessageLite req, Parser<T> respParser) throws InvalidConversionException {
        try {
            return (T)respParser.parseFrom(ApiProxy.makeSyncCall((String)"datastore_v3", (String)method, (byte[])req.toByteArray()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }
}

