/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.shared.EquivalentMessageConverter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class DatastoreProtoConverter {
    private static final Converter<OnestoreEntity.Reference, OnestoreEntity.Reference> REFERENCE_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.Reference.PARSER, OnestoreEntity.Reference.PARSER);
    private static final Converter<OnestoreEntity.EntityProto, OnestoreEntity.EntityProto> ENTITY_PROTO_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.EntityProto.PARSER, OnestoreEntity.EntityProto.PARSER);
    private static final Converter<OnestoreEntity.PropertyValue, OnestoreEntity.PropertyValue> PROPERTY_VALUE_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.PropertyValue.PARSER, OnestoreEntity.PropertyValue.PARSER);
    private static final Converter<OnestoreEntity.CompositeIndex, OnestoreEntity.CompositeIndex> COMPOSITE_INDEX_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.PARSER, OnestoreEntity.CompositeIndex.PARSER);

    protected static void checkConversion(boolean expression, Object errorMessage) throws InvalidConversionException {
        if (!expression) {
            throw new InvalidConversionException(String.valueOf(errorMessage));
        }
    }

    protected static <V3 extends MessageLite, V4 extends MessageLite> List<V4> convertList(Converter<V3, V4> converter, List<V3> list) {
        return ImmutableList.copyOf((Collection)Lists.transform(list, converter));
    }

    protected abstract String getKeyPropertyName();

    public abstract DatastoreV3Pb.CompiledCursor toV3CompiledCursor(ByteString var1) throws InvalidConversionException;

    public abstract ByteString toV4QueryCursor(DatastoreV3Pb.CompiledCursor var1) throws InvalidConversionException;

    public OnestoreEntity.CompositeIndex toV3CompositeIndex(OnestoreEntity.CompositeIndex compositeIndex) {
        return (OnestoreEntity.CompositeIndex)COMPOSITE_INDEX_CONVERTER.reverse().convert((Object)compositeIndex);
    }

    public List<OnestoreEntity.CompositeIndex> toV3CompositeIndex(List<OnestoreEntity.CompositeIndex> compositeIndexes) {
        return DatastoreProtoConverter.convertList(COMPOSITE_INDEX_CONVERTER.reverse(), compositeIndexes);
    }

    public OnestoreEntity.CompositeIndex toV4CompositeIndex(OnestoreEntity.CompositeIndex compositeIndex) {
        return (OnestoreEntity.CompositeIndex)COMPOSITE_INDEX_CONVERTER.convert((Object)compositeIndex);
    }

    public List<OnestoreEntity.CompositeIndex> toV4CompositeIndex(List<OnestoreEntity.CompositeIndex> compositeIndexes) {
        return DatastoreProtoConverter.convertList(COMPOSITE_INDEX_CONVERTER, compositeIndexes);
    }

    public OnestoreEntity.Reference toV3Reference(OnestoreEntity.Reference reference) {
        return (OnestoreEntity.Reference)REFERENCE_CONVERTER.reverse().convert((Object)reference);
    }

    public List<OnestoreEntity.Reference> toV3Reference(List<OnestoreEntity.Reference> references) {
        return DatastoreProtoConverter.convertList(REFERENCE_CONVERTER.reverse(), references);
    }

    public OnestoreEntity.Reference toV4Reference(OnestoreEntity.Reference reference) {
        return (OnestoreEntity.Reference)REFERENCE_CONVERTER.convert((Object)reference);
    }

    public List<OnestoreEntity.Reference> toV4Reference(List<OnestoreEntity.Reference> references) {
        return DatastoreProtoConverter.convertList(REFERENCE_CONVERTER, references);
    }

    public OnestoreEntity.EntityProto toV4Entity(OnestoreEntity.EntityProto entity) {
        return (OnestoreEntity.EntityProto)ENTITY_PROTO_CONVERTER.convert((Object)entity);
    }

    public List<OnestoreEntity.EntityProto> toV4Entity(List<OnestoreEntity.EntityProto> entities) {
        return DatastoreProtoConverter.convertList(ENTITY_PROTO_CONVERTER, entities);
    }

    public OnestoreEntity.EntityProto toV3Entity(OnestoreEntity.EntityProto entity) {
        return (OnestoreEntity.EntityProto)ENTITY_PROTO_CONVERTER.reverse().convert((Object)entity);
    }

    public List<OnestoreEntity.EntityProto> toV3Entity(List<OnestoreEntity.EntityProto> entities) {
        return DatastoreProtoConverter.convertList(ENTITY_PROTO_CONVERTER.reverse(), entities);
    }

    protected static OnestoreEntity.PropertyValue toV4PropertyValue(OnestoreEntity.PropertyValue propValue) {
        return (OnestoreEntity.PropertyValue)PROPERTY_VALUE_CONVERTER.convert((Object)propValue);
    }

    public DatastoreV4.Query.Builder toV4Query(DatastoreV3Pb.Query query) throws InvalidConversionException {
        DatastoreV4.Query.Builder builder = DatastoreV4.Query.newBuilder();
        DatastoreProtoConverter.checkConversion(!query.hasDistinct(), "distinct option not supported");
        DatastoreProtoConverter.checkConversion(query.isRequirePerfectPlan(), "non-perfect plans not supported");
        if (query.hasLimit()) {
            builder.setLimit(query.getLimit());
        }
        if (query.getOffset() != 0) {
            builder.setOffset(query.getOffset());
        }
        if (query.hasCompiledCursor()) {
            builder.setStartCursor(this.toV4QueryCursor(query.getCompiledCursor()));
        }
        if (query.hasEndCompiledCursor()) {
            builder.setEndCursor(this.toV4QueryCursor(query.getEndCompiledCursor()));
        }
        if (query.hasKind()) {
            builder.addKindBuilder().setName(query.getKind());
        }
        for (String name : query.propertyNames()) {
            builder.addProjectionBuilder().getPropertyBuilder().setName(name);
        }
        if (query.isKeysOnly()) {
            builder.addProjectionBuilder().getPropertyBuilder().setName(this.getKeyPropertyName());
        }
        for (String name : query.groupByPropertyNames()) {
            builder.addGroupByBuilder().setName(name);
        }
        DatastoreV4.CompositeFilter.Builder filter = DatastoreV4.CompositeFilter.newBuilder();
        filter.setOperator(DatastoreV4.CompositeFilter.Operator.AND);
        if (query.hasAncestor()) {
            DatastoreV4.PropertyFilter.Builder propFilter = filter.addFilterBuilder().getPropertyFilterBuilder();
            propFilter.setOperator(DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR);
            propFilter.getPropertyBuilder().setName(this.getKeyPropertyName());
            propFilter.setValue(DatastoreProtoConverter.toV4PropertyValue(Paths.toReferenceProperty(query.getAncestor())));
        }
        for (DatastoreV3Pb.Query.Filter filterV3 : query.filters()) {
            DatastoreProtoConverter.checkConversion(filterV3.propertySize() == 1, "invalid filter");
            DatastoreProtoConverter.checkConversion(filterV3.getOp() <= 5, "unsupported filter: " + (Object)((Object)filterV3.getOpEnum()));
            DatastoreV4.PropertyFilter.Builder propFilter = filter.addFilterBuilder().getPropertyFilterBuilder();
            propFilter.setOperator(DatastoreV4.PropertyFilter.Operator.valueOf((int)filterV3.getOp()));
            propFilter.getPropertyBuilder().setName(filterV3.getProperty(0).getName());
            propFilter.setValue(DatastoreProtoConverter.toV4PropertyValue(filterV3.getProperty(0).getValue()));
        }
        if (filter.getFilterCount() == 1) {
            builder.setFilter(filter.getFilterBuilder(0));
        } else if (filter.getFilterCount() > 1) {
            builder.getFilterBuilder().setCompositeFilter(filter);
        }
        for (DatastoreV3Pb.Query.Order order : query.orders()) {
            DatastoreV4.PropertyOrder.Builder orderV4 = builder.addOrderBuilder();
            orderV4.getPropertyBuilder().setName(order.getProperty());
            if (!order.hasDirection()) continue;
            orderV4.setDirection(OnestoreEntity.Index.Property.Direction.valueOf((int)order.getDirection()));
        }
        return builder;
    }

    public DatastoreV3Pb.Query toV3Query(DatastoreV4.QueryOrBuilder query) throws InvalidConversionException {
        DatastoreV3Pb.Query result = new DatastoreV3Pb.Query();
        result.setPersistOffset(true);
        result.setRequirePerfectPlan(true);
        result.setCompile(true);
        if (query.hasLimit()) {
            result.setLimit(query.getLimit());
        }
        if (query.getOffset() != 0) {
            result.setOffset(query.getOffset());
        }
        if (query.hasStartCursor()) {
            result.setCompiledCursor(this.toV3CompiledCursor(query.getStartCursor()));
        }
        if (query.hasEndCursor()) {
            result.setEndCompiledCursor(this.toV3CompiledCursor(query.getEndCursor()));
        }
        if (query.getKindCount() > 0) {
            DatastoreProtoConverter.checkConversion(query.getKindCount() == 1, "multiple kinds not supported");
            result.setKind(query.getKind(0).getName());
        }
        boolean hasKeyProjection = false;
        for (DatastoreV4.PropertyExpression prop : query.getProjectionList()) {
            if (this.getKeyPropertyName().equals(prop.getProperty().getName())) {
                hasKeyProjection = true;
                continue;
            }
            result.addPropertyName(prop.getProperty().getName());
        }
        if (hasKeyProjection && result.propertyNameSize() == 0) {
            result.setKeysOnly(true);
        }
        for (DatastoreV4.PropertyExpression prop : query.getGroupByList()) {
            result.addGroupByPropertyName(prop.getName());
        }
        Pair<List<DatastoreV3Pb.Query.Filter>, OnestoreEntity.Reference> filters = this.toV3Filters((DatastoreV4.FilterOrBuilder)query.getFilter());
        if (filters.second != null) {
            result.setAncestor((OnestoreEntity.Reference)filters.second);
        }
        result.mutableFilters().addAll((Collection)filters.first);
        for (DatastoreV4.PropertyOrder order : query.getOrderList()) {
            DatastoreV3Pb.Query.Order orderV3 = result.addOrder();
            orderV3.setProperty(order.getProperty().getName());
            if (!order.hasDirection()) continue;
            orderV3.setDirection(order.getDirection().getNumber());
        }
        return result;
    }

    private Pair<List<DatastoreV3Pb.Query.Filter>, OnestoreEntity.Reference> toV3Filters(DatastoreV4.FilterOrBuilder filter) throws InvalidConversionException {
        if (filter.hasPropertyFilter()) {
            if (filter.getPropertyFilter().getOperator().equals((Object)DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR)) {
                DatastoreProtoConverter.checkConversion(filter.getPropertyFilter().getValue().hasReferenceValue(), "HAS_ANCESTOR requires a reference value");
                DatastoreProtoConverter.checkConversion(this.getKeyPropertyName().equals(filter.getPropertyFilter().getProperty().getName()), "unsupported property");
                OnestoreEntity.PropertyValue value = new OnestoreEntity.PropertyValue();
                value.mergeFrom(filter.getPropertyFilter().getValue().toByteArray());
                OnestoreEntity.Reference ancestor = new OnestoreEntity.Reference();
                return Pair.of(Collections.emptyList(), (Object)Paths.toReference(value));
            }
            DatastoreV3Pb.Query.Filter result = new DatastoreV3Pb.Query.Filter();
            result.setOp(filter.getPropertyFilter().getOperator().getNumber());
            result.addProperty().setMultiple(false).setName(filter.getPropertyFilter().getProperty().getName()).getMutableValue().mergeFrom(filter.getPropertyFilter().getValue().toByteArray());
            return Pair.of(Collections.singletonList(result), (Object)null);
        }
        if (filter.hasCompositeFilter()) {
            DatastoreProtoConverter.checkConversion(filter.getCompositeFilter().getOperator() == DatastoreV4.CompositeFilter.Operator.AND, "unsupported composite property operator");
            OnestoreEntity.Reference ancestor = null;
            ArrayList filters = Lists.newArrayList();
            for (DatastoreV4.Filter subFilter : filter.getCompositeFilter().getFilterList()) {
                Pair<List<DatastoreV3Pb.Query.Filter>, OnestoreEntity.Reference> result = this.toV3Filters((DatastoreV4.FilterOrBuilder)subFilter);
                if (result.second != null) {
                    DatastoreProtoConverter.checkConversion(ancestor == null, "duplicate ancestor contraint");
                    ancestor = (OnestoreEntity.Reference)result.second;
                }
                filters.addAll((Collection)result.first);
            }
            return Pair.of((Object)filters, ancestor);
        }
        return Pair.of(Collections.emptyList(), (Object)null);
    }

    public DatastoreV3Pb.QueryResult toV3QueryResult(DatastoreV4.QueryResultBatchOrBuilder batch) throws InvalidConversionException {
        DatastoreV3Pb.QueryResult result = new DatastoreV3Pb.QueryResult();
        result.setMoreResults(batch.getMoreResults() == DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED);
        if (batch.hasEndCursor()) {
            result.setCompiledCursor(this.toV3CompiledCursor(batch.getEndCursor()));
        }
        if (batch.getEntityResultType() == DatastoreV4.EntityResult.ResultType.PROJECTION) {
            result.setIndexOnly(true);
        } else if (batch.getEntityResultType() == DatastoreV4.EntityResult.ResultType.KEY_ONLY) {
            result.setKeysOnly(true);
        }
        if (batch.hasSkippedResults()) {
            result.setSkippedResults(batch.getSkippedResults());
        }
        for (DatastoreV4.EntityResult entity : batch.getEntityResultList()) {
            result.addResult(this.toV3Entity(entity.getEntity()));
        }
        return result;
    }

    public DatastoreV4.QueryResultBatch.Builder toV4QueryResultBatch(DatastoreV3Pb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.QueryResultBatch.Builder builder = DatastoreV4.QueryResultBatch.newBuilder();
        builder.setMoreResults(result.isMoreResults() ? DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED : DatastoreV4.QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT);
        if (result.hasCompiledCursor()) {
            builder.setEndCursor(this.toV4QueryCursor(result.getCompiledCursor()));
        }
        builder.setEntityResultType(result.isKeysOnly() ? DatastoreV4.EntityResult.ResultType.KEY_ONLY : (result.isIndexOnly() ? DatastoreV4.EntityResult.ResultType.PROJECTION : DatastoreV4.EntityResult.ResultType.FULL));
        if (result.hasSkippedResults()) {
            builder.setSkippedResults(result.getSkippedResults());
        }
        for (OnestoreEntity.EntityProto entity : result.results()) {
            builder.addEntityResultBuilder().setEntity(this.toV4Entity(entity));
        }
        return builder;
    }
}

