/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.servers.dev;

import com.google.appengine.api.labs.servers.ServersServicePb;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServersController;
import com.google.appengine.tools.development.ServiceProvider;

@ServiceProvider(value=LocalRpcService.class)
public class LocalServersService
extends AbstractLocalRpcService {
    private static final int MAIN_INSTANCE = -1;
    public static final String PACKAGE = "servers";
    private ServersController serversController;

    public String getPackage() {
        return PACKAGE;
    }

    public ServersServicePb.GetServersResponse getServers(LocalRpcService.Status status, ServersServicePb.GetServersRequest request) {
        ServersServicePb.GetServersResponse.Builder result = ServersServicePb.GetServersResponse.newBuilder();
        for (String serverName : this.serversController.getServerNames()) {
            result.addServer(serverName);
        }
        status.setSuccessful(true);
        return result.build();
    }

    public ServersServicePb.GetVersionsResponse getVersions(LocalRpcService.Status status, ServersServicePb.GetVersionsRequest request) {
        status.setSuccessful(false);
        ServersServicePb.GetVersionsResponse.Builder result = ServersServicePb.GetVersionsResponse.newBuilder();
        String serverName = request.getServer();
        Iterable versions = this.serversController.getVersions(serverName);
        for (String version : versions) {
            result.addVersion(version);
        }
        status.setSuccessful(true);
        return result.build();
    }

    public ServersServicePb.GetDefaultVersionResponse getDefaultVersion(LocalRpcService.Status status, ServersServicePb.GetDefaultVersionRequest request) {
        status.setSuccessful(false);
        ServersServicePb.GetDefaultVersionResponse.Builder result = ServersServicePb.GetDefaultVersionResponse.newBuilder();
        String serverName = request.getServer();
        String version = this.serversController.getDefaultVersion(serverName);
        result.setVersion(version);
        status.setSuccessful(true);
        return result.build();
    }

    public ServersServicePb.GetNumInstancesResponse getNumInstances(LocalRpcService.Status status, ServersServicePb.GetNumInstancesRequest request) {
        status.setSuccessful(false);
        ServersServicePb.GetNumInstancesResponse.Builder result = ServersServicePb.GetNumInstancesResponse.newBuilder();
        String serverName = request.getServer();
        String version = request.getVersion();
        int numInstances = this.serversController.getNumInstances(serverName, version);
        result.setInstances((long)numInstances);
        status.setSuccessful(true);
        return result.build();
    }

    public ServersServicePb.SetNumInstancesResponse setNumInstances(LocalRpcService.Status status, ServersServicePb.SetNumInstancesRequest request) {
        throw new UnsupportedOperationException("ServersService.setNumInstances not currentlysupported by java dev appserver");
    }

    public ServersServicePb.StartServerResponse startServer(LocalRpcService.Status status, ServersServicePb.StartServerRequest request) {
        throw new UnsupportedOperationException("ServersService.startServer not currently supported by java dev appserver");
    }

    public ServersServicePb.StopServerResponse stopServer(LocalRpcService.Status status, ServersServicePb.StopServerRequest request) {
        throw new UnsupportedOperationException("ServersService.startServer not currently supported by java dev appserver");
    }

    public ServersServicePb.GetHostnameResponse getHostname(LocalRpcService.Status status, ServersServicePb.GetHostnameRequest request) {
        status.setSuccessful(false);
        ServersServicePb.GetHostnameResponse.Builder result = ServersServicePb.GetHostnameResponse.newBuilder();
        String serverName = request.getServer();
        String version = request.getVersion();
        int instance = request.hasInstance() ? Integer.parseInt(request.getInstance()) : -1;
        result.setHostname(this.serversController.getHostname(serverName, version, instance));
        status.setSuccessful(true);
        return result.build();
    }

    public void setServersControler(ServersController serversController) {
        this.serversController = serversController;
    }
}

