/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.ExpressionLexer;
import com.google.appengine.api.search.ExpressionParser;
import com.google.appengine.api.search.dev.BinaryNumericExpression;
import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.FieldExpression;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.appengine.api.search.dev.ScoreExpression;
import com.google.appengine.api.search.dev.SnippetExpression;
import com.google.appengine.repackaged.org.antlr.runtime.ANTLRStringStream;
import com.google.appengine.repackaged.org.antlr.runtime.CharStream;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream;
import com.google.appengine.repackaged.org.antlr.runtime.TokenSource;
import com.google.appengine.repackaged.org.antlr.runtime.TokenStream;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;

public class ExpressionBuilder {
    private static final Logger LOG = Logger.getLogger(ExpressionBuilder.class.getName());
    private final Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes;

    public ExpressionBuilder(Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public Expression parse(String expr) {
        Tree tree;
        if (expr == null) {
            throw new IllegalArgumentException("Unexpected null expression");
        }
        String trimmed = expr.trim();
        if (trimmed.isEmpty()) {
            return new EmptyExpression();
        }
        ANTLRStringStream stream = new ANTLRStringStream(expr);
        ExpressionLexer lexer = new ExpressionLexer((CharStream)stream);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        ExpressionParser parser = new ExpressionParser((TokenStream)tokens);
        try {
            tree = (Tree)parser.expression().getTree();
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException("Failed to parse " + expr);
        }
        if (!tree.isNil()) {
            throw new IllegalArgumentException("AST is missing nil root " + expr);
        }
        return this.makeExpression(tree.getChild(0));
    }

    private void print(int offset, String msg) {
        for (int i = 0; i < offset; ++i) {
            System.err.print(" ");
        }
        System.err.println(msg);
    }

    private void dumpTree(Tree tree, int offset) {
        this.print(offset, String.format("%s", ExpressionBuilder.getTokenName(tree.getType())));
        if (!tree.getText().isEmpty()) {
            this.print(offset + 2, String.format("TEXT: %s", tree.getText()));
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            this.print(offset, String.format("%s[%d]", ExpressionBuilder.getTokenName(tree.getType()), i));
            this.dumpTree(tree.getChild(i), offset + 2);
        }
    }

    private String getText(Tree tree) {
        if (tree.getType() == 26) {
            return tree.getText();
        }
        if (tree.getType() == 28) {
            String text = tree.getText();
            return text.substring(1, text.length() - 1);
        }
        throw new IllegalArgumentException("text expression expected instead of " + ExpressionBuilder.getTokenName(tree.getType()));
    }

    private CountFieldsFunction makeCountFieldsFunction(Tree tree) {
        if (tree.getChildCount() != 1) {
            throw new IllegalArgumentException("Incorrect number of arguments for COUNT expression.");
        }
        Tree field = tree.getChild(0);
        if (field.getType() != 26) {
            throw new IllegalArgumentException("Field name expected");
        }
        String fieldName = field.getText();
        Set<DocumentPb.FieldValue.ContentType> types = this.fieldTypes.get(fieldName);
        if (types == null) {
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        ArrayList<String> luceneFieldNames = new ArrayList<String>(types.size());
        for (DocumentPb.FieldValue.ContentType type : types) {
            luceneFieldNames.add(LuceneUtils.makeLuceneFieldName(fieldName, type));
        }
        return new CountFieldsFunction(luceneFieldNames);
    }

    private Expression makeSnippetFunction(Tree tree) {
        int nchildren = tree.getChildCount();
        if (nchildren < 2) {
            throw new IllegalArgumentException("Missing required arguments: query and fieldName");
        }
        String query = this.getText(tree.getChild(0));
        Tree field = tree.getChild(1);
        if (field.getType() != 26) {
            throw new IllegalArgumentException("Field name expected");
        }
        String fieldName = field.getText();
        Set<DocumentPb.FieldValue.ContentType> types = this.fieldTypes.get(fieldName);
        if (types == null) {
            throw new IllegalArgumentException("Unknown field: " + fieldName);
        }
        NumericExpression maxCharsExpression = nchildren < 3 ? new IntValueExpression(160.0) : this.makeNumericExpression(tree.getChild(2));
        NumericExpression maxSnippetsExpression = nchildren < 4 ? new IntValueExpression(3.0) : this.makeNumericExpression(tree.getChild(3));
        return SnippetExpression.makeSnippetExpression(query, fieldName, types, maxCharsExpression, maxSnippetsExpression);
    }

    static String getTokenName(int tokenType) {
        return new ExpressionParser(null).getTokenNames()[tokenType];
    }

    private BinaryNumericExpression makeNumericBinaryExpression(Tree tree) {
        BinaryNumericExpression op = BinaryNumericExpression.make(tree.getType());
        op.init(this.makeNumericExpression(tree.getChild(0)), this.makeNumericExpression(tree.getChild(1)));
        return op;
    }

    private NumericExpression makeNumericExpression(Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Unexpected null node encountered");
        }
        switch (tree.getType()) {
            case 31: {
                return this.makeCountFieldsFunction(tree);
            }
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: {
                throw new IllegalArgumentException("Function " + tree.getText() + " not yet implemented");
            }
            case 33: 
            case 39: {
                throw new IllegalArgumentException("Function " + tree.getText() + " does not return numeric value");
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return this.makeNumericBinaryExpression(tree);
            }
            case 24: {
                return this.makeIntValueExpression(tree);
            }
            case 4: {
                return new NegExpression(this.makeNumericExpression(tree.getChild(0)));
            }
            case 26: {
                if ("_score".equals(tree.getText())) {
                    return new ScoreExpression();
                }
                FieldExpression e = FieldExpression.makeFieldExpression(tree.getText(), this.fieldTypes.get(tree.getText()));
                e.checkType(DocumentPb.FieldValue.ContentType.NUMBER);
                return e;
            }
        }
        throw new IllegalArgumentException("Not yet implemented or unexpected: " + ExpressionBuilder.getTokenName(tree.getType()));
    }

    private IntValueExpression makeIntValueExpression(Tree tree) {
        String value = tree.getText();
        try {
            return new IntValueExpression(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wrong number format: " + value);
        }
    }

    private Expression makeExpression(Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Unexpected null node encountered");
        }
        switch (tree.getType()) {
            case 31: {
                return this.makeCountFieldsFunction(tree);
            }
            case 39: {
                return this.makeSnippetFunction(tree);
            }
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: {
                LOG.warning(String.format("Function %s not implemented. Using dummy expression.", tree.getText()));
                return new EmptyExpression();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return this.makeNumericBinaryExpression(tree);
            }
            case 24: {
                return this.makeIntValueExpression(tree);
            }
            case 4: {
                return new NegExpression(this.makeNumericExpression(tree.getChild(0)));
            }
            case 26: {
                if ("_score".equals(tree.getText())) {
                    return new ScoreExpression();
                }
                return FieldExpression.makeFieldExpression(tree.getText(), this.fieldTypes.get(tree.getText()));
            }
        }
        throw new IllegalArgumentException("Not yet implemented: " + ExpressionBuilder.getTokenName(tree.getType()));
    }

    private static class NegExpression
    extends NumericExpression {
        private final NumericExpression input;

        NegExpression(NumericExpression input) {
            this.input = input;
        }

        @Override
        public double evalDouble(Document doc) throws EvaluationException {
            return -this.input.evalDouble(doc);
        }
    }

    public static class IntValueExpression
    extends NumericExpression {
        private final Double value;

        IntValueExpression(double value) {
            this.value = value;
        }

        @Override
        public double evalDouble(Document doc) {
            return this.value;
        }
    }

    private static class CountFieldsFunction
    extends NumericExpression {
        private final List<String> luceneFieldNames;

        CountFieldsFunction(List<String> luceneFieldNames) {
            this.luceneFieldNames = luceneFieldNames;
        }

        @Override
        public double evalDouble(Document doc) {
            int result = 0;
            for (String fieldName : this.luceneFieldNames) {
                result += doc.getFields(fieldName).length;
            }
            return result;
        }
    }

    public static class EmptyExpression
    extends Expression {
        @Override
        public DocumentPb.FieldValue eval(Document doc) throws EvaluationException {
            throw new EvaluationException("empty expression");
        }

        @Override
        public List<Expression.Sorter> getSorters(int sign, double dfltD, String dfltT) {
            return new ArrayList<Expression.Sorter>();
        }
    }
}

