/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.ValidationException;

public abstract class BaseDatastoreV4Validator {
    protected final EntityV4Validator entityValidator;

    public BaseDatastoreV4Validator(EntityV4Validator entityValidator) {
        this.entityValidator = entityValidator;
    }

    protected abstract String getKeyPropertyName();

    protected void validateMutation(DatastoreV4.MutationOrBuilder mutation) throws ValidationException {
        this.validateEntities(EntityV4Validator.KeyConstraint.PATH_COMPLETE, mutation.getUpsertOrBuilderList());
        this.validateEntities(EntityV4Validator.KeyConstraint.PATH_COMPLETE, mutation.getUpdateOrBuilderList());
        this.validateEntities(EntityV4Validator.KeyConstraint.PATH_COMPLETE, mutation.getInsertOrBuilderList());
        this.validateEntities(EntityV4Validator.KeyConstraint.PATH_INCOMPLETE, mutation.getInsertAutoIdOrBuilderList());
        this.validateKeys(EntityV4Validator.KeyConstraint.PATH_COMPLETE, mutation.getDeleteOrBuilderList());
    }

    protected void validateEntities(EntityV4Validator.KeyConstraint keyConstraint, Iterable<? extends EntityV4.EntityOrBuilder> entities) throws ValidationException {
        for (EntityV4.EntityOrBuilder entityOrBuilder : entities) {
            this.entityValidator.validateEntity(keyConstraint, entityOrBuilder);
        }
    }

    protected void validateKeys(EntityV4Validator.KeyConstraint keyConstraint, Iterable<? extends EntityV4.KeyOrBuilder> keys) throws ValidationException {
        for (EntityV4.KeyOrBuilder keyOrBuilder : keys) {
            this.entityValidator.validateKey(keyConstraint, keyOrBuilder);
        }
    }

    protected void validateQuery(DatastoreV4.QueryOrBuilder query) throws ValidationException {
        if (query.hasFilter()) {
            this.validateFilter(query.getFilterOrBuilder());
        }
        for (DatastoreV4.KindExpressionOrBuilder kindExp : query.getKindOrBuilderList()) {
            this.validateKindExpression(kindExp);
        }
        for (DatastoreV4.PropertyExpressionOrBuilder propExp : query.getProjectionOrBuilderList()) {
            this.validatePropertyExpression(propExp);
        }
        for (DatastoreV4.PropertyReferenceOrBuilder propRef : query.getGroupByOrBuilderList()) {
            this.validatePropertyReference(propRef);
        }
        for (DatastoreV4.PropertyOrderOrBuilder order : query.getOrderOrBuilderList()) {
            this.validatePropertyOrder(order);
        }
    }

    private void validatePropertyOrder(DatastoreV4.PropertyOrderOrBuilder order) throws ValidationException {
        this.validatePropertyReference((DatastoreV4.PropertyReferenceOrBuilder)order.getProperty());
    }

    private void validatePropertyExpression(DatastoreV4.PropertyExpressionOrBuilder propExp) throws ValidationException {
        this.validatePropertyReference(propExp.getPropertyOrBuilder());
    }

    private void validateKindExpression(DatastoreV4.KindExpressionOrBuilder kindExp) throws ValidationException {
        this.entityValidator.validateStringUtf8("kind name", kindExp.getNameBytes());
    }

    private void validatePropertyReference(DatastoreV4.PropertyReferenceOrBuilder propertyRef) throws ValidationException {
        this.entityValidator.validateStringUtf8("property name", propertyRef.getNameBytes());
    }

    private void validateFilter(DatastoreV4.FilterOrBuilder filter) throws ValidationException {
        ValidationException.validateAssertion(filter.getAllFields().size() == 1, "a filter must have exactly one of its fields set", new Object[0]);
        if (filter.hasCompositeFilter()) {
            DatastoreV4.CompositeFilterOrBuilder cmpFilter = filter.getCompositeFilterOrBuilder();
            ValidationException.validateAssertion(cmpFilter.getFilterCount() > 0, "a composite filter must have at least one sub-filter", new Object[0]);
            for (DatastoreV4.FilterOrBuilder subFilter : cmpFilter.getFilterOrBuilderList()) {
                this.validateFilter(subFilter);
            }
        } else if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
            this.validatePropertyReference(propFilter.getPropertyOrBuilder());
            ValidationException.validateAssertion(propFilter.getValueOrBuilder().getIndexed(), "a filter value must be indexed", new Object[0]);
            this.entityValidator.validateValue((EntityV4.ValueOrBuilder)propFilter.getValue());
        }
    }

    protected boolean hasAncestor(DatastoreV4.FilterOrBuilder filter) {
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
            return propFilter.getOperator() == DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR && propFilter.getPropertyOrBuilder().getName().equals(this.getKeyPropertyName());
        }
        if (filter.hasCompositeFilter() && filter.getCompositeFilter().getOperator() == DatastoreV4.CompositeFilter.Operator.AND) {
            for (DatastoreV4.Filter subFilter : filter.getCompositeFilter().getFilterList()) {
                if (!this.hasAncestor((DatastoreV4.FilterOrBuilder)subFilter)) continue;
                return true;
            }
        }
        return false;
    }
}

