/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.BaseDatastoreProtoConverter;
import com.google.apphosting.datastore.shared.EntityProtoConverter;
import com.google.apphosting.datastore.shared.GqlQueryTranslator;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.storage.onestore.v3.OnestoreEntity;

public abstract class DatastoreProtoConverter
extends BaseDatastoreProtoConverter {
    private final GqlQueryTranslator gqlQueryTranslator;

    public DatastoreProtoConverter(EntityProtoConverter entityProtoConverter, GqlQueryTranslator gqlQueryTranslator) {
        super(entityProtoConverter);
        this.gqlQueryTranslator = gqlQueryTranslator;
    }

    public abstract DatastoreV3Pb.BeginTransactionRequest toV3BeginTransactionRequest(DatastoreV4.BeginTransactionRequestOrBuilder var1) throws InvalidConversionException;

    public abstract DatastoreV3Pb.Transaction toV3Transaction(ByteString var1) throws InvalidConversionException;

    protected abstract ByteString toV4Transaction(DatastoreV3Pb.Transaction var1) throws InvalidConversionException;

    protected abstract DatastoreV3Pb.Cursor toV3Cursor(ByteString var1) throws InvalidConversionException;

    protected abstract ByteString toV4QueryHandle(DatastoreV3Pb.Cursor var1) throws InvalidConversionException;

    public DatastoreV4.GetRequest.Builder toV4GetRequest(DatastoreV3Pb.GetRequest req) throws InvalidConversionException {
        DatastoreV4.GetRequest.Builder builder = DatastoreV4.GetRequest.newBuilder();
        DatastoreProtoConverter.checkConversion(req.isAllowDeferred(), "allow_deferred must be true");
        if (req.hasTransaction()) {
            builder.getReadOptionsBuilder().setTransaction(this.toV4Transaction(req.getTransaction()));
        } else if (req.isStrong()) {
            builder.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.STRONG);
        } else if (req.hasFailoverMs()) {
            builder.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL);
        }
        for (OnestoreEntity.Reference key : req.keys()) {
            builder.addKey(this.entityProtoConverter.toV4Key(key));
        }
        return builder;
    }

    public DatastoreV3Pb.GetRequest toV3GetRequest(DatastoreV4.GetRequestOrBuilder req) throws InvalidConversionException {
        DatastoreV3Pb.GetRequest get = new DatastoreV3Pb.GetRequest();
        get.setAllowDeferred(true);
        if (req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL) {
            get.setFailoverMs(-1L);
        } else if (req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG) {
            get.setStrong(true);
        }
        if (req.getReadOptionsOrBuilder().hasTransaction()) {
            get.setTransaction(this.toV3Transaction(req.getReadOptionsOrBuilder().getTransaction()));
        }
        for (EntityV4.Key key : req.getKeyList()) {
            get.addKey(this.entityProtoConverter.toV3Reference((EntityV4.KeyOrBuilder)key));
        }
        return get;
    }

    public DatastoreV4.GetResponse.Builder toV4GetResponse(DatastoreV3Pb.GetResponse res) {
        DatastoreV4.GetResponse.Builder builder = DatastoreV4.GetResponse.newBuilder();
        for (OnestoreEntity.Reference key : res.deferreds()) {
            builder.addDeferred(this.entityProtoConverter.toV4Key(key));
        }
        for (DatastoreV3Pb.GetResponse.Entity entity : res.entitys()) {
            if (entity.hasEntity()) {
                builder.addFoundBuilder().setEntity(this.entityProtoConverter.toV4Entity(entity.getEntity()));
            }
            if (!entity.hasKey()) continue;
            builder.addMissingBuilder().getEntityBuilder().setKey(this.entityProtoConverter.toV4Key(entity.getKey()));
        }
        return builder;
    }

    public DatastoreV3Pb.GetResponse toV3GetResponse(DatastoreV4.GetResponseOrBuilder res) {
        DatastoreV3Pb.GetResponse result = new DatastoreV3Pb.GetResponse();
        for (EntityV4.Key key : res.getDeferredList()) {
            result.addDeferred(this.entityProtoConverter.toV3Reference((EntityV4.KeyOrBuilder)key));
        }
        for (DatastoreV4.EntityResult found : res.getFoundList()) {
            result.addEntity().setEntity(this.entityProtoConverter.toV3Entity((EntityV4.EntityOrBuilder)found.getEntity()));
        }
        for (DatastoreV4.EntityResult missing : res.getMissingList()) {
            result.addEntity().setKey(this.entityProtoConverter.toV3Reference((EntityV4.KeyOrBuilder)missing.getEntity().getKey()));
        }
        return result;
    }

    public DatastoreV4.BeginTransactionRequest.Builder toV4BeginTransactionRequest(DatastoreV3Pb.BeginTransactionRequest reqV3) {
        DatastoreV4.BeginTransactionRequest.Builder builder = DatastoreV4.BeginTransactionRequest.newBuilder();
        if (reqV3.hasAllowMultipleEg()) {
            builder.setCrossGroup(reqV3.isAllowMultipleEg());
        }
        return builder;
    }

    public DatastoreV4.BeginTransactionResponse.Builder toV4BeginTransactionResponse(DatastoreV3Pb.Transaction txn) throws InvalidConversionException {
        DatastoreV4.BeginTransactionResponse.Builder builder = DatastoreV4.BeginTransactionResponse.newBuilder();
        builder.setTransaction(this.toV4Transaction(txn));
        return builder;
    }

    public DatastoreV3Pb.Transaction toV3Transaction(DatastoreV4.BeginTransactionResponseOrBuilder res) throws InvalidConversionException {
        return this.toV3Transaction(res.getTransaction());
    }

    public DatastoreV4.RollbackRequest.Builder toV4RollbackRequest(DatastoreV3Pb.Transaction txn) throws InvalidConversionException {
        DatastoreV4.RollbackRequest.Builder builder = DatastoreV4.RollbackRequest.newBuilder();
        builder.setTransaction(this.toV4Transaction(txn));
        return builder;
    }

    public DatastoreV3Pb.Transaction toV3Transaction(DatastoreV4.RollbackRequestOrBuilder req) throws InvalidConversionException {
        return this.toV3Transaction(req.getTransaction());
    }

    public DatastoreV4.RunQueryRequest.Builder toV4RunQueryRequest(DatastoreV3Pb.Query query) throws InvalidConversionException {
        DatastoreV4.RunQueryRequest.Builder builder = DatastoreV4.RunQueryRequest.newBuilder();
        EntityV4.PartitionId.Builder partition = builder.getPartitionIdBuilder();
        partition.setDatasetId(query.getApp());
        if (!query.getNameSpace().isEmpty()) {
            partition.setNamespace(query.getNameSpace());
        }
        if (query.hasCount()) {
            builder.setSuggestedBatchSize(query.getCount());
        }
        if (query.hasTransaction()) {
            builder.getReadOptionsBuilder().setTransaction(this.toV4Transaction(query.getTransaction()));
        } else if (query.isStrong()) {
            builder.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.STRONG);
        } else if (query.hasFailoverMs()) {
            builder.getReadOptionsBuilder().setReadConsistency(DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL);
        }
        if (query.hasMinSafeTimeSeconds()) {
            builder.setMinSafeTimeSeconds(query.getMinSafeTimeSeconds());
        }
        builder.setQuery(this.toV4Query(query));
        return builder;
    }

    public DatastoreV3Pb.Query toV3Query(DatastoreV4.RunQueryRequestOrBuilder request) throws InvalidConversionException {
        DatastoreV4.ReadOptionsOrBuilder options;
        DatastoreV3Pb.Query result = this.toV3Query(request.getQueryOrBuilder());
        EntityV4.PartitionId partition = request.getPartitionId();
        result.setApp(partition.getDatasetId());
        if (partition.hasNamespace()) {
            result.setNameSpace(partition.getNamespace());
        }
        if (request.hasSuggestedBatchSize()) {
            result.setCount(request.getSuggestedBatchSize());
        }
        if ((options = request.getReadOptionsOrBuilder()).hasTransaction()) {
            result.setTransaction(this.toV3Transaction(options.getTransaction()));
        } else if (options.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG) {
            result.setStrong(true);
        } else if (options.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL) {
            result.setStrong(false);
            result.setFailoverMs(-1L);
        }
        if (request.hasMinSafeTimeSeconds()) {
            result.setMinSafeTimeSeconds(request.getMinSafeTimeSeconds());
        }
        return result;
    }

    public DatastoreV4.RunQueryResponse.Builder toV4RunQueryResponse(DatastoreV3Pb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.RunQueryResponse.Builder builder = DatastoreV4.RunQueryResponse.newBuilder();
        builder.setBatch(this.toV4QueryResultBatch(result));
        if (result.hasCursor()) {
            builder.setQueryHandle(this.toV4QueryHandle(result.getCursor()));
        }
        builder.addAllIndex(this.toV4CompositeIndex(result.indexs()));
        return builder;
    }

    public DatastoreV3Pb.QueryResult toV3QueryResult(DatastoreV4.RunQueryResponseOrBuilder respV4, String app) throws InvalidConversionException {
        DatastoreV3Pb.QueryResult result = this.toV3QueryResult((DatastoreV4.QueryResultBatchOrBuilder)respV4.getBatch());
        if (respV4.hasQueryHandle()) {
            result.setCursor(this.toV3Cursor(respV4.getQueryHandle()));
        }
        result.mutableIndexs().addAll(this.toV3CompositeIndex(respV4.getIndexList()));
        return result;
    }

    public DatastoreV4.ContinueQueryResponse.Builder toV4ContinueQueryResponse(DatastoreV3Pb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.ContinueQueryResponse.Builder builder = DatastoreV4.ContinueQueryResponse.newBuilder();
        builder.setBatch(this.toV4QueryResultBatch(result));
        return builder;
    }

    public DatastoreV3Pb.NextRequest toV3NextRequest(DatastoreV4.ContinueQueryRequestOrBuilder req) throws InvalidConversionException {
        DatastoreV3Pb.NextRequest next = new DatastoreV3Pb.NextRequest();
        next.setCompile(true);
        next.setCursor(this.toV3Cursor(req.getQueryHandle()));
        return next;
    }

    public DatastoreV4.RunQueryRequest normalizeV4RunQueryRequest(DatastoreV4.RunQueryRequest request) throws InvalidConversionException {
        DatastoreV4.Query query;
        if (!request.hasGqlQuery()) {
            return request;
        }
        try {
            query = this.gqlQueryTranslator.translateQuery((DatastoreV4.GqlQueryOrBuilder)request.getGqlQuery());
        }
        catch (GqlQueryTranslator.InvalidGqlQuery exception) {
            throw new InvalidConversionException(exception.getMessage(), exception);
        }
        return DatastoreV4.RunQueryRequest.newBuilder((DatastoreV4.RunQueryRequest)request).clearGqlQuery().setQuery(query).build();
    }
}

