/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.shared.BaseDatastoreV4Validator;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.ValidationException;

public class DatastoreV4Validator
extends BaseDatastoreV4Validator {
    public DatastoreV4Validator(EntityV4Validator entityValidator) {
        super(entityValidator);
    }

    private void validateReadOptions(DatastoreV4.ReadOptionsOrBuilder readOptions) throws ValidationException {
        ValidationException.validateAssertion(!readOptions.hasReadConsistency() || !readOptions.hasTransaction(), "cannot specify both a read consistency and a transaction", new Object[0]);
    }

    public void validateWriteRequest(DatastoreV4.WriteRequestOrBuilder req) throws ValidationException {
        this.validateMutation(false, req.getMutationOrBuilder());
    }

    public void validateCommitRequest(DatastoreV4.CommitRequestOrBuilder req) throws ValidationException {
        if (req.hasMutation()) {
            this.validateMutation(false, req.getMutationOrBuilder());
        }
    }

    public void validateGetRequest(DatastoreV4.GetRequestOrBuilder req) throws ValidationException {
        this.validateReadOptions((DatastoreV4.ReadOptionsOrBuilder)req.getReadOptions());
        this.validateKeys(EntityV4Validator.Constraint.READ, req.getKeyOrBuilderList());
    }

    public void validateRunQueryRequest(DatastoreV4.RunQueryRequestOrBuilder req) throws ValidationException {
        this.validateReadOptions(req.getReadOptionsOrBuilder());
        this.entityValidator.validatePartitionId(EntityV4Validator.Constraint.READ, req.getPartitionIdOrBuilder());
        DatastoreV4.QueryOrBuilder query = req.hasQuery() ? req.getQueryOrBuilder() : null;
        DatastoreV4.GqlQueryOrBuilder gqlQuery = req.hasGqlQuery() ? req.getGqlQueryOrBuilder() : null;
        DatastoreV4.ReadOptionsOrBuilder readOptions = req.getReadOptionsOrBuilder();
        boolean isStrongConsistency = readOptions.hasReadConsistency() && readOptions.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG;
        this.validateQueryGroup(isStrongConsistency, query, gqlQuery);
    }

    public void validateAllocateIdsRequest(DatastoreV4.AllocateIdsRequestOrBuilder req) throws ValidationException {
        ValidationException.validateAssertion(req.getAllocateCount() == 0 || req.getReserveCount() == 0, "cannot reserve and allocate ids in the same request", new Object[0]);
        this.validateKeys(EntityV4Validator.Constraint.ALLOCATE_KEY_ID, req.getAllocateOrBuilderList());
        this.validateKeys(EntityV4Validator.Constraint.READ, req.getReserveOrBuilderList());
    }
}

