/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityV4Helper;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.GqlParserConstants;
import com.google.apphosting.datastore.shared.GqlParserTokenManager;
import com.google.apphosting.datastore.shared.ParseException;
import com.google.apphosting.datastore.shared.SimpleCharStream;
import com.google.apphosting.datastore.shared.Token;
import com.google.apphosting.datastore.shared.ValidationException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

class GqlParser
implements GqlParserConstants {
    private EntityV4Validator entityValidator;
    private boolean allowLiteral;
    private ImmutableMap<String, EntityV4.Value> nameBindingMap;
    private List<DatastoreV4.GqlQueryArg> numberBindingList;
    private boolean[] numberBindingUsedList;
    public GqlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[20];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public GqlParser(EntityV4Validator entityValidator, DatastoreV4.GqlQueryOrBuilder gqlQuery) {
        this(new StringReader(gqlQuery.getQueryString()));
        this.entityValidator = entityValidator;
        this.allowLiteral = gqlQuery.getAllowLiteral();
        this.nameBindingMap = GqlParser.createNameBindingMap(gqlQuery.getNameArgList());
        this.numberBindingList = gqlQuery.getNumberArgList();
        this.numberBindingUsedList = new boolean[this.numberBindingList.size()];
    }

    private static ImmutableMap<String, EntityV4.Value> createNameBindingMap(List<DatastoreV4.GqlQueryArg> gqlQueryArgList) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DatastoreV4.GqlQueryArg gqlQueryArg : gqlQueryArgList) {
            builder.put((Object)gqlQueryArg.getName(), (Object)gqlQueryArg.getValue());
        }
        return builder.build();
    }

    private EntityV4.Value lookupNameBinding(String name) throws ParseException {
        EntityV4.Value value = (EntityV4.Value)this.nameBindingMap.get((Object)name);
        if (value == null) {
            this.throwParseException("Unknown named binding: %s.", name);
        }
        return value;
    }

    private EntityV4.Value lookupNumberBinding(long number) throws ParseException {
        if (number > (long)this.numberBindingList.size()) {
            this.throwParseException("Unknown numbered binding: %d.", number);
        }
        int bindingArrayIndex = (int)number - 1;
        this.numberBindingUsedList[bindingArrayIndex] = true;
        return this.numberBindingList.get(bindingArrayIndex).getValue();
    }

    private void verifyEveryNumberBindingUsed() throws ParseException {
        for (int bindingArrayIndex = 0; bindingArrayIndex < this.numberBindingUsedList.length; ++bindingArrayIndex) {
            if (this.numberBindingUsedList[bindingArrayIndex]) continue;
            this.throwParseException("Unused numbered binding: %d.", bindingArrayIndex + 1);
        }
    }

    private void checkAllowLiteral(String literalText) throws ParseException {
        if (!this.allowLiteral) {
            this.throwParseException("Disallowed literal: %s.", literalText);
        }
    }

    private String interpretUnquotedName(String unquotedName) throws ParseException {
        return unquotedName;
    }

    private String interpretQuotedName(String quotedName) throws ParseException {
        String escapedName = quotedName.substring(1, quotedName.length() - 1);
        String unescapedName = escapedName.replace("\"\"", "\"").replace("\\\\", "\\");
        return unescapedName;
    }

    private EntityV4.Value interpretStringLiteral(String stringLiteral) throws ParseException {
        this.checkAllowLiteral(stringLiteral);
        String escapedText = stringLiteral.substring(1, stringLiteral.length() - 1);
        String unescapedText = escapedText.replace("''", "'").replace("\\\\", "\\");
        return EntityV4.Value.newBuilder().setStringValue(unescapedText).build();
    }

    private long interpretIntegerText(String integerText) throws ParseException {
        try {
            return Long.parseLong(integerText);
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid integer literal: %s", exception.getMessage());
        }
    }

    private EntityV4.Value interpretIntegerLiteral(String integerLiteral) throws ParseException {
        this.checkAllowLiteral(integerLiteral);
        long integerAsLong = this.interpretIntegerText(integerLiteral);
        return EntityV4.Value.newBuilder().setIntegerValue(integerAsLong).build();
    }

    private EntityV4.Value interpretDoubleLiteral(String doubleLiteral) throws ParseException {
        this.checkAllowLiteral(doubleLiteral);
        try {
            double doubleValue = Double.parseDouble(doubleLiteral);
            return EntityV4.Value.newBuilder().setDoubleValue(doubleValue).build();
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid double literal: %s", exception.getMessage());
        }
    }

    private EntityV4.Value interpretBindingSiteWithName(String bindingSiteWithName) throws ParseException {
        String name = bindingSiteWithName.substring(1);
        return this.lookupNameBinding(name);
    }

    private EntityV4.Value interpretBindingSiteWithNumber(String bindingSiteWithNumber) throws ParseException {
        String integerText = bindingSiteWithNumber.substring(1);
        try {
            long integerAsLong = Long.parseLong(integerText);
            if (integerAsLong == 0L) {
                this.throwParseException("Invalid binding site :0.", new Object[0]);
            }
            return this.lookupNumberBinding(integerAsLong);
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid binding site number: %s", exception.getMessage());
        }
    }

    private List<DatastoreV4.PropertyReference> reduceProjectionListToGroupByList(List<DatastoreV4.PropertyExpression> projectionList) {
        ArrayList gropuByList = Lists.newArrayList();
        for (DatastoreV4.PropertyExpression expression : projectionList) {
            if (expression.hasAggregationFunction()) continue;
            gropuByList.add(expression.getProperty());
        }
        return gropuByList;
    }

    private ParseException throwParseException(String message, Object ... formatArgList) throws ParseException {
        throw new ParseException(String.format(message, formatArgList));
    }

    public final DatastoreV4.Query selector() throws ParseException {
        List<DatastoreV4.PropertyReference> groupByList;
        DatastoreV4.Query.Builder resultBuilder = DatastoreV4.Query.newBuilder();
        boolean isDistinct = false;
        this.jj_consume_token(30);
        switch (this.jj_nt.kind) {
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            case 16: 
            case 39: 
            case 40: {
                switch (this.jj_nt.kind) {
                    case 16: {
                        this.jj_consume_token(16);
                        isDistinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                    }
                }
                List<DatastoreV4.PropertyExpression> projectionList = this.aggregatedPropertyReferenceList();
                resultBuilder.addAllProjection(projectionList);
                if (!isDistinct) break;
                groupByList = this.reduceProjectionListToGroupByList(projectionList);
                if (groupByList.isEmpty()) {
                    this.throwParseException("Distinct projection queries with only aggregated properties are not supported.", new Object[0]);
                }
                resultBuilder.addAllGroupBy(groupByList);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                DatastoreV4.KindExpression kindExpression = this.kind();
                resultBuilder.addKind(kindExpression);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 34: {
                this.jj_consume_token(34);
                DatastoreV4.Filter filter = this.compoundCondition();
                resultBuilder.setFilter(filter);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 19: {
                this.jj_consume_token(19);
                this.jj_consume_token(11);
                if (isDistinct) {
                    this.throwParseException("Query specifies both DISTINCT and GROUP BY.", new Object[0]);
                }
                groupByList = this.propertyReferenceList();
                resultBuilder.addAllGroupBy(groupByList);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 29: {
                this.jj_consume_token(29);
                this.jj_consume_token(11);
                List<DatastoreV4.PropertyOrder> orderByList = this.orderedPropertyReferenceList();
                resultBuilder.addAllOrder(orderByList);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 24: {
                this.jj_consume_token(24);
                Token token = this.jj_consume_token(37);
                String limitText = token.image;
                long limit = this.interpretIntegerText(limitText);
                if (limit <= 0L) {
                    this.throwParseException("Limit %s is <= 0.", limitText);
                }
                if (limit > Integer.MAX_VALUE) {
                    this.throwParseException("Limit %s is too large.", limitText);
                }
                resultBuilder.setLimit((int)limit);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        this.verifyEveryNumberBindingUsed();
        return resultBuilder.build();
    }

    public final DatastoreV4.Filter compoundCondition() throws ParseException {
        DatastoreV4.CompositeFilter.Builder compositeFilterBuilder = null;
        DatastoreV4.Filter condition = this.condition();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            if (compositeFilterBuilder == null) {
                compositeFilterBuilder = DatastoreV4.CompositeFilter.newBuilder().setOperator(DatastoreV4.CompositeFilter.Operator.AND).addFilter(condition);
            }
            condition = this.condition();
            compositeFilterBuilder.addFilter(condition);
        }
        if (compositeFilterBuilder == null) {
            return condition;
        }
        return DatastoreV4.Filter.newBuilder().setCompositeFilter(compositeFilterBuilder.build()).build();
    }

    public final DatastoreV4.Filter condition() throws ParseException {
        EntityV4.Value value;
        DatastoreV4.PropertyFilter.Operator comparator;
        DatastoreV4.PropertyReference propertyReference;
        switch (this.jj_nt.kind) {
            case 39: 
            case 40: {
                propertyReference = this.propertyReference();
                comparator = this.comparator_with_property_left_op();
                value = this.value();
                break;
            }
            case 17: 
            case 26: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 42: {
                value = this.value();
                comparator = this.comparator_with_property_right_op();
                propertyReference = this.propertyReference();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DatastoreV4.PropertyFilter propertyFilter = DatastoreV4.PropertyFilter.newBuilder().setOperator(comparator).setProperty(propertyReference).setValue(value).build();
        return DatastoreV4.Filter.newBuilder().setPropertyFilter(propertyFilter).build();
    }

    public final DatastoreV4.PropertyFilter.Operator comparator_with_property_left_op() throws ParseException {
        switch (this.jj_nt.kind) {
            case 44: {
                this.jj_consume_token(44);
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
            case 45: {
                this.jj_consume_token(45);
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN;
            }
            case 46: {
                this.jj_consume_token(46);
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case 47: {
                this.jj_consume_token(47);
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN;
            }
            case 48: {
                this.jj_consume_token(48);
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case 12: {
                this.jj_consume_token(12);
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
            case 20: {
                this.jj_consume_token(20);
                this.jj_consume_token(6);
                return DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DatastoreV4.PropertyFilter.Operator comparator_with_property_right_op() throws ParseException {
        switch (this.jj_nt.kind) {
            case 44: {
                this.jj_consume_token(44);
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
            case 45: {
                this.jj_consume_token(45);
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN;
            }
            case 46: {
                this.jj_consume_token(46);
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case 47: {
                this.jj_consume_token(47);
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN;
            }
            case 48: {
                this.jj_consume_token(48);
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case 21: {
                this.jj_consume_token(21);
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
            case 20: {
                this.jj_consume_token(20);
                this.jj_consume_token(15);
                return DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DatastoreV4.KindExpression kind() throws ParseException {
        String kindName = this.name();
        try {
            this.entityValidator.validateKind(EntityV4Validator.Constraint.READ, kindName);
        }
        catch (ValidationException exception) {
            this.throwParseException(exception.getMessage(), new Object[0]);
        }
        return DatastoreV4.KindExpression.newBuilder().setName(kindName).build();
    }

    public final List<DatastoreV4.PropertyExpression> aggregatedPropertyReferenceList() throws ParseException {
        ArrayList propertyExpressionList = Lists.newArrayList();
        DatastoreV4.PropertyExpression propertyExpression = this.aggregatedPropertyReference();
        propertyExpressionList.add(propertyExpression);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 49: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(49);
            propertyExpression = this.aggregatedPropertyReference();
            propertyExpressionList.add(propertyExpression);
        }
        return propertyExpressionList;
    }

    public final DatastoreV4.PropertyExpression aggregatedPropertyReference() throws ParseException {
        DatastoreV4.PropertyReference propertyReference;
        DatastoreV4.PropertyExpression.Builder resultBuilder = DatastoreV4.PropertyExpression.newBuilder();
        if (this.jj_2_1(2)) {
            DatastoreV4.PropertyExpression.AggregationFunction aggregator = this.aggregator();
            resultBuilder.setAggregationFunction(aggregator);
            this.jj_consume_token(50);
            propertyReference = this.propertyReference();
            this.jj_consume_token(51);
        } else {
            switch (this.jj_nt.kind) {
                case 39: 
                case 40: {
                    propertyReference = this.propertyReference();
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        resultBuilder.setProperty(propertyReference);
        return resultBuilder.build();
    }

    public final DatastoreV4.PropertyExpression.AggregationFunction aggregator() throws ParseException {
        Token token = this.jj_consume_token(39);
        if (token.image.equalsIgnoreCase("first")) {
            return DatastoreV4.PropertyExpression.AggregationFunction.FIRST;
        }
        this.throwParseException("Unknown aggregator function name: %s.", token.image);
        throw new Error("Missing return statement in function");
    }

    public final List<DatastoreV4.PropertyOrder> orderedPropertyReferenceList() throws ParseException {
        ArrayList orderedPropertyReferenceList = Lists.newArrayList();
        DatastoreV4.PropertyOrder orderedPropertyReference = this.orderedPropertyReference();
        orderedPropertyReferenceList.add(orderedPropertyReference);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 49: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(49);
            orderedPropertyReference = this.orderedPropertyReference();
            orderedPropertyReferenceList.add(orderedPropertyReference);
        }
        return orderedPropertyReferenceList;
    }

    public final DatastoreV4.PropertyOrder orderedPropertyReference() throws ParseException {
        DatastoreV4.PropertyOrder.Builder resultBuilder = DatastoreV4.PropertyOrder.newBuilder();
        DatastoreV4.PropertyReference propertyReference = this.propertyReference();
        resultBuilder.setProperty(propertyReference);
        block0 : switch (this.jj_nt.kind) {
            case 10: 
            case 14: {
                switch (this.jj_nt.kind) {
                    case 10: {
                        this.jj_consume_token(10);
                        break block0;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        resultBuilder.setDirection(DatastoreV4.PropertyOrder.Direction.DESCENDING);
                        break block0;
                    }
                }
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        return resultBuilder.build();
    }

    public final List<DatastoreV4.PropertyReference> propertyReferenceList() throws ParseException {
        ArrayList propertyReferenceList = Lists.newArrayList();
        DatastoreV4.PropertyReference propertyReference = this.propertyReference();
        propertyReferenceList.add(propertyReference);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 49: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(49);
            propertyReference = this.propertyReference();
            propertyReferenceList.add(propertyReference);
        }
        return propertyReferenceList;
    }

    public final DatastoreV4.PropertyReference propertyReference() throws ParseException {
        String propertyName = this.name();
        try {
            this.entityValidator.validatePropertyName(EntityV4Validator.Constraint.READ, propertyName);
        }
        catch (ValidationException exception) {
            this.throwParseException(exception.getMessage(), new Object[0]);
        }
        return DatastoreV4.PropertyReference.newBuilder().setName(propertyName).build();
    }

    public final String name() throws ParseException {
        switch (this.jj_nt.kind) {
            case 39: {
                Token token = this.jj_consume_token(39);
                return this.interpretUnquotedName(token.image);
            }
            case 40: {
                Token token = this.jj_consume_token(40);
                return this.interpretQuotedName(token.image);
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final EntityV4.Value value() throws ParseException {
        switch (this.jj_nt.kind) {
            case 41: 
            case 42: {
                EntityV4.Value bindingSiteValue = this.bindingSite();
                return bindingSiteValue;
            }
            case 36: {
                Token token = this.jj_consume_token(36);
                return this.interpretStringLiteral(token.image);
            }
            case 37: {
                Token token = this.jj_consume_token(37);
                return this.interpretIntegerLiteral(token.image);
            }
            case 38: {
                Token token = this.jj_consume_token(38);
                return this.interpretDoubleLiteral(token.image);
            }
            case 33: {
                Token token = this.jj_consume_token(33);
                this.checkAllowLiteral(token.image);
                return EntityV4Helper.TRUE_VALUE;
            }
            case 17: {
                Token token = this.jj_consume_token(17);
                this.checkAllowLiteral(token.image);
                return EntityV4Helper.FALSE_VALUE;
            }
            case 26: {
                Token token = this.jj_consume_token(26);
                this.checkAllowLiteral(token.image);
                return EntityV4Helper.NULL_VALUE;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final EntityV4.Value bindingSite() throws ParseException {
        switch (this.jj_nt.kind) {
            case 41: {
                Token token = this.jj_consume_token(41);
                return this.interpretBindingSiteWithName(token.image);
            }
            case 42: {
                Token token = this.jj_consume_token(42);
                return this.interpretBindingSiteWithNumber(token.image);
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_5()) {
            return true;
        }
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_5() {
        return this.jj_scan_token(39);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{65536, 65536, 262144, 0, 524288, 0x20000000, 0x1000000, 128, 0x4020000, 0x101000, 0x300000, 0, 0, 0, 17408, 17408, 0, 0, 0x4020000, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 2432, 0, 4, 0, 0, 0, 0, 2034, 126976, 126976, 131072, 384, 131072, 0, 0, 131072, 384, 1650, 1536};
    }

    public GqlParser(InputStream stream) {
        this(stream, null);
    }

    public GqlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new GqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public GqlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new GqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public GqlParser(GqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(GqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 20; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[52];
        for (i = 0; i < 52; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 20; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 52; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        GqlParser.jj_la1_0();
        GqlParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

