/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.GqlParser;
import com.google.apphosting.datastore.shared.ParseException;
import com.google.apphosting.datastore.shared.TokenMgrError;

public class GqlQueryTranslator {
    public static final GqlQueryTranslator DEFAULT = new GqlQueryTranslator(EntityV4Validator.DEFAULT);
    private EntityV4Validator entityValidator;

    public GqlQueryTranslator(EntityV4Validator entityValidator) {
        this.entityValidator = entityValidator;
    }

    public DatastoreV4.Query translateQuery(DatastoreV4.GqlQueryOrBuilder gqlQuery) throws InvalidGqlQuery {
        try {
            GqlParser parser = new GqlParser(this.entityValidator, gqlQuery);
            DatastoreV4.Query query = parser.selector();
            return query;
        }
        catch (ParseException exception) {
            throw new InvalidGqlQuery(exception.getMessage());
        }
        catch (TokenMgrError exception) {
            throw new InvalidGqlQuery(exception.getMessage());
        }
    }

    public class InvalidGqlQuery
    extends Exception {
        public InvalidGqlQuery(String message) {
            super(message);
        }
    }
}

