/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.datastore.EntityV4;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Arrays;
import java.util.regex.Pattern;

public class Paths {
    public static final Pattern RESERVED_NAME = Pattern.compile("^__(.*)__$");

    protected Paths() {
    }

    public static String getKind(OnestoreEntity.Reference key) {
        return Paths.lastElement(key).getType();
    }

    public static boolean hasIdOrName(OnestoreEntity.Reference key) {
        return Paths.hasIdOrName(Paths.lastElement(key));
    }

    public static boolean hasIdOrName(OnestoreEntity.Path.Element element) {
        return element.hasId() && element.getId() != 0L || element.hasName() && !element.getName().equals("");
    }

    public static long getId(OnestoreEntity.Reference key) {
        return Paths.lastElement(key).getId();
    }

    public static String getName(OnestoreEntity.Reference key) {
        return Paths.lastElement(key).getName();
    }

    public static OnestoreEntity.Path.Element lastElement(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        Preconditions.checkArgument((path.elementSize() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return path.getElement(path.elementSize() - 1);
    }

    public static EntityV4.Key.PathElementOrBuilder lastElement(EntityV4.KeyOrBuilder key) {
        Preconditions.checkArgument((key.getPathElementCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPathElementOrBuilder(key.getPathElementCount() - 1);
    }

    public static EntityV4.Key.PathElement.Builder lastElement(EntityV4.Key.Builder key) {
        Preconditions.checkArgument((key.getPathElementCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPathElementBuilder(key.getPathElementCount() - 1);
    }

    public static OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        return Paths.getGroup(key.getPath());
    }

    public static OnestoreEntity.Path getGroup(OnestoreEntity.Path path) {
        Preconditions.checkArgument((path.elementSize() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    public static OnestoreEntity.Reference toEntityGroupReference(OnestoreEntity.Reference key) {
        OnestoreEntity.Reference egKey = (OnestoreEntity.Reference)key.clone();
        return egKey.setPath(Paths.getGroup(key));
    }

    public static OnestoreEntity.Reference createKeyFromPath(String appId, String namespace, Object ... elms) {
        Preconditions.checkArgument((appId != null && !appId.isEmpty() ? 1 : 0) != 0, (Object)"Application name must be supplied");
        OnestoreEntity.Reference k = new OnestoreEntity.Reference();
        k.setApp(appId);
        if (namespace != null && !namespace.isEmpty()) {
            k.setNameSpace(namespace);
        }
        k.setPath(Paths.createPath(elms));
        return k;
    }

    public static OnestoreEntity.Path createPath(Object ... elms) {
        Preconditions.checkArgument((elms.length > 0 && elms.length % 2 == 0 ? 1 : 0) != 0, (Object)("Bad path: wrong number of elements " + Arrays.toString(elms)));
        OnestoreEntity.Path p = new OnestoreEntity.Path();
        for (int i = 0; i < elms.length; i += 2) {
            Preconditions.checkArgument((boolean)(elms[i] instanceof String), (Object)("Bad path: type should be String: " + elms[i]));
            String type = (String)elms[i];
            if (elms[i + 1] instanceof Long || elms[i + 1] instanceof Integer) {
                long id = ((Number)elms[i + 1]).longValue();
                Preconditions.checkArgument((id != 0L || i + 2 == elms.length ? 1 : 0) != 0, (Object)"Bad path: id can be 0 only for the last element");
                p.addElement().setType(type).setId(id);
                continue;
            }
            Preconditions.checkArgument((boolean)(elms[i + 1] instanceof String), (Object)("Bad path: type should be String, int or long: " + elms[i + 1]));
            String name = (String)elms[i + 1];
            p.addElement().setType(type).setName(name);
        }
        return p;
    }

    public static EntityV4.Key createV4KeyFromPath(EntityV4.PartitionId partitionId, Object ... elms) {
        Preconditions.checkArgument((elms.length > 0 && elms.length % 2 == 0 ? 1 : 0) != 0, (Object)("Bad path: wrong number of elements " + Arrays.toString(elms)));
        EntityV4.Key.Builder key = EntityV4.Key.newBuilder();
        key.setPartitionId(partitionId);
        for (int i = 0; i < elms.length; i += 2) {
            Preconditions.checkArgument((boolean)(elms[i] instanceof String), (Object)("Bad path: kind should be String: " + elms[i]));
            EntityV4.Key.PathElement.Builder element = EntityV4.Key.PathElement.newBuilder();
            element.setKind((String)elms[i]);
            if (elms[i + 1] instanceof Long || elms[i + 1] instanceof Integer) {
                long id = ((Number)elms[i + 1]).longValue();
                Preconditions.checkArgument((id != 0L || i + 2 == elms.length ? 1 : 0) != 0, (Object)"Bad path: id can be 0 only for the last element");
                if (id != 0L) {
                    element.setId(id);
                }
            } else {
                Preconditions.checkArgument((boolean)(elms[i + 1] instanceof String), (Object)("Bad path: id or name should be String, int or long: " + elms[i + 1]));
                element.setName((String)elms[i + 1]);
            }
            key.addPathElement(element);
        }
        return key.build();
    }

    public static OnestoreEntity.PropertyValue toReferenceProperty(OnestoreEntity.Reference key) {
        OnestoreEntity.PropertyValue prop = new OnestoreEntity.PropertyValue();
        OnestoreEntity.PropertyValue.ReferenceValue ref = prop.getMutableReferenceValue();
        if (key.hasApp()) {
            ref.setApp(key.getApp());
        }
        if (key.hasNameSpace()) {
            ref.setNameSpace(key.getNameSpace());
        }
        for (OnestoreEntity.Path.Element keyElem : key.getPath().elements()) {
            OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem = ref.addPathElement();
            if (keyElem.hasType()) {
                refElem.setType(keyElem.getType());
            }
            if (keyElem.hasId()) {
                refElem.setId(keyElem.getId());
            }
            if (!keyElem.hasName()) continue;
            refElem.setName(keyElem.getName());
        }
        return prop;
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue value) {
        Preconditions.checkArgument((boolean)value.hasReferenceValue());
        OnestoreEntity.PropertyValue.ReferenceValue ref = value.getMutableReferenceValue();
        OnestoreEntity.Reference key = new OnestoreEntity.Reference();
        if (ref.hasApp()) {
            key.setApp(ref.getApp());
        }
        if (ref.hasNameSpace()) {
            key.setNameSpace(ref.getNameSpace());
        }
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem : ref.pathElements()) {
            OnestoreEntity.Path.Element keyElem = key.getMutablePath().addElement();
            if (refElem.hasType()) {
                keyElem.setType(refElem.getType());
            }
            if (refElem.hasId()) {
                keyElem.setId(refElem.getId());
            }
            if (!refElem.hasName()) continue;
            keyElem.setName(refElem.getName());
        }
        return key;
    }

    public static String toPathString(EntityV4.KeyOrBuilder key) {
        if (key.getPathElementCount() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (EntityV4.Key.PathElementOrBuilder element : key.getPathElementList()) {
            String kind = element.getKind();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            if (element.hasId()) {
                stringBuilder.append(element.getId());
            } else if (element.hasName()) {
                stringBuilder.append(element.getName());
            } else {
                String nullString = null;
                stringBuilder.append(nullString);
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

