/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.shared.DatastoreV4Validator;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.ValidationException;

public class DatastoreV4ServiceValidator {
    public static final DatastoreV4ServiceValidator DEFAULT = new DatastoreV4ServiceValidator(DatastoreV4Validator.DEFAULT);
    private final DatastoreV4Validator validatorV4;

    DatastoreV4ServiceValidator(DatastoreV4Validator validatorV4) {
        this.validatorV4 = validatorV4;
    }

    public void validateWriteRequest(DatastoreV4.WriteRequestOrBuilder req) throws ValidationException {
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        this.validatorV4.validateMutation(false, req.getMutationOrBuilder());
    }

    public void validateCommitRequest(DatastoreV4.CommitRequestOrBuilder req) throws ValidationException {
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        if (req.hasMutation()) {
            this.validatorV4.validateMutation(false, req.getMutationOrBuilder());
        }
    }

    public void validateGetRequest(DatastoreV4.GetRequestOrBuilder req) throws ValidationException {
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        this.validatorV4.validateReadOptions(req.getReadOptionsOrBuilder().hasReadConsistency(), req.getReadOptionsOrBuilder().hasTransaction());
        this.validatorV4.getEntityValidator().validateKeys(EntityV4Validator.Constraint.READ, req.getKeyOrBuilderList());
    }

    public void validateRunQueryRequest(DatastoreV4.RunQueryRequestOrBuilder req) throws ValidationException {
        Preconditions.checkArgument((!req.hasGqlQuery() ? 1 : 0) != 0, (Object)"RunQueryRequest not normalized");
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        this.validatorV4.validateReadOptions(req.getReadOptionsOrBuilder().hasReadConsistency(), req.getReadOptionsOrBuilder().hasTransaction());
        this.validatorV4.getEntityValidator().validatePartitionId(EntityV4Validator.Constraint.READ, req.getPartitionIdOrBuilder());
        ValidationException.validateAssertion(req.hasQuery(), "one of fields Query.query and Query.gql_query must be set", new Object[0]);
        this.validatorV4.validateQuery(req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG, (DatastoreV4.QueryOrBuilder)req.getQuery());
    }

    public void validateAllocateIdsRequest(DatastoreV4.AllocateIdsRequestOrBuilder req) throws ValidationException {
        this.validatorV4.validateRequestInitialized((MessageOrBuilder)req);
        ValidationException.validateAssertion(req.getAllocateCount() == 0 || req.getReserveCount() == 0, "cannot reserve and allocate ids in the same request", new Object[0]);
        this.validatorV4.getEntityValidator().validateKeys(EntityV4Validator.Constraint.ALLOCATE_KEY_ID, req.getAllocateOrBuilderList());
        this.validatorV4.getEntityValidator().validateKeys(EntityV4Validator.Constraint.WRITE, req.getReserveOrBuilderList());
    }

    public DatastoreV4Validator getDatastoreV4Validator() {
        return this.validatorV4;
    }
}

