/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class DatastoreV4Validator {
    protected final EntityV4Validator entityValidator;
    public static final DatastoreV4Validator DEFAULT = new DatastoreV4Validator(EntityV4Validator.DEFAULT);
    private static final Pattern GQL_ARG_NAME_CHARACTER_SET_PATTERN = Pattern.compile("[A-Za-z0-9_$\u0080-\uffff]*");

    DatastoreV4Validator(EntityV4Validator entityValidator) {
        this.entityValidator = entityValidator;
    }

    public EntityV4Validator getEntityValidator() {
        return this.entityValidator;
    }

    public void validateRequestInitialized(MessageOrBuilder pb) throws ValidationException {
        List error = pb.findInitializationErrors();
        ValidationException.validateAssertion(error.isEmpty(), "not initialized: " + error, new Object[0]);
    }

    public void validateMutation(boolean isUserTrusted, DatastoreV4.MutationOrBuilder mutation) throws ValidationException {
        EntityV4Validator.Constraint insertAutoIdConstraint;
        EntityV4Validator.Constraint constraint;
        if (isUserTrusted) {
            constraint = EntityV4Validator.Constraint.TRUSTED_WRITE;
            insertAutoIdConstraint = EntityV4Validator.Constraint.TRUSTED_WRITE_WITH_ALLOCATE_KEY_ID;
        } else {
            constraint = EntityV4Validator.Constraint.WRITE;
            insertAutoIdConstraint = EntityV4Validator.Constraint.WRITE_WITH_ALLOCATE_KEY_ID;
        }
        this.entityValidator.validateEntities(constraint, mutation.getUpsertOrBuilderList());
        this.entityValidator.validateEntities(constraint, mutation.getUpdateOrBuilderList());
        this.entityValidator.validateEntities(constraint, mutation.getInsertOrBuilderList());
        this.entityValidator.validateEntities(insertAutoIdConstraint, mutation.getInsertAutoIdOrBuilderList());
        this.entityValidator.validateKeys(constraint, mutation.getDeleteOrBuilderList());
    }

    public void validateQuery(boolean isStrongReadConsistency, DatastoreV4.QueryOrBuilder query) throws ValidationException {
        ValidationException.validateAssertion(!isStrongReadConsistency || this.hasAncestor(query.getFilterOrBuilder()), "global queries do not support strong consistency", new Object[0]);
        if (query.hasFilter()) {
            this.validateFilter(query.getFilterOrBuilder());
        }
        for (DatastoreV4.KindExpressionOrBuilder kindExp : query.getKindOrBuilderList()) {
            this.validateKindExpression(kindExp);
        }
        HashSet groupByProperties = Sets.newHashSet();
        for (DatastoreV4.PropertyReferenceOrBuilder propRef : query.getGroupByOrBuilderList()) {
            this.validatePropertyReference(propRef);
            groupByProperties.add(propRef.getName());
        }
        for (DatastoreV4.PropertyExpressionOrBuilder propExp : query.getProjectionOrBuilderList()) {
            this.validatePropertyExpression(propExp, groupByProperties);
        }
        for (DatastoreV4.PropertyOrderOrBuilder order : query.getOrderOrBuilderList()) {
            this.validatePropertyOrder(order);
        }
    }

    public void validateGqlQuery(DatastoreV4.GqlQueryOrBuilder gqlQuery) throws ValidationException {
        this.validateRequestInitialized((MessageOrBuilder)gqlQuery);
        this.entityValidator.validateStringUtf8("GQL query string", gqlQuery.getQueryStringBytes());
        HashSet namedGqlQueryArgSet = Sets.newHashSet();
        for (DatastoreV4.GqlQueryArgOrBuilder namedGqlQueryArg : gqlQuery.getNameArgList()) {
            this.validateGqlQueryArg(namedGqlQueryArgSet, namedGqlQueryArg);
        }
        for (DatastoreV4.GqlQueryArgOrBuilder numberedGqlQueryArg : gqlQuery.getNumberArgList()) {
            this.validateGqlQueryArg(null, numberedGqlQueryArg);
        }
    }

    private void validateGqlQueryArg(Set<String> namedGqlQueryArgSet, DatastoreV4.GqlQueryArgOrBuilder gqlQueryArg) throws ValidationException {
        if (namedGqlQueryArgSet == null) {
            ValidationException.validateAssertion(!gqlQueryArg.hasName(), "A numbered GQL query argument has a name.", new Object[0]);
        } else {
            ValidationException.validateAssertion(gqlQueryArg.hasName(), "A named GQL query argument has no name.", new Object[0]);
            this.entityValidator.validateStringUtf8("GQL query argument name", gqlQueryArg.getNameBytes());
            String name = gqlQueryArg.getName();
            this.entityValidator.validateStringNotEmpty("GQL query argument name is empty.", name);
            ValidationException.validateAssertion(GQL_ARG_NAME_CHARACTER_SET_PATTERN.matcher(name).matches(), "GQL query argument name \"%s\" contains an invalid character.", name);
            ValidationException.validateAssertion(!Character.isDigit(name.charAt(0)), "GQL query argument name \"%s\" starts with a digit.", name);
            this.entityValidator.validateStringNotReserved("GQL query argument name", name);
            ValidationException.validateAssertion(namedGqlQueryArgSet.add(name), "Duplicate GQL query argument name \"%s\".", name);
        }
        boolean hasCursor = gqlQueryArg.hasCursor();
        if (gqlQueryArg.hasValue()) {
            ValidationException.validateAssertion(!hasCursor, "A GQL query argument has both a value and a cursor.", new Object[0]);
            this.entityValidator.validateValue(EntityV4Validator.Constraint.READ, gqlQueryArg.getValueOrBuilder());
        } else {
            ValidationException.validateAssertion(hasCursor, "A GQL query argument has neither value nor cursor.", new Object[0]);
        }
    }

    public void validateReadOptions(boolean hasReadConsistency, boolean hasTransaction) throws ValidationException {
        ValidationException.validateAssertion(!hasReadConsistency || !hasTransaction, "cannot specify both a read consistency and a transaction", new Object[0]);
    }

    private void validatePropertyOrder(DatastoreV4.PropertyOrderOrBuilder order) throws ValidationException {
        this.validatePropertyReference((DatastoreV4.PropertyReferenceOrBuilder)order.getProperty());
    }

    private void validatePropertyExpression(DatastoreV4.PropertyExpressionOrBuilder propExp, Set<String> groupByProperties) throws ValidationException {
        this.validatePropertyReference(propExp.getPropertyOrBuilder());
        if (groupByProperties.isEmpty()) {
            ValidationException.validateAssertion(!propExp.hasAggregationFunction(), "aggregation function is not allowed without group by", new Object[0]);
        } else if (groupByProperties.contains(propExp.getPropertyOrBuilder().getName())) {
            ValidationException.validateAssertion(!propExp.hasAggregationFunction(), "aggregation function is not allowed for properties in group by: " + propExp.getPropertyOrBuilder().getName(), new Object[0]);
        } else {
            ValidationException.validateAssertion(propExp.hasAggregationFunction(), "aggregation function is required for properties not in group by: " + propExp.getPropertyOrBuilder().getName(), new Object[0]);
        }
    }

    private void validateKindExpression(DatastoreV4.KindExpressionOrBuilder kindExp) throws ValidationException {
        this.entityValidator.validateStringUtf8("kind", kindExp.getNameBytes());
        this.entityValidator.validateKind(EntityV4Validator.Constraint.READ, kindExp.getName());
    }

    private void validatePropertyReference(DatastoreV4.PropertyReferenceOrBuilder propertyRef) throws ValidationException {
        this.entityValidator.validateStringUtf8("property name", propertyRef.getNameBytes());
        this.entityValidator.validatePropertyName(EntityV4Validator.Constraint.READ, propertyRef.getName());
    }

    private void validateFilter(DatastoreV4.FilterOrBuilder filter) throws ValidationException {
        ValidationException.validateAssertion(filter.getAllFields().size() == 1, "a filter must have exactly one of its fields set", new Object[0]);
        if (filter.hasCompositeFilter()) {
            DatastoreV4.CompositeFilterOrBuilder cmpFilter = filter.getCompositeFilterOrBuilder();
            ValidationException.validateAssertion(cmpFilter.getFilterCount() > 0, "a composite filter must have at least one sub-filter", new Object[0]);
            for (DatastoreV4.FilterOrBuilder subFilter : cmpFilter.getFilterOrBuilderList()) {
                this.validateFilter(subFilter);
            }
        } else if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
            this.validatePropertyReference(propFilter.getPropertyOrBuilder());
            ValidationException.validateAssertion(propFilter.getValueOrBuilder().getIndexed(), "a filter value must be indexed", new Object[0]);
            this.entityValidator.validateValue(EntityV4Validator.Constraint.READ, (EntityV4.ValueOrBuilder)propFilter.getValue());
        }
    }

    private boolean hasAncestor(DatastoreV4.FilterOrBuilder filter) {
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
            return propFilter.getOperator() == DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR && propFilter.getPropertyOrBuilder().getName().equals("__key__");
        }
        if (filter.hasCompositeFilter() && filter.getCompositeFilter().getOperator() == DatastoreV4.CompositeFilter.Operator.AND) {
            for (DatastoreV4.Filter subFilter : filter.getCompositeFilter().getFilterList()) {
                if (!this.hasAncestor((DatastoreV4.FilterOrBuilder)subFilter)) continue;
                return true;
            }
        }
        return false;
    }
}

