/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.api.datastore.dev.PseudoKind;
import com.google.appengine.api.datastore.dev.Utils;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.Map;

class PseudoKinds {
    static final OnestoreEntity.EntityProto NOT_A_PSEUDO_KIND = new OnestoreEntity.EntityProto();
    private final Map<String, PseudoKind> pseudoKinds = new MapMaker().makeMap();

    PseudoKinds() {
    }

    void register(PseudoKind implementation) {
        Preconditions.checkNotNull((Object)implementation);
        PseudoKind previous = this.pseudoKinds.put(implementation.getKindName(), implementation);
        Preconditions.checkState((previous == null ? 1 : 0) != 0, (Object)("duplicate registration for pseudo-kind " + implementation.getKindName()));
    }

    List<OnestoreEntity.EntityProto> runQuery(DatastoreV3Pb.Query query) {
        Preconditions.checkNotNull((Object)((Object)query));
        PseudoKind pseudoKind = this.pseudoKinds.get(query.getKind());
        if (pseudoKind == null) {
            return null;
        }
        query.clearKind();
        List<OnestoreEntity.EntityProto> results = pseudoKind.runQuery(query);
        Preconditions.checkNotNull(results, (Object)("pseudo-kind " + pseudoKind.getKindName() + " returned invalid result"));
        return results;
    }

    OnestoreEntity.EntityProto get(LocalDatastoreService.LiveTxn txn, LocalDatastoreService.Profile.EntityGroup eg, OnestoreEntity.Reference key, boolean eventualConsistency) {
        PseudoKind pseudoKind = this.pseudoKinds.get(Utils.getKind(key));
        if (pseudoKind == null) {
            return NOT_A_PSEUDO_KIND;
        }
        return pseudoKind.get(txn, eg, key, eventualConsistency);
    }
}

