/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.shared.BaseDatastoreHelper;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Iterator;

public class BaseDatastoreValidator {
    public static final BaseDatastoreValidator INSTANCE = new BaseDatastoreValidator();

    protected BaseDatastoreValidator() {
    }

    public void validateKind(ValidationConstraint constraint, String kind) throws ValidationException {
        this.validateStringNotEmpty(kind, "kind");
        this.validateStringNotTooLong(kind, "kind");
        if (!constraint.reservedKeyAllowed) {
            this.validateStringNotReserved(kind, "kind");
        }
    }

    protected void validatePartitionIdDimension(ValidationConstraint constraint, ByteString partitionId, String desc) throws ValidationException {
        this.validateStringUtf8(partitionId, desc);
        String stringValue = partitionId.toStringUtf8();
        this.validatePartitionIdDimension(constraint, stringValue, desc);
    }

    void validatePartitionIdDimension(ValidationConstraint constraint, String partitionId, String desc) throws ValidationException {
        this.validateStringNotEmpty(partitionId, desc);
        if (!constraint.reservedKeyAllowed) {
            this.validateStringNotReserved(partitionId, desc);
        }
        ValidationException.validateAssertion(!partitionId.contains("!"), "The %s \"%s\" contains invalid character '!'.", desc, partitionId);
    }

    public void validateAppName(ValidationConstraint constraint, String appName) throws ValidationException {
        this.validateAppName(constraint, appName, "");
    }

    public void validateAppName(ValidationConstraint constraint, String appName, String desc) throws ValidationException {
        desc = desc.isEmpty() ? "app" : desc + ".app";
        this.validateStringNotEmpty(appName, desc);
        this.validateStringNotTooLong(appName, desc);
        if (!constraint.reservedKeyAllowed) {
            this.validateStringNotReserved(appName, desc);
        }
        int appLength = appName.length();
        for (int appCharIdx = 0; appCharIdx < appLength; ++appCharIdx) {
            ValidationException.validateAssertion(appName.charAt(appCharIdx) > '!', "Illegal character '%c' in %s.", Character.valueOf(appName.charAt(appCharIdx)), desc);
        }
    }

    public void validatePropertyName(ValidationConstraint constraint, String propertyName) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, "");
    }

    public void validatePropertyName(ValidationConstraint constraint, String propertyName, String desc) throws ValidationException {
        desc = desc.isEmpty() ? "property.name" : desc + ".property.name";
        this.validateStringNotEmpty(propertyName, desc);
        this.validateStringNotTooLong(propertyName, desc);
        if (!constraint.reservedPropertyNameAllowed) {
            this.validateStringVisibleOrNotReserved(propertyName, desc);
        }
    }

    public void validateKeyPathString(ValidationConstraint constraint, String pathElement, String desc) throws ValidationException {
        this.validateStringNotEmpty(pathElement, desc);
        this.validateStringNotTooLong(pathElement, desc);
        if (!constraint.reservedPropertyNameAllowed) {
            this.validateStringNotReserved(pathElement, desc);
        }
    }

    public void validateStringNotReserved(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!BaseDatastoreHelper.RESERVED_NAME.matcher(string).matches(), "The %s \"%s\" is reserved.", desc, string);
    }

    public void validateStringVisibleOrNotReserved(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!BaseDatastoreHelper.RESERVED_NAME.matcher(string).matches() || BaseDatastoreHelper.ALLOWED_RESERVED_NAMES.contains(string), "The %s \"%s\" is reserved.", desc, string);
    }

    public void validateStringNotEmpty(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateStringNotTooLong(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(string.length() <= 500, "The %s is longer than %d characters.", desc, 500);
    }

    public void validateStringUtf8(ByteString byteString, String desc) throws ValidationException {
        ValidationException.validateAssertion(byteString.isValidUtf8(), "The %s is not valid UTF-8.", desc);
    }

    public void validateQueryKey(OnestoreEntity.Reference key, DatastoreV3Pb.Query query, boolean validateNamespace, String desc) throws ValidationException {
        this.validateKey(ValidationConstraint.READ, key, desc);
        ValidationException.validateAssertion(Paths.hasIdOrName(key), desc + " missing id/name", new Object[0]);
        ValidationException.validateAssertion(query.getApp().equals(key.getApp()), "The query app is '%s' but %s.key app is '%s'.", query.getApp(), desc, key.getApp());
        ValidationException.validateAssertion(!validateNamespace || query.getNameSpace().equals(key.getNameSpace()), "The query namespace is '%s' but %s namespace is '%s'.", query.getNameSpace(), desc, key.getNameSpace());
    }

    public void validateEntityKey(ValidationConstraint constraint, OnestoreEntity.Reference key, String desc) throws ValidationException {
        this.validateKey(constraint, key, desc);
        switch (constraint) {
            case WRITE_WITH_ALLOCATE_KEY_ID: 
            case TRUSTED_WRITE_WITH_ALLOCATE_KEY_ID: {
                ValidationException.validateAssertion(!Paths.hasIdOrName(key), "entity must have no key", new Object[0]);
                break;
            }
            case WRITE: 
            case TRUSTED_WRITE: {
                this.validateKeyIdOrName(key);
                break;
            }
        }
    }

    public void validateKey(ValidationConstraint constraint, OnestoreEntity.Reference key) throws ValidationException {
        this.validateKey(constraint, key, "");
    }

    public void validateKey(ValidationConstraint constraint, OnestoreEntity.Reference key, String desc) throws ValidationException {
        OnestoreEntity.Path path;
        desc = desc.isEmpty() ? "key" : desc + ".key";
        this.validateAppName(constraint, key.getApp(), desc);
        if (key.hasNameSpace()) {
            this.validatePartitionIdDimension(constraint, key.getNameSpace(), "namespace");
        }
        ValidationException.validateAssertion((path = key.getPath()).elementSize() >= 1, "The %s.path is empty.", desc);
        ValidationException.validateAssertion(path.elementSize() <= 100, "The path cannot have more than %s elements", 100);
        Iterator i = path.elementIterator();
        while (i.hasNext()) {
            OnestoreEntity.Path.Element e = (OnestoreEntity.Path.Element)i.next();
            this.validateKeyPathString(constraint, e.getType(), desc + ".path.element.type");
            ValidationException.validateAssertion(!e.hasId() || !e.hasName(), "The key cannot have both an id: %s and a name: %s", e.getId(), e.getName());
            if (e.hasName()) {
                this.validateKeyPathString(constraint, e.getName(), desc + ".path.element.name");
            }
            if (!i.hasNext()) continue;
            ValidationException.validateAssertion(e.hasId() || e.hasName(), "The key path element must have an id or name.", new Object[0]);
            if (!e.hasId()) continue;
            ValidationException.validateAssertion(e.getId() != 0L, "The key path element cannot have an id of 0.", new Object[0]);
        }
    }

    public void validateReference(ValidationConstraint constraint, OnestoreEntity.PropertyValue.ReferenceValue ref) throws ValidationException {
        this.validateAppName(constraint, ref.getApp(), "value.key_value");
        if (ref.hasNameSpace()) {
            this.validatePartitionIdDimension(constraint, ref.getNameSpace(), "namespace");
        }
        ValidationException.validateAssertion(ref.pathElementSize() >= 1, "The value.key_value.path is empty.", new Object[0]);
        ValidationException.validateAssertion(ref.pathElementSize() <= 100, "The value.key_value.path cannot have more than %s elements", 100);
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement e : ref.pathElements()) {
            this.validateKeyPathString(constraint, e.getType(), "value.key_value.path.element.type");
            ValidationException.validateAssertion(e.hasId() || e.hasName(), "The value.key_value path element must have an id or name.", new Object[0]);
            ValidationException.validateAssertion(!e.hasId() || !e.hasName(), "The value.key_value cannot have both an id: %s and a name: %s", e.getId(), e.getName());
            if (e.hasId()) {
                ValidationException.validateAssertion(e.getId() != 0L, "The value.key_value path element cannot have an id of 0.", new Object[0]);
            }
            if (!e.hasName()) continue;
            this.validateKeyPathString(constraint, e.getName(), "value.key_value.path.element.name");
        }
    }

    public void validateCursor(ValidationConstraint constraint, DatastoreV3Pb.Query query, DatastoreV3Pb.CompiledCursor compiledCursor, boolean validateNamespace) throws ValidationException {
        ValidationException.validateAssertion(query.isRequirePerfectPlan(), "Cursors can only be used with perfect plans.", new Object[0]);
        if (compiledCursor.positionSize() == 0) {
            return;
        }
        if (!compiledCursor.hasMultiqueryIndex()) {
            ValidationException.validateAssertion(compiledCursor.positionSize() == 1, "Single query cursors do not support multiple positions.", new Object[0]);
        }
        for (DatastoreV3Pb.CompiledCursor.Position position : compiledCursor.positions()) {
            ValidationException.validateAssertion(!position.hasKey() && position.indexValues().isEmpty() || !position.hasStartKey(), "Cursor position cannot specify both encoded and plannable position.", new Object[0]);
            ValidationException.validateAssertion(position.hasStartKey() || position.hasKey() || position.indexValueSize() > 0 || !position.hasStartInclusive(), "Cursor position cannot specify start inclusivity with out a start key.", new Object[0]);
            if (position.hasKey()) {
                this.validateQueryKey(position.getKey(), query, validateNamespace, "cursor.position");
                ValidationException.validateAssertion(!query.hasKind() || query.getKind().equals(Paths.getKind(position.getKey())), "The query kind is %s but cursor.position.key kind is %s.", query.getKind(), Paths.getKind(position.getKey()));
            }
            for (DatastoreV3Pb.CompiledCursor.PositionIndexValue value : position.indexValues()) {
                ValidationException.validateAssertion(!"__key__".equals(value.getProperty()), "index data should not include primary key", new Object[0]);
                this.validatePropertyValue(constraint, value.getValue(), value.getProperty());
            }
        }
    }

    public void validateSingleQueryCursor(DatastoreV3Pb.CompiledCursor compiledCursor) throws ValidationException {
        ValidationException.validateAssertion(!compiledCursor.hasMultiqueryIndex(), "The cursor does not match the query.", new Object[0]);
    }

    public void validateProperty(ValidationConstraint constraint, OnestoreEntity.Property property) throws ValidationException {
        ValidationException.validateAssertion(!BaseDatastoreValidator.isBlobProperty(property), "BLOB, ENITY_PROTO or TEXT properties must be in a raw_property field.", new Object[0]);
        this.validatePropertyWithLengthLimit(constraint, property, 500);
    }

    public void validateRawProperty(ValidationConstraint constraint, OnestoreEntity.Property property, int maxRawPropertyBytes) throws ValidationException {
        this.validatePropertyWithLengthLimit(constraint, property, maxRawPropertyBytes);
    }

    private void validatePropertyWithLengthLimit(ValidationConstraint constraint, OnestoreEntity.Property property, int maxStringLength) throws ValidationException {
        String name = property.getName();
        OnestoreEntity.PropertyValue value = property.getValue();
        this.validatePropertyName(constraint, name);
        this.validatePropertyValue(constraint, value, name);
        if (constraint == ValidationConstraint.WRITE || constraint == ValidationConstraint.WRITE_WITH_ALLOCATE_KEY_ID || constraint == ValidationConstraint.TRUSTED_WRITE || constraint == ValidationConstraint.TRUSTED_WRITE_WITH_ALLOCATE_KEY_ID) {
            ValidationException.validateAssertion(property.getMeaningEnum() != OnestoreEntity.Property.Meaning.INDEX_VALUE, "Entities with incomplete properties cannot be written.", new Object[0]);
        }
        if (BaseDatastoreValidator.isBlobProperty(property)) {
            ValidationException.validateAssertion(value.hasStringValue(), "BLOB / ENTITY_PROTO / TEXT raw property %s must have a string value", name);
        }
        if (value.hasStringValue()) {
            if (property.hasMeaning() && property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ATOM_LINK) {
                ValidationException.validateAssertion(value.getStringValue().length() <= 2038, "The link property %s is too long. Use TEXT for links over %s characters.", name, 2038);
            } else {
                ValidationException.validateAssertion(value.getStringValue().length() <= maxStringLength, "The string property %s has a value that is too long. It cannot exceed %s characters.", name, maxStringLength);
            }
        }
    }

    public void validatePropertyValue(ValidationConstraint constraint, OnestoreEntity.PropertyValue value, String desc) throws ValidationException {
        int numValues = (value.hasInt64Value() ? 1 : 0) + (value.hasStringValue() ? 1 : 0) + (value.hasBooleanValue() ? 1 : 0) + (value.hasDoubleValue() ? 1 : 0) + (value.hasPointValue() ? 1 : 0) + (value.hasUserValue() ? 1 : 0) + (value.hasReferenceValue() ? 1 : 0);
        ValidationException.validateAssertion(numValues <= 1, "PropertyValue for %s has multiple value fields set", desc);
        if (value.hasReferenceValue()) {
            this.validateReference(constraint, value.getReferenceValue());
        } else if (value.hasUserValue()) {
            ValidationException.validateAssertion(!value.getUserValue().hasNickname(), "nickname is not supported yet", new Object[0]);
            ValidationException.validateAssertion(!value.getUserValue().hasObfuscatedGaiaid(), "User properties should not have obfuscated_gaiaid set.", new Object[0]);
        }
    }

    public void validateSameApp(String app1, String app2) throws ValidationException {
        Preconditions.checkNotNull((Object)app1);
        Preconditions.checkNotNull((Object)app2);
        ValidationException.validateAssertion(app1.equals(app2), "mismatched app ids within request: " + app1 + " vs. " + app2, new Object[0]);
    }

    public void validateKeyValue(DatastoreV3Pb.Query query, OnestoreEntity.PropertyValue value, String desc) throws ValidationException {
        ValidationException.validateAssertion(value.hasReferenceValue(), desc + " value must be a Key", new Object[0]);
        OnestoreEntity.PropertyValue.ReferenceValue refVal = value.getReferenceValue();
        ValidationException.validateAssertion(refVal.getApp().equals(query.getApp()), "%s app is %s but query app is %s", desc, refVal.getApp(), query.getApp());
        ValidationException.validateAssertion(refVal.getNameSpace().equals(query.getNameSpace()), "%s namespace is %s but query namespace is %s", desc, refVal.getNameSpace(), query.getNameSpace());
    }

    protected void validateKeyIdOrName(OnestoreEntity.Reference key) throws ValidationException {
        ValidationException.validateAssertion(Paths.hasIdOrName(key), "Key is missing id or name.", new Object[0]);
    }

    protected void validatePerfectPlan(DatastoreV3Pb.Query query) throws ValidationException {
        for (DatastoreV3Pb.Query.Filter filter : query.filters()) {
            String filterPropertyName = filter.getProperty(0).getName();
            ValidationException.validateAssertion("__key__".equals(filterPropertyName), String.format("kind is required for non-%s filters", "__key__"), new Object[0]);
        }
        for (DatastoreV3Pb.Query.Order order : query.orders()) {
            ValidationException.validateAssertion("__key__".equals(order.getProperty()) && order.getDirection() == DatastoreV3Pb.Query.Order.Direction.ASCENDING.getValue(), String.format("kind is required for all orders except %s ascending", "__key__"), new Object[0]);
        }
    }

    public void validateNonNamespacedAppId(String appId) throws ValidationException {
        ValidationException.validateAssertion(appId.indexOf(33) < 0, "appId should not contain namespace separator char '!'", new Object[0]);
    }

    private static boolean isBlobProperty(OnestoreEntity.Property property) {
        return property.getMeaningEnum() == OnestoreEntity.Property.Meaning.BLOB || property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO || property.getMeaningEnum() == OnestoreEntity.Property.Meaning.TEXT;
    }
}

