/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.prospectivesearch.dev;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.prospectivesearch.ProspectiveSearchPb;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class QueryEngine {
    QueryEngine() {
    }

    static boolean query(Entity doc, String fieldName, String opStr, String queryTerm, Map<String, ProspectiveSearchPb.SchemaEntry> schema) {
        if (doc == null) {
            throw new IllegalStateException("init(...) must be called before query.");
        }
        Op op = Op.LOOKUP.get(opStr);
        if (op == null) {
            throw new UnsupportedOperationException("Unknown op: " + opStr);
        }
        if (fieldName.equals("")) {
            return QueryEngine.matchesAnyStringOrStringListField(doc, queryTerm);
        }
        Object fieldVal = doc.getProperty(fieldName);
        ProspectiveSearchPb.SchemaEntry schemaEntry = schema.get(fieldName);
        if (fieldVal == null || schemaEntry == null) {
            return false;
        }
        if (!QueryEngine.fieldTypeMatchesSchema(fieldVal, schemaEntry)) {
            return false;
        }
        ArrayList<Object> expanded = new ArrayList<Object>();
        if (fieldVal instanceof List) {
            expanded.addAll((List)fieldVal);
        } else {
            expanded.add(fieldVal);
        }
        boolean matches = false;
        for (Object e : expanded) {
            matches |= QueryEngine.queryField(op, e, queryTerm);
        }
        return matches;
    }

    static boolean matchesAnyStringOrStringListField(Entity doc, String queryTerm) {
        for (Object val : doc.getProperties().values()) {
            if (val instanceof String) {
                if (!QueryEngine.tokenizeAndSearch((String)val, queryTerm)) continue;
                return true;
            }
            if (!(val instanceof List)) continue;
            for (Object obj : (List)val) {
                if (!(obj instanceof String) || !QueryEngine.tokenizeAndSearch((String)obj, queryTerm)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean objectIsConvertibleInstanceOrListOfType(Object val, Class<?> ... classes) {
        if (val instanceof List) {
            List l = (List)val;
            if (l.size() == 0) {
                return false;
            }
            val = l.get(0);
        }
        for (Class<?> c : classes) {
            if (!c.isAssignableFrom(val.getClass())) continue;
            return true;
        }
        return false;
    }

    static boolean fieldTypeMatchesSchema(Object fieldVal, ProspectiveSearchPb.SchemaEntry schemaEntry) {
        switch (schemaEntry.getTypeEnum()) {
            case STRING: {
                return QueryEngine.objectIsConvertibleInstanceOrListOfType(fieldVal, String.class, Text.class);
            }
            case INT32: {
                return QueryEngine.objectIsConvertibleInstanceOrListOfType(fieldVal, Integer.class, Long.class);
            }
            case BOOLEAN: {
                return QueryEngine.objectIsConvertibleInstanceOrListOfType(fieldVal, Boolean.class);
            }
            case DOUBLE: {
                return QueryEngine.objectIsConvertibleInstanceOrListOfType(fieldVal, Float.class, Double.class);
            }
        }
        throw new IllegalStateException("Internal: unknown schema type.");
    }

    static boolean queryField(Op op, Object fieldVal, String queryTerm) {
        if (op == Op.MATCH) {
            return QueryEngine.doMatch(fieldVal, queryTerm);
        }
        if (!(fieldVal instanceof Number)) {
            return false;
        }
        double x = ((Number)fieldVal).doubleValue();
        if (op == Op.RANGE) {
            return QueryEngine.numInRange(x, queryTerm);
        }
        return QueryEngine.doNumericComparison(op, x, Double.parseDouble(queryTerm));
    }

    static boolean doMatch(Object fieldVal, String queryTerm) {
        if (fieldVal instanceof String || fieldVal instanceof Text) {
            if (fieldVal instanceof Text) {
                fieldVal = ((Text)fieldVal).getValue();
            }
            return QueryEngine.tokenizeAndSearch((String)fieldVal, queryTerm);
        }
        if (fieldVal instanceof Integer || fieldVal instanceof Long) {
            return ((Number)fieldVal).longValue() == Long.parseLong(queryTerm);
        }
        if (fieldVal instanceof Float || fieldVal instanceof Double) {
            return ((Number)fieldVal).doubleValue() == Double.parseDouble(queryTerm);
        }
        if (fieldVal instanceof Boolean) {
            return (Boolean)fieldVal == Boolean.parseBoolean(queryTerm);
        }
        return false;
    }

    static boolean numInRange(double fieldVal, String queryTerm) {
        List parts = Splitter.onPattern((String)"(\\.){2,3}").splitToList((CharSequence)queryTerm);
        if (parts.size() != 2) {
            return false;
        }
        double from = Double.parseDouble((String)parts.get(0));
        double to = Double.parseDouble((String)parts.get(1));
        return fieldVal >= from && fieldVal <= to;
    }

    static boolean doNumericComparison(Op op, double fieldVal, double queryVal) {
        switch (op) {
            case EQUALS: {
                return fieldVal == queryVal;
            }
            case LESS: {
                return fieldVal < queryVal;
            }
            case GREATER: {
                return fieldVal > queryVal;
            }
            case LESSEQ: {
                return fieldVal <= queryVal;
            }
            case GREATEREQ: {
                return fieldVal >= queryVal;
            }
        }
        throw new IllegalStateException("Internal: unknown operation type.");
    }

    static boolean isANum(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static boolean tokenizeAndSearch(String text, String query) {
        if (query.startsWith("\"") && query.endsWith("\"")) {
            query = query.substring(1, query.length() - 1);
            query = query.replaceAll("\\s+", "\\\\s+");
        }
        query = "(^\\s*|\\s+)" + query + "(\\s+|\\s*$)";
        return Pattern.compile(query, 66).matcher(text).find();
    }

    static enum Op {
        MATCH(":"),
        EQUALS("=", "=="),
        LESS("<"),
        GREATER(">"),
        LESSEQ("<=", "=<"),
        GREATEREQ(">=", "=>"),
        RANGE("..", "...");

        static final Map<String, Op> LOOKUP;
        final String[] tokens;

        private Op(String ... tokens) {
            this.tokens = tokens;
        }

        static {
            LOOKUP = new HashMap<String, Op>();
            for (Op op : Op.values()) {
                for (String token : op.tokens) {
                    if (LOOKUP.get(token) != null) {
                        throw new IllegalStateException("Duplicate tokens.");
                    }
                    LOOKUP.put(token, op);
                }
            }
        }
    }
}

