/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.BaseDatastoreValidator;
import com.google.apphosting.datastore.shared.EntityV4Helper;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntityV4Validator
extends BaseDatastoreValidator {
    public static final EntityV4Validator DEFAULT = new EntityV4Validator(true, false, false, true);
    private final boolean requireDatasetId;
    private final boolean requireNormal;
    private final boolean allowUnknownFields;
    private final boolean validateSubObjects;

    public EntityV4Validator(boolean requireDatasetId, boolean requireNormal, boolean allowUnknownFields, boolean validateSubObjects) {
        this.requireDatasetId = requireDatasetId;
        this.requireNormal = requireNormal;
        this.allowUnknownFields = allowUnknownFields;
        this.validateSubObjects = validateSubObjects;
    }

    public void validateEntities(ValidationConstraint constraint, Iterable<? extends EntityV4.EntityOrBuilder> entities) throws ValidationException {
        for (EntityV4.EntityOrBuilder entityOrBuilder : entities) {
            this.validateEntity(constraint, entityOrBuilder);
        }
    }

    public void validateKeys(ValidationConstraint constraint, Iterable<? extends EntityV4.KeyOrBuilder> keys) throws ValidationException {
        for (EntityV4.KeyOrBuilder keyOrBuilder : keys) {
            this.validateKey(constraint, keyOrBuilder);
        }
    }

    public void validateEntity(ValidationConstraint constraint, EntityV4.EntityOrBuilder entity) throws ValidationException {
        if (entity.hasKey()) {
            this.validateKey(constraint, (EntityV4.KeyOrBuilder)entity.getKey());
        } else {
            ValidationException.validateAssertion(constraint.absentKeyAllowed, "Entity is missing key.", new Object[0]);
        }
        HashSet propertyNameSet = Sets.newHashSet();
        for (EntityV4.PropertyOrBuilder property : entity.getPropertyList()) {
            String propertyName = property.getName();
            ValidationException.validateAssertion(propertyNameSet.add(propertyName), "Entity has duplicate property name \"%s\".", propertyName);
            if (!this.validateSubObjects) continue;
            this.validateProperty(constraint, property);
        }
        this.validateMessageUnknownFields("entity", (MessageOrBuilder)entity);
    }

    public void validateKey(ValidationConstraint constraint, EntityV4.KeyOrBuilder key) throws ValidationException {
        boolean finalElementComplete;
        int numKeyPathElements;
        if (key.hasPartitionId()) {
            if (this.validateSubObjects) {
                this.validatePartitionId(constraint, (EntityV4.PartitionIdOrBuilder)key.getPartitionId());
            }
        } else {
            ValidationException.validateAssertion(!this.requireDatasetId, "Key is missing partition id.", new Object[0]);
        }
        ValidationException.validateAssertion((numKeyPathElements = key.getPathElementCount()) != 0, "Key path is empty.", new Object[0]);
        int numIncompleteElements = 0;
        for (EntityV4.Key.PathElementOrBuilder element : key.getPathElementList()) {
            this.validateStringUtf8(element.getKindBytes(), "key path kind");
            String kind = element.getKind();
            this.validateKind(constraint, kind);
            boolean elementHasName = element.hasName();
            if (element.hasId()) {
                ValidationException.validateAssertion(!elementHasName, "Key path element has both id (%d) and name (\"%s\").", element.getId(), element.getName());
                ValidationException.validateAssertion(element.getId() != 0L, "Key path id is invalid. May not be zero.", new Object[0]);
            } else if (elementHasName) {
                this.validateStringUtf8(element.getNameBytes(), "key path name");
                String name = element.getName();
                this.validateStringNotEmpty(name, "key path name");
                if (!constraint.reservedKeyAllowed) {
                    this.validateStringNotReserved(name, "key path name");
                }
            } else {
                ++numIncompleteElements;
            }
            this.validateMessageUnknownFields("key path element", (MessageOrBuilder)element);
        }
        EntityV4.Key.PathElementOrBuilder finalElement = key.getPathElementOrBuilder(numKeyPathElements - 1);
        boolean bl = finalElementComplete = finalElement.hasId() || finalElement.hasName();
        if (!constraint.completeKeyPathAllowed) {
            ValidationException.validateAssertion(!finalElementComplete, "Key path is complete: %s", Paths.toPathString(key));
        }
        if (!constraint.incompleteKeyPathAllowed) {
            ValidationException.validateAssertion(finalElementComplete, "Key path is incomplete: %s", Paths.toPathString(key));
        }
        if (numIncompleteElements != !finalElementComplete) {
            ValidationException.validateAssertion(false, "Key path element is incomplete: %s", Paths.toPathString(key));
        }
        this.validateMessageUnknownFields("key", (MessageOrBuilder)key);
    }

    public void validatePartitionId(ValidationConstraint constraint, EntityV4.PartitionIdOrBuilder partitionId) throws ValidationException {
        if (this.requireDatasetId) {
            ValidationException.validateAssertion(partitionId.hasDatasetId(), "Partition id is missing dataset id.", new Object[0]);
        }
        if (partitionId.hasDatasetId()) {
            this.validatePartitionIdDimension(constraint, partitionId.getDatasetIdBytes(), "dataset id");
        }
        if (partitionId.hasNamespace()) {
            this.validatePartitionIdDimension(constraint, partitionId.getNamespaceBytes(), "namespace");
        }
        this.validateMessageUnknownFields("partition id", (MessageOrBuilder)partitionId);
        for (Map.Entry entry : partitionId.getUnknownFields().asMap().entrySet()) {
            Integer tag = (Integer)entry.getKey();
            UnknownFieldSet.Field unknownField = (UnknownFieldSet.Field)entry.getValue();
            if (tag < 1 || tag > 100) continue;
            String unknownFieldDescriptor = String.format("unknown partition id dimension (with tag %d)", tag);
            ValidationException.validateAssertion(this.unknownFieldOnlyValueIsLengthDelimited(unknownField), "The %s has invalid value type.", unknownFieldDescriptor);
            this.validatePartitionIdDimension(constraint, (ByteString)unknownField.getLengthDelimitedList().get(0), unknownFieldDescriptor);
        }
    }

    public void validateProperty(ValidationConstraint constraint, EntityV4.PropertyOrBuilder property) throws ValidationException {
        this.validateStringUtf8(property.getNameBytes(), "property name");
        String propertyName = property.getName();
        this.validatePropertyName(constraint, propertyName);
        if (property.hasDeprecatedMulti() || property.getDeprecatedValueCount() > 0) {
            int numValues;
            ValidationException.validateAssertion(!property.hasValue(), "Property has both old and new value type", new Object[0]);
            ValidationException.validateAssertion(!this.requireNormal, "Property \"%s\" has deprecated fields set.", propertyName);
            if (this.requireNormal) {
                ValidationException.validateAssertion(!property.hasDeprecatedMulti() || property.getDeprecatedMulti() != EntityV4.Property.getDefaultInstance().getDeprecatedMulti(), "Property \"%s\" sets multi to default value.", propertyName);
            }
            ValidationException.validateAssertion((numValues = property.getDeprecatedValueCount()) > 0, "Property \"%s\" has no value.", propertyName);
            ValidationException.validateAssertion(property.getDeprecatedMulti() || numValues == 1, "Single-valued property \"%s\" has many values.", propertyName);
            if (this.validateSubObjects) {
                for (EntityV4.ValueOrBuilder value : property.getDeprecatedValueList()) {
                    ValidationException.validateAssertion(value.getListValueCount() == 0, "Property has both old and new value type", new Object[0]);
                    this.validateValue(constraint, value);
                }
            }
        } else {
            ValidationException.validateAssertion(property.hasValue(), "Property \"%s\" has no value.", propertyName);
            this.validateValue(constraint, property.getValueOrBuilder());
        }
        this.validateMessageUnknownFields("property", (MessageOrBuilder)property);
    }

    void validateValue(ValidationConstraint constraint, EntityV4.ValueOrBuilder value) throws ValidationException {
        if (this.requireNormal) {
            ValidationException.validateAssertion(!value.hasIndexed() || value.getIndexed() != EntityV4.Value.getDefaultInstance().getIndexed(), "Value sets indexed to default value.", new Object[0]);
        }
        this.validateValueUnion(value);
        if (value.hasStringValue()) {
            this.validateStringUtf8(value.getStringValueBytes(), "string value");
        } else if (value.hasBlobKeyValue()) {
            this.validateStringUtf8(value.getBlobKeyValueBytes(), "blob key value");
        } else if (value.hasKeyValue()) {
            if (this.validateSubObjects) {
                this.validateKey(ValidationConstraint.KEY_IN_VALUE, (EntityV4.KeyOrBuilder)value.getKeyValue());
            }
        } else if (value.hasEntityValue()) {
            if (this.validateSubObjects) {
                this.validateEntity(constraint.getEntityInValueConstraint(), value.getEntityValueOrBuilder());
            }
        } else if (value.getListValueCount() > 0) {
            ValidationException.validateAssertion(!value.hasIndexed(), "A Value containing a list_value cannot specify indexed.", new Object[0]);
            ValidationException.validateAssertion(!value.hasMeaning(), "A Value containing a list_value cannot specify a meaning.", new Object[0]);
            for (EntityV4.ValueOrBuilder subValue : value.getListValueList()) {
                ValidationException.validateAssertion(subValue.getListValueCount() == 0, "list_value cannot contain a Value containing another list_value.", new Object[0]);
                this.validateValue(constraint, subValue);
            }
        }
        this.validateValueMeaningMatchesUnion(value);
        this.validateValueMeaningConstraints(constraint, value);
        this.validateValueIndexConstraints(value);
        this.validateMessageUnknownFields("value", (MessageOrBuilder)value);
    }

    private void validateValueUnion(EntityV4.ValueOrBuilder value) throws ValidationException {
        int numSubValues = 0;
        if (value.hasBooleanValue()) {
            ++numSubValues;
        }
        if (value.hasIntegerValue()) {
            ++numSubValues;
        }
        if (value.hasDoubleValue()) {
            ++numSubValues;
        }
        if (value.hasTimestampMicrosecondsValue()) {
            ++numSubValues;
        }
        if (value.hasKeyValue()) {
            ++numSubValues;
        }
        if (value.hasBlobKeyValue()) {
            ++numSubValues;
        }
        if (value.hasStringValue()) {
            ++numSubValues;
        }
        if (value.hasBlobValue()) {
            ++numSubValues;
        }
        if (value.hasEntityValue()) {
            ++numSubValues;
        }
        if (value.getListValueCount() > 0) {
            ++numSubValues;
        }
        ValidationException.validateAssertion(numSubValues <= 1, "Value has multiple <type>_value fields set.", new Object[0]);
    }

    private void validateValueMeaningMatchesUnion(EntityV4.ValueOrBuilder value) throws ValidationException {
        if (!value.hasMeaning()) {
            return;
        }
        String message = "Value meaning %d does not match %s field.";
        int meaning = value.getMeaning();
        switch (meaning) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                ValidationException.validateAssertion(value.hasStringValue(), message, meaning, "string_value");
                break;
            }
            case 16: 
            case 22: {
                ValidationException.validateAssertion(value.hasBlobValue(), message, meaning, "blob_value");
                break;
            }
            case 13: {
                ValidationException.validateAssertion(value.hasIntegerValue(), message, meaning, "integer_value");
                break;
            }
            case 9: 
            case 20: 
            case 21: {
                ValidationException.validateAssertion(value.hasEntityValue(), message, meaning, "entity_value");
                break;
            }
            case 18: {
                ValidationException.validateAssertion(!value.hasTimestampMicrosecondsValue(), "Value meaning %d does not match field timestamp_microseconds_value.", 18);
                ValidationException.validateAssertion(!value.hasBlobKeyValue(), "Value meaning %d does not match field blob_key_value.", 18);
                ValidationException.validateAssertion(!value.hasEntityValue(), "Value meaning %d does not match field entity_value.", 18);
                break;
            }
            default: {
                ValidationException.validateAssertion(false, "Unknown value meaning %s.", meaning);
            }
        }
    }

    private void validateValueMeaningConstraints(ValidationConstraint constraint, EntityV4.ValueOrBuilder value) throws ValidationException {
        if (!value.hasMeaning()) {
            return;
        }
        switch (value.getMeaning()) {
            case 16: {
                ValidationException.validateAssertion(value.getBlobValue().size() <= 500, "Blob value with meaning %d has more than permitted %d bytes.", value.getMeaning(), 500);
                if (!this.requireNormal) break;
                ValidationException.validateAssertion(!EntityV4Helper.isBlobValueMeaningRedundant(value), "Indexed blob value has redundant meaning %d.", 16);
                break;
            }
            case 15: 
            case 22: {
                ValidationException.validateAssertion(!value.getIndexed(), "Indexed value has meaning %d.", value.getMeaning());
                break;
            }
            case 2: {
                ValidationException.validateAssertion(value.getStringValue().length() <= 2038, "Url value has more than permitted %d characters.", 2038);
                break;
            }
            case 13: {
                ValidationException.validateAssertion(value.getIntegerValue() >= 0L && value.getIntegerValue() <= 100L, "Percent value outside permitted range [0, 100].", new Object[0]);
                break;
            }
            case 9: {
                Map<String, EntityV4.ValueOrBuilder> propertyMap = this.validatePredefinedValueEntity("geo point", (Map<String, Integer>)EntityV4Helper.PredefinedEntityPointConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityPointConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                double lat = propertyMap.get("x").getDoubleValue();
                double lon = propertyMap.get("y").getDoubleValue();
                ValidationException.validateAssertion(Math.abs(lat) <= 90.0, "Latitude outside permitted range -90.0 to 90.0.", new Object[0]);
                ValidationException.validateAssertion(Math.abs(lon) <= 180.0, "Longitude outside permitted range -180.0 to 180.0.", new Object[0]);
                break;
            }
            case 21: {
                this.validatePredefinedValueEntity("point", (Map<String, Integer>)EntityV4Helper.PredefinedEntityPointConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityPointConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                break;
            }
            case 20: {
                this.validatePredefinedValueEntity("user", (Map<String, Integer>)EntityV4Helper.PredefinedEntityUserConstants.PROPERTY_MAP, (Set<String>)EntityV4Helper.PredefinedEntityUserConstants.REQUIRED_PROPERTY_NAME_SET, (EntityV4.EntityOrBuilder)value.getEntityValue());
                break;
            }
            case 18: {
                ValidationException.validateAssertion(constraint.meaningIndexOnlyAllowed, "Value has meaning %d.", 18);
            }
        }
    }

    private Map<String, EntityV4.ValueOrBuilder> validatePredefinedValueEntity(String predefinedEntityName, Map<String, Integer> allowedProperties, Set<String> requiredPropertyNameSet, EntityV4.EntityOrBuilder entity) throws ValidationException {
        ValidationException.validateAssertion(!entity.hasKey(), "The %s entity has a key.", predefinedEntityName);
        HashMap propertyMap = Maps.newHashMap();
        for (EntityV4.PropertyOrBuilder property : entity.getPropertyList()) {
            EntityV4.ValueOrBuilder value;
            String propertyName = property.getName();
            ValidationException.validateAssertion(allowedProperties.containsKey(propertyName), "The %s entity property \"%s\" is not allowed.", predefinedEntityName, propertyName);
            if (property.hasValue()) {
                value = property.getValueOrBuilder();
                ValidationException.validateAssertion(value.getListValueCount() == 0, "The %s entity property \"%s\" is multi-valued.", predefinedEntityName, propertyName);
            } else {
                ValidationException.validateAssertion(!property.getDeprecatedMulti(), "The %s entity property \"%s\" is multi-valued.", predefinedEntityName, propertyName);
                value = property.getDeprecatedValue(0);
            }
            boolean isValueRequiredType = value.hasField(EntityV4.Value.getDescriptor().findFieldByNumber(allowedProperties.get(propertyName).intValue()));
            ValidationException.validateAssertion(isValueRequiredType, "The %s entity property \"%s\" is the wrong type.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(!value.hasMeaning(), "The %s entity property \"%s\" has a meaning.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(!value.getIndexed(), "The %s entity property \"%s\" is indexed.", predefinedEntityName, propertyName);
            propertyMap.put(propertyName, value);
        }
        for (String requiredPropertyName : requiredPropertyNameSet) {
            ValidationException.validateAssertion(propertyMap.containsKey(requiredPropertyName), "The %s entity is missing required property \"%s\".", predefinedEntityName, requiredPropertyName);
        }
        return propertyMap;
    }

    private void validateValueIndexConstraints(EntityV4.ValueOrBuilder value) throws ValidationException {
        if (!value.getIndexed()) {
            return;
        }
        if (value.hasStringValue() && value.getMeaning() != 2) {
            ValidationException.validateAssertion(value.getStringValue().length() <= 500, "Indexed string value has more than permitted %d characters.", 500);
        } else if (value.hasBlobValue()) {
            ValidationException.validateAssertion(value.getBlobValue().size() <= 500, "Indexed blob value has more than permitted %d bytes.", 500);
        } else if (value.hasEntityValue()) {
            ValidationException.validateAssertion(value.hasMeaning(), "Entity value is indexed.", new Object[0]);
        }
    }

    private void validateMessageUnknownFields(String messageName, MessageOrBuilder message) throws ValidationException {
        if (!this.allowUnknownFields) {
            ValidationException.validateAssertion(message.getUnknownFields().asMap().isEmpty(), "The %s has an unknown field.", messageName);
        }
    }

    public boolean unknownFieldOnlyValueIsLengthDelimited(UnknownFieldSet.Field unknownField) {
        return unknownField.getFixed32List().isEmpty() && unknownField.getFixed64List().isEmpty() && unknownField.getGroupList().isEmpty() && unknownField.getVarintList().isEmpty() && unknownField.getLengthDelimitedList().size() == 1;
    }
}

