/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

public enum ValidationConstraint {
    READ(false, false, true, true, true, true),
    WRITE(false, false, true, false, false, false),
    TRUSTED_WRITE(false, false, true, true, true, false),
    WRITE_WITH_ALLOCATE_KEY_ID(false, true, false, false, false, false),
    TRUSTED_WRITE_WITH_ALLOCATE_KEY_ID(false, true, false, true, true, false),
    ALLOCATE_KEY_ID(false, true, false, false, false, false),
    KEY_IN_VALUE(false, false, true, true, true, false),
    READ_ENTITY_IN_VALUE(true, true, true, true, true, true),
    WRITE_ENTITY_IN_VALUE(true, true, true, true, false, false),
    TRUSTED_WRITE_ENTITY_IN_VALUE(true, true, true, true, true, false),
    TOUCH(false, false, true, true, true, true);

    public final boolean absentKeyAllowed;
    public final boolean incompleteKeyPathAllowed;
    public final boolean completeKeyPathAllowed;
    public final boolean reservedKeyAllowed;
    public final boolean reservedPropertyNameAllowed;
    public final boolean meaningIndexOnlyAllowed;

    private ValidationConstraint(boolean absentKeyAllowed, boolean incompleteKeyPathAllowed, boolean completeKeyPathAllowed, boolean reservedKeyAllowed, boolean reservedPropertyNameAllowed, boolean meaningIndexOnlyAllowed) {
        this.absentKeyAllowed = absentKeyAllowed;
        this.incompleteKeyPathAllowed = incompleteKeyPathAllowed;
        this.completeKeyPathAllowed = completeKeyPathAllowed;
        this.reservedKeyAllowed = reservedKeyAllowed;
        this.reservedPropertyNameAllowed = reservedPropertyNameAllowed;
        this.meaningIndexOnlyAllowed = meaningIndexOnlyAllowed;
    }

    public static ValidationConstraint fromPermissions(boolean isWrite, boolean isTrusted, boolean isAllocateId) {
        if (isWrite) {
            if (isTrusted) {
                return isAllocateId ? TRUSTED_WRITE_WITH_ALLOCATE_KEY_ID : TRUSTED_WRITE;
            }
            return isAllocateId ? WRITE_WITH_ALLOCATE_KEY_ID : WRITE;
        }
        return READ;
    }

    public ValidationConstraint getEntityInValueConstraint() {
        switch (this) {
            case READ: 
            case READ_ENTITY_IN_VALUE: {
                return READ_ENTITY_IN_VALUE;
            }
            case WRITE: 
            case WRITE_WITH_ALLOCATE_KEY_ID: 
            case WRITE_ENTITY_IN_VALUE: {
                return WRITE_ENTITY_IN_VALUE;
            }
            case TRUSTED_WRITE: 
            case TRUSTED_WRITE_WITH_ALLOCATE_KEY_ID: {
                return TRUSTED_WRITE_ENTITY_IN_VALUE;
            }
        }
        throw new IllegalStateException("Unexpected BaseDatastoreValidator.Constraint.getEntityInValueConstraint()");
    }
}

