/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.DatastoreServiceProtoConverter;
import com.google.apphosting.datastore.shared.DatastoreV4ServiceValidator;
import com.google.apphosting.datastore.shared.EntityProtoConverter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;

@ServiceProvider(value=LocalRpcService.class)
public class LocalDatastoreV4Service
extends AbstractLocalRpcService {
    public static final String PACKAGE = "datastore_v4";
    private final DatastoreV4ServiceValidator validator;
    private final DatastoreServiceProtoConverter converter;

    public LocalDatastoreV4Service() {
        this(DatastoreV4ServiceValidator.DEFAULT, DatastoreServiceProtoConverter.TRIVIAL);
    }

    public LocalDatastoreV4Service(DatastoreV4ServiceValidator validator, DatastoreServiceProtoConverter converter) {
        this.validator = validator;
        this.converter = converter;
    }

    public String getPackage() {
        return PACKAGE;
    }

    public DatastoreV4.AllocateIdsResponse allocateIds(LocalRpcService.Status status, DatastoreV4.AllocateIdsRequest req) {
        DatastoreV3Pb.AllocateIdsResponse respV3;
        DatastoreV4.AllocateIdsResponse.Builder respBuilder = DatastoreV4.AllocateIdsResponse.newBuilder();
        try {
            this.validator.validateAllocateIdsRequest((DatastoreV4.AllocateIdsRequestOrBuilder)req);
            DatastoreV3Pb.AllocateIdsRequest reqV3 = new DatastoreV3Pb.AllocateIdsRequest();
            reqV3.setSize(req.getAllocateCount());
            respV3 = this.makeV3Call("allocateIds", (MessageLite)reqV3, DatastoreV3Pb.AllocateIdsResponse.PARSER);
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        if (respV3.getEnd() - respV3.getStart() + 1L < (long)req.getAllocateCount()) {
            throw new ApiProxy.ApplicationException(3, "could not allocate sufficent ids");
        }
        long i = respV3.getStart();
        for (EntityV4.Key reqKey : req.getAllocateList()) {
            EntityV4.Key.Builder respKey = EntityV4.Key.newBuilder().mergeFrom(reqKey);
            respKey.getPathElementBuilder(respKey.getPathElementCount() - 1).setId(LocalDatastoreService.toScatteredId(i++));
            respBuilder.addAllocated(respKey);
        }
        return respBuilder.build();
    }

    public DatastoreV4.BeginTransactionResponse beginTransaction(LocalRpcService.Status status, DatastoreV4.BeginTransactionRequest req) {
        DatastoreV3Pb.Transaction internalResp;
        try {
            DatastoreV3Pb.BeginTransactionRequest reqV3 = this.converter.toV3BeginTransactionRequest(ApiProxy.getCurrentEnvironment().getAppId(), (DatastoreV4.BeginTransactionRequestOrBuilder)req);
            internalResp = this.makeV3Call("beginTransaction", (MessageLite)reqV3, DatastoreV3Pb.Transaction.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return this.converter.toV4BeginTransactionResponse(internalResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    public DatastoreV4.CommitResponse commit(LocalRpcService.Status status, DatastoreV4.CommitRequest req) {
        DatastoreV4.CommitResponse.Builder builder = DatastoreV4.CommitResponse.newBuilder();
        try {
            this.validator.validateCommitRequest((DatastoreV4.CommitRequestOrBuilder)req);
            if (req.hasTransaction()) {
                builder.setMutationResult(this.applyMutation((DatastoreV4.MutationOrBuilder)req.getMutation(), req.getTransaction()));
                builder.getMutationResultBuilder().setIndexUpdates(builder.getMutationResultOrBuilder().getIndexUpdates() + this.makeV3Call("commit", (MessageLite)this.converter.toV3Transaction(req.getTransaction()), DatastoreV3Pb.CommitResponse.PARSER).getCost().getIndexWrites());
            } else {
                builder.setMutationResult(this.applyMutation((DatastoreV4.MutationOrBuilder)req.getMutation(), null));
            }
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        return builder.build();
    }

    public DatastoreV4.RollbackResponse rollback(LocalRpcService.Status status, DatastoreV4.RollbackRequest req) {
        try {
            this.makeV3Call("rollback", (MessageLite)this.converter.toV3Transaction((DatastoreV4.RollbackRequestOrBuilder)req), ApiBasePb.VoidProto.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
        return DatastoreV4.RollbackResponse.getDefaultInstance();
    }

    public DatastoreV4.LookupResponse get(LocalRpcService.Status status, DatastoreV4.LookupRequest request) {
        return this.lookup(status, request);
    }

    public DatastoreV4.LookupResponse lookup(LocalRpcService.Status status, DatastoreV4.LookupRequest request) {
        try {
            this.validator.validateLookupRequest((DatastoreV4.LookupRequestOrBuilder)request);
            DatastoreV3Pb.GetResponse internResp = this.makeV3Call("get", (MessageLite)this.converter.toV3GetRequest((DatastoreV4.LookupRequestOrBuilder)request), DatastoreV3Pb.GetResponse.PARSER);
            return this.converter.toV4LookupResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
    }

    public DatastoreV4.CommitResponse write(LocalRpcService.Status status, DatastoreV4.WriteRequest request) {
        return this.commit(status, this.converter.toV4CommitRequest((DatastoreV4.WriteRequestOrBuilder)request).build());
    }

    protected DatastoreV4.RunQueryRequest normalizeRunQueryRequest(DatastoreV4.RunQueryRequest request) throws ValidationException, InvalidConversionException {
        if (request.hasGqlQuery()) {
            ValidationException.validateAssertion(!request.hasQuery(), "1 (and only 1) of fields Query.query and Query.gql_query must be set", new Object[0]);
            this.validator.getDatastoreV4Validator().validateGqlQuery((DatastoreV4.GqlQueryOrBuilder)request.getGqlQuery());
            request = DatastoreV4.RunQueryRequest.newBuilder((DatastoreV4.RunQueryRequest)request).setQuery(this.converter.getDatastoreProtoConverter().toV4Query((DatastoreV4.GqlQueryOrBuilder)request.getGqlQuery(), request.getPartitionId())).clearGqlQuery().build();
        }
        return request;
    }

    public DatastoreV4.RunQueryResponse runQuery(LocalRpcService.Status status, DatastoreV4.RunQueryRequest request) {
        DatastoreV3Pb.QueryResult internResp;
        try {
            request = this.normalizeRunQueryRequest(request);
            this.validator.validateRunQueryRequest((DatastoreV4.RunQueryRequestOrBuilder)request);
            internResp = this.makeV3Call("runQuery", (MessageLite)this.converter.toV3Query((DatastoreV4.RunQueryRequestOrBuilder)request), DatastoreV3Pb.QueryResult.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return this.converter.toV4RunQueryResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    public DatastoreV4.ContinueQueryResponse continueQuery(LocalRpcService.Status status, DatastoreV4.ContinueQueryRequest request) {
        DatastoreV3Pb.QueryResult internResp;
        try {
            internResp = this.makeV3Call("next", (MessageLite)this.converter.toV3NextRequest((DatastoreV4.ContinueQueryRequestOrBuilder)request), DatastoreV3Pb.QueryResult.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return this.converter.toV4ContinueQueryResponse(internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    private int insert(OnestoreEntity.EntityProto entity, DatastoreV3Pb.Transaction txn) throws InvalidConversionException {
        if (txn == null) {
            txn = this.makeV3Call("beginTransaction", (MessageLite)new DatastoreV3Pb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastoreV3Pb.Transaction.PARSER);
            this.insert(entity, txn);
            return this.makeV3Call("commit", (MessageLite)txn, DatastoreV3Pb.CommitResponse.PARSER).getCost().getIndexWrites();
        }
        DatastoreV3Pb.GetRequest get = new DatastoreV3Pb.GetRequest().setTransaction(txn);
        get.addKey(entity.getKey());
        DatastoreV3Pb.GetResponse res = this.makeV3Call("get", (MessageLite)get, DatastoreV3Pb.GetResponse.PARSER);
        if (res.getEntity(0).hasEntity()) {
            throw new ApiProxy.ApplicationException(1, "entity already exists");
        }
        DatastoreV3Pb.PutRequest put = new DatastoreV3Pb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return this.makeV3Call("put", (MessageLite)put, DatastoreV3Pb.PutResponse.PARSER).getCost().getIndexWrites();
    }

    private int update(OnestoreEntity.EntityProto entity, DatastoreV3Pb.Transaction txn) throws InvalidConversionException {
        if (txn == null) {
            txn = this.makeV3Call("beginTransaction", (MessageLite)new DatastoreV3Pb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastoreV3Pb.Transaction.PARSER);
            this.update(entity, txn);
            return this.makeV3Call("commit", (MessageLite)txn, DatastoreV3Pb.CommitResponse.PARSER).getCost().getIndexWrites();
        }
        DatastoreV3Pb.GetRequest get = new DatastoreV3Pb.GetRequest().setTransaction(txn);
        get.addKey(entity.getKey());
        DatastoreV3Pb.GetResponse res = this.makeV3Call("get", (MessageLite)get, DatastoreV3Pb.GetResponse.PARSER);
        if (!res.getEntity(0).hasEntity()) {
            throw new ApiProxy.ApplicationException(1, "entity does not exist");
        }
        DatastoreV3Pb.PutRequest put = new DatastoreV3Pb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return this.makeV3Call("put", (MessageLite)put, DatastoreV3Pb.PutResponse.PARSER).getCost().getIndexWrites();
    }

    private DatastoreV4.MutationResult.Builder applyMutation(DatastoreV4.MutationOrBuilder mutation, ByteString v4Txn) throws InvalidConversionException {
        DatastoreV3Pb.Transaction txn = v4Txn == null ? null : this.converter.toV3Transaction(v4Txn);
        int indexWrites = 0;
        EntityProtoConverter entityConverter = this.converter.getDatastoreProtoConverter().getEntityProtoConverter();
        for (EntityV4.Entity entity : mutation.getInsertList()) {
            indexWrites += this.insert(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)entity), txn);
        }
        for (EntityV4.Entity entity : mutation.getUpdateList()) {
            indexWrites += this.update(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)entity), txn);
        }
        DatastoreV3Pb.PutRequest putReq = new DatastoreV3Pb.PutRequest();
        DatastoreV3Pb.DeleteRequest deleteReq = new DatastoreV3Pb.DeleteRequest();
        if (txn != null) {
            putReq.setTransaction(txn);
            deleteReq.setTransaction(txn);
        }
        for (EntityV4.Entity entity : mutation.getInsertAutoIdList()) {
            putReq.addEntity(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)entity));
        }
        DatastoreV3Pb.PutResponse insertAutoResp = this.makeV3Call("put", (MessageLite)putReq, DatastoreV3Pb.PutResponse.PARSER);
        indexWrites += insertAutoResp.getCost().getIndexWrites();
        putReq.clearEntity();
        for (EntityV4.Entity entity : mutation.getUpsertList()) {
            putReq.addEntity(entityConverter.toV3Entity((EntityV4.EntityOrBuilder)entity));
        }
        indexWrites += this.makeV3Call("put", (MessageLite)putReq, DatastoreV3Pb.PutResponse.PARSER).getCost().getIndexWrites();
        for (EntityV4.Key key : mutation.getDeleteList()) {
            deleteReq.addKey(entityConverter.toV3Reference((EntityV4.KeyOrBuilder)key));
        }
        indexWrites += this.makeV3Call("delete", (MessageLite)deleteReq, DatastoreV3Pb.DeleteResponse.PARSER).getCost().getIndexWrites();
        DatastoreV4.MutationResult.Builder builder = DatastoreV4.MutationResult.newBuilder();
        for (OnestoreEntity.Reference key : insertAutoResp.keys()) {
            builder.addInsertAutoIdKey(entityConverter.toV4Key(key));
        }
        builder.setIndexUpdates(indexWrites);
        return builder;
    }

    private <T> T makeV3Call(String method, MessageLite req, Parser<T> respParser) throws InvalidConversionException {
        try {
            return (T)respParser.parseFrom(ApiProxy.makeSyncCall((String)"datastore_v3", (String)method, (byte[])req.toByteArray()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }
}

