/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.modules.dev;

import com.google.appengine.api.modules.ModulesServicePb;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ModulesController;
import com.google.appengine.tools.development.ServiceProvider;

@ServiceProvider(value=LocalRpcService.class)
public class LocalModulesService
extends AbstractLocalRpcService {
    private static final int MAIN_INSTANCE = -1;
    public static final String PACKAGE = "modules";
    private ModulesController modulesController;

    public String getPackage() {
        return PACKAGE;
    }

    public ModulesServicePb.GetModulesResponse getModules(LocalRpcService.Status status, ModulesServicePb.GetModulesRequest request) {
        ModulesServicePb.GetModulesResponse.Builder result = ModulesServicePb.GetModulesResponse.newBuilder();
        for (String moduleName : this.modulesController.getModuleNames()) {
            result.addModule(moduleName);
        }
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.GetVersionsResponse getVersions(LocalRpcService.Status status, ModulesServicePb.GetVersionsRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.GetVersionsResponse.Builder result = ModulesServicePb.GetVersionsResponse.newBuilder();
        String moduleName = request.getModule();
        Iterable versions = this.modulesController.getVersions(moduleName);
        for (String version : versions) {
            result.addVersion(version);
        }
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.GetDefaultVersionResponse getDefaultVersion(LocalRpcService.Status status, ModulesServicePb.GetDefaultVersionRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.GetDefaultVersionResponse.Builder result = ModulesServicePb.GetDefaultVersionResponse.newBuilder();
        String moduleName = request.getModule();
        String version = this.modulesController.getDefaultVersion(moduleName);
        result.setVersion(version);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.GetNumInstancesResponse getNumInstances(LocalRpcService.Status status, ModulesServicePb.GetNumInstancesRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.GetNumInstancesResponse.Builder result = ModulesServicePb.GetNumInstancesResponse.newBuilder();
        String moduleName = request.getModule();
        String version = request.getVersion();
        int numInstances = this.modulesController.getNumInstances(moduleName, version);
        result.setInstances((long)numInstances);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.SetNumInstancesResponse setNumInstances(LocalRpcService.Status status, ModulesServicePb.SetNumInstancesRequest request) {
        throw new UnsupportedOperationException("ModulesService.setNumInstances not currentlysupported by java dev appserver");
    }

    public ModulesServicePb.StartModuleResponse startModule(LocalRpcService.Status status, ModulesServicePb.StartModuleRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.StartModuleResponse.Builder result = ModulesServicePb.StartModuleResponse.newBuilder();
        String moduleName = request.getModule();
        String version = request.getVersion();
        this.modulesController.startModule(moduleName, version);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.StopModuleResponse stopModule(LocalRpcService.Status status, ModulesServicePb.StopModuleRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.StopModuleResponse.Builder result = ModulesServicePb.StopModuleResponse.newBuilder();
        String moduleName = request.getModule();
        String version = request.getVersion();
        this.modulesController.stopModule(moduleName, version);
        status.setSuccessful(true);
        return result.build();
    }

    public ModulesServicePb.GetHostnameResponse getHostname(LocalRpcService.Status status, ModulesServicePb.GetHostnameRequest request) {
        status.setSuccessful(false);
        ModulesServicePb.GetHostnameResponse.Builder result = ModulesServicePb.GetHostnameResponse.newBuilder();
        String moduleName = request.getModule();
        String version = request.getVersion();
        int instance = request.hasInstance() ? Integer.parseInt(request.getInstance()) : -1;
        result.setHostname(this.modulesController.getHostname(moduleName, version, instance));
        status.setSuccessful(true);
        return result.build();
    }

    public void setModulesController(ModulesController modulesController) {
        this.modulesController = modulesController;
    }
}

