/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.dev.GeometricQuery;
import com.google.appengine.api.search.dev.LuceneQueryTreeContext;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.WordSeparatorAnalyzer;
import com.google.appengine.api.search.query.ParserUtils;
import com.google.appengine.api.search.query.QueryTreeContext;
import com.google.appengine.api.search.query.QueryTreeVisitor;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import com.google.apphosting.api.search.DocumentPb;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

class LuceneQueryTreeVisitor
implements QueryTreeVisitor<LuceneQueryTreeContext> {
    private static final Map<DocumentPb.FieldValue.ContentType, QueryTreeContext.Type> TYPE_MAP = new EnumMap<DocumentPb.FieldValue.ContentType, QueryTreeContext.Type>(DocumentPb.FieldValue.ContentType.class);
    private static final Set<DocumentPb.FieldValue.ContentType> TEXT_TYPES = EnumSet.of(DocumentPb.FieldValue.ContentType.TEXT, DocumentPb.FieldValue.ContentType.ATOM, DocumentPb.FieldValue.ContentType.HTML);
    private final Map<String, Set<DocumentPb.FieldValue.ContentType>> allFieldTypes;

    public LuceneQueryTreeVisitor(Map<String, Set<DocumentPb.FieldValue.ContentType>> allFieldTypes) {
        this.allFieldTypes = allFieldTypes;
    }

    public void visitSequence(Tree node, LuceneQueryTreeContext context) {
        this.visitConjunction(node, context);
    }

    public void visitConjunction(Tree node, LuceneQueryTreeContext context) {
        context.setQuery(this.visitBooleanQueryChildren(new BooleanQuery(), BooleanClause.Occur.MUST, context));
    }

    public void visitDisjunction(Tree node, LuceneQueryTreeContext context) {
        context.setQuery(this.visitBooleanQueryChildren(new BooleanQuery(), BooleanClause.Occur.SHOULD, context));
    }

    public void visitNegation(Tree node, LuceneQueryTreeContext context) {
        BooleanQuery query = new BooleanQuery();
        query.add(LuceneUtils.getMatchAnyDocumentQuery(), BooleanClause.Occur.MUST);
        context.setQuery(this.visitBooleanQueryChildren(query, BooleanClause.Occur.MUST_NOT, context));
    }

    private Query visitBooleanQueryChildren(BooleanQuery parentQuery, BooleanClause.Occur occur, LuceneQueryTreeContext context) {
        for (LuceneQueryTreeContext childContext : context.children()) {
            parentQuery.add(childContext.getQuery(), occur);
        }
        return parentQuery;
    }

    public void visitFuzzy(Tree node, LuceneQueryTreeContext context) {
        context.setRewriteMode(QueryTreeContext.RewriteMode.FUZZY);
    }

    public void visitLiteral(Tree node, LuceneQueryTreeContext context) {
        context.setRewriteMode(QueryTreeContext.RewriteMode.STRICT);
    }

    public void visitLessThan(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.LT);
    }

    public void visitLessOrEqual(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.LE);
    }

    public void visitGreaterThan(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.GT);
    }

    public void visitGreaterOrEqual(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.GE);
    }

    public void visitEqual(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.HAS);
    }

    public void visitContains(Tree node, LuceneQueryTreeContext context) {
        this.visitComparison(node, context, LuceneQueryTreeContext.ComparisonOp.HAS);
    }

    private void visitComparison(Tree node, LuceneQueryTreeContext context, LuceneQueryTreeContext.ComparisonOp op) {
        LuceneQueryTreeContext lhs = (LuceneQueryTreeContext)context.getChild(0);
        LuceneQueryTreeContext rhs = (LuceneQueryTreeContext)context.getChild(1);
        ArrayList<Query> children = new ArrayList<Query>();
        for (QueryTreeContext.Type type : lhs.getCommonReturnTypes(rhs)) {
            children.addAll(this.newQuery(type, lhs, op, rhs));
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Query query = (Query)iter.next();
            if (query != null) continue;
            iter.remove();
        }
        if (children.isEmpty()) {
            context.setQuery(LuceneUtils.getMatchNoneQuery());
        } else if (children.size() == 1) {
            context.setQuery((Query)children.get(0));
        } else {
            BooleanQuery or = new BooleanQuery();
            for (Query query : children) {
                or.add(query, BooleanClause.Occur.SHOULD);
            }
            context.setQuery(or);
        }
    }

    public void visitValue(Tree node, LuceneQueryTreeContext context) {
        if (node.getChild(0).getType() == 12) {
            String text = node.getChild(2).getText();
            context.setRawText(text);
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i < node.getChildCount(); ++i) {
                builder.append(node.getChild(i).getText());
            }
            context.setText(builder.toString());
            context.setKind(QueryTreeContext.Kind.PHRASE);
            context.setReturnType(QueryTreeContext.Type.TEXT);
            if (ParserUtils.isNumber((String)text)) {
                context.addReturnType(QueryTreeContext.Type.NUMBER);
            }
            if (LuceneUtils.isDateString(text)) {
                context.addReturnType(QueryTreeContext.Type.DATE);
            }
        } else {
            String text = node.getChild(1).getText();
            Set<DocumentPb.FieldValue.ContentType> types = this.allFieldTypes.get(text);
            if (types != null && !types.isEmpty()) {
                for (DocumentPb.FieldValue.ContentType type : types) {
                    context.addReturnType(TYPE_MAP.get(type));
                }
                context.setKind(QueryTreeContext.Kind.FIELD);
                context.setFieldTypes(types);
            } else {
                context.setKind(QueryTreeContext.Kind.LITERAL);
                context.setReturnType(QueryTreeContext.Type.TEXT);
                if (ParserUtils.isNumber((String)text)) {
                    context.addReturnType(QueryTreeContext.Type.NUMBER);
                    context.addReturnType(QueryTreeContext.Type.DISTANCE);
                }
                if (LuceneUtils.isDateString(text)) {
                    context.addReturnType(QueryTreeContext.Type.DATE);
                }
            }
            context.setText(text);
        }
    }

    public void visitFunction(Tree node, LuceneQueryTreeContext context) {
        String token = node.getChild(0).getText();
        Function fn = Function.fromToken(token);
        ArrayList children = Lists.newArrayList((Iterable)context.children());
        if (children.size() != 2) {
            throw new SearchQueryException(String.format("%s() function requires exactly 2 arguments", token));
        }
        switch (fn) {
            case DISTANCE: {
                LuceneQueryTreeContext arg0 = (LuceneQueryTreeContext)((Object)children.get(0));
                LuceneQueryTreeContext arg1 = (LuceneQueryTreeContext)((Object)children.get(1));
                if (!arg0.isField() && arg1.isField()) {
                    LuceneQueryTreeContext tmp = arg0;
                    arg0 = arg1;
                    arg1 = tmp;
                    children.set(0, arg0);
                    children.set(1, arg1);
                }
                if (!arg0.isField() || !arg1.isLiteral()) {
                    throw new SearchQueryException("distance() function requires field-name and geopoint() arguments");
                }
                String field = arg0.getText();
                String point = arg1.getText();
                context.setReturnType(QueryTreeContext.Type.DISTANCE);
                context.setKind(QueryTreeContext.Kind.FUNCTION);
                context.setText(field + ":" + point);
                break;
            }
            case GEOPOINT: {
                context.setReturnType(QueryTreeContext.Type.LOCATION);
                context.setKind(QueryTreeContext.Kind.LITERAL);
                double lat = Double.valueOf(((LuceneQueryTreeContext)((Object)children.get(0))).getText());
                double lng = Double.valueOf(((LuceneQueryTreeContext)((Object)children.get(1))).getText());
                context.setText(lat + ":" + lng);
            }
        }
    }

    public void visitGlobal(Tree node, LuceneQueryTreeContext context) {
        context.setReturnType(QueryTreeContext.Type.TEXT);
        context.addReturnType(QueryTreeContext.Type.DATE);
        context.addReturnType(QueryTreeContext.Type.NUMBER);
        context.setText("_GLOBAL");
    }

    public void visitOther(Tree node, LuceneQueryTreeContext context) {
        throw new SearchQueryException("Unexpected query found at " + node.getCharPositionInLine() + ": \"" + node.getText() + "\"");
    }

    private List<Query> newQuery(QueryTreeContext.Type type, LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        ArrayList<Query> queries = new ArrayList<Query>();
        switch (type) {
            case TEXT: {
                EnumSet<DocumentPb.FieldValue.ContentType> types;
                if (lhs.getFieldTypes() == null) {
                    types = EnumSet.of(DocumentPb.FieldValue.ContentType.TEXT);
                } else {
                    types = EnumSet.copyOf(lhs.getFieldTypes());
                    types.retainAll(TEXT_TYPES);
                }
                for (DocumentPb.FieldValue.ContentType subType : types) {
                    queries.add(LuceneQueryTreeVisitor.newTextQuery(subType, lhs, op, rhs));
                }
                break;
            }
            case NUMBER: {
                queries.add(LuceneQueryTreeVisitor.newNumericQuery(lhs, op, rhs));
                break;
            }
            case DATE: {
                queries.add(LuceneQueryTreeVisitor.newDateQuery(lhs, op, rhs));
                break;
            }
            case DISTANCE: {
                queries.add(LuceneQueryTreeVisitor.newDistanceQuery(lhs, op, rhs));
                break;
            }
            case LOCATION: {
                throw new SearchQueryException("Comparison operator not available for Geo type");
            }
            default: {
                throw new SearchQueryException("Unknown field type " + type.name().toLowerCase());
            }
        }
        return queries;
    }

    private static Query newNumericQuery(LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        try {
            double value = Double.parseDouble(rhs.getUnquotedText());
            boolean minInclusive = true;
            boolean maxInclusive = true;
            double min = value;
            double max = value;
            switch (op) {
                case EQ: 
                case HAS: {
                    if (!"_GLOBAL".equals(lhs.getText())) break;
                    return new TermQuery(new Term(lhs.getText(), Double.toString(min)));
                }
                case LT: {
                    maxInclusive = false;
                    min = -1.7976931348623157E308;
                    break;
                }
                case LE: {
                    maxInclusive = true;
                    min = -1.7976931348623157E308;
                    break;
                }
                case GT: {
                    minInclusive = false;
                    max = Double.MAX_VALUE;
                    break;
                }
                case GE: {
                    minInclusive = true;
                    max = Double.MAX_VALUE;
                    break;
                }
                default: {
                    return null;
                }
            }
            String text = lhs.getText();
            if (lhs.isField()) {
                text = LuceneUtils.makeLuceneFieldName(text, DocumentPb.FieldValue.ContentType.NUMBER);
            }
            return NumericRangeQuery.newDoubleRange(text, min, max, minInclusive, maxInclusive);
        }
        catch (NumberFormatException e) {
            throw new SearchQueryException(lhs.getText() + (Object)((Object)op) + rhs.getText());
        }
    }

    private static Query newDistanceQuery(LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        if (op == LuceneQueryTreeContext.ComparisonOp.HAS) {
            throw new SearchQueryException("Equality comparison not available for Geo type");
        }
        String[] parts = lhs.getText().split(Pattern.quote(":"));
        String fieldName = parts[0];
        double latitude = Double.parseDouble(parts[1]);
        double longitude = Double.parseDouble(parts[2]);
        double distance = Double.parseDouble(rhs.getText());
        return GeometricQuery.create(fieldName, latitude, longitude, op, distance);
    }

    private static Query newDateQuery(LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        long min;
        long time;
        try {
            time = LuceneUtils.dateStringToLong(rhs.getUnquotedText());
        }
        catch (ParseException e) {
            throw new SearchQueryException("Could not parse date");
        }
        boolean minInclusive = true;
        boolean maxInclusive = true;
        long max = min = time / 86400000L;
        switch (op) {
            case EQ: 
            case HAS: {
                if ("_GLOBAL".equals(lhs.getText())) {
                    return new TermQuery(new Term(lhs.getText(), Long.toString(min)));
                }
                max = min + 1L;
                maxInclusive = false;
                break;
            }
            case LT: {
                maxInclusive = false;
                min = Long.MIN_VALUE;
                break;
            }
            case LE: {
                maxInclusive = true;
                min = Long.MIN_VALUE;
                break;
            }
            case GT: {
                minInclusive = false;
                max = Long.MAX_VALUE;
                break;
            }
            case GE: {
                minInclusive = true;
                max = Long.MAX_VALUE;
                break;
            }
            default: {
                return null;
            }
        }
        return NumericRangeQuery.newLongRange(LuceneUtils.makeLuceneFieldName(lhs.getText(), DocumentPb.FieldValue.ContentType.DATE), min, max, minInclusive, maxInclusive);
    }

    private static Query newTextQuery(DocumentPb.FieldValue.ContentType subType, LuceneQueryTreeContext lhs, LuceneQueryTreeContext.ComparisonOp op, LuceneQueryTreeContext rhs) {
        switch (op) {
            case EQ: 
            case HAS: {
                return LuceneQueryTreeVisitor.newTextMatchQuery(subType, lhs, rhs);
            }
            case NE: {
                BooleanQuery boolQuery = new BooleanQuery();
                boolQuery.add(LuceneUtils.getMatchAnyDocumentQuery(), BooleanClause.Occur.MUST);
                boolQuery.add(LuceneQueryTreeVisitor.newTextMatchQuery(subType, lhs, rhs), BooleanClause.Occur.MUST_NOT);
                return boolQuery;
            }
        }
        return null;
    }

    private static Query newTextMatchQuery(DocumentPb.FieldValue.ContentType subType, LuceneQueryTreeContext lhs, LuceneQueryTreeContext rhs) {
        String field = lhs.getText();
        String value = rhs.getText();
        if (lhs.isField()) {
            field = LuceneUtils.makeLuceneFieldNameWithExtractedText(field, subType);
        } else if (!"_GLOBAL".equals(field)) {
            value = (Object)((Object)lhs) + ":" + value;
            field = "_GLOBAL";
        }
        if (!rhs.isPhrase()) {
            List<String> tokens = WordSeparatorAnalyzer.tokenList(value);
            if (tokens.size() == 1) {
                return new TermQuery(new Term(field, tokens.get(0)));
            }
            if (tokens.isEmpty()) {
                return LuceneUtils.getMatchAnyDocumentQuery();
            }
            BooleanQuery conjunction = new BooleanQuery();
            for (String token : tokens) {
                conjunction.add(new TermQuery(new Term(field, token)), BooleanClause.Occur.MUST);
            }
            return conjunction;
        }
        PhraseQuery phraseQuery = new PhraseQuery();
        for (String token : WordSeparatorAnalyzer.tokenList(value)) {
            phraseQuery.add(new Term(field, token));
        }
        if (!WordSeparatorAnalyzer.normalize(value = value.substring(1, value.length() - 1)).equals(value.toLowerCase())) {
            BooleanQuery disjunction = new BooleanQuery();
            disjunction.add(phraseQuery, BooleanClause.Occur.SHOULD);
            PhraseQuery literalPhraseQuery = new PhraseQuery();
            literalPhraseQuery.add(new Term(field, value));
            disjunction.add(literalPhraseQuery, BooleanClause.Occur.SHOULD);
            return disjunction;
        }
        return phraseQuery;
    }

    static {
        TYPE_MAP.put(DocumentPb.FieldValue.ContentType.ATOM, QueryTreeContext.Type.TEXT);
        TYPE_MAP.put(DocumentPb.FieldValue.ContentType.DATE, QueryTreeContext.Type.DATE);
        TYPE_MAP.put(DocumentPb.FieldValue.ContentType.GEO, QueryTreeContext.Type.LOCATION);
        TYPE_MAP.put(DocumentPb.FieldValue.ContentType.HTML, QueryTreeContext.Type.TEXT);
        TYPE_MAP.put(DocumentPb.FieldValue.ContentType.NUMBER, QueryTreeContext.Type.NUMBER);
        TYPE_MAP.put(DocumentPb.FieldValue.ContentType.TEXT, QueryTreeContext.Type.TEXT);
    }

    static enum Function {
        GEOPOINT,
        DISTANCE;

        final String token = this.name().toLowerCase();

        static Function fromToken(String token) {
            for (Function f : Function.values()) {
                if (!f.token.equals(token)) continue;
                return f;
            }
            throw new SearchQueryException("unknown function '" + token + "'");
        }
    }
}

