/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch.dev;

import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.urlfetch.dev.AllMethodsRedirectHandler;
import com.google.appengine.api.urlfetch.dev.HttpPatch;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.org.apache.http.Header;
import com.google.appengine.repackaged.org.apache.http.HttpEntity;
import com.google.appengine.repackaged.org.apache.http.HttpHost;
import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.client.HttpClient;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpDelete;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpGet;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpHead;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpPost;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpPut;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpRequestBase;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpUriRequest;
import com.google.appengine.repackaged.org.apache.http.client.params.HttpClientParams;
import com.google.appengine.repackaged.org.apache.http.conn.scheme.PlainSocketFactory;
import com.google.appengine.repackaged.org.apache.http.conn.scheme.Scheme;
import com.google.appengine.repackaged.org.apache.http.conn.scheme.SchemeRegistry;
import com.google.appengine.repackaged.org.apache.http.conn.ssl.SSLSocketFactory;
import com.google.appengine.repackaged.org.apache.http.entity.ByteArrayEntity;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultHttpClient;
import com.google.appengine.repackaged.org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import com.google.appengine.repackaged.org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import com.google.appengine.repackaged.org.apache.http.params.BasicHttpParams;
import com.google.appengine.repackaged.org.apache.http.params.HttpConnectionParams;
import com.google.appengine.repackaged.org.apache.http.protocol.BasicHttpContext;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.DevSocketImplFactory;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@ServiceProvider(value=LocalRpcService.class)
public class LocalURLFetchService
extends AbstractLocalRpcService {
    private static final int DEFAULT_TIMEOUT_IN_MS = 600000;
    static final int DEFAULT_MAX_RESPONSE_LENGTH = 0x2000000;
    static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final String PACKAGE = "urlfetch";
    private static final int TEMPORARY_RESPONSE_BUFFER_LENGTH = 4096;
    int maxResponseLength = 0x2000000;
    int maxRedirects = 5;
    Logger logger = Logger.getLogger(LocalURLFetchService.class.getName());
    private HttpClient validatingClient;
    private HttpClient nonValidatingClient;
    private static final Map<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> METHOD_FACTORY_MAP = LocalURLFetchService.buildMethodFactoryMap();
    private int timeoutInMs = 600000;
    private static final String TRUST_STORE_LOCATION = "/com/google/appengine/api/urlfetch/dev/cacerts";

    private static Map<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> buildMethodFactoryMap() {
        HashMap<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory> map = new HashMap<URLFetchServicePb.URLFetchRequest.RequestMethod, MethodFactory>();
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.GET, new MethodFactory(){

            @Override
            public HttpRequestBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new HttpGet(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.DELETE, new MethodFactory(){

            @Override
            public HttpRequestBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new HttpDelete(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.HEAD, new MethodFactory(){

            @Override
            public HttpRequestBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                return new HttpHead(request.getUrl());
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.POST, new MethodFactory(){

            @Override
            public HttpRequestBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                HttpPost post = new HttpPost(request.getUrl());
                if (request.hasPayload()) {
                    ByteArrayEntity requestEntity = new ByteArrayEntity(request.getPayload().toByteArray());
                    post.setEntity(requestEntity);
                }
                return post;
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.PUT, new MethodFactory(){

            @Override
            public HttpRequestBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                HttpPut put = new HttpPut(request.getUrl());
                if (request.hasPayload()) {
                    ByteArrayEntity requestEntity = new ByteArrayEntity(request.getPayload().toByteArray());
                    put.setEntity(requestEntity);
                }
                return put;
            }
        });
        map.put(URLFetchServicePb.URLFetchRequest.RequestMethod.PATCH, new MethodFactory(){

            @Override
            public HttpRequestBase buildMethod(URLFetchServicePb.URLFetchRequest request) {
                HttpPatch patch = new HttpPatch(request.getUrl());
                if (request.hasPayload()) {
                    ByteArrayEntity requestEntity = new ByteArrayEntity(request.getPayload().toByteArray());
                    patch.setEntity(requestEntity);
                }
                return patch;
            }
        });
        return map;
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void setTimeoutInMs(int timeoutInMs) {
        this.timeoutInMs = timeoutInMs;
    }

    private KeyStore getTrustStore() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(TRUST_STORE_LOCATION);
        if (is == null) {
            throw new IOException("Couldn't get trust store stream");
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(is, null);
        return ks;
    }

    private Scheme createValidatingScheme() throws Exception {
        KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmFactory.init(null, null);
        KeyManager[] keyManagers = kmFactory.getKeyManagers();
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(this.getTrustStore());
        TrustManager[] trustManagers = tmFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        SSLSocketFactory strictSocketFactory = new SSLSocketFactory(sslContext);
        strictSocketFactory.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        return new Scheme("https", strictSocketFactory, 443);
    }

    private Scheme createNonvalidatingScheme() throws KeyManagementException, NoSuchAlgorithmException {
        X509TrustManager poorLifeChoicesTrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String atuhType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{poorLifeChoicesTrustManager}, null);
        return new Scheme("https", new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER), 443);
    }

    public HttpClient createHttpClient(boolean validateHttps) {
        Scheme urlfetchHttps = null;
        if (validateHttps) {
            try {
                urlfetchHttps = this.createValidatingScheme();
            }
            catch (Exception e) {
                validateHttps = false;
                this.logger.log(Level.WARNING, "Encountered exception trying to initialize SSL. SSL certificate validation will be disabled", e);
            }
        }
        if (!validateHttps) {
            try {
                urlfetchHttps = this.createNonvalidatingScheme();
            }
            catch (KeyManagementException kme) {
                this.logger.log(Level.WARNING, "Encountered exception trying to initialize SSL. All HTTPS fetches will be disabled.", kme);
                urlfetchHttps = null;
            }
            catch (NoSuchAlgorithmException nsae) {
                this.logger.log(Level.WARNING, "Encountered exception trying to initialize SSL. All HTTPS fetches will be disabled.", nsae);
                urlfetchHttps = null;
            }
        }
        Scheme urlfetchHttp = new Scheme("http", PlainSocketFactory.getSocketFactory(), 80);
        SchemeRegistry sr = new SchemeRegistry();
        if (urlfetchHttps != null) {
            sr.register(urlfetchHttps);
        }
        sr.register(urlfetchHttp);
        DefaultHttpClient client = new DefaultHttpClient(new ThreadSafeClientConnManager(new BasicHttpParams(), sr), new BasicHttpParams());
        client.getParams().setIntParameter("http.protocol.max-redirects", this.maxRedirects);
        client.setRedirectHandler(new AllMethodsRedirectHandler());
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        client.setRoutePlanner(routePlanner);
        return client;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
    }

    public void start() {
    }

    public void stop() {
    }

    private byte[] responseToByteArray(HttpEntity responseEntity) throws IOException {
        int result;
        InputStream responseInputStream = responseEntity.getContent();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tempBuffer = new byte[4096];
        long total = 0L;
        while ((result = responseInputStream.read(tempBuffer)) != -1) {
            baos.write(tempBuffer, 0, result);
            total += (long)result;
        }
        return baos.toByteArray();
    }

    @LatencyPercentiles(latency50th=5)
    public URLFetchServicePb.URLFetchResponse fetch(LocalRpcService.Status status, URLFetchServicePb.URLFetchRequest request) {
        if (status == null) {
            throw new NullPointerException("status cannot be null.");
        }
        if (request == null) {
            throw new NullPointerException("request cannot be null.");
        }
        if (!this.hasValidURL(request)) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.INVALID_URL.getNumber(), "Invalid URL: " + request.getUrl());
        }
        MethodFactory methodFactory = METHOD_FACTORY_MAP.get(request.getMethod());
        if (methodFactory == null) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.INVALID_URL.getNumber(), "Unsupported method: " + request.getMethod());
        }
        HttpRequestBase method = methodFactory.buildMethod(request);
        BasicHttpParams params = new BasicHttpParams();
        HttpClientParams.setRedirecting(params, request.getFollowRedirects());
        HttpConnectionParams.setConnectionTimeout(params, this.timeoutInMs);
        HttpConnectionParams.setSoTimeout(params, this.timeoutInMs);
        method.setParams(params);
        boolean sawContentType = false;
        for (URLFetchServicePb.URLFetchRequest.Header pbHeader : request.getHeaderList()) {
            if (pbHeader.getKey().equalsIgnoreCase("Content-Length")) continue;
            method.addHeader(pbHeader.getKey(), pbHeader.getValue());
            if (!pbHeader.getKey().equalsIgnoreCase("Content-Type")) continue;
            sawContentType = true;
        }
        if (!sawContentType && request.getMethod() == URLFetchServicePb.URLFetchRequest.RequestMethod.POST) {
            method.addHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        URLFetchServicePb.URLFetchResponse.Builder response = URLFetchServicePb.URLFetchResponse.newBuilder();
        try {
            HttpResponse httpResponse = this.doPrivilegedExecute(request, method, response);
            HttpEntity responseEntity = httpResponse.getEntity();
            if (responseEntity != null) {
                byte[] responseBuffer = this.responseToByteArray(responseEntity);
                if (responseBuffer.length > this.maxResponseLength) {
                    byte[] oldBuffer = responseBuffer;
                    responseBuffer = new byte[this.maxResponseLength];
                    System.arraycopy(oldBuffer, 0, responseBuffer, 0, this.maxResponseLength);
                    response.setContentWasTruncated(true);
                }
                response.setContent(ByteString.copyFrom((byte[])responseBuffer));
            }
            this.httpclientHeadersToPbHeaders(httpResponse.getAllHeaders(), response);
        }
        catch (SocketTimeoutException ste) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.DEADLINE_EXCEEDED.getNumber(), "http method " + method.getMethod() + " against URL " + request.getUrl() + " timed out.");
        }
        catch (SSLException e) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.SSL_CERTIFICATE_ERROR.getNumber(), "Couldn't validate the server's SSL certificate for URL " + request.getUrl() + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new ApiProxy.ApplicationException(URLFetchServicePb.URLFetchServiceError.ErrorCode.FETCH_ERROR.getNumber(), "Received exception executing http method " + method.getMethod() + " against URL " + request.getUrl() + ": " + e.getMessage());
        }
        return response.build();
    }

    private HttpResponse doPrivilegedExecute(final URLFetchServicePb.URLFetchRequest request, final HttpRequestBase method, final URLFetchServicePb.URLFetchResponse.Builder response) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<HttpResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public HttpResponse run() throws IOException {
                    boolean isNativeMode = DevSocketImplFactory.setSocketNativeMode((boolean)true);
                    try {
                        BasicHttpContext context = new BasicHttpContext();
                        HttpResponse httpResponse = request.hasMustValidateServerCertificate() && request.getMustValidateServerCertificate() ? LocalURLFetchService.this.getValidatingClient().execute((HttpUriRequest)method, context) : LocalURLFetchService.this.getNonValidatingClient().execute((HttpUriRequest)method, context);
                        response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
                        HttpHost lastHost = (HttpHost)context.getAttribute("http.target_host");
                        HttpUriRequest lastReq = (HttpUriRequest)context.getAttribute("http.request");
                        String lastUrl = lastHost.toURI() + lastReq.getURI();
                        if (!lastUrl.equals(method.getURI().toString())) {
                            response.setFinalUrl(lastUrl);
                        }
                        HttpResponse httpResponse2 = httpResponse;
                        return httpResponse2;
                    }
                    finally {
                        DevSocketImplFactory.setSocketNativeMode((boolean)isNativeMode);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(e);
        }
    }

    boolean isAllowedPort(int port) {
        return port == -1 || port >= 80 && port <= 90 || port >= 440 && port <= 450 || port >= 1024;
    }

    boolean hasValidURL(URLFetchServicePb.URLFetchRequest request) {
        URL url;
        if (!request.hasUrl() || request.getUrl().length() == 0) {
            return false;
        }
        try {
            url = new URL(request.getUrl());
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            return false;
        }
        if (!this.isAllowedPort(url.getPort())) {
            this.logger.log(Level.WARNING, String.format("urlfetch received %s ; port %s is not allowed in production!", url, url.getPort()));
        }
        return true;
    }

    void httpclientHeadersToPbHeaders(Header[] headers, URLFetchServicePb.URLFetchResponse.Builder response) {
        LinkedHashMap newHeaders = new LinkedHashMap(headers.length);
        for (Header header : headers) {
            response.addHeader(URLFetchServicePb.URLFetchResponse.Header.newBuilder().setKey(header.getName()).setValue(header.getValue()));
        }
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return isOfflineRequest ? 600.0 : 60.0;
    }

    public Integer getMaxApiRequestSize() {
        return 0xA00000;
    }

    private synchronized HttpClient getNonValidatingClient() {
        if (this.nonValidatingClient == null) {
            this.nonValidatingClient = this.createHttpClient(false);
        }
        return this.nonValidatingClient;
    }

    private synchronized HttpClient getValidatingClient() {
        if (this.validatingClient == null) {
            this.validatingClient = this.createHttpClient(true);
        }
        return this.validatingClient;
    }

    private static interface MethodFactory {
        public HttpRequestBase buildMethod(URLFetchServicePb.URLFetchRequest var1);
    }
}

