/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mediautil.gen.Log;
import mediautil.gen.MediaFormat;
import mediautil.gen.MediaInfo;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.AdvancedImage;
import mediautil.image.jpeg.Entry;
import mediautil.image.jpeg.Exif;
import mediautil.image.jpeg.LLJTran;
import mediautil.image.jpeg.LLJTranException;

public class BasicJpeg
extends LLJTran
implements MediaFormat {
    protected AdvancedImage advancedImage;
    public static final String PROGRAMNAME = "LLJTran";
    protected Rectangle rect;
    private Map tables;
    private byte[] markers;
    private byte[] rawDct;
    private String in_comment;

    public BasicJpeg(File file, String enc) {
        super(file);
        if (enc != null) {
            this.setEncoding(enc);
        }
        this.read();
    }

    public BasicJpeg(InputStream inStream) {
        super(inStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(boolean info_only, boolean keep_appxs) {
        int currentRead = this.getReadUpto();
        if (!(currentRead >= 3 || info_only && currentRead >= 1)) {
            int readUpto = 3;
            if (info_only) {
                readUpto = 1;
            }
            if (currentRead > 0 && this.getFile() != null) {
                this.resetInput((InputStream)null);
            }
            try {
                this.read(readUpto, info_only);
            }
            catch (LLJTranException e) {
                if (Log.debugLevel >= 1) {
                    System.err.println("Error Reading Jpeg: " + e.getMessage());
                }
                if (this.inStream != null) {
                    try {
                        this.inStream.close();
                        this.inStream = null;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.closeInternalInputStream();
            }
        }
    }

    protected void read() {
        this.read(true, false);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public InputStream getAsStream() {
        return this.createInputStream();
    }

    public String getParentPath() {
        return this.file == null ? null : this.file.getParent();
    }

    @Override
    public long getFileSize() {
        return this.length();
    }

    public long length() {
        return this.file == null ? -1L : this.file.length();
    }

    @Override
    public URL getUrl() {
        if (this.file == null) {
            return null;
        }
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException me) {
            return null;
        }
    }

    public Date getDateTimeOriginal() {
        return this.file == null ? new Date() : new Date(this.file.lastModified());
    }

    @Override
    public boolean renameTo(File dest) {
        if (this.file == null) {
            return false;
        }
        if (this.file.renameTo(dest)) {
            this.file = dest;
            try {
                this.imageinfo.setName(this.file.getName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public MediaInfo getMediaInfo() {
        return this.getImageInfo();
    }

    @Override
    public String getType() {
        return "JPEG";
    }

    @Override
    public String getThumbnailType() {
        return ((AbstractImageInfo)this.getMediaInfo()).getThumbnailExtension();
    }

    @Override
    public byte[] getThumbnailData(Dimension size) {
        throw new RuntimeException("Method getThumbnailData is not implemented yet");
    }

    public Image getImage() {
        if (this.valid) {
            return Toolkit.getDefaultToolkit().getImage(this.getLocationName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getBufferedImage() throws IOException {
        Iterator<ImageReader> readers;
        if (this.valid && (readers = ImageIO.getImageReadersByFormatName("JPEG")).hasNext()) {
            ImageReader reader = readers.next();
            try (ImageInputStream iis = ImageIO.createImageInputStream(this.getFile());){
                reader.setInput(iis, true);
                BufferedImage bufferedImage = reader.read(0, reader.getDefaultReadParam());
                return bufferedImage;
            }
        }
        return null;
    }

    @Override
    public Icon getThumbnail(Dimension size) {
        return ((AbstractImageInfo)this.getMediaInfo()).getThumbnailIcon(size);
    }

    public void setAdvancedImage(AdvancedImage advancedImage) {
        this.advancedImage = advancedImage;
    }

    public AdvancedImage getAdvancedImage() {
        return this.advancedImage;
    }

    public Icon getIcon() {
        block4: {
            try {
                if (this.valid) {
                    if (this.getAdvancedImage() != null) {
                        return this.getAdvancedImage().createIcon(this.getLocationName());
                    }
                    return new ImageIcon(this.getLocationName());
                }
            }
            catch (Throwable e) {
                if (Log.debugLevel < 1) break block4;
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    @Override
    public void setComment(String comment) {
        this.out_comment = comment;
        if (this.imageinfo != null) {
            this.imageinfo.setAttribute("Comments", this.out_comment);
        }
    }

    protected void transformAppHeader(int op, boolean transformThumbnail) throws IOException {
        if (!(this.imageinfo instanceof Exif)) {
            return;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(2048);
        Exif exif = (Exif)this.imageinfo;
        if (this.artist != null) {
            Entry e = exif.getTagValue(315, true);
            if (e == null) {
                e = new Entry("Camera owner, " + this.artist);
                exif.setTagValue(315, 34665, e, true);
            } else {
                e.setValue(0, "Camera owner, " + this.artist);
            }
        }
        int options = 777;
        if (transformThumbnail) {
            options |= 2;
        }
        super.transformAppHeader(op, options, true);
    }

    @Override
    protected void addMarker(int len, byte markercode) {
        if (this.tables == null) {
            this.tables = new Hashtable();
        }
        if (this.markers == null) {
            this.markers = new byte[1];
        } else {
            byte[] ta = new byte[this.markers.length + 1];
            System.arraycopy(this.markers, 0, ta, 0, this.markers.length);
            this.markers = ta;
        }
        this.markers[this.markers.length - 1] = markercode;
        byte[] marker = new byte[len + 4];
        marker[0] = -1;
        marker[1] = markercode;
        System.arraycopy(this.markerid, 0, marker, 2, 2);
        System.arraycopy(this.data, 0, marker, 4, len);
        this.tables.put("" + markercode, marker);
    }

    void writeUnprocessedMarkers(OutputStream os) throws IOException {
        if (this.tables != null && this.markers != null) {
            for (int i = 0; i < this.markers.length; ++i) {
                byte[] marker = (byte[])this.tables.get("" + this.markers[i]);
                if (marker == null) continue;
                os.write(marker);
            }
        }
    }

    void writeRawDCT(OutputStream os) throws IOException {
        if (this.rawDct != null) {
            os.write(this.rawDct);
        }
    }

    @Override
    void readRawDCT(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((len = is.read(buffer)) > 0) {
            this.readcounter += len;
            os.write(buffer, 0, len);
        }
        this.rawDct = os.toByteArray();
    }

    public boolean transform(String destname, int op) {
        return this.transform(destname, op, false);
    }

    public boolean transform(String destname, int op, boolean preserve_appxs) {
        return this.transform(destname, op, preserve_appxs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(String destname, int op, boolean preserve_appxs, Class custom_appx) {
        if (new File(destname).exists()) {
            if (Log.debugLevel >= 1) {
                System.err.println("File " + destname + " already exists. The operation abandoned.");
            }
        } else {
            OutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(destname), 4096);
                boolean bl = this.transform(os, op, preserve_appxs, custom_appx);
                return bl;
            }
            catch (FileNotFoundException fne) {
                if (Log.debugLevel >= 1) {
                    System.err.println(fne + " in saving of " + this.getName());
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(OutputStream outStream, int op, boolean preserve_appxs, Class custom_appx) {
        int additionalInfo = 512;
        boolean transformThumbnail = false;
        if (preserve_appxs) {
            additionalInfo |= 0x302;
            transformThumbnail = true;
        }
        this.read(false, preserve_appxs);
        try {
            this.transform(outStream, op, additionalInfo, this.rect, this.restart_interval, custom_appx);
        }
        catch (IOException e) {
            if (Log.debugLevel >= 1) {
                System.err.println(e + " in saving of " + this.getName());
            }
            if (Log.debugLevel >= 1) {
                e.printStackTrace(System.err);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.freeMemory();
        }
        return true;
    }

    void save(OutputStream os, int op, Class custom_appx) throws IOException {
        String comment = op == 9 ? this.in_comment : "Mediautil (c) 2005 Dmitriy Rogatkin, Suresh Mahalingam " + (this.out_comment.length() == 0 ? "" : "\n") + this.out_comment;
        if ("".equals(comment)) {
            comment = null;
        }
        this.writeJpeg(os, op, comment, this.appxs_read, custom_appx);
    }

    protected void writeJpeg(OutputStream os, int op, String comment, boolean writeAppxs, Class custom_appx) throws IOException {
        if (op == 8) {
            op = 0;
        }
        int options = 777;
        if (!writeAppxs) {
            options &= 0xFFFFFEFF;
        }
        super.writeJpeg(os, op, comment, options, null, custom_appx, this.restart_interval, false);
        if (!this.canBeProcessed) {
            this.writeUnprocessedMarkers(os);
            this.writeRawDCT(os);
        }
        os.flush();
        os.close();
        os = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMarkers(OutputStream os) throws IOException {
        try {
            this.read(true, true);
            if (os != null) {
                this.writeMarkerAppXs(os);
                os.close();
            }
        }
        finally {
            this.appxs = null;
        }
    }

    @Override
    public void freeMemory() {
        super.freeMemory();
        this.tables = null;
        this.markers = null;
        this.rawDct = null;
    }

    public void setArtist(String val) {
        this.artist = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(Image image, final boolean sizeOnly) {
        Dimension imageSize;
        Dimension dimension = imageSize = new Dimension();
        synchronized (dimension) {
            imageSize.width = image.getWidth(new ImageObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    if (sizeOnly && (infoflags & 3) == 3 || (infoflags & 0x10) == 32 || (infoflags & 0x80) == 128 || (infoflags & 0x40) == 64) {
                        Dimension dimension = imageSize;
                        synchronized (dimension) {
                            imageSize.width = width;
                            imageSize.height = height;
                            imageSize.notify();
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (imageSize.width < 0) {
                try {
                    imageSize.wait(60000L);
                }
                catch (Exception ie) {}
            } else {
                imageSize.height = image.getHeight(null);
            }
        }
        return imageSize;
    }

    public static Image getScaled(Image image, Dimension newSize, int method, double[] stretchFactor) {
        if (stretchFactor == null || stretchFactor.length == 0) {
            stretchFactor = new double[1];
        }
        Dimension scaledSize = BasicJpeg.getScaledSize(image, newSize, stretchFactor);
        if (stretchFactor[0] == 0.0) {
            return image;
        }
        return image.getScaledInstance(scaledSize.width, scaledSize.height, method);
    }

    public static Dimension getScaledSize(Image image, Dimension newSize, double[] stretchFactor) {
        Dimension imageSize = BasicJpeg.getImageSize(image, true);
        if (imageSize.width <= 0 || imageSize.height <= 0) {
            return newSize;
        }
        if (imageSize.width <= newSize.width && imageSize.height <= newSize.height) {
            return imageSize;
        }
        double hScale = (double)newSize.height / (double)imageSize.height;
        double wScale = (double)newSize.width / (double)imageSize.width;
        if (hScale < wScale) {
            wScale = hScale;
        }
        if (stretchFactor != null && stretchFactor.length > 0) {
            stretchFactor[0] = wScale;
        }
        return new Dimension((int)((double)imageSize.width * wScale), (int)((double)imageSize.height * wScale));
    }

    public static void main(String[] args) {
        try {
            System.setErr(new PrintStream(new FileOutputStream("LLJTran.log"), true));
        }
        catch (IOException e) {
            System.err.println("LLJTran: Can't redirect error stream.");
        }
        new BasicJpeg(new File(args[0]), null).transform(args[1], Integer.parseInt(args[2]), true);
    }

    public void setCropRect(Rectangle cr) {
        this.rect = cr;
    }

    public Rectangle getCropRect() {
        if (this.rect == null) {
            return null;
        }
        return (Rectangle)this.rect.clone();
    }
}

