/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;

@VisibleForTesting
public abstract class BaseDatastoreValidator {
    public void validateKind(ValidationConstraint constraint, String kind) throws ValidationException {
        this.validateStringNotEmpty(kind, "kind");
        this.validateStringNotTooLong(kind, 500, "kind");
        if (!constraint.reservedKeyAllowed) {
            this.validateStringNotReserved(kind, "kind");
        }
    }

    void validatePartitionIdDimension(ValidationConstraint constraint, String partitionId, String desc) throws ValidationException {
        this.validateStringNotEmpty(partitionId, desc);
        this.validateStringNotTooLong(partitionId, 100, desc);
        if (!constraint.reservedKeyAllowed) {
            this.validateStringNotReserved(partitionId, desc);
        }
        ValidationException.validateAssertion(DatastoreHelper.PARTITION_ID_REGEX.matcher(partitionId).matches(), "Illegal string \"%s\" in %s.", partitionId, desc);
    }

    public void validateAppName(ValidationConstraint constraint, String appName, String desc) throws ValidationException {
        this.validateStringNotEmpty(appName, desc);
        this.validateStringNotTooLong(appName, 302, desc);
        if (!constraint.reservedKeyAllowed) {
            this.validateStringNotReserved(appName, desc);
        }
        ValidationException.validateAssertion(DatastoreHelper.APP_ID_REGEX.matcher(appName).matches(), "\"%s\" is an invalid %s.", appName, desc);
    }

    public void validatePropertyName(ValidationConstraint constraint, String propertyName) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, "");
    }

    public void validatePropertyName(ValidationConstraint constraint, String propertyName, String desc) throws ValidationException {
        desc = desc.isEmpty() ? "property.name" : desc + ".property.name";
        this.validateStringNotEmpty(propertyName, desc);
        this.validateStringNotTooLong(propertyName, 500, desc);
        if (!constraint.reservedPropertyNameAllowed) {
            this.validateStringVisibleOrNotReserved(propertyName, desc);
        }
    }

    public void validateKeyPathString(ValidationConstraint constraint, String pathElement, String desc) throws ValidationException {
        this.validateStringNotEmpty(pathElement, desc);
        this.validateStringNotTooLong(pathElement, 500, desc);
        if (!constraint.reservedPropertyNameAllowed) {
            this.validateStringNotReserved(pathElement, desc);
        }
    }

    public void validateStringNotReserved(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!DatastoreHelper.RESERVED_NAME.matcher(string).matches(), "The %s \"%s\" is reserved.", desc, string);
    }

    public void validateStringVisibleOrNotReserved(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!DatastoreHelper.RESERVED_NAME.matcher(string).matches() || DatastoreHelper.ALLOWED_RESERVED_NAMES.contains(string), "The %s \"%s\" is reserved.", desc, string);
    }

    public void validateStringNotEmpty(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateStringNotTooLong(String string, int length, String desc) throws ValidationException {
        ValidationException.validateAssertion(string.length() <= length, "The %s is longer than %d characters.", desc, length);
    }

    public void validateStringUtf8(ByteString byteString, String desc) throws ValidationException {
        ValidationException.validateAssertion(byteString.isValidUtf8(), "The %s is not valid UTF-8.", desc);
    }

    public void validateSameApp(String app1, String app2) throws ValidationException {
        Preconditions.checkNotNull((Object)app1);
        Preconditions.checkNotNull((Object)app2);
        ValidationException.validateAssertion(app1.equals(app2), "mismatched app ids within request: " + app1 + " vs. " + app2, new Object[0]);
    }

    public void validateNonNamespacedAppId(String appId) throws ValidationException {
        ValidationException.validateAssertion(appId.indexOf(33) < 0, "appId should not contain namespace separator char '!'", new Object[0]);
    }
}

