/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.RequestStatusUtil;
import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.checkers.DocumentChecker;
import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.ExpressionBuilder;
import com.google.appengine.api.search.dev.FieldGenerator;
import com.google.appengine.api.search.dev.LuceneDirectoryMap;
import com.google.appengine.api.search.dev.LuceneQueryBuilder;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.Scorer;
import com.google.appengine.api.search.dev.SearchException;
import com.google.appengine.api.search.dev.WordSeparatorAnalyzer;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexReader;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.Term;
import com.google.appengine.repackaged.org.apache.lucene.search.IndexSearcher;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.ScoreDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.Sort;
import com.google.appengine.repackaged.org.apache.lucene.search.SortField;
import com.google.appengine.repackaged.org.apache.lucene.search.TermRangeQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocs;
import com.google.appengine.repackaged.org.apache.lucene.store.Directory;
import com.google.appengine.repackaged.org.apache.lucene.util.Version;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.search.DocumentPb;
import com.google.apphosting.utils.config.GenerationDirectory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@ServiceProvider(value=LocalRpcService.class)
public class LocalSearchService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "search";
    public static final String USE_RAM_DIRECTORY = "LocalSearchService.useRamDirectory";
    public static final String USE_DIRECTORY = "LocalSearchService.useDirectory";
    static final Logger LOG = Logger.getLogger(LocalSearchService.class.getCanonicalName());
    public static final String SEARCH_LOG_LEVEL_PROPERTY = "LocalSearchService.LogLevel";
    private static final Level DEFAULT_LOG_LEVEL = Level.INFO;
    private static final Version VERSION = Version.LUCENE_29;
    private static final int PERSIST_VERSION = 0;
    private static final IndexWriter.MaxFieldLength MAX_FIELD_LENGTH = IndexWriter.MaxFieldLength.LIMITED;
    private LuceneDirectoryMap dirMap;
    private final Analyzer analyzer;
    private Map<String, DocumentPb.Document> documentsById;
    private final ReadWriteLock docsMapLock = new ReentrantReadWriteLock();
    private String documentsFile;
    private static Map<Directory, IndexWriter> indexWriters = new HashMap<Directory, IndexWriter>();

    public LocalSearchService() {
        this.analyzer = new WordSeparatorAnalyzer();
        LOG.info("Local search service created");
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String logLevelStr = properties.get(SEARCH_LOG_LEVEL_PROPERTY);
        if (logLevelStr != null) {
            LOG.setLevel(Level.parse(logLevelStr));
        } else {
            LOG.setLevel(DEFAULT_LOG_LEVEL);
        }
        this.documentsById = new LinkedHashMap<String, DocumentPb.Document>();
        if ("true".equals(properties.get(USE_RAM_DIRECTORY))) {
            LOG.warning("Using RAM directory; results are not preserved");
            this.dirMap = new LuceneDirectoryMap.RamBased();
            this.documentsFile = null;
        } else {
            String dirName = properties.get(USE_DIRECTORY);
            File dir = dirName == null ? GenerationDirectory.getGenerationDirectory((File)context.getLocalServerEnvironment().getAppDir()) : new File(dirName);
            File indexDirectory = null;
            dir.mkdirs();
            if (dir.exists()) {
                indexDirectory = new File(dir.getAbsolutePath(), "indexes");
                this.documentsFile = dir.getAbsolutePath() + File.separator + "local_search.bin";
                File documentsFileHandle = new File(this.documentsFile);
                if (!documentsFileHandle.exists()) {
                    LOG.info("The search document storage file does not exist. It will be created.");
                    this.clearIndexes(indexDirectory);
                } else {
                    this.loadDocumentMap(indexDirectory, documentsFileHandle);
                }
                this.dirMap = new LuceneDirectoryMap.FileBased(indexDirectory);
            } else {
                if (LOG.isLoggable(Level.WARNING)) {
                    String message = String.format("Failed to create data directory %s, using RAM directory instead; results are not preserved", dir.getAbsolutePath());
                    LOG.warning(message);
                }
                this.dirMap = new LuceneDirectoryMap.RamBased();
                this.documentsFile = null;
            }
        }
        LOG.info(this.getPackage() + " initialized");
    }

    private void loadDocumentMap(File indexDirectory, File documentsFile) {
        String path = documentsFile.getAbsolutePath();
        try {
            ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path)));
            int readVersion = objectIn.readInt();
            if (readVersion != 0) {
                this.clearIndexes(indexDirectory);
            } else {
                Map documentsOnDisk;
                this.documentsById = documentsOnDisk = (Map)objectIn.readObject();
            }
            objectIn.close();
        }
        catch (FileNotFoundException e) {
            LOG.severe("Failed to find search document storage, " + path);
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Failed to load from search document storage, " + path, e);
            this.clearIndexes(indexDirectory);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.INFO, "Failed to load from search document storage, " + path, e);
            this.clearIndexes(indexDirectory);
        }
    }

    public void start() {
        LOG.info(this.getPackage() + " started");
    }

    private void closeIndexWriters() {
        for (IndexWriter writer : indexWriters.values()) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close index writer", e);
            }
        }
        if (this.dirMap != null) {
            try {
                this.dirMap.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close local directory", e);
            }
        }
    }

    public void stop() {
        this.closeIndexWriters();
        LOG.info(this.getPackage() + " stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchServicePb.IndexDocumentResponse indexDocument(LocalRpcService.Status status, SearchServicePb.IndexDocumentRequest req) {
        IndexWriter indexWriter;
        SearchServicePb.IndexDocumentResponse.Builder respBuilder = SearchServicePb.IndexDocumentResponse.newBuilder();
        SearchServicePb.IndexDocumentParams indexDocumentParams = req.getParams();
        int docsToIndex = indexDocumentParams.getDocumentCount();
        if (this.dirMap == null) {
            LOG.severe("Index documents called before local search service was initialized");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToIndex, SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        String appId = LocalSearchService.getAppId();
        try {
            indexWriter = this.getIndexWriter(this.dirMap.getDirectory(appId, indexDocumentParams.getIndexSpec()), true);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to access index", e);
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToIndex, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
        for (DocumentPb.Document d : indexDocumentParams.getDocumentList()) {
            try {
                DocumentChecker.checkValid((DocumentPb.Document)d);
            }
            catch (IllegalArgumentException e) {
                respBuilder.addStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, (String)e.getMessage()));
                continue;
            }
            String id = d.getId();
            if (Strings.isNullOrEmpty((String)d.getId())) {
                id = UUID.randomUUID().toString();
                d = d.toBuilder().setId(id).build();
                respBuilder.addDocId(id);
            } else {
                respBuilder.addDocId(d.getId());
            }
            Document doc = LuceneUtils.toLuceneDocument(id, d);
            try {
                indexWriter.updateDocument(new Term("_DOCID", id), doc);
            }
            catch (IOException e) {
                respBuilder.addStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR));
                continue;
            }
            try {
                this.docsMapLock.writeLock().lock();
                this.documentsById.put(id, d);
            }
            finally {
                this.docsMapLock.writeLock().unlock();
            }
            respBuilder.addStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK));
        }
        if (LOG.isLoggable(Level.FINE)) {
            try {
                LOG.fine(String.format("Added %d documents. Index %s holds %d documents", indexDocumentParams.getDocumentCount(), indexDocumentParams.getIndexSpec().getName(), indexWriter.numDocs()));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.commitChangesToIndexWriter(indexWriter);
        this.commitChangesToDocumentMap();
        return respBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchServicePb.DeleteDocumentResponse deleteDocument(LocalRpcService.Status status, SearchServicePb.DeleteDocumentRequest req) {
        SearchServicePb.DeleteDocumentResponse.Builder respBuilder = SearchServicePb.DeleteDocumentResponse.newBuilder();
        SearchServicePb.DeleteDocumentParams deleteParams = req.getParams();
        int docsToDelete = deleteParams.getDocIdCount();
        if (this.dirMap == null) {
            LOG.severe("Delete documents called before local search service was initialized");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        if (docsToDelete <= 0) {
            LOG.info("Request to delete 0 documents; ignoring");
            return respBuilder.build();
        }
        String appId = LocalSearchService.getAppId();
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.getIndexWriter(this.dirMap.getDirectory(appId, deleteParams.getIndexSpec()), false);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to access index directory", e);
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
        if (indexWriter == null) {
            LOG.info("Request to delete documents from non-existing index; ignoring");
            return respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.OK, "Not found")).build();
        }
        Term[] deleteTerms = new Term[docsToDelete];
        ArrayList<SearchServicePb.RequestStatus> docStatusList = new ArrayList<SearchServicePb.RequestStatus>();
        for (int i = 0; i < docsToDelete; ++i) {
            DocumentPb.Document previousDoc;
            String docId = deleteParams.getDocId(i);
            deleteTerms[i] = LuceneUtils.newDeleteTerm(docId);
            try {
                this.docsMapLock.writeLock().lock();
                previousDoc = this.documentsById.remove(docId);
            }
            finally {
                this.docsMapLock.writeLock().unlock();
            }
            docStatusList.add(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK, (String)(previousDoc == null ? "Not found" : null)));
        }
        try {
            indexWriter.deleteDocuments(deleteTerms);
            SearchServicePb.DeleteDocumentResponse i = respBuilder.addAllStatus(docStatusList).build();
            return i;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to delete documents", e);
            SearchServicePb.DeleteDocumentResponse deleteDocumentResponse = respBuilder.addAllStatus(LocalSearchService.newRepeatedStatus(docsToDelete, SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
            return deleteDocumentResponse;
        }
        finally {
            this.commitChangesToIndexWriter(indexWriter);
            this.commitChangesToDocumentMap();
        }
    }

    public SearchServicePb.ListIndexesResponse listIndexes(LocalRpcService.Status status, SearchServicePb.ListIndexesRequest req) {
        SearchServicePb.ListIndexesResponse.Builder respBuilder = SearchServicePb.ListIndexesResponse.newBuilder();
        SearchServicePb.RequestStatus requestStatus = RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK);
        if (this.dirMap == null) {
            LOG.severe("List indexes called before local search service was initialized");
            return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        List<SearchServicePb.IndexMetadata.Builder> indexMetadatas = this.dirMap.listIndexes(LocalSearchService.getAppId(), req.getParams());
        long MAX_STORAGE = 0x40000000L;
        for (SearchServicePb.IndexMetadata.Builder builder : indexMetadatas) {
            if (req.getParams().getFetchSchema()) {
                Map<String, Set<DocumentPb.FieldValue.ContentType>> schema = this.getFieldTypes(builder.getIndexSpec());
                for (String fieldName : schema.keySet()) {
                    builder.addField(DocumentPb.FieldTypes.newBuilder().setName(fieldName).addAllType((Iterable)schema.get(fieldName)));
                }
            }
            try {
                long amountUsed = this.addUpStorageUsed(builder.getIndexSpec());
                builder.setStorage(SearchServicePb.IndexMetadata.Storage.newBuilder().setAmountUsed(amountUsed).setLimit(0x40000000L));
            }
            catch (IOException e) {
                requestStatus = RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, (String)e.getMessage());
            }
            respBuilder.addIndexMetadata(builder);
        }
        return respBuilder.setStatus(requestStatus).build();
    }

    private long addUpStorageUsed(SearchServicePb.IndexSpec indexSpec) throws IOException {
        long amount = 0L;
        for (DocumentPb.Document docIdDoc : this.getDocuments(indexSpec, "", true, Integer.MAX_VALUE)) {
            DocumentPb.Document doc = this.getFullDoc(docIdDoc);
            for (DocumentPb.Field field : doc.getFieldList()) {
                amount += (long)field.getSerializedSize();
            }
            amount += (long)docIdDoc.getId().getBytes("UTF-8").length;
        }
        return amount;
    }

    private Iterable<DocumentPb.Document> getDocuments(SearchServicePb.IndexSpec indexSpec, String start, boolean includeStart, int limit) throws IOException {
        Directory directory = this.dirMap.getDirectory(LocalSearchService.getAppId(), indexSpec);
        final IndexSearcher indexSearcher = new IndexSearcher(directory, true);
        TopFieldDocs topDocs = indexSearcher.search(new TermRangeQuery("_DOCID", start, Character.toString('\u007f'), includeStart, true), null, limit, new Sort(new SortField("_DOCID", 11)));
        final ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        return new Iterable<DocumentPb.Document>(){

            @Override
            public Iterator<DocumentPb.Document> iterator() {
                return new Iterator<DocumentPb.Document>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < scoreDocs.length;
                    }

                    @Override
                    public DocumentPb.Document next() {
                        ScoreDoc scoreDoc = scoreDocs[this.index++];
                        try {
                            return LuceneUtils.toAppengineDocumentId(indexSearcher.doc(scoreDoc.doc));
                        }
                        catch (IOException e) {
                            LOG.log(Level.SEVERE, e.getMessage(), e);
                            throw new SearchException(e.toString());
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private DocumentPb.Document getFullDoc(DocumentPb.Document docWithId) {
        this.docsMapLock.readLock().lock();
        try {
            DocumentPb.Document document = this.documentsById.get(docWithId.getId());
            return document;
        }
        finally {
            this.docsMapLock.readLock().unlock();
        }
    }

    public SearchServicePb.ListDocumentsResponse listDocuments(LocalRpcService.Status status, SearchServicePb.ListDocumentsRequest req) {
        SearchServicePb.ListDocumentsResponse.Builder respBuilder = SearchServicePb.ListDocumentsResponse.newBuilder();
        if (this.dirMap == null) {
            LOG.severe("listDocuments called before local search service was initialized");
            return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST)).build();
        }
        SearchServicePb.ListDocumentsParams params = req.getParams();
        try {
            Iterable<DocumentPb.Document> docs = this.getDocuments(params.getIndexSpec(), params.getStartDocId(), params.getIncludeStartDoc(), params.getLimit());
            for (DocumentPb.Document docWithId : docs) {
                if (params.getKeysOnly()) {
                    respBuilder.addDocument(docWithId);
                    continue;
                }
                respBuilder.addDocument(this.getFullDoc(docWithId));
            }
            respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK));
            return respBuilder.build();
        }
        catch (FileNotFoundException e) {
            LOG.info("List request for empty or non-existing index; ignoring");
            return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK)).build();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to list documents", e);
            return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchServicePb.SearchResponse search(LocalRpcService.Status status, SearchServicePb.SearchRequest req) {
        SearchServicePb.SearchResponse searchResponse;
        SearchServicePb.SearchResponse.Builder respBuilder = SearchServicePb.SearchResponse.newBuilder();
        if (this.dirMap == null) {
            LOG.severe("Search called before local search service was initialized");
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, respBuilder);
        }
        SearchServicePb.SearchParams searchParams = req.getParams();
        IndexSearcher indexSearcher = null;
        Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes = null;
        try {
            String appId = LocalSearchService.getAppId();
            Directory directory = this.dirMap.getDirectory(appId, searchParams.getIndexSpec());
            if (IndexReader.indexExists(directory)) {
                fieldTypes = this.getFieldTypes(searchParams.getIndexSpec());
                indexSearcher = new IndexSearcher(directory, true);
                indexSearcher.setDefaultFieldSortScoring(true, false);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to access index", e);
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, respBuilder);
        }
        if (indexSearcher == null) {
            LOG.info("Search on an empty or non-existing index; ignoring");
            String message = String.format("Index '%s' in namespace '%s' does not exist", searchParams.getIndexSpec().getName(), searchParams.getIndexSpec().getNamespace());
            return this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.OK, message, respBuilder);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Index %s holds %d documents", searchParams.getIndexSpec().getName(), indexSearcher.getIndexReader().numDocs()));
        }
        try {
            int offset;
            Query q = new LuceneQueryBuilder(fieldTypes).parse(searchParams.getQuery());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Query " + searchParams.getQuery() + " translated to " + q);
            }
            if ((offset = LocalSearchService.getOffset(searchParams)) == -1) {
                SearchServicePb.SearchResponse searchResponse2 = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, respBuilder);
                return searchResponse2;
            }
            List<FieldGenerator> fieldGenerators = LocalSearchService.createFieldGenerators(searchParams, fieldTypes);
            Scorer scorer = Scorer.newInstance(searchParams, fieldTypes);
            Set<String> fieldFilter = LocalSearchService.createFilter(searchParams);
            int limit = searchParams.getLimit();
            Scorer.SearchResults results = scorer.search(indexSearcher, q, offset, limit);
            DocumentPb.FieldValue defaultExpressionValue = Expression.makeValue(DocumentPb.FieldValue.ContentType.HTML, "");
            int docIndex = offset;
            for (Scorer.Result result : results.results) {
                DocumentPb.Document fullDoc;
                SearchServicePb.SearchResult.Builder resultBuilder = SearchServicePb.SearchResult.newBuilder();
                String docId = LuceneUtils.toAppengineDocumentId(result.doc).getId();
                try {
                    this.docsMapLock.readLock().lock();
                    fullDoc = this.documentsById.get(docId);
                }
                finally {
                    this.docsMapLock.readLock().unlock();
                }
                if (fullDoc == null) {
                    LOG.severe("No document found with ID " + docId);
                    continue;
                }
                fullDoc = fullDoc.toBuilder().build();
                for (FieldGenerator fieldGenerator : fieldGenerators) {
                    DocumentPb.FieldValue fieldValue = defaultExpressionValue;
                    try {
                        fieldValue = fieldGenerator.getExpression().eval(result.doc);
                    }
                    catch (EvaluationException e) {
                        // empty catch block
                    }
                    resultBuilder.addExpression(DocumentPb.Field.newBuilder().setName(fieldGenerator.getName()).setValue(fieldValue));
                }
                if (req.getParams().hasScorerSpec()) {
                    result.addScores(resultBuilder);
                }
                resultBuilder.setDocument(LocalSearchService.filterDocument(fullDoc, searchParams.getKeysOnly(), fieldFilter));
                if (SearchServicePb.SearchParams.CursorType.PER_RESULT.equals((Object)searchParams.getCursorType())) {
                    resultBuilder.setCursor(Integer.toString(docIndex + 1));
                }
                respBuilder.addResult(resultBuilder);
                ++docIndex;
            }
            respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)SearchServicePb.SearchServiceError.ErrorCode.OK)).setMatchedCount((long)results.totalHits);
            if (SearchServicePb.SearchParams.CursorType.SINGLE.equals((Object)searchParams.getCursorType()) && results.totalHits - offset > limit) {
                respBuilder.setCursor(Integer.toString(offset + limit));
            }
            SearchServicePb.SearchResponse searchResponse3 = respBuilder.build();
            return searchResponse3;
        }
        catch (SearchException e) {
            LOG.log(Level.SEVERE, "Failed to execute search", e);
            searchResponse = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, e.getMessage(), respBuilder);
            return searchResponse;
        }
        catch (SearchQueryException e) {
            LOG.log(Level.SEVERE, "Failed to parse query", e);
            searchResponse = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INVALID_REQUEST, String.format("%s in query '%s'", e.getMessage(), searchParams.getQuery()), respBuilder);
            return searchResponse;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to execute search", e);
            searchResponse = this.replyWith(SearchServicePb.SearchServiceError.ErrorCode.INTERNAL_ERROR, respBuilder);
            return searchResponse;
        }
        finally {
            LocalSearchService.closeIndexSearcher(indexSearcher);
        }
    }

    private SearchServicePb.SearchResponse replyWith(SearchServicePb.SearchServiceError.ErrorCode code, SearchServicePb.SearchResponse.Builder respBuilder) {
        return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)code)).setMatchedCount(0L).build();
    }

    private SearchServicePb.SearchResponse replyWith(SearchServicePb.SearchServiceError.ErrorCode code, String message, SearchServicePb.SearchResponse.Builder respBuilder) {
        return respBuilder.setStatus(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)code, (String)message)).setMatchedCount(0L).build();
    }

    private static void closeIndexSearcher(IndexSearcher indexSearcher) {
        if (indexSearcher != null) {
            try {
                indexSearcher.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close index searcher", e);
            }
        }
    }

    private Map<String, Set<DocumentPb.FieldValue.ContentType>> getFieldTypes(SearchServicePb.IndexSpec indexSpec) {
        TreeMap<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes = new TreeMap<String, Set<DocumentPb.FieldValue.ContentType>>();
        LocalRpcService.Status status = new LocalRpcService.Status();
        SearchServicePb.ListDocumentsRequest.Builder req = SearchServicePb.ListDocumentsRequest.newBuilder();
        req.getParamsBuilder().setIndexSpec(indexSpec);
        SearchServicePb.ListDocumentsResponse resp = this.listDocuments(status, req.build());
        for (DocumentPb.Document document : resp.getDocumentList()) {
            for (DocumentPb.Field field : document.getFieldList()) {
                LinkedHashSet<DocumentPb.FieldValue.ContentType> types = (LinkedHashSet<DocumentPb.FieldValue.ContentType>)fieldTypes.get(field.getName());
                if (types == null) {
                    types = new LinkedHashSet<DocumentPb.FieldValue.ContentType>();
                    fieldTypes.put(field.getName(), types);
                }
                types.add(field.getValue().getType());
            }
        }
        return fieldTypes;
    }

    private static List<SearchServicePb.RequestStatus> newRepeatedStatus(int count, SearchServicePb.SearchServiceError.ErrorCode errorCode) {
        ArrayList<SearchServicePb.RequestStatus> statusList = new ArrayList<SearchServicePb.RequestStatus>();
        for (int i = 0; i < count; ++i) {
            statusList.add(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)errorCode));
        }
        return statusList;
    }

    private static List<SearchServicePb.RequestStatus> newRepeatedStatus(int count, SearchServicePb.SearchServiceError.ErrorCode errorCode, String errorDetail) {
        ArrayList<SearchServicePb.RequestStatus> statusList = new ArrayList<SearchServicePb.RequestStatus>();
        for (int i = 0; i < count; ++i) {
            statusList.add(RequestStatusUtil.newStatus((SearchServicePb.SearchServiceError.ErrorCode)errorCode, (String)errorDetail));
        }
        return statusList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter(Directory directory, boolean createIfNotPresent) throws IOException {
        Map<Directory, IndexWriter> map = indexWriters;
        synchronized (map) {
            IndexWriter writer = indexWriters.get(directory);
            if (writer != null) {
                return writer;
            }
            if (IndexReader.indexExists(directory)) {
                writer = new IndexWriter(directory, this.analyzer, false, MAX_FIELD_LENGTH);
            } else {
                if (!createIfNotPresent) {
                    return null;
                }
                writer = new IndexWriter(directory, this.analyzer, true, MAX_FIELD_LENGTH);
            }
            indexWriters.put(directory, writer);
            return writer;
        }
    }

    private void recursiveDelete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.recursiveDelete(f);
            }
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete file " + file);
        }
    }

    private void clearIndexes(final File indexDirectory) {
        if (indexDirectory == null) {
            this.dirMap = new LuceneDirectoryMap.RamBased();
        } else {
            this.closeIndexWriters();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        if (indexDirectory.exists()) {
                            LocalSearchService.this.recursiveDelete(indexDirectory);
                        }
                        indexDirectory.mkdirs();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
            this.dirMap = new LuceneDirectoryMap.FileBased(indexDirectory);
        }
    }

    private void commitChangesToIndexWriter(IndexWriter indexWriter) {
        if (indexWriter != null) {
            try {
                indexWriter.commit();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to commit changes to an index", e);
            }
        }
    }

    private void commitChangesToDocumentMap() {
        if (this.documentsFile != null) {
            try {
                ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.documentsFile)));
                objectOut.writeInt(0);
                try {
                    this.docsMapLock.readLock().lock();
                    objectOut.writeObject(this.documentsById);
                }
                finally {
                    this.docsMapLock.readLock().unlock();
                }
                objectOut.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to commit changes to search document storage", e);
            }
        }
    }

    private static int getOffset(SearchServicePb.SearchParams searchParams) {
        if (searchParams.hasOffset() && searchParams.hasCursor()) {
            LOG.severe("Both offset and cursor are set");
            return -1;
        }
        if (searchParams.hasOffset()) {
            return searchParams.getOffset();
        }
        if (!searchParams.hasCursor()) {
            return 0;
        }
        try {
            return Integer.parseInt(searchParams.getCursor());
        }
        catch (NumberFormatException e) {
            LOG.log(Level.SEVERE, "Invalid cursor value: " + searchParams.getCursor(), e);
            return -1;
        }
    }

    private static Set<String> createFilter(SearchServicePb.SearchParams searchParams) {
        if (searchParams.getKeysOnly()) {
            return new HashSet<String>();
        }
        if (searchParams.getFieldSpec().getNameList().isEmpty()) {
            return null;
        }
        return new HashSet<String>((Collection<String>)searchParams.getFieldSpec().getNameList());
    }

    private static DocumentPb.Document filterDocument(DocumentPb.Document fullDoc, boolean keysOnly, Set<String> fieldFilter) {
        DocumentPb.Document.Builder docBuilder = DocumentPb.Document.newBuilder();
        docBuilder.setId(fullDoc.getId());
        if (!keysOnly) {
            for (DocumentPb.Field field : fullDoc.getFieldList()) {
                if (fieldFilter != null && !fieldFilter.contains(field.getName())) continue;
                docBuilder.addField(field);
            }
            docBuilder.setOrderId(fullDoc.getOrderId());
            if (fullDoc.hasLanguage()) {
                docBuilder.setLanguage(fullDoc.getLanguage());
            }
        }
        return docBuilder.build();
    }

    private static List<FieldGenerator> createFieldGenerators(SearchServicePb.SearchParams searchParams, Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        ExpressionBuilder exprBuilder = new ExpressionBuilder(fieldTypes);
        ArrayList<FieldGenerator> fieldGenerators = new ArrayList<FieldGenerator>();
        for (SearchServicePb.FieldSpec.Expression exprSpec : searchParams.getFieldSpec().getExpressionList()) {
            Expression expr = null;
            try {
                expr = exprBuilder.parse(exprSpec.getExpression());
            }
            catch (IllegalArgumentException e) {
                String errorMessage = String.format("Failed to parse field '%s': %s", exprSpec.getExpression(), e.getMessage());
                throw new SearchException(errorMessage);
            }
            fieldGenerators.add(new FieldGenerator(exprSpec.getName(), expr));
        }
        return fieldGenerators;
    }

    private static String getAppId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            LOG.severe("Unable to retrieve information about the calling application. Aborting!");
            throw new ApiProxy.ApiProxyException("Failed to access application environment");
        }
        String appId = environment.getAppId();
        if (appId == null) {
            LOG.severe("Unable to read application ID. Aborting!");
            throw new ApiProxy.ApplicationException(3, "Failed to retrieve application ID");
        }
        return appId;
    }
}

