/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.dev.BlobstoreFile;
import com.google.appengine.api.files.dev.GSFile;
import com.google.appengine.api.files.dev.LocalFileService;
import com.google.appengine.api.files.dev.ParsedFileName;
import com.google.appengine.api.files.dev.Session;
import com.google.appengine.repackaged.com.google.common.base.StringUtil;
import com.google.appengine.repackaged.com.google.common.io.Closeables;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.api.ApiProxy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FileMetadata {
    private static final Logger logger = Logger.getLogger(FileMetadata.class.getName());
    protected FileServicePb.FileContentType.ContentType contentType;
    protected boolean finalized = false;
    protected final String readName;
    protected final String appendName;
    private Session lockOwner;
    private Map<String, OpenState> sessionToStateMap = new ConcurrentHashMap<String, OpenState>(10);
    protected String currentSequenceKey;
    protected ByteArrayOutputStream tempBytes = new ByteArrayOutputStream();
    protected int tempBytesSizeWhenFinalized = 0;
    private static final int BUF_SIZE = 4096;

    protected final int getTempBytesSize() {
        return this.finalized ? this.tempBytesSizeWhenFinalized : this.tempBytes.size();
    }

    public FileMetadata(String readName, String appendName, FileServicePb.FileContentType.ContentType contentType) {
        this.readName = readName;
        this.appendName = appendName;
        this.contentType = contentType;
    }

    public String getAppendName() {
        return this.appendName;
    }

    public void setFinalized() {
        this.finalized = true;
        try {
            boolean swallowDueToThrow = true;
            OutputStream outStream = this.getOutputStream();
            try {
                this.tempBytes.writeTo(outStream);
                swallowDueToThrow = false;
            }
            finally {
                Closeables.close((Closeable)outStream, (boolean)swallowDueToThrow);
            }
            this.tempBytesSizeWhenFinalized = this.tempBytes.size();
            this.tempBytes = null;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Caught IOException while attempting to write blob", e);
            throw new ApiProxy.ApplicationException(7, e.getMessage());
        }
    }

    public abstract BlobInfo getBlobInfo();

    public boolean isFinalized() {
        return this.finalized;
    }

    public FileServicePb.FileContentType.ContentType getContentType() {
        return this.contentType;
    }

    public void lock(Session session) {
        this.lockOwner = session;
    }

    public LockState getLockState(Session session) {
        if (null == this.lockOwner) {
            return LockState.UNLOCKED;
        }
        if (this.lockOwner == session) {
            return LockState.LOCKED_IN_CURRENT_SESSION;
        }
        return LockState.LOCKED_IN_OTHER_SESSION;
    }

    public void setState(OpenState state, Session session) {
        if (OpenState.CLOSED == state) {
            this.sessionToStateMap.remove(session.getID());
            if (session == this.lockOwner) {
                this.lockOwner = null;
            }
        } else {
            this.sessionToStateMap.put(session.getID(), state);
        }
    }

    public OpenState getOpenState(Session session) {
        OpenState state = this.sessionToStateMap.get(session.getID());
        if (null == state) {
            state = OpenState.CLOSED;
        }
        return state;
    }

    public boolean isOpenInDifferentSession(Session session) {
        int size = this.sessionToStateMap.size();
        if (size > 1) {
            return true;
        }
        if (0 == size) {
            return false;
        }
        return null == this.sessionToStateMap.get(session.getID());
    }

    public ByteString read(FileServicePb.ReadRequest request) {
        try {
            InputStream input = this.getInputStream();
            input.skip(request.getPos());
            ByteString.Output output = ByteString.newOutput();
            FileMetadata.copy(input, (OutputStream)output, request.getMaxBytes());
            input.close();
            return output.toByteString();
        }
        catch (FileNotFoundException e) {
            throw new ApiProxy.ApplicationException(100, e.getMessage());
        }
        catch (IOException e) {
            throw new ApiProxy.ApplicationException(7, e.getMessage());
        }
    }

    public void append(FileServicePb.AppendRequest request) {
        String sequenceKey = StringUtil.toNullIfEmptyOrWhitespace((String)request.getSequenceKey());
        if (null != this.currentSequenceKey && null != sequenceKey && sequenceKey.compareTo(this.currentSequenceKey) <= 0) {
            throw new ApiProxy.ApplicationException(300, this.currentSequenceKey);
        }
        this.currentSequenceKey = sequenceKey;
        try {
            this.tempBytes.write(request.getData().toByteArray());
        }
        catch (IOException e) {
            throw new ApiProxy.ApplicationException(7, e.getMessage());
        }
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    protected static void checkParameters(Map<String, String> parameters, String ... names) {
        for (String name : parameters.keySet()) {
            boolean unknown = true;
            for (String match : names) {
                if (!match.equals(name)) continue;
                unknown = false;
                parameters.put(name, parameters.get(name));
                break;
            }
            if (!unknown) continue;
            String string = String.valueOf(String.valueOf(name));
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.INVALID_PARAMETER, new StringBuilder(27 + string.length()).append("Parameter ").append(string).append(" is not supported").toString());
        }
    }

    protected static long copy(InputStream from, OutputStream to, long maxBytes) throws IOException {
        int r;
        int batchSize;
        byte[] buf = new byte[4096];
        long totalCopied = 0L;
        while ((batchSize = Math.min((int)(maxBytes - totalCopied), 4096)) >= 1 && (r = from.read(buf, 0, batchSize)) != -1) {
            to.write(buf, 0, r);
            totalCopied += (long)r;
        }
        return totalCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBlobInfo(DatastoreService datastore, BlobKey blobKey, String entityKind, String mimeType, long currentTime, String fileName, String creationHandle) {
        BlobInfo blobInfo = new BlobInfo(blobKey, mimeType, new Date(currentTime), fileName, (long)this.getTempBytesSize());
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            String blobKeyString = blobInfo.getBlobKey().getKeyString();
            Entity blobInfoEntity = new Entity(entityKind, blobKeyString);
            blobInfoEntity.setProperty("content_type", (Object)blobInfo.getContentType());
            blobInfoEntity.setProperty("creation", (Object)blobInfo.getCreation());
            blobInfoEntity.setProperty("filename", (Object)blobInfo.getFilename());
            blobInfoEntity.setProperty("size", (Object)blobInfo.getSize());
            datastore.put(blobInfoEntity);
            if (creationHandle != null) {
                Entity fileIndexEntity = new Entity("__BlobFileIndex__", creationHandle);
                fileIndexEntity.setProperty("blob_key", (Object)blobKeyString);
                datastore.put(fileIndexEntity);
            }
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }

    public static FileMetadata newReadableInstance(LocalFileService localFileService, Clock clock, ParsedFileName parsedName) {
        String fileSystem = parsedName.getFileSystem();
        if (BlobstoreFile.FILE_SYSTEM.equals(fileSystem)) {
            return BlobstoreFile.newFinalizedInstance(localFileService, clock, parsedName);
        }
        if (GSFile.FILE_SYSTEM.equals(fileSystem)) {
            return GSFile.newFinalizedInstance(localFileService, clock, parsedName);
        }
        throw new ApiProxy.ApplicationException(5);
    }

    public static enum LockState {
        LOCKED_IN_CURRENT_SESSION,
        LOCKED_IN_OTHER_SESSION,
        UNLOCKED;

    }

    public static enum OpenState {
        OPENED_FOR_READ,
        OPENED_FOR_APPEND,
        CLOSED;

    }
}

