/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.dev.BlobstoreFile;
import com.google.appengine.api.files.dev.FileMetadata;
import com.google.appengine.api.files.dev.GSFile;
import com.google.appengine.api.files.dev.ParsedFileName;
import com.google.appengine.api.files.dev.Session;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.RequestEndListener;
import com.google.appengine.tools.development.RequestEndListenerHelper;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@ServiceProvider(value=LocalRpcService.class)
public class LocalFileService
extends AbstractLocalRpcService
implements RequestEndListener {
    private static final Logger logger = Logger.getLogger(LocalFileService.class.getName());
    public static final String PACKAGE = "file";
    private Map<String, FileMetadata> fileMap;
    private Map<String, Session> openSessions;
    private SecureRandom secureRandom;
    private BlobStorage blobStorage;
    private DatastoreService datastoreService;
    private BlobstoreService blobstoreService;
    private Clock clock;

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.initializeState();
        context.getLocalService("blobstore");
        this.blobStorage = BlobStorageFactory.getBlobStorage();
        this.datastoreService = DatastoreServiceFactory.getDatastoreService();
        this.blobstoreService = BlobstoreServiceFactory.getBlobstoreService();
        this.clock = context.getClock();
    }

    @VisibleForTesting
    void initializeState() {
        this.secureRandom = new SecureRandom();
        this.fileMap = new ConcurrentHashMap<String, FileMetadata>(10);
        this.openSessions = new ConcurrentHashMap<String, Session>(10);
    }

    public void start() {
    }

    public void stop() {
    }

    private static String getRequestID(ApiProxy.Environment environment) {
        String requestID = (String)environment.getAttributes().get("com.google.appengine.runtime.request_log_id");
        if (null == requestID) {
            requestID = "null";
        }
        return requestID;
    }

    private Session getCurrentSession() {
        String sessionID = LocalFileService.getRequestID(ApiProxy.getCurrentEnvironment());
        Session session = this.openSessions.get(sessionID);
        if (null == session) {
            session = new Session(sessionID);
            this.openSessions.put(sessionID, session);
        }
        return session;
    }

    public void onRequestEnd(ApiProxy.Environment environment) {
        String requestID = LocalFileService.getRequestID(environment);
        Session session = this.openSessions.remove(requestID);
        if (null == session) {
            logger.log(Level.WARNING, "No session object found during request-end handling.");
            return;
        }
        Set<FileMetadata> openFiles = session.getOpenFileSet();
        for (FileMetadata file : openFiles) {
            file.setState(FileMetadata.OpenState.CLOSED, session);
        }
    }

    BlobStorage getBlobStorage() {
        return this.blobStorage;
    }

    DatastoreService getDatastore() {
        return this.datastoreService;
    }

    BlobstoreService getBlobstore() {
        return this.blobstoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String nextRandomString() {
        byte[] bytes = new byte[16];
        SecureRandom secureRandom = this.secureRandom;
        synchronized (secureRandom) {
            this.secureRandom.nextBytes(bytes);
        }
        return BaseEncoding.base64Url().omitPadding().encode(bytes);
    }

    void registerNewFile(String fileName, FileMetadata metadata) {
        this.fileMap.put(fileName, metadata);
    }

    FileMetadata getFile(String fileName) {
        return this.fileMap.get(fileName);
    }

    private void checkName(String fileName) {
        if (null == fileName || fileName.isEmpty()) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.INVALID_FILE_NAME, fileName);
        }
    }

    static RuntimeException throwError(FileServicePb.FileServiceErrors.ErrorCode errorCode, String message) {
        throw new ApiProxy.ApplicationException(errorCode.getNumber(), message);
    }

    public FileServicePb.CreateResponse create(LocalRpcService.Status status, FileServicePb.CreateRequest request) {
        FileMetadata created;
        String fileSystem;
        FileServicePb.FileContentType.ContentType contentType = request.getContentType();
        if (FileServicePb.FileContentType.ContentType.RAW != contentType) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.WRONG_CONTENT_TYPE, "Only RAW supported currently");
        }
        if (BlobstoreFile.FILE_SYSTEM.equals(fileSystem = request.getFilesystem())) {
            created = BlobstoreFile.create(this, this.clock, request.getFilename(), this.nextRandomString(), contentType, LocalFileService.getParameters(request));
        } else if (GSFile.FILE_SYSTEM.equals(fileSystem)) {
            created = GSFile.create(this, this.clock, request.getFilename(), this.nextRandomString(), contentType, LocalFileService.getParameters(request));
        } else {
            throw LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.UNSUPPORTED_FILE_SYSTEM, "Only blobstore and gs supported currently");
        }
        this.registerNewFile(created.getAppendName(), created);
        return FileServicePb.CreateResponse.newBuilder().setFilename(created.getAppendName()).build();
    }

    private static Map<String, String> getParameters(FileServicePb.CreateRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (FileServicePb.CreateRequest.Parameter p : request.getParametersList()) {
            parameters.put(p.getName(), p.getValue());
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileServicePb.OpenResponse open(LocalRpcService.Status status, FileServicePb.OpenRequest request) {
        Object object;
        ParsedFileName parsedName;
        FileMetadata metadata;
        RequestEndListenerHelper.register((RequestEndListener)this);
        Session session = this.getCurrentSession();
        String fileName = request.getFilename();
        this.checkName(fileName);
        String string = String.valueOf(fileName);
        logger.finest(string.length() != 0 ? "LocalFileService.open: ".concat(string) : new String("LocalFileService.open: "));
        FileServicePb.OpenRequest.OpenMode openMode = request.getOpenMode();
        FileServicePb.FileContentType.ContentType requestContentType = request.getContentType();
        if (FileServicePb.FileContentType.ContentType.RAW != requestContentType) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.WRONG_CONTENT_TYPE, "Only RAW supported currently");
        }
        if ((metadata = this.fileMap.get(fileName)) == null && openMode == FileServicePb.OpenRequest.OpenMode.READ && (metadata = FileMetadata.newReadableInstance(this, this.clock, parsedName = new ParsedFileName(fileName))) != null) {
            metadata.contentType = requestContentType;
            this.registerNewFile(fileName, metadata);
        }
        if (metadata == null) {
            String string2 = String.valueOf(fileName);
            throw LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.EXISTENCE_ERROR, string2.length() != 0 ? "No such file ".concat(string2) : new String("No such file "));
        }
        FileServicePb.FileContentType.ContentType fileContentType = metadata.getContentType();
        if (requestContentType != fileContentType) {
            object = String.valueOf(String.valueOf(fileContentType));
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.WRONG_CONTENT_TYPE, new StringBuilder(23 + ((String)object).length()).append("content-type should be ").append((String)object).toString());
        }
        object = metadata;
        synchronized (object) {
            FileMetadata.LockState lockState = metadata.getLockState(session);
            if (FileMetadata.LockState.LOCKED_IN_OTHER_SESSION == lockState) {
                LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.EXCLUSIVE_LOCK_FAILED, String.valueOf(fileName).concat(" is locked in another session."));
            }
            if (request.getExclusiveLock()) {
                if (metadata.isOpenInDifferentSession(session)) {
                    LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.EXCLUSIVE_LOCK_FAILED, String.valueOf(fileName).concat(" is opened in another session."));
                }
                metadata.lock(session);
            }
            switch (openMode) {
                case READ: {
                    if (!metadata.isFinalized()) {
                        LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FINALIZATION_ERROR, String.valueOf(fileName).concat(" is not yet finalized"));
                    }
                    metadata.setState(FileMetadata.OpenState.OPENED_FOR_READ, session);
                    break;
                }
                case APPEND: {
                    if (metadata.isFinalized()) {
                        LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FINALIZATION_ERROR, String.valueOf(fileName).concat(" is already finalized"));
                    }
                    metadata.setState(FileMetadata.OpenState.OPENED_FOR_APPEND, session);
                    break;
                }
                default: {
                    String string3 = String.valueOf(String.valueOf(openMode));
                    throw new RuntimeException(new StringBuilder(21 + string3.length()).append("Unexpected openMode: ").append(string3).toString());
                }
            }
        }
        session.getOpenFileSet().add(metadata);
        FileServicePb.OpenResponse.Builder openResponse = FileServicePb.OpenResponse.newBuilder();
        return openResponse.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileServicePb.CloseResponse close(LocalRpcService.Status status, FileServicePb.CloseRequest request) {
        Session session = this.getCurrentSession();
        String fileName = request.getFilename();
        this.checkName(fileName);
        boolean finalize = request.getFinalize();
        FileMetadata metadata = this.fileMap.get(fileName);
        if (null == metadata) {
            throw LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NOT_OPENED, fileName);
        }
        FileMetadata fileMetadata = metadata;
        synchronized (fileMetadata) {
            if (FileMetadata.OpenState.CLOSED == metadata.getOpenState(session)) {
                LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NOT_OPENED, fileName);
            }
            if (finalize) {
                if (FileMetadata.LockState.LOCKED_IN_CURRENT_SESSION != metadata.getLockState(session)) {
                    LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.EXCLUSIVE_LOCK_REQUIRED, fileName);
                }
                metadata.setFinalized();
            }
            metadata.setState(FileMetadata.OpenState.CLOSED, session);
        }
        FileServicePb.CloseResponse.Builder closeResponse = FileServicePb.CloseResponse.newBuilder();
        return closeResponse.build();
    }

    public FileServicePb.AppendResponse append(LocalRpcService.Status status, FileServicePb.AppendRequest request) {
        Session session = this.getCurrentSession();
        String fileName = request.getFilename();
        this.checkName(fileName);
        FileMetadata metadata = this.fileMap.get(fileName);
        if (null == metadata) {
            throw LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NOT_OPENED, fileName);
        }
        FileMetadata.OpenState openState = metadata.getOpenState(session);
        if (openState == FileMetadata.OpenState.CLOSED) {
            String string = String.valueOf(fileName);
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NOT_OPENED, string.length() != 0 ? "File not opened: ".concat(string) : new String("File not opened: "));
        }
        if (openState != FileMetadata.OpenState.OPENED_FOR_APPEND) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.WRONG_OPEN_MODE, openState.toString());
        }
        metadata.append(request);
        FileServicePb.AppendResponse.Builder appendResponse = FileServicePb.AppendResponse.newBuilder();
        return appendResponse.build();
    }

    public FileServicePb.ReadResponse read(LocalRpcService.Status status, FileServicePb.ReadRequest request) {
        Session session = this.getCurrentSession();
        String fileName = request.getFilename();
        this.checkName(fileName);
        FileMetadata metadata = this.fileMap.get(fileName);
        if (null == metadata) {
            throw LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NOT_OPENED, fileName);
        }
        FileMetadata.OpenState openState = metadata.getOpenState(session);
        if (FileMetadata.OpenState.CLOSED == openState) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NOT_OPENED, fileName);
        }
        if (FileMetadata.OpenState.OPENED_FOR_READ != openState) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.WRONG_OPEN_MODE, openState.toString());
        }
        ByteString data = metadata.read(request);
        FileServicePb.ReadResponse.Builder readResponse = FileServicePb.ReadResponse.newBuilder();
        readResponse.setData(data);
        return readResponse.build();
    }

    public FileServicePb.StatResponse stat(LocalRpcService.Status status, FileServicePb.StatRequest request) {
        Session session = this.getCurrentSession();
        String fileName = request.getFilename();
        this.checkName(fileName);
        FileMetadata metadata = this.fileMap.get(fileName);
        if (null == metadata) {
            throw LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NOT_OPENED, fileName);
        }
        FileMetadata.OpenState openState = metadata.getOpenState(session);
        if (FileMetadata.OpenState.CLOSED == openState) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NOT_OPENED, fileName);
        }
        if (FileMetadata.OpenState.OPENED_FOR_READ != openState) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.WRONG_OPEN_MODE, openState.toString());
        }
        BlobInfo blobInfo = metadata.getBlobInfo();
        FileServicePb.StatResponse.Builder statResponseBuilder = FileServicePb.StatResponse.newBuilder();
        FileServicePb.FileStat.Builder fileStatBuilder = FileServicePb.FileStat.newBuilder().setFilename(fileName).setContentType(metadata.getContentType()).setCtime(blobInfo.getCreation().getTime()).setMtime(blobInfo.getCreation().getTime()).setFinalized(metadata.isFinalized());
        fileStatBuilder.setLength(blobInfo.getSize());
        statResponseBuilder.addStat(fileStatBuilder.build()).setMoreFilesFound(false);
        return statResponseBuilder.build();
    }

    public FileServicePb.GetCapabilitiesResponse getCapabilities(LocalRpcService.Status status, FileServicePb.GetCapabilitiesRequest request) {
        FileServicePb.GetCapabilitiesResponse.Builder response = FileServicePb.GetCapabilitiesResponse.newBuilder();
        response.addFilesystem("blobstore");
        response.addFilesystem("gs");
        response.setShuffleAvailable(false);
        return response.build();
    }

    public FileServicePb.GetDefaultGsBucketNameResponse getDefaultGsBucketName(LocalRpcService.Status status, FileServicePb.GetDefaultGsBucketNameRequest request) {
        FileServicePb.GetDefaultGsBucketNameResponse.Builder response = FileServicePb.GetDefaultGsBucketNameResponse.newBuilder();
        response.setDefaultGsBucketName("app_default_bucket");
        return response.build();
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Integer getMaxApiRequestSize() {
        return 0x2000000;
    }
}

