/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalStatement;
import com.google.appengine.api.rdbms.dev.ResultState;
import com.google.appengine.api.rdbms.dev.Util;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LocalConnection {
    private static final Logger logger = Logger.getLogger(LocalConnection.class.getCanonicalName());
    private final Connection conn;
    private final DatabaseMetaData dmd;
    private final Map<String, Savepoint> savepoints = new HashMap<String, Savepoint>();
    private final Map<Long, LocalStatement> statementsById = new HashMap<Long, LocalStatement>();
    private final AtomicLong nextStatementId = new AtomicLong(0L);

    static LocalConnection create(Connection connection) throws SQLException {
        return new LocalConnection(connection, connection.getMetaData());
    }

    private LocalConnection(Connection conn, DatabaseMetaData dmd) {
        this.conn = conn;
        this.dmd = dmd;
    }

    Connection getConnection() {
        return this.conn;
    }

    DatabaseMetaData getMetaData() {
        return this.dmd;
    }

    Map<String, Savepoint> savepoints() {
        return this.savepoints;
    }

    ExecResponse exec(LocalRpcService.Status status, ExecRequest request) {
        if (request.hasStatementId()) {
            LocalStatement statement = this.getStatementById(request.getStatementId());
            ExecResponse response = statement.next();
            ResultState result = statement.getResultState();
            if (!result.hasMoreResults() && !result.hasMoreRows()) {
                this.removeStatementById(statement.getStatementId());
                statement.close();
            }
            return response;
        }
        LocalStatement statement = LocalStatement.create(this.nextStatementId.incrementAndGet(), this);
        ExecResponse response = statement.exec(status, request);
        ResultState result = statement.getResultState();
        if (result.hasMoreResults() || result.hasMoreRows()) {
            this.storeStatement(statement);
        } else {
            statement.close();
        }
        return response;
    }

    ExecOpResponse execOp(LocalRpcService.Status status, ExecOpRequest request) {
        ExecOpResponse.Builder responseBuilder = ExecOpResponse.newBuilder();
        Client.OpProto op = request.getOp();
        try {
            switch (op.getType()) {
                case NATIVE_SQL: {
                    String response = this.conn.nativeSQL(op.getSql());
                    responseBuilder.setNativeSql(response);
                    break;
                }
                case ROLLBACK: {
                    if (op.hasSavepoint()) {
                        Savepoint savepoint = this.getAndRemoveSavepoint(op.getSavepoint().getName());
                        this.conn.rollback(savepoint);
                        break;
                    }
                    this.conn.rollback();
                    break;
                }
                case SET_CATALOG: {
                    this.conn.setCatalog(op.getCatalog());
                    break;
                }
                case SET_SAVEPOINT: {
                    Savepoint savepoint;
                    String key;
                    if (op.getSavepoint().getName().length() > 0) {
                        key = op.getSavepoint().getName();
                        savepoint = this.conn.setSavepoint(key);
                    } else {
                        savepoint = this.conn.setSavepoint();
                        key = LocalConnection.getSavepointKey(savepoint);
                    }
                    responseBuilder.setSavepoint(Client.SavePoint.newBuilder().setName(key));
                    this.savepoints.put(key, savepoint);
                    break;
                }
                case SET_AUTO_COMMIT: {
                    this.conn.setAutoCommit(op.getAutoCommit());
                    break;
                }
                case SET_READ_ONLY: {
                    this.conn.setReadOnly(op.getReadOnly());
                    break;
                }
                case SET_TRANSACTION_ISOLATION_LEVEL: {
                    this.conn.setTransactionIsolation(op.getTransactionIsolationLevel().getNumber());
                    break;
                }
                case CLOSE_STATEMENT: {
                    LocalStatement stmt = this.getStatementById(op.getStatementId());
                    if (stmt != null) {
                        stmt.close();
                    }
                    break;
                }
                case COMMIT: {
                    this.conn.commit();
                    break;
                }
                case PING: {
                    try {
                        if (!this.conn.isValid(5000)) {
                            responseBuilder.setSqlException(Client.SqlException.newBuilder().setCode(0).setMessage("Connection not valid"));
                        }
                    }
                    catch (AbstractMethodError e) {}
                    break;
                }
                case NEXT_RESULT: {
                    LocalStatement stmt = this.getStatementById(op.getStatementId());
                    if (stmt == null) {
                        responseBuilder.setSqlException(Client.SqlException.newBuilder().setCode(0).setMessage("There is no next result"));
                        break;
                    }
                    if (!stmt.getNextResult(responseBuilder)) {
                        this.removeStatementById(stmt.getStatementId());
                    }
                    break;
                }
                default: {
                    String string = String.valueOf(String.valueOf(op.getType()));
                    throw new UnsupportedOperationException(new StringBuilder(19 + string.length()).append("Unsupported OpType ").append(string).toString());
                }
            }
        }
        catch (SQLException e) {
            if (op.hasStatementId()) {
                this.removeStatementById(op.getStatementId());
            }
            String string = String.valueOf(String.valueOf(op.getType()));
            logger.log(Level.SEVERE, new StringBuilder(43 + string.length()).append("Could not perform the requested operation: ").append(string).toString(), e);
            responseBuilder.setSqlException(Util.toClientSqlException(e));
        }
        return responseBuilder.build();
    }

    private static String getSavepointKey(Savepoint savepoint) throws SQLException {
        try {
            return savepoint.getSavepointName();
        }
        catch (SQLException exName) {
            logger.log(Level.FINER, "Unable to get Savepoint by name.", exName);
            try {
                return Long.toString(savepoint.getSavepointId());
            }
            catch (SQLException exId) {
                logger.log(Level.FINER, "Unable to get Savepoint by id.", exId);
                throw new SQLException("Unable to create key for savepoint.");
            }
        }
    }

    private Savepoint getAndRemoveSavepoint(String name) throws SQLException {
        Savepoint savepoint = this.savepoints.remove(name);
        if (savepoint == null) {
            throw new SQLException("savepoint not found");
        }
        return savepoint;
    }

    void storeStatement(LocalStatement statement) {
        this.statementsById.put(statement.getStatementId(), statement);
    }

    LocalStatement getStatementById(long statementId) {
        return this.statementsById.get(statementId);
    }

    void removeStatementById(long statementId) {
        this.statementsById.remove(statementId);
    }

    void close() throws SQLException {
        for (LocalStatement stmt : this.statementsById.values()) {
            stmt.close();
        }
        this.statementsById.clear();
        this.conn.close();
    }
}

