/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.ExpressionBuilder;
import com.google.appengine.api.search.dev.NumericDefaultExpression;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.appengine.api.search.dev.Scorer;
import com.google.appengine.api.search.dev.SearchException;
import com.google.appengine.api.search.dev.SimpleScorer;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.search.IndexSearcher;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.ScoreDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.Sort;
import com.google.appengine.repackaged.org.apache.lucene.search.SortField;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocs;
import com.google.apphosting.api.search.DocumentPb;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.regex.Pattern;

public class GenericScorer
extends Scorer
implements Comparator<Result> {
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("^\\w+$");
    private final Sort nativeSort;
    private final boolean isNative;
    private final NumericExpression[] expressions;
    private final Expression.Sorter[] sorters;
    private final int scorerLimit;

    public GenericScorer(boolean isNative, int scorerLimit, Sort nativeSort, NumericExpression[] expressions, Expression.Sorter[] sorters) {
        this.isNative = isNative;
        this.scorerLimit = scorerLimit;
        this.nativeSort = nativeSort;
        this.expressions = expressions;
        this.sorters = sorters;
    }

    public static Scorer newInstance(SearchServicePb.SearchParams searchParams, Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        int count = searchParams.getSortSpecCount();
        if (count == 0) {
            throw new IllegalArgumentException("no sort exporessions found");
        }
        boolean isNative = true;
        SortField[] fields = new SortField[count];
        int index = 0;
        for (SearchServicePb.SortSpec spec : searchParams.getSortSpecList()) {
            String expression = spec.getSortExpression();
            if (!FIELD_NAME_PATTERN.matcher(expression).matches()) {
                isNative = false;
                break;
            }
            fields[index++] = new SortField(expression, 3, spec.getSortDescending());
        }
        Sort nativeSort = isNative ? new Sort(fields) : SimpleScorer.naturalOrder();
        ExpressionBuilder builder = new ExpressionBuilder(fieldTypes);
        NumericExpression[] expressions = new NumericExpression[count];
        ArrayList<Expression.Sorter> sorters = new ArrayList<Expression.Sorter>();
        for (int i = 0; i < count; ++i) {
            SearchServicePb.SortSpec spec = searchParams.getSortSpec(i);
            Expression expression = null;
            try {
                expression = builder.parse(spec.getSortExpression());
            }
            catch (IllegalArgumentException e) {
                String errorMessage = String.format("Failed to parse sort expression '%s': %s", spec.getSortExpression(), e.getMessage());
                throw new SearchException(errorMessage);
            }
            double numericDefault = spec.getDefaultValueNumeric();
            sorters.addAll(expression.getSorters(spec.getSortDescending() ? 1 : -1, numericDefault, spec.getDefaultValueText()));
            expressions[i] = expression instanceof NumericExpression ? new NumericDefaultExpression((NumericExpression)expression, numericDefault) : new ExpressionBuilder.IntValueExpression(numericDefault);
        }
        Expression.Sorter[] sortersArray = sorters.toArray(new Expression.Sorter[sorters.size()]);
        return new GenericScorer(isNative, searchParams.getScorerSpec().getLimit(), nativeSort, expressions, sortersArray);
    }

    @Override
    public int compare(Result left, Result right) {
        for (int i = 0; i < this.sorters.length; ++i) {
            int compare = this.sorters[i].compare(left.getValue(i), right.getValue(i));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    @Override
    public Scorer.SearchResults search(IndexSearcher indexSearcher, Query q, int offset, int limit) throws IOException {
        int docsToFind;
        int numDocs = docsToFind = offset + limit;
        if (!this.isNative) {
            numDocs = Math.max(this.scorerLimit, docsToFind);
        }
        TopFieldDocs topDocs = indexSearcher.search(q, null, numDocs, this.nativeSort);
        Scorer.Result[] resultsArray = new Result[topDocs.scoreDocs.length];
        if (this.sorters.length != 0) {
            PriorityQueue<Result> results = new PriorityQueue<Result>(docsToFind, this);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Result res = new Result(indexSearcher.doc(scoreDoc.doc));
                results.add(res);
                if (results.size() <= docsToFind) continue;
                results.poll();
            }
            resultsArray = new Result[results.size() - offset];
            for (int i = results.size() - 1; i >= offset; --i) {
                resultsArray[i - offset] = results.poll();
            }
        } else {
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                resultsArray[i] = new Result(indexSearcher.doc(topDocs.scoreDocs[i].doc));
            }
        }
        return new Scorer.SearchResults(resultsArray, topDocs.totalHits);
    }

    public class Result
    extends Scorer.Result {
        private final Object[] intermediate;

        public Result(Document doc) {
            super(doc);
            this.intermediate = new Object[GenericScorer.this.sorters.length];
        }

        public Object getValue(int idx) {
            if (this.intermediate[idx] != null) {
                return this.intermediate[idx];
            }
            this.intermediate[idx] = GenericScorer.this.sorters[idx].eval(this.doc);
            return this.intermediate[idx];
        }

        @Override
        public void addScores(SearchServicePb.SearchResult.Builder resultBuilder) {
            for (int i = 0; i < GenericScorer.this.expressions.length; ++i) {
                try {
                    resultBuilder.addScore(GenericScorer.this.expressions[i].evalDouble(this.doc));
                    continue;
                }
                catch (EvaluationException e) {
                    throw new RuntimeException("internal error, the exception should be caught already", e);
                }
            }
        }
    }
}

