/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.api.socket.AppEngineSocketImplFactory;
import com.google.appengine.tools.development.DevSocketImplFactory;
import java.io.IOException;
import java.net.DatagramSocketImplFactory;
import java.net.SocketImplFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class DevSocketFilter
implements Filter {
    boolean useNativeSocket = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        AppEngineSocketImplFactory factory = new AppEngineSocketImplFactory();
        DevSocketImplFactory.setAppEngineSocketImplFactory((SocketImplFactory)factory);
        DevSocketImplFactory.setAppEngineDatagramSocketImplFactory((DatagramSocketImplFactory)factory);
        String useNativeSocketsStr = filterConfig.getInitParameter("use-native-sockets");
        if (useNativeSocketsStr != null) {
            try {
                this.useNativeSocket = Boolean.valueOf(useNativeSocketsStr);
            }
            catch (IllegalArgumentException exception) {
                String string = String.valueOf(String.valueOf("web.xml filter config \"use-native-sockets\" setting to \""));
                String string2 = String.valueOf(String.valueOf(useNativeSocketsStr));
                filterConfig.getServletContext().log(new StringBuilder(42 + string.length() + string2.length()).append(string).append(string2).append("\" is invalid. Must be either true or false").toString());
                throw new ServletException((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean previousMode = DevSocketImplFactory.setSocketNativeMode((boolean)this.useNativeSocket);
        try {
            chain.doFilter(request, response);
        }
        finally {
            DevSocketImplFactory.setSocketNativeMode((boolean)previousMode);
        }
    }

    public void destroy() {
    }
}

