/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;

@GwtCompatible(serializable=true)
public strictfp class S2Point
implements S2Region,
Comparable<S2Point>,
Serializable {
    public static final S2Point ORIGIN = new S2Point(0.0, 0.0, 0.0);
    public static final S2Point X_POS = new S2Point(1.0, 0.0, 0.0);
    public static final S2Point X_NEG = new S2Point(-1.0, 0.0, 0.0);
    public static final S2Point Y_POS = new S2Point(0.0, 1.0, 0.0);
    public static final S2Point Y_NEG = new S2Point(0.0, -1.0, 0.0);
    public static final S2Point Z_POS = new S2Point(0.0, 0.0, 1.0);
    public static final S2Point Z_NEG = new S2Point(0.0, 0.0, -1.0);
    final double x;
    final double y;
    final double z;

    public S2Point() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public S2Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public static final S2Point minus(S2Point p1, S2Point p2) {
        return S2Point.sub(p1, p2);
    }

    public static final S2Point neg(S2Point p) {
        return new S2Point(-p.x, -p.y, -p.z);
    }

    public final double norm2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double norm() {
        return Math.sqrt(this.norm2());
    }

    public static final S2Point crossProd(S2Point p1, S2Point p2) {
        return new S2Point(p1.y * p2.z - p1.z * p2.y, p1.z * p2.x - p1.x * p2.z, p1.x * p2.y - p1.y * p2.x);
    }

    public static final S2Point add(S2Point p1, S2Point p2) {
        return new S2Point(p1.x + p2.x, p1.y + p2.y, p1.z + p2.z);
    }

    public static final S2Point sub(S2Point p1, S2Point p2) {
        return new S2Point(p1.x - p2.x, p1.y - p2.y, p1.z - p2.z);
    }

    public final double dotProd(S2Point that) {
        return this.x * that.x + this.y * that.y + this.z * that.z;
    }

    public static final double scalarTripleProduct(S2Point a, S2Point b, S2Point c) {
        double x = b.y * c.z - b.z * c.y;
        double y = b.z * c.x - b.x * c.z;
        double z = b.x * c.y - b.y * c.x;
        double result = a.x * x + a.y * y + a.z * z;
        return result;
    }

    public double getDistance(S2Point that) {
        return Math.sqrt(this.getDistance2(that));
    }

    public double getDistance2(S2Point that) {
        double dx = this.x - that.x;
        double dy = this.y - that.y;
        double dz = this.z - that.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static final S2Point mul(S2Point p, double m) {
        return new S2Point(m * p.x, m * p.y, m * p.z);
    }

    public static final S2Point div(S2Point p, double m) {
        return new S2Point(p.x / m, p.y / m, p.z / m);
    }

    @CheckReturnValue
    public final S2Point ortho() {
        int k = this.largestAbsComponent();
        S2Point temp = k == 1 ? X_POS : (k == 2 ? Y_POS : Z_POS);
        return S2Point.normalize(S2Point.crossProd(this, temp));
    }

    public final int largestAbsComponent() {
        double absX = Math.abs(this.x);
        double absY = Math.abs(this.y);
        double absZ = Math.abs(this.z);
        if (absX > absY) {
            if (absX > absZ) {
                return 0;
            }
            return 2;
        }
        if (absY > absZ) {
            return 1;
        }
        return 2;
    }

    public static final S2Point fabs(S2Point p) {
        return new S2Point(Math.abs(p.x), Math.abs(p.y), Math.abs(p.z));
    }

    public static final S2Point normalize(S2Point p) {
        double norm = p.norm();
        if (norm != 0.0) {
            norm = 1.0 / norm;
        }
        return S2Point.mul(p, norm);
    }

    public final double get(int axis) {
        return axis == 0 ? this.x : (axis == 1 ? this.y : this.z);
    }

    public final double crossProdNorm(S2Point va) {
        double x = this.y * va.z - this.z * va.y;
        double y = this.z * va.x - this.x * va.z;
        double z = this.x * va.y - this.y * va.x;
        double result = Math.sqrt(x * x + y * y + z * z);
        return result;
    }

    @CheckReturnValue
    public S2Point rotate(S2Point axis, double radians) {
        S2Point point = S2Point.normalize(this);
        S2Point normAxis = S2Point.normalize(axis);
        S2Point pointOnAxis = S2Point.mul(normAxis, point.dotProd(normAxis));
        S2Point axisToPoint = S2Point.sub(point, pointOnAxis);
        S2Point axisToPointNormal = S2Point.crossProd(normAxis, axisToPoint);
        axisToPoint = S2Point.mul(axisToPoint, Math.cos(radians));
        axisToPointNormal = S2Point.mul(axisToPointNormal, Math.sin(radians));
        return S2Point.normalize(S2Point.add(S2Point.add(axisToPoint, axisToPointNormal), pointOnAxis));
    }

    public final double angle(S2Point va) {
        return Math.atan2(this.crossProdNorm(va), this.dotProd(va));
    }

    boolean aequal(S2Point that, double margin) {
        return Math.abs(this.x - that.x) < margin && Math.abs(this.y - that.y) < margin && Math.abs(this.z - that.z) < margin;
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2Point)) {
            return false;
        }
        S2Point thatPoint = (S2Point)that;
        return this.x == thatPoint.x && this.y == thatPoint.y && this.z == thatPoint.z;
    }

    public boolean equalsPoint(S2Point that) {
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public boolean lessThan(S2Point vb) {
        if (this.x < vb.x) {
            return true;
        }
        if (vb.x < this.x) {
            return false;
        }
        if (this.y < vb.y) {
            return true;
        }
        if (vb.y < this.y) {
            return false;
        }
        return this.z < vb.z;
    }

    @Override
    public int compareTo(S2Point other) {
        return this.lessThan(other) ? -1 : (this.equalsPoint(other) ? 0 : 1);
    }

    public String toString() {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        return new StringBuilder(78).append("(").append(d).append(", ").append(d2).append(", ").append(d3).append(")").toString();
    }

    public String toDegreesString() {
        S2LatLng s2LatLng = new S2LatLng(this);
        String string = String.valueOf(String.valueOf(Double.toString(s2LatLng.latDegrees())));
        String string2 = String.valueOf(String.valueOf(Double.toString(s2LatLng.lngDegrees())));
        return new StringBuilder(4 + string.length() + string2.length()).append("(").append(string).append(", ").append(string2).append(")").toString();
    }

    public int hashCode() {
        long value = 17L;
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.x));
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.y));
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.z));
        return (int)(value ^ value >>> 32);
    }

    @Override
    public boolean contains(S2Cell cell) {
        return false;
    }

    @Override
    public S2Cap getCapBound() {
        return S2Cap.fromAxisHeight(this, 0.0);
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2LatLng latLng = new S2LatLng(this);
        return S2LatLngRect.fromPoint(latLng);
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return cell.contains(this);
    }
}

