/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityV4Validator;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class DatastoreV4Validator {
    protected final EntityV4Validator entityValidator;
    public static final DatastoreV4Validator DEFAULT = new DatastoreV4Validator(EntityV4Validator.DEFAULT);
    private static final Pattern GQL_ARG_NAME_CHARACTER_SET_PATTERN = Pattern.compile("[A-Za-z0-9_$\u0080-\uffff]*");

    public DatastoreV4Validator(EntityV4Validator entityValidator) {
        this.entityValidator = entityValidator;
    }

    public EntityV4Validator getEntityValidator() {
        return this.entityValidator;
    }

    public void validateRequestInitialized(MessageOrBuilder pb) throws ValidationException {
        List error = pb.findInitializationErrors();
        String string = String.valueOf(String.valueOf(error));
        ValidationException.validateAssertion(error.isEmpty(), new StringBuilder(17 + string.length()).append("not initialized: ").append(string).toString(), new Object[0]);
    }

    public void validateMutation(boolean isUserTrusted, DatastoreV4.MutationOrBuilder mutation) throws ValidationException {
        ValidationException.validateAssertion(!mutation.hasKey() || !mutation.hasEntity(), "mutation has both key and entity", new Object[0]);
        DatastoreV4.Mutation.Operation op = mutation.getOp();
        switch (op) {
            case UPSERT: 
            case UPDATE: 
            case INSERT: {
                ValidationException.validateAssertion(mutation.hasEntity(), "mutation lacks required entity", new Object[0]);
                break;
            }
            case DELETE: {
                ValidationException.validateAssertion(mutation.hasKey(), "mutation lacks required key", new Object[0]);
                break;
            }
            case UNKNOWN: {
                throw new ValidationException("unknown mutation operation");
            }
        }
        ValidationConstraint constraint = (op == DatastoreV4.Mutation.Operation.INSERT || op == DatastoreV4.Mutation.Operation.UPSERT) && Paths.hasIncompleteLastElement((EntityV4.KeyOrBuilder)mutation.getEntity().getKey()) ? (isUserTrusted ? ValidationConstraint.TRUSTED_WRITE_ALLOW_ALLOCATE_KEY_ID : ValidationConstraint.WRITE_ALLOW_ALLOCATE_KEY_ID) : (isUserTrusted ? ValidationConstraint.TRUSTED_WRITE : ValidationConstraint.WRITE);
        if (op == DatastoreV4.Mutation.Operation.DELETE) {
            this.entityValidator.validateKey(constraint, (EntityV4.KeyOrBuilder)mutation.getKey());
        } else {
            this.entityValidator.validateEntity(constraint, (EntityV4.EntityOrBuilder)mutation.getEntity());
        }
    }

    public void validateDeprecatedMutation(boolean isUserTrusted, DatastoreV4.DeprecatedMutationOrBuilder deprecatedMutation) throws ValidationException {
        ValidationConstraint insertAutoIdConstraint;
        ValidationConstraint constraint;
        if (isUserTrusted) {
            constraint = ValidationConstraint.TRUSTED_WRITE;
            insertAutoIdConstraint = ValidationConstraint.TRUSTED_WRITE_WITH_ALLOCATE_KEY_ID;
        } else {
            constraint = ValidationConstraint.WRITE;
            insertAutoIdConstraint = ValidationConstraint.WRITE_WITH_ALLOCATE_KEY_ID;
        }
        this.entityValidator.validateEntities(constraint, deprecatedMutation.getUpsertOrBuilderList());
        this.entityValidator.validateEntities(constraint, deprecatedMutation.getUpdateOrBuilderList());
        this.entityValidator.validateEntities(constraint, deprecatedMutation.getInsertOrBuilderList());
        this.entityValidator.validateEntities(insertAutoIdConstraint, deprecatedMutation.getInsertAutoIdOrBuilderList());
        this.entityValidator.validateKeys(constraint, deprecatedMutation.getDeleteOrBuilderList());
    }

    public void validateCommitMode(DatastoreV4.CommitRequest.Mode mode, boolean hasTransaction) throws ValidationException {
        switch (mode) {
            case TRANSACTIONAL: {
                ValidationException.validateAssertion(hasTransaction, "transactional commit requires a transaction", new Object[0]);
                break;
            }
            case NON_TRANSACTIONAL: {
                ValidationException.validateAssertion(!hasTransaction, "non-transaction commit cannot specify a transaction", new Object[0]);
                break;
            }
            default: {
                String string = String.valueOf(String.valueOf(mode));
                throw new ValidationException(new StringBuilder(21 + string.length()).append("unknown commit mode: ").append(string).toString());
            }
        }
    }

    public void validateQuery(boolean isStrongReadConsistency, DatastoreV4.QueryOrBuilder query) throws ValidationException {
        ValidationException.validateAssertion(!isStrongReadConsistency || this.hasAncestor(query.getFilterOrBuilder()), "global queries do not support strong consistency", new Object[0]);
        if (query.hasFilter()) {
            this.validateFilter(query.getFilterOrBuilder());
        }
        for (DatastoreV4.KindExpressionOrBuilder kindExp : query.getKindOrBuilderList()) {
            this.validateKindExpression(kindExp);
        }
        HashSet groupByProperties = Sets.newHashSet();
        for (DatastoreV4.PropertyReferenceOrBuilder propRef : query.getGroupByOrBuilderList()) {
            this.validatePropertyReference(propRef);
            groupByProperties.add(propRef.getName());
        }
        for (DatastoreV4.PropertyExpressionOrBuilder propExp : query.getProjectionOrBuilderList()) {
            this.validatePropertyExpression(propExp, groupByProperties);
        }
        for (DatastoreV4.PropertyOrderOrBuilder order : query.getOrderOrBuilderList()) {
            this.validatePropertyOrder(order);
        }
    }

    public void validateGqlQuery(DatastoreV4.GqlQueryOrBuilder gqlQuery) throws ValidationException {
        this.validateRequestInitialized((MessageOrBuilder)gqlQuery);
        this.entityValidator.validateStringUtf8(gqlQuery.getQueryStringBytes(), "GQL query string");
        HashSet namedGqlQueryArgSet = Sets.newHashSet();
        for (DatastoreV4.GqlQueryArgOrBuilder namedGqlQueryArg : gqlQuery.getNameArgList()) {
            this.validateGqlQueryArg(namedGqlQueryArgSet, namedGqlQueryArg);
        }
        for (DatastoreV4.GqlQueryArgOrBuilder numberedGqlQueryArg : gqlQuery.getNumberArgList()) {
            this.validateGqlQueryArg(null, numberedGqlQueryArg);
        }
    }

    private void validateGqlQueryArg(Set<String> namedGqlQueryArgSet, DatastoreV4.GqlQueryArgOrBuilder gqlQueryArg) throws ValidationException {
        if (namedGqlQueryArgSet == null) {
            ValidationException.validateAssertion(!gqlQueryArg.hasName(), "A numbered GQL query argument has a name.", new Object[0]);
        } else {
            ValidationException.validateAssertion(gqlQueryArg.hasName(), "A named GQL query argument has no name.", new Object[0]);
            this.entityValidator.validateStringUtf8(gqlQueryArg.getNameBytes(), "GQL query argument name");
            String name = gqlQueryArg.getName();
            this.entityValidator.validateStringNotEmpty(name, "GQL query argument name is empty.");
            ValidationException.validateAssertion(GQL_ARG_NAME_CHARACTER_SET_PATTERN.matcher(name).matches(), "GQL query argument name \"%s\" contains an invalid character.", name);
            ValidationException.validateAssertion(!Character.isDigit(name.charAt(0)), "GQL query argument name \"%s\" starts with a digit.", name);
            this.entityValidator.validateStringNotReserved(name, "GQL query argument name");
            ValidationException.validateAssertion(namedGqlQueryArgSet.add(name), "Duplicate GQL query argument name \"%s\".", name);
        }
        boolean hasCursor = gqlQueryArg.hasCursor();
        if (gqlQueryArg.hasValue()) {
            ValidationException.validateAssertion(!hasCursor, "A GQL query argument has both a value and a cursor.", new Object[0]);
            String string = String.valueOf(gqlQueryArg.getName());
            this.entityValidator.validateValue(ValidationConstraint.READ, "", gqlQueryArg.getValueOrBuilder(), string.length() != 0 ? "GQL argument ".concat(string) : new String("GQL argument "));
        } else {
            ValidationException.validateAssertion(hasCursor, "A GQL query argument has neither value nor cursor.", new Object[0]);
        }
    }

    public void validateReadOptions(boolean hasReadConsistency, boolean hasTransaction) throws ValidationException {
        ValidationException.validateAssertion(!hasReadConsistency || !hasTransaction, "cannot specify both a read consistency and a transaction", new Object[0]);
    }

    private void validatePropertyOrder(DatastoreV4.PropertyOrderOrBuilder order) throws ValidationException {
        this.validatePropertyReference((DatastoreV4.PropertyReferenceOrBuilder)order.getProperty());
    }

    private void validatePropertyExpression(DatastoreV4.PropertyExpressionOrBuilder propExp, Set<String> groupByProperties) throws ValidationException {
        this.validatePropertyReference(propExp.getPropertyOrBuilder());
        if (groupByProperties.isEmpty()) {
            ValidationException.validateAssertion(!propExp.hasAggregationFunction(), "aggregation function is not allowed without group by", new Object[0]);
        } else if (groupByProperties.contains(propExp.getPropertyOrBuilder().getName())) {
            String string = String.valueOf(propExp.getPropertyOrBuilder().getName());
            ValidationException.validateAssertion(!propExp.hasAggregationFunction(), string.length() != 0 ? "aggregation function is not allowed for properties in group by: ".concat(string) : new String("aggregation function is not allowed for properties in group by: "), new Object[0]);
        } else {
            String string = String.valueOf(propExp.getPropertyOrBuilder().getName());
            ValidationException.validateAssertion(propExp.hasAggregationFunction(), string.length() != 0 ? "aggregation function is required for properties not in group by: ".concat(string) : new String("aggregation function is required for properties not in group by: "), new Object[0]);
        }
    }

    private void validateKindExpression(DatastoreV4.KindExpressionOrBuilder kindExp) throws ValidationException {
        this.entityValidator.validateStringUtf8(kindExp.getNameBytes(), "kind");
        this.entityValidator.validateKind(ValidationConstraint.READ, kindExp.getName());
    }

    private void validatePropertyReference(DatastoreV4.PropertyReferenceOrBuilder propertyRef) throws ValidationException {
        this.entityValidator.validateStringUtf8(propertyRef.getNameBytes(), "property name");
        this.entityValidator.validatePropertyName(ValidationConstraint.READ, true, propertyRef.getName());
    }

    private void validateFilter(DatastoreV4.FilterOrBuilder filter) throws ValidationException {
        ValidationException.validateAssertion(filter.getAllFields().size() == 1, "a filter must have exactly one of its fields set", new Object[0]);
        if (filter.hasCompositeFilter()) {
            DatastoreV4.CompositeFilterOrBuilder cmpFilter = filter.getCompositeFilterOrBuilder();
            ValidationException.validateAssertion(cmpFilter.getFilterCount() > 0, "a composite filter must have at least one sub-filter", new Object[0]);
            for (DatastoreV4.FilterOrBuilder subFilter : cmpFilter.getFilterOrBuilderList()) {
                this.validateFilter(subFilter);
            }
        } else if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
            this.validatePropertyReference(propFilter.getPropertyOrBuilder());
            ValidationException.validateAssertion(propFilter.getValueOrBuilder().getIndexed(), "a filter value must be indexed", new Object[0]);
            this.entityValidator.validateValue(ValidationConstraint.READ, "", (EntityV4.ValueOrBuilder)propFilter.getValue(), propFilter.getPropertyOrBuilder().getName());
        } else if (filter.hasBoundingCircleFilter()) {
            DatastoreV4.BoundingCircleFilterOrBuilder bcFilter = filter.getBoundingCircleFilterOrBuilder();
            this.validatePropertyReference(bcFilter.getPropertyOrBuilder());
            double d = bcFilter.getRadiusMeters();
            ValidationException.validateAssertion(bcFilter.getRadiusMeters() >= 0.0, new StringBuilder(40).append("invalid radius: ").append(d).toString(), new Object[0]);
            this.entityValidator.validateGeoPoint((EntityV4.GeoPointOrBuilder)bcFilter.getCenter());
        } else if (filter.hasBoundingBoxFilter()) {
            DatastoreV4.BoundingBoxFilterOrBuilder bbFilter = filter.getBoundingBoxFilterOrBuilder();
            this.validatePropertyReference(bbFilter.getPropertyOrBuilder());
            this.entityValidator.validateGeoPoint((EntityV4.GeoPointOrBuilder)bbFilter.getSouthwest());
            this.entityValidator.validateGeoPoint((EntityV4.GeoPointOrBuilder)bbFilter.getNortheast());
            ValidationException.validateAssertion(bbFilter.getSouthwest().getLatitude() <= bbFilter.getNortheast().getLatitude(), "the south-west coordinate is on top of the north-east coordinate", new Object[0]);
        }
    }

    private boolean hasAncestor(DatastoreV4.FilterOrBuilder filter) {
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
            return propFilter.getOperator() == DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR && propFilter.getPropertyOrBuilder().getName().equals("__key__");
        }
        if (filter.hasCompositeFilter() && filter.getCompositeFilter().getOperator() == DatastoreV4.CompositeFilter.Operator.AND) {
            for (DatastoreV4.Filter subFilter : filter.getCompositeFilter().getFilterList()) {
                if (!this.hasAncestor((DatastoreV4.FilterOrBuilder)subFilter)) continue;
                return true;
            }
        }
        return false;
    }
}

