/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.shared.EntityV4Helper;
import com.google.apphosting.datastore.shared.GqlParserConstants;
import com.google.apphosting.datastore.shared.GqlParserTokenManager;
import com.google.apphosting.datastore.shared.ParseException;
import com.google.apphosting.datastore.shared.SimpleCharStream;
import com.google.apphosting.datastore.shared.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GqlParser
implements GqlParserConstants {
    private EntityV4.PartitionId defaultPartitionId;
    private boolean allowLiteral;
    private ImmutableMap<String, DatastoreV4.GqlQueryArg> nameBindingMap;
    private List<DatastoreV4.GqlQueryArg> numberBindingList;
    private boolean[] numberBindingUsedList;
    private static final ImmutableMap<Character, String> SLASHED_CHAR_TRANSLATION_MAP = new ImmutableMap.Builder().put((Object)Character.valueOf('\\'), (Object)"\\").put((Object)Character.valueOf('0'), (Object)"\u0000").put((Object)Character.valueOf('b'), (Object)"\b").put((Object)Character.valueOf('n'), (Object)"\n").put((Object)Character.valueOf('r'), (Object)"\r").put((Object)Character.valueOf('t'), (Object)"\t").put((Object)Character.valueOf('Z'), (Object)"\u001a").put((Object)Character.valueOf('%'), (Object)"\\%").put((Object)Character.valueOf('_'), (Object)"\\_").put((Object)Character.valueOf('\''), (Object)"'").put((Object)Character.valueOf('\"'), (Object)"\"").put((Object)Character.valueOf('`'), (Object)"`").build();
    private static final BaseEncoding BASE64_URL_WITHOUT_PADDING_ENCODING = BaseEncoding.base64Url().omitPadding();
    private static final String DATE_REGEX = "(\\d\\d\\d\\d-\\d\\d-\\d\\d)";
    private static final String TIME_REGEX = "(\\d\\d:\\d\\d:\\d\\d)(?:\\.(\\d{1,6}))?";
    private static final String TIMEZONE_REGEX = "((?:[+-]\\d\\d:\\d\\d)|[zZ])";
    private static final Pattern DATETIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d-\\d\\d-\\d\\d)[tT](\\d\\d:\\d\\d:\\d\\d)(?:\\.(\\d{1,6}))?((?:[+-]\\d\\d:\\d\\d)|[zZ])");
    private static final int DATE_GROUP = 1;
    private static final int TIME_IN_SECONDS_GROUP = 2;
    private static final int PARTIAL_SECONDS_GROUP = 3;
    private static final int TIME_ZONE_GROUP = 4;
    private static final DateFormat DATETIME_FORMAT = GqlParser.createDatetimeDateFormat();
    public GqlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[29];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[3];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public GqlParser(DatastoreV4.GqlQueryOrBuilder gqlQuery, EntityV4.PartitionId defaultPartitionId) {
        this(new StringReader(gqlQuery.getQueryString()));
        this.defaultPartitionId = defaultPartitionId;
        this.allowLiteral = gqlQuery.getAllowLiteral();
        this.nameBindingMap = GqlParser.createNameBindingMap(gqlQuery.getNameArgList());
        this.numberBindingList = gqlQuery.getNumberArgList();
        this.numberBindingUsedList = new boolean[this.numberBindingList.size()];
    }

    private static ImmutableMap<String, DatastoreV4.GqlQueryArg> createNameBindingMap(List<DatastoreV4.GqlQueryArg> argList) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DatastoreV4.GqlQueryArg arg : argList) {
            builder.put((Object)arg.getName(), (Object)arg);
        }
        return builder.build();
    }

    private DatastoreV4.GqlQueryArg lookupNameBinding(String name) throws ParseException {
        DatastoreV4.GqlQueryArg arg = (DatastoreV4.GqlQueryArg)this.nameBindingMap.get((Object)name);
        if (arg == null) {
            this.throwParseException("Unknown named binding: %s.", name);
        }
        return arg;
    }

    private DatastoreV4.GqlQueryArg lookupNumberBinding(long number) throws ParseException {
        if (number > (long)this.numberBindingList.size()) {
            this.throwParseException("Unknown numbered binding: %d.", number);
        }
        int bindingArrayIndex = (int)number - 1;
        this.numberBindingUsedList[bindingArrayIndex] = true;
        return this.numberBindingList.get(bindingArrayIndex);
    }

    private void verifyEveryNumberBindingUsed() throws ParseException {
        for (int bindingArrayIndex = 0; bindingArrayIndex < this.numberBindingUsedList.length; ++bindingArrayIndex) {
            if (this.numberBindingUsedList[bindingArrayIndex]) continue;
            this.throwParseException("Unused numbered binding: %d.", bindingArrayIndex + 1);
        }
    }

    private void checkAllowLiteral(String literalText) throws ParseException {
        if (!this.allowLiteral) {
            this.throwParseException("Disallowed literal: %s.", literalText);
        }
    }

    private String interpretUnquotedName(String unquotedName) throws ParseException {
        return unquotedName;
    }

    private String interpretQuotedName(String quotedName) throws ParseException {
        return GqlParser.deEscapeQuotedText(quotedName, '`');
    }

    private EntityV4.Value interpretStringLiteral(String stringLiteral, char quoteChar) throws ParseException {
        this.checkAllowLiteral(stringLiteral);
        return EntityV4.Value.newBuilder().setStringValue(GqlParser.deEscapeQuotedText(stringLiteral, quoteChar)).build();
    }

    private static String deEscapeQuotedText(String quotedText, char quoteChar) {
        int closingQuoteIndex = quotedText.length() - 1;
        if (quotedText.lastIndexOf(92, closingQuoteIndex) <= 0 && quotedText.lastIndexOf(quoteChar, closingQuoteIndex) <= 0) {
            return quotedText.substring(1, closingQuoteIndex);
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = 1; index < closingQuoteIndex; ++index) {
            char character = quotedText.charAt(index);
            if (character == '\\') {
                char slashedChar = quotedText.charAt(++index);
                buffer.append((String)SLASHED_CHAR_TRANSLATION_MAP.get((Object)Character.valueOf(slashedChar)));
                continue;
            }
            buffer.append(character);
            if (character != quoteChar) continue;
            ++index;
        }
        return buffer.toString();
    }

    private long interpretIntegerText(String integerText) throws ParseException {
        try {
            return Long.parseLong(integerText);
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid integer literal: %s", exception.getMessage());
        }
    }

    private EntityV4.Value interpretIntegerLiteral(String integerLiteral) throws ParseException {
        this.checkAllowLiteral(integerLiteral);
        long integerAsLong = this.interpretIntegerText(integerLiteral);
        return EntityV4.Value.newBuilder().setIntegerValue(integerAsLong).build();
    }

    private EntityV4.Value interpretDoubleLiteral(String doubleLiteral) throws ParseException {
        this.checkAllowLiteral(doubleLiteral);
        try {
            double doubleValue = Double.parseDouble(doubleLiteral);
            return EntityV4.Value.newBuilder().setDoubleValue(doubleValue).build();
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid double literal: %s", exception.getMessage());
        }
    }

    private EntityV4.Value interpretBlobText(String blobText) throws ParseException {
        byte[] blob;
        try {
            blob = BASE64_URL_WITHOUT_PADDING_ENCODING.decodeChecked((CharSequence)blobText);
        }
        catch (BaseEncoding.DecodingException exception) {
            throw this.throwParseException("Invalid blob text: \"%s\".", blobText);
        }
        return EntityV4.Value.newBuilder().setBlobValue(ByteString.copyFrom((byte[])blob)).build();
    }

    private EntityV4.Value interpretBlobKeyText(String blobKeyText) {
        return EntityV4.Value.newBuilder().setBlobKeyValue(blobKeyText).build();
    }

    private static DateFormat createDatetimeDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss XXX");
        dateFormat.setCalendar(new GregorianCalendar());
        dateFormat.setLenient(false);
        return dateFormat;
    }

    private EntityV4.Value interpretDatetimeText(String datetimeText) throws ParseException {
        ParsePosition parsePosition;
        Matcher datetimeMatcher = DATETIME_PATTERN.matcher(datetimeText);
        if (!datetimeMatcher.matches()) {
            throw this.throwParseException("Invalid datetime text (does not match pattern): \"%s\"", datetimeText);
        }
        String dateString = datetimeMatcher.group(1);
        String timeInSecondsString = datetimeMatcher.group(2);
        String partialSecondsString = datetimeMatcher.group(3);
        String timezoneString = datetimeMatcher.group(4);
        long partialSecondsMicroseconds = 0L;
        if (partialSecondsString != null) {
            long partialSecondsNum = Long.parseLong(partialSecondsString);
            for (int counter = partialSecondsString.length(); counter < 6; ++counter) {
                partialSecondsNum *= 10L;
            }
            partialSecondsMicroseconds = partialSecondsNum;
        }
        if (timezoneString.equals("+00:00") || timezoneString.equals("-00:00")) {
            throw this.throwParseException("Invalid datetime text (zero offset must be Z): \"%s\"", datetimeText);
        }
        if (timezoneString.equals("z")) {
            timezoneString = "Z";
        }
        String string = String.valueOf(String.valueOf(dateString));
        String counter = String.valueOf(String.valueOf(timeInSecondsString));
        String string2 = String.valueOf(String.valueOf(timezoneString));
        String formattedDatetimeString = new StringBuilder(2 + string.length() + counter.length() + string2.length()).append(string).append(" ").append(counter).append(" ").append(string2).toString();
        Date date = DATETIME_FORMAT.parse(formattedDatetimeString, parsePosition = new ParsePosition(0));
        if (date == null || parsePosition.getIndex() < formattedDatetimeString.length()) {
            throw this.throwParseException("Invalid datetime text (parse failure): \"%s\"", datetimeText);
        }
        long timestampMilliseconds = date.getTime();
        long timestampMicroseconds = 1000L * timestampMilliseconds + partialSecondsMicroseconds;
        if (timestampMicroseconds < 0L) {
            throw this.throwParseException("Invalid datetime text (timestamp < 0): \"%s\"", datetimeText);
        }
        return EntityV4.Value.newBuilder().setTimestampMicrosecondsValue(timestampMicroseconds).build();
    }

    private DatastoreV4.GqlQueryArg interpretBindingSiteWithName(String bindingSiteWithName) throws ParseException {
        String name = bindingSiteWithName.substring(1);
        return this.lookupNameBinding(name);
    }

    private DatastoreV4.GqlQueryArg interpretBindingSiteWithNumber(String bindingSiteWithNumber) throws ParseException {
        String integerText = bindingSiteWithNumber.substring(1);
        try {
            long integerAsLong = Long.parseLong(integerText);
            if (integerAsLong == 0L) {
                this.throwParseException("Invalid binding site @0.", new Object[0]);
            }
            return this.lookupNumberBinding(integerAsLong);
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid binding site number: %s", exception.getMessage());
        }
    }

    private List<DatastoreV4.PropertyReference> reduceProjectionListToGroupByList(List<DatastoreV4.PropertyExpression> projectionList) {
        ArrayList gropuByList = Lists.newArrayList();
        for (DatastoreV4.PropertyExpression expression : projectionList) {
            if (expression.hasAggregationFunction()) continue;
            gropuByList.add(expression.getProperty());
        }
        return gropuByList;
    }

    private int interpretIntegerValueAsResultCount(String descriptor, EntityV4.Value integerValue) throws ParseException {
        long count = integerValue.getIntegerValue();
        if (count < 0L) {
            this.throwParseException("The %s %d is < 0.", descriptor, count);
        }
        if (count > Integer.MAX_VALUE) {
            this.throwParseException("The %s %d is too large.", descriptor, count);
        }
        return (int)count;
    }

    private ParseException throwParseException(String message, Object ... formatArgList) throws ParseException {
        throw new ParseException(String.format(message, formatArgList));
    }

    public final DatastoreV4.Query.Builder selector() throws ParseException {
        List<DatastoreV4.PropertyReference> groupByList;
        DatastoreV4.Query.Builder resultBuilder = DatastoreV4.Query.newBuilder();
        boolean isDistinct = false;
        this.jj_consume_token(38);
        switch (this.jj_nt.kind) {
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 18: 
            case 55: 
            case 56: {
                switch (this.jj_nt.kind) {
                    case 18: {
                        this.jj_consume_token(18);
                        isDistinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                    }
                }
                List<DatastoreV4.PropertyExpression> projectionList = this.aggregatedPropertyReferenceList();
                resultBuilder.addAllProjection(projectionList);
                if (!isDistinct) break;
                groupByList = this.reduceProjectionListToGroupByList(projectionList);
                if (groupByList.isEmpty()) {
                    this.throwParseException("Distinct projection queries with only aggregated properties are not supported.", new Object[0]);
                }
                resultBuilder.addAllGroupBy(groupByList);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 21: {
                this.jj_consume_token(21);
                DatastoreV4.KindExpression kindExpression = this.kind();
                resultBuilder.addKind(kindExpression);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 42: {
                this.jj_consume_token(42);
                DatastoreV4.Filter filter = this.compoundCondition();
                resultBuilder.setFilter(filter);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 22: {
                this.jj_consume_token(22);
                this.jj_consume_token(13);
                if (isDistinct) {
                    this.throwParseException("Query specifies both DISTINCT and GROUP BY.", new Object[0]);
                }
                groupByList = this.propertyReferenceList();
                resultBuilder.addAllGroupBy(groupByList);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 35: {
                this.jj_consume_token(35);
                this.jj_consume_token(13);
                List<DatastoreV4.PropertyOrder> orderByList = this.orderedPropertyReferenceList();
                resultBuilder.addAllOrder(orderByList);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 29: {
                this.jj_consume_token(29);
                this.limit(resultBuilder);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 33: {
                this.jj_consume_token(33);
                this.offset(resultBuilder);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        this.verifyEveryNumberBindingUsed();
        return resultBuilder;
    }

    public final DatastoreV4.Filter compoundCondition() throws ParseException {
        DatastoreV4.CompositeFilter.Builder compositeFilterBuilder = null;
        DatastoreV4.Filter condition = this.condition();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            if (compositeFilterBuilder == null) {
                compositeFilterBuilder = DatastoreV4.CompositeFilter.newBuilder().setOperator(DatastoreV4.CompositeFilter.Operator.AND).addFilter(condition);
            }
            condition = this.condition();
            compositeFilterBuilder.addFilter(condition);
        }
        if (compositeFilterBuilder == null) {
            return condition;
        }
        return DatastoreV4.Filter.newBuilder().setCompositeFilter(compositeFilterBuilder.build()).build();
    }

    public final DatastoreV4.Filter condition() throws ParseException {
        DatastoreV4.PropertyReference propertyReference;
        DatastoreV4.PropertyFilter.Operator comparator;
        EntityV4.Value value;
        if (this.jj_2_1(2)) {
            value = this.value();
            comparator = this.comparator_with_property_right_op();
            propertyReference = this.propertyReference();
        } else {
            block0 : switch (this.jj_nt.kind) {
                case 55: 
                case 56: {
                    propertyReference = this.propertyReference();
                    switch (this.jj_nt.kind) {
                        case 26: {
                            this.jj_consume_token(26);
                            comparator = DatastoreV4.PropertyFilter.Operator.EQUAL;
                            value = this.nullValue();
                            break block0;
                        }
                        case 14: 
                        case 23: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: {
                            comparator = this.comparator_with_property_left_op();
                            value = this.value();
                            break block0;
                        }
                    }
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        DatastoreV4.PropertyFilter propertyFilter = DatastoreV4.PropertyFilter.newBuilder().setOperator(comparator).setProperty(propertyReference).setValue(value).build();
        return DatastoreV4.Filter.newBuilder().setPropertyFilter(propertyFilter).build();
    }

    public final DatastoreV4.PropertyFilter.Operator comparator_with_property_left_op() throws ParseException {
        switch (this.jj_nt.kind) {
            case 60: {
                this.jj_consume_token(60);
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
            case 61: {
                this.jj_consume_token(61);
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN;
            }
            case 62: {
                this.jj_consume_token(62);
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case 63: {
                this.jj_consume_token(63);
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN;
            }
            case 64: {
                this.jj_consume_token(64);
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case 14: {
                this.jj_consume_token(14);
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(6);
                return DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR;
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DatastoreV4.PropertyFilter.Operator comparator_with_property_right_op() throws ParseException {
        switch (this.jj_nt.kind) {
            case 60: {
                this.jj_consume_token(60);
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
            case 61: {
                this.jj_consume_token(61);
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN;
            }
            case 62: {
                this.jj_consume_token(62);
                return DatastoreV4.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case 63: {
                this.jj_consume_token(63);
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN;
            }
            case 64: {
                this.jj_consume_token(64);
                return DatastoreV4.PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case 25: {
                this.jj_consume_token(25);
                return DatastoreV4.PropertyFilter.Operator.EQUAL;
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(17);
                return DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR;
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<DatastoreV4.PropertyExpression> aggregatedPropertyReferenceList() throws ParseException {
        ArrayList propertyExpressionList = Lists.newArrayList();
        DatastoreV4.PropertyExpression propertyExpression = this.aggregatedPropertyReference();
        propertyExpressionList.add(propertyExpression);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            propertyExpression = this.aggregatedPropertyReference();
            propertyExpressionList.add(propertyExpression);
        }
        return propertyExpressionList;
    }

    public final DatastoreV4.PropertyExpression aggregatedPropertyReference() throws ParseException {
        DatastoreV4.PropertyReference propertyReference;
        DatastoreV4.PropertyExpression.Builder resultBuilder = DatastoreV4.PropertyExpression.newBuilder();
        if (this.jj_2_2(2)) {
            DatastoreV4.PropertyExpression.AggregationFunction aggregator = this.aggregator();
            resultBuilder.setAggregationFunction(aggregator);
            this.jj_consume_token(66);
            propertyReference = this.propertyReference();
            this.jj_consume_token(67);
        } else {
            switch (this.jj_nt.kind) {
                case 55: 
                case 56: {
                    propertyReference = this.propertyReference();
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        resultBuilder.setProperty(propertyReference);
        return resultBuilder.build();
    }

    public final DatastoreV4.PropertyExpression.AggregationFunction aggregator() throws ParseException {
        Aggregator aggregator;
        Token identifier = this.jj_consume_token(55);
        try {
            aggregator = Aggregator.valueOf(identifier.image.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            throw this.throwParseException("Unknown aggregator function \"%s\".", identifier.image);
        }
        return aggregator.getAggregationFunction();
    }

    public final List<DatastoreV4.PropertyOrder> orderedPropertyReferenceList() throws ParseException {
        ArrayList orderedPropertyReferenceList = Lists.newArrayList();
        DatastoreV4.PropertyOrder orderedPropertyReference = this.orderedPropertyReference();
        orderedPropertyReferenceList.add(orderedPropertyReference);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            orderedPropertyReference = this.orderedPropertyReference();
            orderedPropertyReferenceList.add(orderedPropertyReference);
        }
        return orderedPropertyReferenceList;
    }

    public final DatastoreV4.PropertyOrder orderedPropertyReference() throws ParseException {
        DatastoreV4.PropertyOrder.Builder resultBuilder = DatastoreV4.PropertyOrder.newBuilder();
        DatastoreV4.PropertyReference propertyReference = this.propertyReference();
        resultBuilder.setProperty(propertyReference);
        block0 : switch (this.jj_nt.kind) {
            case 10: 
            case 16: {
                switch (this.jj_nt.kind) {
                    case 10: {
                        this.jj_consume_token(10);
                        break block0;
                    }
                    case 16: {
                        this.jj_consume_token(16);
                        resultBuilder.setDirection(DatastoreV4.PropertyOrder.Direction.DESCENDING);
                        break block0;
                    }
                }
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        return resultBuilder.build();
    }

    public final List<DatastoreV4.PropertyReference> propertyReferenceList() throws ParseException {
        ArrayList propertyReferenceList = Lists.newArrayList();
        DatastoreV4.PropertyReference propertyReference = this.propertyReference();
        propertyReferenceList.add(propertyReference);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            propertyReference = this.propertyReference();
            propertyReferenceList.add(propertyReference);
        }
        return propertyReferenceList;
    }

    public final void limit(DatastoreV4.Query.Builder resultBuilder) throws ParseException {
        Object limitObject;
        Object limitObject2 = null;
        switch (this.jj_nt.kind) {
            case 49: 
            case 57: 
            case 58: {
                limitObject = this.resultPosition("limit", BindingConstraint.CURSOR_OR_INTEGER);
                break;
            }
            case 55: {
                Token identifier = this.jj_consume_token(55);
                if (!identifier.image.equalsIgnoreCase("first")) {
                    this.throwParseException("Unexpected name \"%s\" (after LIMIT).", identifier.image);
                }
                this.jj_consume_token(66);
                limitObject = this.resultPosition("limit", BindingConstraint.CURSOR_OR_INTEGER);
                this.jj_consume_token(65);
                limitObject2 = this.resultPosition("limit", limitObject instanceof ByteString ? BindingConstraint.INTEGER : BindingConstraint.CURSOR);
                this.jj_consume_token(67);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (limitObject instanceof Integer) {
            Object temp = limitObject;
            limitObject = limitObject2;
            limitObject2 = temp;
        }
        if (limitObject != null) {
            resultBuilder.setEndCursor((ByteString)limitObject);
        }
        if (limitObject2 != null) {
            resultBuilder.setLimit(((Integer)limitObject2).intValue());
        }
    }

    public final void offset(DatastoreV4.Query.Builder resultBuilder) throws ParseException {
        Object offsetCountObject = null;
        Object offsetObject = this.resultPosition("offset", BindingConstraint.CURSOR_OR_INTEGER);
        switch (this.jj_nt.kind) {
            case 68: {
                this.jj_consume_token(68);
                if (offsetObject instanceof Integer) {
                    this.throwParseException("Encountered \"+\" after integer offset.", new Object[0]);
                }
                offsetCountObject = this.resultPosition("offset", BindingConstraint.INTEGER);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        if (offsetObject instanceof Integer) {
            offsetCountObject = offsetObject;
            offsetObject = null;
        }
        if (offsetObject != null) {
            resultBuilder.setStartCursor((ByteString)offsetObject);
        }
        if (offsetCountObject != null) {
            resultBuilder.setOffset(((Integer)offsetCountObject).intValue());
        }
    }

    public final Object resultPosition(String descriptor, BindingConstraint bindingConstraint) throws ParseException {
        switch (this.jj_nt.kind) {
            case 49: {
                EntityV4.Value value = this.integerLiteral();
                if (bindingConstraint == BindingConstraint.CURSOR) {
                    this.throwParseException("Expected %s cursor instead of %s.", descriptor, this.token.image);
                }
                return this.interpretIntegerValueAsResultCount(descriptor, value);
            }
            case 57: 
            case 58: {
                DatastoreV4.GqlQueryArg arg = this.bindingSite(descriptor, bindingConstraint);
                if (arg.hasValue()) {
                    return this.interpretIntegerValueAsResultCount(descriptor, arg.getValue());
                }
                return arg.getCursor();
            }
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DatastoreV4.PropertyReference propertyReference() throws ParseException {
        String propertyName = this.name();
        return DatastoreV4.PropertyReference.newBuilder().setName(propertyName).build();
    }

    public final EntityV4.Value value() throws ParseException {
        switch (this.jj_nt.kind) {
            case 57: 
            case 58: {
                DatastoreV4.GqlQueryArg arg = this.bindingSite("value", BindingConstraint.VALUE);
                return arg.getValue();
            }
            case 55: {
                EntityV4.Value value = this.syntheticLiteral();
                return value;
            }
            case 53: 
            case 54: {
                EntityV4.Value value = this.stringLiteral();
                return value;
            }
            case 49: {
                EntityV4.Value value = this.integerLiteral();
                return value;
            }
            case 50: {
                Token literal = this.jj_consume_token(50);
                return this.interpretDoubleLiteral(literal.image);
            }
            case 41: {
                Token literal = this.jj_consume_token(41);
                this.checkAllowLiteral(literal.image);
                return EntityV4Helper.TRUE_VALUE;
            }
            case 20: {
                Token literal = this.jj_consume_token(20);
                this.checkAllowLiteral(literal.image);
                return EntityV4Helper.FALSE_VALUE;
            }
            case 32: {
                EntityV4.Value value = this.nullValue();
                return value;
            }
        }
        this.jj_la1[22] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final EntityV4.Value nullValue() throws ParseException {
        Token literal = this.jj_consume_token(32);
        this.checkAllowLiteral(literal.image);
        return EntityV4Helper.NULL_VALUE;
    }

    public final EntityV4.Value syntheticLiteral() throws ParseException {
        Function function;
        Token identifier = this.jj_consume_token(55);
        try {
            function = Function.valueOf(identifier.image.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            throw this.throwParseException("Unknown function \"%s\".", identifier.image);
        }
        this.checkAllowLiteral(identifier.image);
        this.jj_consume_token(66);
        EntityV4.Value result = this.syntheticLiteralContent(function);
        this.jj_consume_token(67);
        return result;
    }

    public final EntityV4.Value syntheticLiteralContent(Function function) throws ParseException {
        if (function == Function.KEY) {
            EntityV4.Value value = this.keySyntheticLiteralContent(this.defaultPartitionId);
            return value;
        }
        switch (this.jj_nt.kind) {
            case 53: 
            case 54: {
                EntityV4.Value value = this.stringLiteral();
                String string = value.getStringValue();
                switch (function) {
                    case BLOB: {
                        return this.interpretBlobText(string);
                    }
                    case BLOBKEY: {
                        return this.interpretBlobKeyText(string);
                    }
                    case DATETIME: {
                        return this.interpretDatetimeText(string);
                    }
                }
                throw this.throwParseException("Unimplemented function \"%s\".", new Object[]{function});
            }
        }
        this.jj_la1[23] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final EntityV4.Value keySyntheticLiteralContent(EntityV4.PartitionId defaultPartitionId) throws ParseException {
        EntityV4.Key.Builder keyBuilder = EntityV4.Key.newBuilder().setPartitionId(defaultPartitionId);
        EntityV4.PartitionId partitionId = this.partitionIdSubSyntheticLiteral(defaultPartitionId);
        keyBuilder.setPartitionId(partitionId);
        this.keyPath(keyBuilder);
        return EntityV4.Value.newBuilder().setKeyValue(keyBuilder.build()).build();
    }

    public final EntityV4.PartitionId partitionIdSubSyntheticLiteral(EntityV4.PartitionId defaultPartitionId) throws ParseException {
        EntityV4.PartitionId.Builder partitionIdBuilder = null;
        while (this.jj_2_3(2)) {
            Token identifier = this.jj_consume_token(55);
            if (partitionIdBuilder == null) {
                partitionIdBuilder = EntityV4.PartitionId.newBuilder();
            }
            boolean isDataset = identifier.image.equalsIgnoreCase("dataset");
            boolean isNamespace = identifier.image.equalsIgnoreCase("namespace");
            if (isDataset) {
                if (partitionIdBuilder.hasDatasetId()) {
                    this.throwParseException("A key may have at most one dataset.", new Object[0]);
                }
                if (partitionIdBuilder.hasNamespace()) {
                    this.throwParseException("A key's dataset must precede its namespace.", new Object[0]);
                }
            } else if (isNamespace) {
                if (partitionIdBuilder.hasNamespace()) {
                    this.throwParseException("A key may have at most one namespace.", new Object[0]);
                }
            } else {
                this.throwParseException("Unknown partition dimension \"%s\".", identifier.image);
            }
            this.jj_consume_token(66);
            EntityV4.Value nameValue = this.stringLiteral();
            String name = nameValue.getStringValue();
            if (isDataset) {
                partitionIdBuilder.setDatasetId(name);
            } else if (isNamespace) {
                partitionIdBuilder.setNamespace(name);
            }
            this.jj_consume_token(67);
            this.jj_consume_token(65);
        }
        if (partitionIdBuilder == null) {
            return defaultPartitionId;
        }
        if (!partitionIdBuilder.hasDatasetId()) {
            partitionIdBuilder.setDatasetId(defaultPartitionId.getDatasetId());
        }
        return partitionIdBuilder.build();
    }

    public final void keyPath(EntityV4.Key.Builder keyBuilder) throws ParseException {
        EntityV4.Key.PathElement keyPathElement = this.keyPathElement();
        keyBuilder.addPathElement(keyPathElement);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            keyPathElement = this.keyPathElement();
            keyBuilder.addPathElement(keyPathElement);
        }
    }

    public final EntityV4.Key.PathElement keyPathElement() throws ParseException {
        EntityV4.Key.PathElement.Builder keyPathElementBuilder = EntityV4.Key.PathElement.newBuilder();
        DatastoreV4.KindExpression kindExpression = this.kind();
        keyPathElementBuilder.setKind(kindExpression.getName());
        this.jj_consume_token(65);
        switch (this.jj_nt.kind) {
            case 49: {
                EntityV4.Value id = this.integerLiteral();
                keyPathElementBuilder.setId(id.getIntegerValue());
                break;
            }
            case 53: 
            case 54: {
                EntityV4.Value name = this.stringLiteral();
                keyPathElementBuilder.setName(name.getStringValue());
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return keyPathElementBuilder.build();
    }

    public final EntityV4.Value stringLiteral() throws ParseException {
        switch (this.jj_nt.kind) {
            case 53: {
                Token literal = this.jj_consume_token(53);
                return this.interpretStringLiteral(literal.image, '\'');
            }
            case 54: {
                Token literal = this.jj_consume_token(54);
                return this.interpretStringLiteral(literal.image, '\"');
            }
        }
        this.jj_la1[26] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final EntityV4.Value integerLiteral() throws ParseException {
        Token literal = this.jj_consume_token(49);
        return this.interpretIntegerLiteral(literal.image);
    }

    public final DatastoreV4.GqlQueryArg bindingSite(String descriptor, BindingConstraint bindingConstraint) throws ParseException {
        DatastoreV4.GqlQueryArg arg;
        Token site;
        switch (this.jj_nt.kind) {
            case 57: {
                site = this.jj_consume_token(57);
                arg = this.interpretBindingSiteWithName(site.image);
                break;
            }
            case 58: {
                site = this.jj_consume_token(58);
                arg = this.interpretBindingSiteWithNumber(site.image);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (bindingConstraint) {
            case VALUE: {
                if (arg.hasValue()) break;
                this.throwParseException("Binding site %s for %s bound to non-value argument.", site.image, descriptor);
                break;
            }
            case CURSOR: {
                if (arg.hasCursor()) break;
                this.throwParseException("Binding site %s for %s bound to non-cursor argument.", site.image, descriptor);
                break;
            }
            case INTEGER: {
                if (arg.hasValue()) break;
                this.throwParseException("Binding site %s for %s bound to non-value argument.", site.image, descriptor);
                break;
            }
            case CURSOR_OR_INTEGER: {
                if (arg.hasCursor() || arg.hasValue()) break;
                this.throwParseException("Binding site %s for %s bound to argument that is neither a cursor nor an integer value.", site.image, descriptor);
            }
        }
        if ((bindingConstraint == BindingConstraint.INTEGER || bindingConstraint == BindingConstraint.CURSOR_OR_INTEGER) && arg.hasValue() && !arg.getValue().hasIntegerValue()) {
            this.throwParseException("Binding site %s for %s bound to non-integer value argument.", site.image, descriptor);
        }
        return arg;
    }

    public final DatastoreV4.KindExpression kind() throws ParseException {
        String kindName = this.name();
        return DatastoreV4.KindExpression.newBuilder().setName(kindName).build();
    }

    public final String name() throws ParseException {
        switch (this.jj_nt.kind) {
            case 55: {
                Token identifier = this.jj_consume_token(55);
                return this.interpretUnquotedName(identifier.image);
            }
            case 56: {
                Token identifier = this.jj_consume_token(56);
                return this.interpretQuotedName(identifier.image);
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    private final boolean jj_3R_22() {
        return this.jj_scan_token(64);
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_9()) {
            return true;
        }
        return this.jj_scan_token(66);
    }

    private final boolean jj_3R_11() {
        return this.jj_3R_26();
    }

    private final boolean jj_3R_21() {
        return this.jj_scan_token(63);
    }

    private final boolean jj_3R_33() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_10() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_11()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_12()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_13()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_14()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_15()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_16()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_17()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_29() {
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_20() {
        return this.jj_scan_token(62);
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(53);
    }

    private final boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_19() {
        return this.jj_scan_token(61);
    }

    private final boolean jj_3R_17() {
        return this.jj_3R_29();
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        return this.jj_scan_token(66);
    }

    private final boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_19()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_20()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_21()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_22()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_23()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_24()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_18() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_16() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_31() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_9() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3R_30() {
        return this.jj_scan_token(57);
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(41);
    }

    private final boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_14() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_24() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_28();
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        return this.jj_scan_token(66);
    }

    private final boolean jj_3R_23() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3R_28() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_3R_8();
    }

    private final boolean jj_3R_12() {
        return this.jj_3R_27();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{262144, 262144, 0x200000, 0, 0x400000, 0, 0x20000000, 0, 128, 0x4804000, 0, 0x804000, 0x2800000, 0, 0, 0, 66560, 66560, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0x9800000, 0, 1024, 0, 8, 0, 2, 0, -268435456, 0x1800000, -268435456, -268435456, 0, 0x1800000, 0, 0, 0, 0, 109182976, 0, 0x6020000, 115737089, 0x600000, 0, 0x620000, 0x600000, 0x6000000, 0x1800000};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 2, 0, 2, 0, 0, 2, 0, 16, 0, 0, 0, 2, 0, 0, 0, 0};
    }

    public GqlParser(InputStream stream) {
        this(stream, null);
    }

    public GqlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new GqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public GqlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new GqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public GqlParser(GqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(GqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 29; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[69];
        for (i = 0; i < 69; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 29; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 69; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 3; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        GqlParser.jj_la1_0();
        GqlParser.jj_la1_1();
        GqlParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private static enum BindingConstraint {
        VALUE,
        CURSOR,
        INTEGER,
        CURSOR_OR_INTEGER;

    }

    private static enum Function {
        BLOB,
        BLOBKEY,
        DATETIME,
        KEY;

    }

    private static enum Aggregator {
        FIRST(DatastoreV4.PropertyExpression.AggregationFunction.FIRST);

        private DatastoreV4.PropertyExpression.AggregationFunction aggregationFunction;

        private Aggregator(DatastoreV4.PropertyExpression.AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
        }

        public DatastoreV4.PropertyExpression.AggregationFunction getAggregationFunction() {
            return this.aggregationFunction;
        }
    }
}

