/*
 * Decompiled with CFR 0.152.
 */
package mediautil.gen.directio;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import mediautil.gen.BasicIo;
import mediautil.gen.directio.ByteCounter;
import mediautil.gen.directio.IterativeReader;

public class SplitInputStream
extends FilterInputStream {
    private byte[] q;
    private static final int DEF_BUF_SIZE = 5120;
    private static final int DEF_INC_SIZE = 1024;
    private byte[] oneByteArr = new byte[1];
    private int bufSize;
    private int incSize;
    private int qEnd;
    private int q2nd;
    private boolean eofFlag;
    private int[] qPtrs;
    private int[] subReaderIds;
    private IterativeReader[] codes;
    private SubStream[] subStreams;
    private byte[] requestBuf;
    private int requestPos;
    private int requestRemain;
    private int curReaderId;
    private int maxReaderId;
    private int maxBufSize;
    private int maxBufUsage;
    private boolean isSkipCall = false;

    private int dequeue(int readerNo, byte[] b, int off, int n) {
        int qReadSize = this.qEnd - this.qPtrs[readerNo];
        if (qReadSize > n) {
            qReadSize = n;
        }
        if (qReadSize > 0) {
            if (b != null) {
                System.arraycopy(this.q, this.qPtrs[readerNo], b, off, qReadSize);
            }
            int n2 = readerNo;
            this.qPtrs[n2] = this.qPtrs[n2] + qReadSize;
        } else {
            qReadSize = 0;
        }
        return qReadSize;
    }

    private void reallocBuf(int newLen) {
        int offset = this.findQBegin(null);
        byte[] newQ = new byte[newLen];
        int copyLen = this.qEnd - offset;
        if (copyLen > 0) {
            System.arraycopy(this.q, offset, newQ, 0, copyLen);
        } else {
            offset = this.qEnd;
        }
        this.q = newQ;
        int i = 0;
        while (i < this.qPtrs.length) {
            int n = i++;
            this.qPtrs[n] = this.qPtrs[n] - offset;
        }
        this.qEnd -= offset;
        this.q2nd -= offset;
        if (newLen > this.maxBufSize) {
            this.maxBufSize = newLen;
        }
    }

    private int fillAndDequeue(int readerNo, byte[] b, int off, int len) throws IOException {
        int qReadSize = this.dequeue(readerNo, b, off, len);
        int remain = len - qReadSize;
        off += qReadSize;
        int qPtr = this.qPtrs[readerNo];
        if (remain > 0 && !this.eofFlag) {
            int actualRead;
            int readLen;
            int skipLen = qPtr - this.qEnd;
            int fillSize = remain + skipLen;
            int reqSize = fillSize + (this.qEnd - this.q2nd);
            if (this.q2nd < qPtr) {
                skipLen = this.q2nd - this.qEnd;
            }
            if (this.q2nd > this.qEnd && fillSize > this.bufSize && (reqSize <= this.bufSize || (reqSize - this.bufSize - 1) / this.incSize < (fillSize - this.bufSize - 1) / this.incSize)) {
                int dFillLen;
                int newQStart = qPtr + remain;
                if (newQStart > this.q2nd) {
                    newQStart = this.q2nd;
                }
                int dRemain = dFillLen = newQStart - this.qEnd;
                readLen = 0;
                if (this.requestBuf != null && (readLen = this.requestRemain) > dRemain) {
                    readLen = dRemain;
                }
                if (readLen > 0) {
                    int xferLen;
                    actualRead = BasicIo.read(this.in, this.requestBuf, this.requestPos, readLen, readLen);
                    if (actualRead < readLen) {
                        this.eofFlag = true;
                    }
                    if ((xferLen = actualRead - skipLen) > 0) {
                        if (b != null) {
                            System.arraycopy(this.requestBuf, this.requestPos + skipLen, b, off, xferLen);
                        }
                        skipLen = 0;
                        off += xferLen;
                        remain -= xferLen;
                    } else {
                        skipLen = -xferLen;
                    }
                    dRemain -= actualRead;
                }
                if (skipLen > 0 && !this.eofFlag) {
                    actualRead = (int)BasicIo.skip(this.in, skipLen);
                    if (actualRead < skipLen) {
                        this.eofFlag = true;
                    }
                    skipLen -= actualRead;
                    dRemain -= actualRead;
                }
                if (dRemain > 0 && !this.eofFlag) {
                    actualRead = b != null ? BasicIo.read(this.in, b, off, dRemain, dRemain) : (int)BasicIo.skip(this.in, dRemain);
                    if (actualRead < dRemain) {
                        this.eofFlag = true;
                    }
                    off += actualRead;
                    remain -= actualRead;
                    dRemain -= actualRead;
                }
                readLen = dFillLen - dRemain;
                this.qEnd += readLen;
                if (readLen > this.requestRemain) {
                    readLen = this.requestRemain;
                }
                this.requestPos += readLen;
                this.requestRemain -= readLen;
                qPtr += len - qReadSize - remain;
            }
            if (this.requestBuf == null && skipLen > 0 && !this.eofFlag) {
                actualRead = (int)BasicIo.skip(this.in, skipLen);
                if (actualRead < skipLen) {
                    this.eofFlag = true;
                }
                if ((readLen = this.requestRemain) > actualRead) {
                    readLen = actualRead;
                }
                this.requestPos += readLen;
                this.requestRemain -= readLen;
                this.qEnd += actualRead;
            }
            this.qPtrs[readerNo] = qPtr;
            if (remain > 0 && !this.eofFlag) {
                int newQBegin = this.q2nd;
                if (this.qEnd < this.q2nd) {
                    newQBegin = this.qEnd;
                }
                if ((reqSize = (fillSize = remain + (qPtr - this.qEnd)) + (this.qEnd - newQBegin)) > this.maxBufUsage) {
                    this.maxBufUsage = reqSize;
                }
                if (reqSize > this.q.length) {
                    this.reallocBuf(reqSize + this.incSize - 1 - (reqSize - 1 - this.bufSize) % this.incSize);
                } else {
                    if (this.qEnd > newQBegin && newQBegin > 0) {
                        System.arraycopy(this.q, newQBegin, this.q, 0, this.qEnd - newQBegin);
                    }
                    int i = 0;
                    do {
                        int n = i++;
                        this.qPtrs[n] = this.qPtrs[n] - newQBegin;
                    } while (i < this.qPtrs.length);
                    this.qEnd -= newQBegin;
                    this.q2nd -= newQBegin;
                }
                int maxFillSize = this.bufSize - this.qEnd;
                if (maxFillSize < fillSize) {
                    maxFillSize = fillSize;
                }
                if ((actualRead = BasicIo.read(this.in, this.q, this.qEnd, fillSize, maxFillSize)) < fillSize) {
                    this.eofFlag = true;
                }
                if ((readLen = this.requestRemain) > actualRead) {
                    readLen = actualRead;
                }
                if (readLen > 0) {
                    if (this.requestBuf != null) {
                        System.arraycopy(this.q, this.qEnd, this.requestBuf, this.requestPos, readLen);
                    }
                    this.requestPos += readLen;
                    this.requestRemain -= readLen;
                }
                this.qEnd += actualRead;
                remain -= this.dequeue(readerNo, b, off, remain);
            }
        }
        return len - remain;
    }

    private int findQBegin(int[] qBeginIndex) {
        int qBegin;
        int index = -1;
        if (this.qPtrs.length == 0) {
            qBegin = 0;
        } else {
            qBegin = Integer.MAX_VALUE;
            int i = 0;
            do {
                if (this.qPtrs[i] >= qBegin) continue;
                qBegin = this.qPtrs[i];
                index = i;
            } while (++i < this.qPtrs.length);
        }
        if (qBeginIndex != null) {
            qBeginIndex[0] = index;
        }
        return qBegin;
    }

    private void init(InputStream mainStream, int bufSize, int incSize) {
        if (bufSize < 2048) {
            bufSize = 2048;
        }
        if (incSize < 512) {
            incSize = 512;
        }
        this.bufSize = bufSize;
        this.maxBufSize = bufSize;
        this.incSize = incSize;
        this.qPtrs = new int[1];
        this.qPtrs[0] = 0;
        this.qEnd = 0;
        this.q = null;
        this.eofFlag = false;
        this.subReaderIds = new int[0];
        this.subStreams = new SubStream[0];
        this.codes = new IterativeReader[0];
        this.curReaderId = -1;
        this.maxReaderId = 0;
    }

    public SplitInputStream(InputStream mainStream, int bufSize, int incSize) {
        super(mainStream);
        this.init(mainStream, bufSize, incSize);
    }

    public SplitInputStream(InputStream mainStream) {
        this(mainStream, 5120, 1024);
    }

    public InputStream createSubStream(int minReadSize, int readCushion) {
        if (minReadSize < 512) {
            minReadSize = 512;
        }
        if (readCushion < 512) {
            readCushion = 512;
        }
        return new SubStream(this, minReadSize, readCushion);
    }

    public InputStream createSubStream() {
        return new SubStream(this);
    }

    public int attachSubReader(IterativeReader code, InputStream subStream) {
        int retVal;
        String err = null;
        SubStream sub = null;
        if (code == null) {
            throw new NullPointerException("code is NULL");
        }
        if (!(subStream instanceof SubStream)) {
            err = "subStream passed was not created using createSubStream call";
        } else {
            sub = (SubStream)subStream;
            if (sub.parentThis != this) {
                err = "subStream was created from another SplitInputStream instance";
            } else if (sub.readerNo > 0 || sub.readerId > 0) {
                err = "subStream already in use";
            }
        }
        if (err != null) {
            throw new RuntimeException(err);
        }
        int minBufSize = sub.minReadSize + sub.readCushion + 512;
        if (minBufSize > this.bufSize) {
            if (this.q != null) {
                this.reallocBuf(minBufSize);
            }
            this.bufSize = minBufSize;
        }
        int[] newSubReaderIds = new int[this.subReaderIds.length + 1];
        IterativeReader[] newCodes = new IterativeReader[this.codes.length + 1];
        SubStream[] newSubStreams = new SubStream[this.subStreams.length + 1];
        System.arraycopy(this.subReaderIds, 0, newSubReaderIds, 0, this.subReaderIds.length);
        System.arraycopy(this.codes, 0, newCodes, 0, this.codes.length);
        System.arraycopy(this.subStreams, 0, newSubStreams, 0, this.subStreams.length);
        newCodes[this.codes.length] = code;
        newSubStreams[this.subStreams.length] = sub;
        ++this.maxReaderId;
        newSubReaderIds[this.subReaderIds.length] = retVal = this.maxReaderId;
        sub.readerNo = newSubStreams.length;
        sub.readerId = retVal;
        int[] newQPtrs = new int[this.qPtrs.length + 1];
        System.arraycopy(this.qPtrs, 0, newQPtrs, 0, this.qPtrs.length);
        newQPtrs[this.qPtrs.length] = this.findQBegin(null);
        this.qPtrs = newQPtrs;
        this.subReaderIds = newSubReaderIds;
        this.codes = newCodes;
        this.subStreams = newSubStreams;
        return retVal;
    }

    public void detachSubReader(int subReaderId) {
        int i;
        for (i = 0; i < this.subReaderIds.length && this.subReaderIds[i] != subReaderId; ++i) {
        }
        if (i >= this.subReaderIds.length) {
            int n = subReaderId;
            throw new RuntimeException(new StringBuilder(69).append("SubReaderId ").append(n).append(" Not found for detaching from SplitInputStream").toString());
        }
        this.detachSubReaderNo(i);
    }

    private void detachSubReaderNo(int subReaderNo) {
        int i;
        int readerNo = subReaderNo + 1;
        this.codes[subReaderNo] = null;
        SubStream detachedStream = this.subStreams[subReaderNo];
        detachedStream.readerNo = -1;
        detachedStream.readerId = 0;
        detachedStream.closedFlag = true;
        this.subStreams[subReaderNo] = null;
        int[] newSubReaderIds = new int[this.subReaderIds.length - 1];
        IterativeReader[] newCodes = new IterativeReader[this.codes.length - 1];
        SubStream[] newSubStreams = new SubStream[this.subStreams.length - 1];
        System.arraycopy(this.subReaderIds, 0, newSubReaderIds, 0, subReaderNo);
        System.arraycopy(this.codes, 0, newCodes, 0, subReaderNo);
        System.arraycopy(this.subStreams, 0, newSubStreams, 0, subReaderNo);
        System.arraycopy(this.subReaderIds, subReaderNo + 1, newSubReaderIds, subReaderNo, newSubReaderIds.length - subReaderNo);
        System.arraycopy(this.codes, subReaderNo + 1, newCodes, subReaderNo, newCodes.length - subReaderNo);
        System.arraycopy(this.subStreams, subReaderNo + 1, newSubStreams, subReaderNo, newSubStreams.length - subReaderNo);
        int[] newQPtrs = new int[this.qPtrs.length - 1];
        int j = 0;
        for (i = 0; i < this.qPtrs.length; ++i) {
            if (i == readerNo) continue;
            newQPtrs[j] = this.qPtrs[i];
            ++j;
        }
        this.codes = newCodes;
        this.subStreams = newSubStreams;
        this.qPtrs = newQPtrs;
        this.subReaderIds = newSubReaderIds;
        for (i = 0; i < this.subStreams.length; ++i) {
            if (this.subStreams[i].readerNo <= readerNo) continue;
            this.subStreams[i].readerNo--;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int remain;
        int qReadSize;
        boolean isSkip = this.isSkipCall;
        this.isSkipCall = false;
        if (!isSkip) {
            if (len < 0) {
                int n = len;
                throw new IndexOutOfBoundsException(new StringBuilder(49).append("Negative Length Read attempted, len = ").append(n).toString());
            }
            byte b1 = b[off];
            byte by = b[off + len - 1];
        }
        if (len <= 0) {
            return 0;
        }
        if (this.q == null) {
            this.q = new byte[this.bufSize];
        }
        if ((qReadSize = this.qEnd - this.qPtrs[0]) > (remain = len)) {
            qReadSize = remain;
        }
        if (qReadSize > 0) {
            if (b != null) {
                System.arraycopy(this.q, this.qPtrs[0], b, off, qReadSize);
            }
            remain -= qReadSize;
            off += qReadSize;
        }
        this.qPtrs[0] = this.qPtrs[0] + len;
        this.requestBuf = b;
        this.requestPos = off;
        this.requestRemain = remain;
        int[] indexArr = null;
        this.maxBufUsage = 0;
        while (!(this.requestRemain <= 0 || this.qPtrs.length <= 1 && this.eofFlag)) {
            int i;
            if (indexArr == null) {
                indexArr = new int[1];
            }
            int newQBegin = this.findQBegin(indexArr);
            int newQ2nd = Integer.MAX_VALUE;
            int newQBeginIndex = indexArr[0];
            int newQ2ndIndex = 0;
            if (this.qPtrs.length > 1) {
                i = 0;
                do {
                    int testPtr;
                    if (i == newQBeginIndex || (testPtr = this.qPtrs[i]) > newQ2nd) continue;
                    newQ2nd = testPtr;
                    newQ2ndIndex = i;
                } while (++i < this.qPtrs.length);
            }
            if (newQBegin >= this.qEnd) {
                i = 0;
                if (this.eofFlag) {
                    do {
                        IterativeReader reader = this.codes[0];
                        SubStream stream = this.subStreams[0];
                        this.curReaderId = this.subReaderIds[0];
                        reader.nextRead(stream.minReadSize);
                        this.curReaderId = -1;
                        if (stream.closedFlag) continue;
                        this.detachSubReaderNo(0);
                    } while (this.codes.length > 0);
                    continue;
                }
                remain = this.requestRemain;
                this.requestRemain = 0;
                this.qPtrs[0] = this.qPtrs[0] - remain;
                qReadSize = this.bufSize;
                if (qReadSize > remain) {
                    qReadSize = remain;
                }
                this.q2nd = newQBegin;
                qReadSize = this.fillAndDequeue(0, b, this.requestPos, qReadSize);
                this.requestPos += qReadSize;
                this.requestRemain = remain - qReadSize;
                if (this.eofFlag) continue;
                this.qPtrs[0] = this.qPtrs[0] + this.requestRemain;
                continue;
            }
            this.q2nd = newQ2nd;
            int headStreamNo = newQBeginIndex - 1;
            IterativeReader headReader = this.codes[headStreamNo];
            SubStream headStream = this.subStreams[headStreamNo];
            int numBytes = this.qEnd - newQBegin - headStream.readCushion;
            SubStream nextStream = null;
            if (newQ2ndIndex > 0) {
                nextStream = this.subStreams[newQ2ndIndex - 1];
            }
            if (numBytes < headStream.minReadSize || newQ2ndIndex == 0 || this.qEnd - newQ2nd - nextStream.readCushion < nextStream.minReadSize) {
                numBytes += this.bufSize - (this.qEnd - newQ2nd);
            }
            this.curReaderId = this.subReaderIds[headStreamNo];
            int readerStatus = headReader.nextRead(numBytes);
            this.curReaderId = -1;
            if (headStream.closedFlag || readerStatus == 0) continue;
            this.detachSubReaderNo(headStreamNo);
        }
        if (this.q.length > this.bufSize && this.maxBufUsage > 0 && this.q.length - this.maxBufUsage >= this.incSize) {
            int resizeLen = this.bufSize;
            if (this.maxBufUsage > this.bufSize) {
                resizeLen = this.maxBufUsage + (this.incSize - 1 - (this.maxBufUsage - 1 - this.bufSize) % this.incSize);
            }
            this.reallocBuf(resizeLen);
        }
        int retVal = len - this.requestRemain;
        this.requestBuf = null;
        this.requestRemain = 0;
        if (retVal == 0) {
            retVal = -1;
        }
        return retVal;
    }

    @Override
    public int read() throws IOException {
        int retVal = -1;
        if (this.read(this.oneByteArr, 0, 1) == 1) {
            retVal = this.oneByteArr[0] & 0xFF;
        }
        return retVal;
    }

    @Override
    public long skip(long n) throws IOException {
        long retVal = n;
        if (retVal < 0L) {
            retVal = 0L;
        }
        if (retVal > 0L) {
            this.isSkipCall = true;
            if ((retVal = (long)this.read(null, 0, (int)retVal)) < 0L) {
                retVal = 0L;
            }
        }
        return retVal;
    }

    @Override
    public int available() {
        int retVal = this.qEnd - this.qPtrs[0];
        if (retVal <= 0) {
            retVal = this.eofFlag ? 0 : 1;
        }
        return retVal;
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public void wrapup() throws IOException {
        while (this.codes.length > 0) {
            this.skip(100000L);
        }
        this.q = null;
    }

    static /* synthetic */ byte[] access$102(SplitInputStream x0, byte[] x1) {
        x0.q = x1;
        return x1;
    }

    private class SubStream
    extends InputStream
    implements ByteCounter {
        public SplitInputStream parentThis;
        private byte[] oneByteArr = new byte[1];
        private int readerNo;
        private int readerId;
        public int minReadSize;
        public int readCushion;
        public boolean closedFlag;
        private int[] counterArr;
        private boolean upMode;
        private long totalBytes;

        public SubStream(SplitInputStream parentThis, int minReadSize, int readCushion) {
            this.parentThis = parentThis;
            this.readCushion = readCushion;
            this.minReadSize = minReadSize;
            this.closedFlag = false;
            this.readerNo = -1;
            this.readerId = 0;
            this.totalBytes = 0L;
            this.counterArr = null;
        }

        public SubStream(SplitInputStream parentThis) {
            this(parentThis, 750, 750);
        }

        @Override
        public void setCounter(int[] counterArr, boolean upMode) {
            int i = counterArr[0];
            this.counterArr = counterArr;
            this.upMode = upMode;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        private String validate() {
            String retVal = null;
            if (!this.closedFlag) {
                if (this.readerNo < 0) {
                    retVal = "Attempt to read from an invalid or unattached substream";
                } else if (this.readerId != SplitInputStream.this.curReaderId) {
                    int n = SplitInputStream.this.curReaderId;
                    int n2 = this.readerId;
                    retVal = new StringBuilder(120).append("Substream Context Error: Iterative code attached as id ").append(n).append(" attempting to read from substream with id ").append(n2).toString();
                }
            }
            return retVal;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n;
            String ioError = null;
            if (!this.closedFlag) {
                if (this.readerNo < 0) {
                    ioError = "Attempt to read from an invalid or unattached substream";
                } else if (this.readerId != SplitInputStream.this.curReaderId) {
                    n = SplitInputStream.this.curReaderId;
                    int n2 = this.readerId;
                    ioError = new StringBuilder(120).append("Substream Context Error: Iterative code attached as id ").append(n).append(" attempting to read from substream with id ").append(n2).toString();
                }
                if (ioError != null) {
                    throw new IOException(ioError);
                }
            }
            if (len < 0) {
                n = len;
                throw new IndexOutOfBoundsException(new StringBuilder(49).append("Negative Length Read attempted, len = ").append(n).toString());
            }
            byte b1 = b[off];
            byte b2 = b[off + len - 1];
            if (len == 0) {
                return 0;
            }
            if (this.closedFlag) {
                return -1;
            }
            if (SplitInputStream.this.q == null) {
                SplitInputStream.access$102(SplitInputStream.this, new byte[SplitInputStream.this.bufSize]);
            }
            int remain = len;
            int qReadSize = SplitInputStream.this.qEnd - SplitInputStream.this.qPtrs[this.readerNo];
            if (qReadSize > len) {
                qReadSize = len;
            }
            if (qReadSize > 0) {
                System.arraycopy(SplitInputStream.this.q, SplitInputStream.this.qPtrs[this.readerNo], b, off, qReadSize);
                int[] nArray = SplitInputStream.this.qPtrs;
                int n3 = this.readerNo;
                nArray[n3] = nArray[n3] + qReadSize;
                off += qReadSize;
                remain -= qReadSize;
            }
            int retVal = len;
            if (remain > 0) {
                if (!SplitInputStream.this.eofFlag) {
                    remain -= SplitInputStream.this.fillAndDequeue(this.readerNo, b, off, remain);
                }
                if ((retVal -= remain) <= 0) {
                    retVal = -1;
                    SplitInputStream.this.detachSubReaderNo(this.readerNo - 1);
                }
            }
            if (retVal > 0) {
                this.totalBytes += (long)retVal;
                if (this.counterArr != null) {
                    this.counterArr[0] = this.upMode ? this.counterArr[0] + retVal : this.counterArr[0] - retVal;
                }
            }
            return retVal;
        }

        @Override
        public int read() throws IOException {
            int retVal = -1;
            if (this.read(this.oneByteArr, 0, 1) == 1) {
                retVal = this.oneByteArr[0] & 0xFF;
            }
            return retVal;
        }

        @Override
        public long skip(long n) throws IOException {
            String ioError = this.validate();
            if (ioError != null) {
                throw new IOException(ioError);
            }
            int retVal = (int)n;
            if (this.closedFlag || retVal < 0) {
                retVal = 0;
            }
            int[] nArray = SplitInputStream.this.qPtrs;
            int n2 = this.readerNo;
            nArray[n2] = nArray[n2] + retVal;
            this.totalBytes += (long)retVal;
            if (this.counterArr != null) {
                this.counterArr[0] = this.upMode ? this.counterArr[0] + retVal : this.counterArr[0] - retVal;
            }
            return retVal;
        }

        @Override
        public int available() throws IOException {
            String ioError = this.validate();
            if (ioError != null) {
                throw new IOException(ioError);
            }
            int retVal = 0;
            if (!this.closedFlag && (retVal = SplitInputStream.this.qEnd - SplitInputStream.this.qPtrs[this.readerNo]) <= 0) {
                retVal = SplitInputStream.this.eofFlag ? 0 : 1;
            }
            return retVal;
        }

        @Override
        public void close() throws IOException {
            String ioError = this.validate();
            if (ioError != null) {
                throw new IOException(ioError);
            }
            if (this.readerNo > 0) {
                SplitInputStream.this.detachSubReaderNo(this.readerNo - 1);
            }
        }
    }
}

