/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationResult;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.CloudDatastoreV1ServiceValidator;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.DatastoreServiceProtoConverter;
import com.google.apphosting.datastore.shared.EntityProtoConverter;
import com.google.apphosting.datastore.shared.EntityV1Validator;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.UserValueObfuscator;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ServiceProvider(value=LocalRpcService.class)
public class LocalCloudDatastoreV1Service
extends AbstractLocalRpcService {
    public static final String PACKAGE = "cloud_datastore_v1";
    public static final EntityProtoConverter.IdResolver RESOLVER = new EntityProtoConverter.IdResolver(){

        @Override
        public String resolveAppId(String projectId) throws InvalidConversionException {
            if (projectId.isEmpty()) {
                return ApiProxy.getCurrentEnvironment().getAppId();
            }
            return DatastoreHelper.projectIdToApp(this.getCluster(), projectId);
        }

        @Override
        public String resolveProjectId(String appId) {
            String cluster = this.getCluster();
            Preconditions.checkArgument((cluster == null || appId.startsWith(cluster) ? 1 : 0) != 0);
            return DatastoreHelper.appToProjectId(appId);
        }

        private String getCluster() {
            return DatastoreHelper.getCluster(ApiProxy.getCurrentEnvironment().getAppId());
        }
    };
    private static final Collection<OnestoreEntity.CompositeIndex> EMPTY_INDEX_COLLECTION = Collections.emptySet();
    private static final boolean NO_IN_MEMORY_OPERATIONS = false;
    static final EntityProtoConverter LOCAL_ENTITY_CONVERTER = new EntityProtoConverter(false, UserValueObfuscator.IDENTITY);
    static final DatastoreServiceProtoConverter LOCAL_SERVICE_CONVERTER = new DatastoreServiceProtoConverter(new DatastoreProtoConverter(LOCAL_ENTITY_CONVERTER)){

        @Override
        public DatastorePb.Transaction toV3Transaction(ByteString transactionBytes, String app) throws InvalidConversionException {
            try {
                return (DatastorePb.Transaction)DatastorePb.Transaction.PARSER.parseFrom(transactionBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toTransactionBytes(DatastorePb.Transaction transactionV3) {
            return transactionV3.toByteString();
        }

        @Override
        public DatastorePb.Cursor toV3Cursor(ByteString queryHandleV4) throws InvalidConversionException {
            try {
                return (DatastorePb.Cursor)DatastorePb.Cursor.PARSER.parseFrom(queryHandleV4);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toV4QueryHandle(DatastorePb.Cursor cursorV3) {
            return cursorV3.toByteString();
        }
    };
    private static final CloudDatastoreV1ServiceValidator LOCAL_VALIDATOR = new CloudDatastoreV1ServiceValidator(new CloudDatastoreV1Validator(new EntityV1Validator(Config.DatastoreConfig.getDefaultInstance())));

    public String getPackage() {
        return PACKAGE;
    }

    public AllocateIdsResponse allocateIds(LocalRpcService.Status status, AllocateIdsRequest req) {
        DatastorePb.AllocateIdsResponse respV3;
        AllocateIdsResponse.Builder respBuilder = AllocateIdsResponse.newBuilder();
        try {
            LOCAL_VALIDATOR.validateAllocateIdsRequest((AllocateIdsRequestOrBuilder)req);
            DatastorePb.AllocateIdsRequest reqV3 = new DatastorePb.AllocateIdsRequest();
            reqV3.setSize((long)req.getKeysCount());
            respV3 = (DatastorePb.AllocateIdsResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.AllocateIds, (MessageLite)reqV3, DatastorePb.AllocateIdsResponse.PARSER);
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        if (respV3.getEnd() - respV3.getStart() + 1L < (long)req.getKeysCount()) {
            throw new ApiProxy.ApplicationException(1, "could not allocate sufficent ids");
        }
        long i = respV3.getStart();
        for (Key reqKey : req.getKeysList()) {
            Key.Builder respKey = Key.newBuilder().mergeFrom(reqKey);
            respKey.getPathBuilder(respKey.getPathCount() - 1).setId(LocalDatastoreService.toScatteredId(i++));
            respBuilder.addKeys(respKey);
        }
        return respBuilder.build();
    }

    public BeginTransactionResponse beginTransaction(LocalRpcService.Status status, BeginTransactionRequest req) {
        DatastorePb.Transaction internalResp;
        try {
            DatastorePb.BeginTransactionRequest reqV3 = new DatastorePb.BeginTransactionRequest().setApp(LocalCloudDatastoreV1Service.getAppId()).setAllowMultipleEg(true);
            internalResp = (DatastorePb.Transaction)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)reqV3, DatastorePb.Transaction.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return LOCAL_SERVICE_CONVERTER.toV1BeginTransactionResponse(internalResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    public CommitResponse commit(LocalRpcService.Status status, CommitRequest req) {
        CommitResponse.Builder builder = CommitResponse.newBuilder();
        try {
            LOCAL_VALIDATOR.validateCommitRequest(false, (CommitRequestOrBuilder)req);
            boolean hasTransaction = !req.getTransaction().isEmpty();
            ByteString transaction = hasTransaction ? req.getTransaction() : null;
            this.applyMutationList(req.getMutationsList(), transaction, builder);
            if (hasTransaction) {
                DatastorePb.CommitResponse commitRes = (DatastorePb.CommitResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3Transaction(req.getTransaction(), LocalCloudDatastoreV1Service.getAppId()), DatastorePb.CommitResponse.PARSER);
                builder.setIndexUpdates(builder.getIndexUpdates() + commitRes.getCost().getIndexWrites());
            }
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        return builder.build();
    }

    public RollbackResponse rollback(LocalRpcService.Status status, RollbackRequest req) {
        try {
            LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Rollback, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3Transaction((RollbackRequestOrBuilder)req, LocalCloudDatastoreV1Service.getAppId()), ApiBasePb.VoidProto.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        return RollbackResponse.getDefaultInstance();
    }

    public LookupResponse get(LocalRpcService.Status status, LookupRequest request) {
        return this.lookup(status, request);
    }

    public LookupResponse lookup(LocalRpcService.Status status, LookupRequest request) {
        DatastorePb.GetResponse internResp;
        try {
            LOCAL_VALIDATOR.validateLookupRequest((LookupRequestOrBuilder)request);
            internResp = (DatastorePb.GetResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3GetRequest(RESOLVER, (LookupRequestOrBuilder)request, LocalCloudDatastoreV1Service.getAppId()), DatastorePb.GetResponse.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return LOCAL_SERVICE_CONVERTER.toV1LookupResponse(RESOLVER, internResp).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    private RunQueryRequest normalizeRunQueryRequest(RunQueryRequest request) throws ValidationException, InvalidConversionException {
        if (request.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.GQL_QUERY) {
            LOCAL_VALIDATOR.getDatastoreV1Validator().validateGqlQuery((GqlQueryOrBuilder)request.getGqlQuery());
            request = RunQueryRequest.newBuilder((RunQueryRequest)request).setQuery(LOCAL_SERVICE_CONVERTER.getDatastoreProtoConverter().toV1Query((GqlQueryOrBuilder)request.getGqlQuery(), request.getPartitionId())).clearGqlQuery().build();
        }
        return request;
    }

    public RunQueryResponse runQuery(LocalRpcService.Status status, RunQueryRequest request) {
        DatastorePb.QueryResult internResp;
        RunQueryRequest normalizedRequest;
        try {
            normalizedRequest = this.normalizeRunQueryRequest(request);
            LOCAL_VALIDATOR.validateRunQueryRequest(normalizedRequest);
            internResp = (DatastorePb.QueryResult)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.RunQuery, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3Query(RESOLVER, (RunQueryRequestOrBuilder)normalizedRequest, false, EMPTY_INDEX_COLLECTION), DatastorePb.QueryResult.PARSER);
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        catch (ValidationException e) {
            throw new ApiProxy.ApplicationException(1, e.getMessage());
        }
        try {
            return LOCAL_SERVICE_CONVERTER.toV1RunQueryResponse(RESOLVER, internResp, request.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.GQL_QUERY ? normalizedRequest.getQuery() : null).build();
        }
        catch (InvalidConversionException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
    }

    private int insert(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn) throws InvalidConversionException {
        if (txn == null) {
            txn = (DatastorePb.Transaction)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)new DatastorePb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastorePb.Transaction.PARSER);
            this.insert(entity, txn);
            return ((DatastorePb.CommitResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)txn, DatastorePb.CommitResponse.PARSER)).getCost().getIndexWrites();
        }
        DatastorePb.GetRequest get = new DatastorePb.GetRequest().setTransaction(txn);
        get.addKey(entity.getKey());
        DatastorePb.GetResponse res = (DatastorePb.GetResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)get, DatastorePb.GetResponse.PARSER);
        if (res.getEntity(0).hasEntity()) {
            throw new ApiProxy.ApplicationException(1, "entity already exists");
        }
        DatastorePb.PutRequest put = new DatastorePb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return ((DatastorePb.PutResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)put, DatastorePb.PutResponse.PARSER)).getCost().getIndexWrites();
    }

    private int update(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn) throws InvalidConversionException {
        if (txn == null) {
            txn = (DatastorePb.Transaction)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)new DatastorePb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastorePb.Transaction.PARSER);
            this.update(entity, txn);
            return ((DatastorePb.CommitResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)txn, DatastorePb.CommitResponse.PARSER)).getCost().getIndexWrites();
        }
        DatastorePb.GetRequest get = new DatastorePb.GetRequest().setTransaction(txn);
        get.addKey(entity.getKey());
        DatastorePb.GetResponse res = (DatastorePb.GetResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)get, DatastorePb.GetResponse.PARSER);
        if (!res.getEntity(0).hasEntity()) {
            throw new ApiProxy.ApplicationException(1, "entity does not exist");
        }
        DatastorePb.PutRequest put = new DatastorePb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return ((DatastorePb.PutResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)put, DatastorePb.PutResponse.PARSER)).getCost().getIndexWrites();
    }

    private void applyMutationList(List<Mutation> mutationList, ByteString v1Txn, CommitResponse.Builder response) throws InvalidConversionException {
        EntityProtoConverter entityConverter = LOCAL_SERVICE_CONVERTER.getDatastoreProtoConverter().getEntityConverter();
        DatastorePb.Transaction txn = v1Txn == null ? null : LOCAL_SERVICE_CONVERTER.toV3Transaction(v1Txn, LocalCloudDatastoreV1Service.getAppId());
        int indexUpdates = 0;
        DatastorePb.PutRequest putReq = new DatastorePb.PutRequest();
        DatastorePb.DeleteRequest deleteReq = new DatastorePb.DeleteRequest();
        if (txn != null) {
            putReq.setTransaction(txn);
            deleteReq.setTransaction(txn);
        }
        int mutationIndex = 0;
        ArrayList putReqMutationIdx = Lists.newArrayList();
        for (Mutation mutation : mutationList) {
            switch (mutation.getOp()) {
                case INSERT: {
                    if (!Paths.hasIncompleteLastElement(mutation.getEntity().getKey())) {
                        indexUpdates += this.insert(entityConverter.toV3Entity(RESOLVER, (EntityOrBuilder)mutation.getEntity()), txn);
                        break;
                    }
                }
                case UPSERT: {
                    putReqMutationIdx.add(mutationIndex);
                    putReq.addEntity(entityConverter.toV3Entity(RESOLVER, (EntityOrBuilder)mutation.getEntity()));
                    break;
                }
                case UPDATE: {
                    indexUpdates += this.update(entityConverter.toV3Entity(RESOLVER, (EntityOrBuilder)mutation.getEntity()), txn);
                    break;
                }
                case DELETE: {
                    deleteReq.addKey(entityConverter.toV3Reference((EntityProtoConverter.AppIdResolver)RESOLVER, (KeyOrBuilder)mutation.getKey()));
                    break;
                }
                default: {
                    throw new Error("Unexpected mutation operation.");
                }
            }
            ++mutationIndex;
        }
        DatastorePb.PutResponse putResp = (DatastorePb.PutResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)putReq, DatastorePb.PutResponse.PARSER);
        indexUpdates += putResp.getCost().getIndexWrites();
        indexUpdates += ((DatastorePb.DeleteResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Delete, (MessageLite)deleteReq, DatastorePb.DeleteResponse.PARSER)).getCost().getIndexWrites();
        Iterator putReqMutationIdxIt = putReqMutationIdx.iterator();
        MutationResult emptyMutation = MutationResult.getDefaultInstance();
        for (OnestoreEntity.Reference autoIdKeyResp : putResp.keys()) {
            int mutListIdx = (Integer)putReqMutationIdxIt.next();
            int emptyResultsToAdd = mutListIdx - response.getMutationResultsCount();
            response.addAllMutationResults(Collections.nCopies(emptyResultsToAdd, emptyMutation));
            MutationResult.Builder resultBuilder = response.addMutationResultsBuilder();
            if (!Paths.hasIncompleteLastElement(mutationList.get(mutListIdx).getEntity().getKey())) continue;
            resultBuilder.setKey(entityConverter.toV1Key((EntityProtoConverter.ProjectIdResolver)RESOLVER, autoIdKeyResp));
        }
        response.addAllMutationResults(Collections.nCopies(mutationList.size() - response.getMutationResultsCount(), emptyMutation));
        response.setIndexUpdates(indexUpdates);
    }

    static <T> T makeV3Call(DatastorePb.DatastoreService_3.Method method, MessageLite req, Parser<T> respParser) throws InvalidConversionException {
        try {
            return (T)respParser.parseFrom(ApiProxy.makeSyncCall((String)"datastore_v3", (String)method.name(), (byte[])req.toByteArray()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }

    static String getAppId() {
        return ApiProxy.getCurrentEnvironment().getAppId();
    }
}

