/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;

@VisibleForTesting
public abstract class BaseDatastoreValidator {
    protected Config.DatastoreConfig config;

    protected BaseDatastoreValidator(Config.DatastoreConfig config) {
        this.config = config;
    }

    public Config.DatastoreConfig getConfig() {
        return this.config;
    }

    public void validateKind(ValidationConstraint constraint, ByteString kind) throws ValidationException {
        this.validateStringNotEmpty(kind, "kind");
        this.validateLength(kind, this.config.getMaxIndexedValueBytes(), "kind");
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(kind, "kind");
        }
    }

    void validatePartitionIdDimension(ValidationConstraint constraint, String partitionId, String desc) throws ValidationException {
        this.validateAppOrPartitionIdNotEmpty(partitionId, desc);
        this.validateAppOrPartitionIdLength(partitionId, 100, desc);
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(partitionId, desc);
        }
        ValidationException.validateAssertion(DatastoreHelper.PARTITION_ID_REGEX.matcher(partitionId).matches(), "Illegal string \"%s\" in %s.", partitionId, desc);
    }

    public void validateAppName(ValidationConstraint constraint, String appName, String desc) throws ValidationException {
        this.validateAppOrPartitionIdNotEmpty(appName, desc);
        this.validateAppOrPartitionIdLength(appName, 306, desc);
        if (constraint.allowReservedKey()) {
            ValidationException.validateAssertion(DatastoreHelper.RESERVED_APP_ID_REGEX.matcher(appName).matches(), "\"%s\" is an invalid %s.", appName, desc);
        } else {
            ValidationException.validateAssertion(DatastoreHelper.APP_ID_REGEX.matcher(appName).matches(), "\"%s\" is an invalid %s.", appName, desc);
        }
    }

    public void validatePropertyName(ValidationConstraint constraint, ByteString propertyName) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, "");
    }

    public void validatePropertyName(ValidationConstraint constraint, ByteString propertyName, String desc) throws ValidationException {
        desc = desc.isEmpty() ? "property.name" : String.valueOf(desc).concat(".property.name");
        this.validateStringNotEmpty(propertyName, desc);
        this.validateLength(propertyName, this.config.getMaxIndexedValueBytes(), desc);
        if (!constraint.allowReservedName()) {
            this.validateStringVisibleOrNotReserved(propertyName, desc);
        }
    }

    public void validateKeyPathString(ValidationConstraint constraint, ByteString pathElement, String desc) throws ValidationException {
        this.validateStringNotEmpty(pathElement, desc);
        this.validateLength(pathElement, this.config.getMaxIndexedValueBytes(), desc);
        if (!constraint.allowReservedName()) {
            this.validateStringNotReserved(pathElement, desc);
        }
    }

    public void validateStringNotReserved(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!DatastoreHelper.RESERVED_NAME.matcher(string).matches(), "The %s \"%s\" is reserved.", desc, string);
    }

    public void validateStringNotReserved(ByteString string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!this.isReservedString(string), "The %s \"%s\" is reserved.", desc, string.toStringUtf8());
    }

    public void validateStringVisibleOrNotReserved(ByteString string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!this.isReservedString(string) || DatastoreHelper.ALLOWED_RESERVED_NAMES_BYTES.contains(string), "The %s \"%s\" is reserved.", desc, string.toStringUtf8());
    }

    public void validateAppOrPartitionIdNotEmpty(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateStringNotEmpty(ByteString string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateAppOrPartitionIdLength(String string, int length, String desc) throws ValidationException {
        ValidationException.validateAssertion(string.length() <= length, "The %s is longer than %d characters.", desc, length);
    }

    public void validateLength(ByteString byteString, int maxLength, String desc) throws ValidationException {
        ValidationException.validateAssertion(byteString.size() <= maxLength, "The %s is longer than %d bytes.", desc, maxLength);
    }

    public void validateStringUtf8(ByteString byteString, String desc) throws ValidationException {
        ValidationException.validateAssertion(byteString.isValidUtf8(), "The %s is not valid UTF-8.", desc);
    }

    public void validateSameApp(String app1, String app2) throws ValidationException {
        Preconditions.checkNotNull((Object)app1);
        Preconditions.checkNotNull((Object)app2);
        ValidationException.validateAssertion(app1.equals(app2), "%s%s vs. %s", "mismatched app ids within request: ", app1, app2);
    }

    public static void validateGeoPoint(double lat, double lon) throws ValidationException {
        ValidationException.validateAssertion(Math.abs(lat) <= 90.0, "Geo point latitude outside permitted range -90.0 to 90.0.", new Object[0]);
        ValidationException.validateAssertion(Math.abs(lon) <= 180.0, "Geo point longitude outside permitted range -180.0 to 180.0.", new Object[0]);
    }

    private boolean isReservedString(ByteString byteString) {
        return byteString.startsWith(DatastoreHelper.RESERVED_DELIMITER_BYTES) && byteString.endsWith(DatastoreHelper.RESERVED_DELIMITER_BYTES) && byteString.size() >= 4;
    }
}

