/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameter;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpressionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ProjectionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrderOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReferenceOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.EntityV1Validator;
import com.google.apphosting.datastore.shared.QueryHelper;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.Map;
import java.util.regex.Pattern;

public class CloudDatastoreV1Validator {
    private static final Pattern GQL_ARG_NAME_CHARACTER_SET_PATTERN = Pattern.compile("[A-Za-z0-9_$\u0080-\uffff]*");
    protected final EntityV1Validator entityValidator;

    public CloudDatastoreV1Validator(EntityV1Validator entityValidator) {
        this.entityValidator = entityValidator;
    }

    public EntityV1Validator getEntityValidator() {
        return this.entityValidator;
    }

    static ValidationConstraint constraintForMutationOperation(Mutation.Operation op) throws ValidationException {
        switch (op) {
            case UPSERT: {
                return ValidationConstraint.UPSERT;
            }
            case UPDATE: {
                return ValidationConstraint.UPDATE;
            }
            case INSERT: {
                return ValidationConstraint.INSERT;
            }
            case DELETE: {
                return ValidationConstraint.DELETE;
            }
        }
        String string = String.valueOf(op);
        throw new ValidationException(new StringBuilder(28 + String.valueOf(string).length()).append("unknown mutation operation: ").append(string).toString());
    }

    public void validateMutation(ValidationConstraint constraint, String projectId, Mutation mutation) throws ValidationException {
        Mutation.Operation op = mutation.getOp();
        switch (op) {
            case UPSERT: 
            case UPDATE: 
            case INSERT: {
                ValidationException.validateAssertion(mutation.getArgTypeCase() == Mutation.ArgTypeCase.ENTITY, "mutation lacks required entity", new Object[0]);
                break;
            }
            case DELETE: {
                ValidationException.validateAssertion(mutation.getArgTypeCase() == Mutation.ArgTypeCase.KEY, "mutation lacks required key", new Object[0]);
                break;
            }
            case OPERATION_UNSPECIFIED: {
                throw new ValidationException("mutation lacks required op");
            }
            default: {
                String string = String.valueOf(op);
                throw new ValidationException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized mutation op: ").append(string).toString());
            }
        }
        if (op == Mutation.Operation.DELETE) {
            this.entityValidator.validateKey(constraint, (KeyOrBuilder)mutation.getKey());
            this.validateProjectIdMatches(projectId, mutation.getKeyOrBuilder().getPartitionIdOrBuilder());
        } else {
            this.entityValidator.validateEntity(constraint, (EntityOrBuilder)mutation.getEntity());
            this.validateProjectIdMatches(projectId, mutation.getEntityOrBuilder().getKeyOrBuilder().getPartitionIdOrBuilder());
        }
    }

    public void validateProjectIdMatches(String projectId, PartitionIdOrBuilder partitionId) throws ValidationException {
        if (projectId.isEmpty() || partitionId.getProjectId().isEmpty()) {
            return;
        }
        ValidationException.validateAssertion(projectId.equals(partitionId.getProjectId()), "expected project id %s, found %s", projectId, partitionId.getProjectId());
    }

    public void validateCommitMode(CommitRequest.Mode mode, boolean hasTransaction) throws ValidationException {
        switch (mode) {
            case MODE_UNSPECIFIED: 
            case TRANSACTIONAL: {
                ValidationException.validateAssertion(hasTransaction, "transactional commit requires a transaction", new Object[0]);
                break;
            }
            case NON_TRANSACTIONAL: {
                ValidationException.validateAssertion(!hasTransaction, "non-transaction commit cannot specify a transaction", new Object[0]);
                break;
            }
            default: {
                String string = String.valueOf(mode);
                throw new ValidationException(new StringBuilder(21 + String.valueOf(string).length()).append("unknown commit mode: ").append(string).toString());
            }
        }
    }

    public void validateQuery(ValidationConstraint constraint, boolean isStrongReadConsistency, QueryOrBuilder query) throws ValidationException {
        ValidationException.validateAssertion(!isStrongReadConsistency || QueryHelper.hasAncestorFilter(query), "global queries do not support strong consistency", new Object[0]);
        if (query.hasFilter()) {
            this.validateFilter(constraint, query.getFilter());
        }
        for (KindExpressionOrBuilder kindExp : query.getKindOrBuilderList()) {
            this.validateKindExpression(constraint, kindExp);
        }
        for (PropertyReferenceOrBuilder propRef : query.getDistinctOnOrBuilderList()) {
            this.validatePropertyReference(constraint, propRef);
        }
        for (ProjectionOrBuilder propExp : query.getProjectionOrBuilderList()) {
            this.validateProjection(constraint, propExp);
        }
        for (PropertyOrderOrBuilder order : query.getOrderOrBuilderList()) {
            this.validatePropertyOrder(constraint, order);
        }
    }

    public void validateGqlQuery(GqlQueryOrBuilder gqlQuery) throws ValidationException {
        this.entityValidator.validateStringUtf8(gqlQuery.getQueryStringBytes(), "GQL query string");
        for (Map.Entry namedGqlQueryParam : gqlQuery.getNamedBindings().entrySet()) {
            String name = (String)namedGqlQueryParam.getKey();
            ByteString nameBytes = ByteString.copyFromUtf8((String)name);
            this.entityValidator.validateStringNotEmpty(nameBytes, "GQL query argument name is empty.");
            ValidationException.validateAssertion(GQL_ARG_NAME_CHARACTER_SET_PATTERN.matcher(name).matches(), "GQL query argument name \"%s\" contains an invalid character.", name);
            ValidationException.validateAssertion(!Character.isDigit(name.charAt(0)), "GQL query argument name \"%s\" starts with a digit.", name);
            this.entityValidator.validateStringNotReserved(nameBytes, "GQL query argument name");
            this.validateGqlQueryParam((GqlQueryParameter)namedGqlQueryParam.getValue());
        }
        for (GqlQueryParameter numberedGqlQueryParam : gqlQuery.getPositionalBindingsList()) {
            this.validateGqlQueryParam(numberedGqlQueryParam);
        }
    }

    private void validateGqlQueryParam(GqlQueryParameter gqlQueryParam) throws ValidationException {
        switch (gqlQueryParam.getArgTypeCase()) {
            case VALUE: 
            case CURSOR: {
                break;
            }
            case ARGTYPE_NOT_SET: {
                throw new ValidationException("A GQL query argument has neither value nor cursor.");
            }
            default: {
                String string = String.valueOf(gqlQueryParam.getArgTypeCase());
                throw new ValidationException(new StringBuilder(33 + String.valueOf(string).length()).append("Unrecognized GQL query arg_type: ").append(string).toString());
            }
        }
    }

    private void validatePropertyOrder(ValidationConstraint constraint, PropertyOrderOrBuilder order) throws ValidationException {
        this.validatePropertyReference(constraint, (PropertyReferenceOrBuilder)order.getProperty());
    }

    private void validateProjection(ValidationConstraint constraint, ProjectionOrBuilder propExp) throws ValidationException {
        this.validatePropertyReference(constraint, propExp.getPropertyOrBuilder());
    }

    private void validateKindExpression(ValidationConstraint constraint, KindExpressionOrBuilder kindExp) throws ValidationException {
        this.entityValidator.validateStringUtf8(kindExp.getNameBytes(), "kind");
        this.entityValidator.validateKind(constraint, kindExp.getNameBytes());
    }

    void validatePropertyReference(ValidationConstraint constraint, PropertyReferenceOrBuilder propertyRef) throws ValidationException {
        this.entityValidator.validateStringUtf8(propertyRef.getNameBytes(), "property name");
        this.entityValidator.validatePropertyName(constraint, propertyRef.getNameBytes());
    }

    private void validateFilter(ValidationConstraint constraint, Filter filter) throws ValidationException {
        switch (filter.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                CompositeFilterOrBuilder cmpFilter = filter.getCompositeFilterOrBuilder();
                ValidationException.validateAssertion(cmpFilter.getFiltersCount() > 0, "a composite filter must have at least one sub-filter", new Object[0]);
                for (Filter subFilter : cmpFilter.getFiltersList()) {
                    this.validateFilter(constraint, subFilter);
                }
                break;
            }
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
                this.validatePropertyReference(constraint, propFilter.getPropertyOrBuilder());
                ValidationException.validateAssertion(!propFilter.getValueOrBuilder().getExcludeFromIndexes(), "a filter value must be indexed", new Object[0]);
                if (propFilter.getProperty().getName().endsWith(".__key__")) {
                    constraint = constraint.withContext(ValidationConstraint.Context.IN_FILTER_ON_ENTITY_VALUE_KEY);
                }
                this.entityValidator.validateValue(constraint, propFilter.getValue(), propFilter.getPropertyOrBuilder().getName());
                break;
            }
            case FILTERTYPE_NOT_SET: {
                throw new ValidationException("a filter must have exactly one of its fields set");
            }
            default: {
                String string = String.valueOf(filter.getFilterTypeCase());
                throw new ValidationException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized filter_type: ").append(string).toString());
            }
        }
    }
}

