/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Interner;
import com.google.appengine.repackaged.com.google.common.collect.Interners;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ValidationConstraint {
    private static final Interner<ValidationConstraint> CONSTRAINT_INTERNER = Interners.newStrongInterner();
    public static final ValidationConstraint LOOKUP = ValidationConstraint.forOperation(Operation.LOOKUP);
    public static final ValidationConstraint INSERT = ValidationConstraint.forOperation(Operation.INSERT);
    public static final ValidationConstraint UPSERT = ValidationConstraint.forOperation(Operation.UPSERT);
    public static final ValidationConstraint UPDATE = ValidationConstraint.forOperation(Operation.UPDATE);
    public static final ValidationConstraint DELETE = ValidationConstraint.forOperation(Operation.DELETE);
    public static final ValidationConstraint QUERY = ValidationConstraint.forOperation(Operation.QUERY);
    public static final ValidationConstraint ALLOCATE_ID = ValidationConstraint.forOperation(Operation.ALLOCATE_ID);
    public static final ValidationConstraint ALLOCATE_ID_RANGE = ValidationConstraint.forOperation(Operation.ALLOCATE_ID_RANGE);
    public static final ValidationConstraint RESERVE_ID = ValidationConstraint.forOperation(Operation.RESERVE_ID);
    private final Operation operation;
    private final EnumSet<Context> contexts;

    @VisibleForTesting
    static ImmutableSet<ValidationConstraint> getAllForTesting() {
        ImmutableSet.Builder all = ImmutableSet.builder();
        Set contexts = Sets.powerSet(EnumSet.allOf(Context.class));
        for (Operation op : Operation.values()) {
            for (Set context : contexts) {
                if (context.isEmpty()) {
                    all.add((Object)ValidationConstraint.create(op, EnumSet.noneOf(Context.class)));
                    continue;
                }
                all.add((Object)ValidationConstraint.create(op, EnumSet.copyOf(context)));
            }
        }
        return all.build();
    }

    private ValidationConstraint(Operation operation, EnumSet<Context> contexts) {
        this.operation = operation;
        this.contexts = contexts;
    }

    private static ValidationConstraint create(Operation operation, EnumSet<Context> contexts) {
        return (ValidationConstraint)CONSTRAINT_INTERNER.intern((Object)new ValidationConstraint(operation, contexts));
    }

    private static ValidationConstraint forOperation(Operation operation) {
        return ValidationConstraint.create(operation, EnumSet.noneOf(Context.class));
    }

    public ValidationConstraint withContext(Context ... context) {
        List<Context> contextList = Arrays.asList(context);
        if (this.contexts.containsAll(contextList)) {
            return this;
        }
        EnumSet<Context> newContexts = EnumSet.copyOf(this.contexts);
        newContexts.addAll(contextList);
        return ValidationConstraint.create(this.operation, newContexts);
    }

    public ValidationConstraint withContext(boolean isTrusted, Context ... context) {
        if (isTrusted) {
            if (!this.contexts.contains((Object)Context.TRUSTED)) {
                return this.withContext(Context.TRUSTED).withContext(context);
            }
        } else {
            Preconditions.checkState((!this.contexts.contains((Object)Context.TRUSTED) ? 1 : 0) != 0);
        }
        return this.withContext(context);
    }

    @VisibleForTesting
    public boolean hasContext(Context context) {
        return this.contexts.contains((Object)context);
    }

    public boolean allowPathDelimiterInPropertyName() {
        return this.contexts.contains((Object)Context.IN_ENTITY_WITH_PATH_SEPARATOR);
    }

    public boolean allowMissingKey() {
        return this.contexts.contains((Object)Context.IN_ENTITY_VALUE);
    }

    public boolean allowCompleteKey() {
        if (this.contexts.contains((Object)Context.IN_ENTITY_VALUE) || this.contexts.contains((Object)Context.IN_KEY_VALUE)) {
            return true;
        }
        return this.operation != Operation.ALLOCATE_ID;
    }

    public boolean allowIncompleteKey(boolean getAllowIncompleteKeyPathsInQueryFilters) {
        if (this.contexts.contains((Object)Context.IN_FILTER_ON_ENTITY_VALUE_KEY)) {
            return getAllowIncompleteKeyPathsInQueryFilters;
        }
        if (this.contexts.contains((Object)Context.IN_KEY_VALUE)) {
            return false;
        }
        if (this.contexts.contains((Object)Context.IN_ENTITY_VALUE)) {
            return true;
        }
        switch (this.operation) {
            case INSERT: 
            case UPSERT: 
            case QUERY: 
            case ALLOCATE_ID: 
            case ALLOCATE_ID_RANGE: {
                return true;
            }
        }
        return false;
    }

    public boolean allowPartitionMissingProjectId() {
        return this.contexts.contains((Object)Context.PRENORMALIZATION);
    }

    public boolean allowMissingPartionId() {
        return this.contexts.contains((Object)Context.PRENORMALIZATION);
    }

    public boolean allowReservedKey() {
        return this.contexts.contains((Object)Context.IN_KEY_VALUE) || this.contexts.contains((Object)Context.IN_ENTITY_VALUE) || this.allowReservedName();
    }

    public boolean allowReservedName() {
        switch (this.operation) {
            case QUERY: 
            case LOOKUP: {
                return true;
            }
        }
        return this.contexts.contains((Object)Context.TRUSTED);
    }

    public boolean allowIndexOnlyMeaning() {
        return this.operation == Operation.LOOKUP || this.operation == Operation.QUERY;
    }

    public boolean allowCompoundValues() {
        return this.operation != Operation.QUERY;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValidationConstraint)) {
            return false;
        }
        ValidationConstraint otherConstraint = (ValidationConstraint)other;
        return this.operation == otherConstraint.operation && this.contexts.equals(otherConstraint.contexts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.contexts});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.operation).add("contexts", this.contexts).toString();
    }

    private static enum Operation {
        LOOKUP,
        INSERT,
        UPSERT,
        UPDATE,
        DELETE,
        QUERY,
        ALLOCATE_ID,
        ALLOCATE_ID_RANGE,
        RESERVE_ID;

    }

    public static enum Context {
        IN_KEY_VALUE,
        IN_ENTITY_VALUE,
        IN_ENTITY_WITH_PATH_SEPARATOR,
        TRUSTED,
        PRENORMALIZATION,
        IN_FILTER_ON_ENTITY_VALUE_KEY;

    }
}

