/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;

@GwtCompatible(serializable=true)
public strictfp final class R1Interval
implements Serializable {
    private double lo;
    private double hi;

    R1Interval() {
        this.lo = 1.0;
        this.hi = 0.0;
    }

    public R1Interval(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    public R1Interval(R1Interval interval) {
        this.lo = interval.lo;
        this.hi = interval.hi;
    }

    public static R1Interval empty() {
        return new R1Interval(1.0, 0.0);
    }

    public static R1Interval fromPoint(double p) {
        return new R1Interval(p, p);
    }

    public static R1Interval fromPointPair(double p1, double p2) {
        R1Interval result = new R1Interval();
        result.initFromPointPair(p1, p2);
        return result;
    }

    void initFromPointPair(double p1, double p2) {
        if (p1 <= p2) {
            this.lo = p1;
            this.hi = p2;
        } else {
            this.lo = p2;
            this.hi = p1;
        }
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    double getValue(Endpoint endpoint) {
        return endpoint.getValue(this);
    }

    void setValue(Endpoint endpoint, double value) {
        endpoint.setValue(this, value);
    }

    public boolean isEmpty() {
        return this.lo > this.hi;
    }

    public double getCenter() {
        return 0.5 * (this.lo + this.hi);
    }

    public double getLength() {
        return this.hi - this.lo;
    }

    public boolean contains(double p) {
        return p >= this.lo && p <= this.hi;
    }

    public boolean interiorContains(double p) {
        return p > this.lo && p < this.hi;
    }

    public boolean contains(R1Interval y) {
        if (y.isEmpty()) {
            return true;
        }
        return y.lo >= this.lo && y.hi <= this.hi;
    }

    public boolean interiorContains(R1Interval y) {
        if (y.isEmpty()) {
            return true;
        }
        return y.lo > this.lo && y.hi < this.hi;
    }

    public boolean intersects(R1Interval y) {
        if (this.lo <= y.lo) {
            return y.lo <= this.hi && y.lo <= y.hi;
        }
        return this.lo <= y.hi && this.lo <= this.hi;
    }

    public boolean interiorIntersects(R1Interval y) {
        return y.lo < this.hi && this.lo < y.hi && this.lo < this.hi && y.lo <= y.hi;
    }

    void set(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    void setLo(double lo) {
        this.lo = lo;
    }

    void setHi(double hi) {
        this.hi = hi;
    }

    void setEmpty() {
        this.lo = 1.0;
        this.hi = 0.0;
    }

    void unionInternal(double p) {
        if (this.isEmpty()) {
            this.lo = p;
            this.hi = p;
        } else if (p < this.lo) {
            this.lo = p;
        } else if (p > this.hi) {
            this.hi = p;
        }
    }

    public double clampPoint(double p) {
        return Math.max(this.lo, Math.min(this.hi, p));
    }

    @CheckReturnValue
    public R1Interval expanded(double radius) {
        if (this.isEmpty()) {
            return this;
        }
        return new R1Interval(this.lo - radius, this.hi + radius);
    }

    void expandedInternal(double radius) {
        this.lo -= radius;
        this.hi += radius;
    }

    @CheckReturnValue
    public R1Interval union(R1Interval y) {
        if (this.isEmpty()) {
            return y;
        }
        if (y.isEmpty()) {
            return this;
        }
        return new R1Interval(Math.min(this.lo, y.lo), Math.max(this.hi, y.hi));
    }

    void unionInternal(R1Interval y) {
        if (this.isEmpty()) {
            this.lo = y.lo;
            this.hi = y.hi;
        } else if (!y.isEmpty()) {
            this.lo = Math.min(this.lo, y.lo);
            this.hi = Math.max(this.hi, y.hi);
        }
    }

    @CheckReturnValue
    public R1Interval intersection(R1Interval y) {
        return new R1Interval(Math.max(this.lo, y.lo), Math.min(this.hi, y.hi));
    }

    void intersectionInternal(R1Interval y) {
        this.lo = Math.max(this.lo, y.lo);
        this.hi = Math.min(this.hi, y.hi);
    }

    @CheckReturnValue
    public R1Interval addPoint(double p) {
        if (this.isEmpty()) {
            return R1Interval.fromPoint(p);
        }
        if (p < this.lo) {
            return new R1Interval(p, this.hi);
        }
        if (p > this.hi) {
            return new R1Interval(this.lo, p);
        }
        return new R1Interval(this.lo, this.hi);
    }

    public boolean equals(Object that) {
        if (that instanceof R1Interval) {
            R1Interval y = (R1Interval)that;
            return this.lo == y.lo && this.hi == y.hi || this.isEmpty() && y.isEmpty();
        }
        return false;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 17;
        }
        long value = 17L;
        value = 37L * value + Double.doubleToLongBits(this.lo);
        value = 37L * value + Double.doubleToLongBits(this.hi);
        return (int)(value ^ value >>> 32);
    }

    public boolean approxEquals(R1Interval y) {
        return this.approxEquals(y, 1.0E-15);
    }

    public boolean approxEquals(R1Interval y, double maxError) {
        if (this.isEmpty()) {
            return y.getLength() <= maxError;
        }
        if (y.isEmpty()) {
            return this.getLength() <= maxError;
        }
        return Math.abs(y.lo - this.lo) <= maxError && Math.abs(y.hi - this.hi) <= maxError;
    }

    public String toString() {
        double d = this.lo;
        double d2 = this.hi;
        return new StringBuilder(52).append("[").append(d).append(", ").append(d2).append("]").toString();
    }

    strictfp static enum Endpoint {
        LO{

            @Override
            public double getValue(R1Interval interval) {
                return interval.lo;
            }

            @Override
            public void setValue(R1Interval interval, double value) {
                interval.lo = value;
            }

            @Override
            public Endpoint opposite() {
                return HI;
            }
        }
        ,
        HI{

            @Override
            public double getValue(R1Interval interval) {
                return interval.hi;
            }

            @Override
            public void setValue(R1Interval interval, double value) {
                interval.hi = value;
            }

            @Override
            public Endpoint opposite() {
                return LO;
            }
        };


        public abstract double getValue(R1Interval var1);

        public abstract void setValue(R1Interval var1, double var2);

        public abstract Endpoint opposite();
    }
}

