/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.rpc.Code;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DatastoreHelper {
    public static final int MAX_KEY_PATH_LENGTH = 100;
    public static final int MAX_PARTITION_ID_LENGTH = 100;
    @VisibleForTesting
    public static final int MAX_APP_ID_SECTION_LENGTH = 100;
    public static final String PROPERTY_PATH_DELIMITER = ".";
    public static final Byte PROPERTY_PATH_DELIMITER_BYTE = 46;
    private static final String CLUSTER_DELIMITER = "~";
    public static final String CLUSTER = "cluster";
    public static final String PROJECT_ID = "project";
    public static final String METADATA_PROJECT_ID = "metadata";
    private static final String APP_ID_PARTITION_STRING = String.format("[a-z\\d\\-]{1,%d}", 100);
    private static final String APP_ID_DOMAIN_STRING = String.format("[a-z\\d][a-z\\d\\-\\.]{0,%d}", 99);
    private static final String APP_ID_DISPLAY_STRING = String.format("[a-z\\d][a-z\\d\\-]{0,%d}", 99);
    private static final String PUBLIC_PROJECT_ID_STRING = String.format("(?:%s:)?%s", APP_ID_DOMAIN_STRING, APP_ID_DISPLAY_STRING);
    private static final String RESTRICTED_PROJECT_ID_STRING = String.format("__%s__", PUBLIC_PROJECT_ID_STRING);
    private static final String METADATA_PROJECT_ID_STRING = String.format("__metadata-(?<%s>%s|%s)__", "metadata", RESTRICTED_PROJECT_ID_STRING, PUBLIC_PROJECT_ID_STRING);
    private static final String PROJECT_ID_STRING = String.format("(?<%s>%s|%s|%s)", "project", METADATA_PROJECT_ID_STRING, RESTRICTED_PROJECT_ID_STRING, PUBLIC_PROJECT_ID_STRING);
    public static final Pattern APP_ID_REGEX = Pattern.compile(String.format("(?:(?<%s>%s)%s)?%s", "cluster", APP_ID_PARTITION_STRING, "~", PROJECT_ID_STRING));
    public static final Pattern PROJECT_ID_REGEX = Pattern.compile(PROJECT_ID_STRING);
    public static final Pattern PARTITION_ID_REGEX = Pattern.compile(String.format("[0-9A-Za-z\\._\\-]{0,%d}", 100));
    public static final String KEY_PROPERTY_NAME = "__key__";
    public static final String KIND_PROPERTY_NAME = "__kind__";
    public static final String NAMESPACE_KIND_NAME = "__namespace__";
    public static final String SPLITS_PROPERTY_NAME = "__splits__";
    public static final String ALL_NAMESPACES = "__all__";
    private static final String RESERVED_DELIMITER = "__";
    private static final ByteString RESERVED_DELIMITER_BYTES = ByteString.copyFromUtf8((String)"__");
    public static final Set<ByteString> ALLOWED_RESERVED_PROPERTY_NAMES_BYTES = ImmutableSet.of((Object)ByteString.copyFromUtf8((String)"__version__"));
    public static final Set<DatastorePb.Query.Filter.Operator> INEQUALITY_OPERATORS = ImmutableSet.of((Object)DatastorePb.Query.Filter.Operator.GREATER_THAN, (Object)DatastorePb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL, (Object)DatastorePb.Query.Filter.Operator.LESS_THAN, (Object)DatastorePb.Query.Filter.Operator.LESS_THAN_OR_EQUAL);
    public static final int MAX_QUERY_COMPONENTS = 100;
    public static final ImmutableMap<Integer, Codes.Code> CANONICAL_ERROR_MAPPING = ImmutableMap.builder().put((Object)DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), (Object)Codes.Code.INVALID_ARGUMENT).put((Object)DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), (Object)Codes.Code.ABORTED).put((Object)DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), (Object)Codes.Code.INTERNAL).put((Object)DatastorePb.Error.ErrorCode.NEED_INDEX.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)DatastorePb.Error.ErrorCode.TIMEOUT.getValue(), (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)DatastorePb.Error.ErrorCode.PERMISSION_DENIED.getValue(), (Object)Codes.Code.PERMISSION_DENIED).put((Object)DatastorePb.Error.ErrorCode.BIGTABLE_ERROR.getValue(), (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)DatastorePb.Error.ErrorCode.COMMITTED_BUT_STILL_APPLYING.getValue(), (Object)Codes.Code.INTERNAL).put((Object)DatastorePb.Error.ErrorCode.CAPABILITY_DISABLED.getValue(), (Object)Codes.Code.UNAVAILABLE).put((Object)DatastorePb.Error.ErrorCode.TRY_ALTERNATE_BACKEND.getValue(), (Object)Codes.Code.UNAVAILABLE).put((Object)DatastorePb.Error.ErrorCode.SAFE_TIME_TOO_OLD.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)DatastorePb.Error.ErrorCode.RESOURCE_EXHAUSTED.getValue(), (Object)Codes.Code.RESOURCE_EXHAUSTED).put((Object)90000, (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)90001, (Object)Codes.Code.INTERNAL).put((Object)90002, (Object)Codes.Code.INTERNAL).build();

    private DatastoreHelper() {
    }

    public static boolean isMetadataAppId(String appId) {
        Matcher matcher = APP_ID_REGEX.matcher(appId);
        return matcher.matches() && matcher.group(METADATA_PROJECT_ID) != null;
    }

    public static String toMetadataAppId(String appId) {
        String string;
        Matcher matcher = APP_ID_REGEX.matcher(appId);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Cannot get metadata app of an invalid app id: %s", (Object[])new Object[]{appId});
        Preconditions.checkArgument((matcher.group(METADATA_PROJECT_ID) == null ? 1 : 0) != 0, (Object)"Metadata apps do no have their own metadata apps.");
        String cluster = matcher.group(CLUSTER);
        String projectId = matcher.group(PROJECT_ID);
        Object[] objectArray = new Object[2];
        if (cluster == null) {
            string = "";
        } else {
            String string2 = String.valueOf(cluster);
            String string3 = String.valueOf(CLUSTER_DELIMITER);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        objectArray[0] = string;
        objectArray[1] = projectId;
        return String.format("%s__metadata-%s__", objectArray);
    }

    public static String fromMetadataAppId(String metadataAppId) {
        String string;
        Matcher matcher = APP_ID_REGEX.matcher(metadataAppId);
        Preconditions.checkArgument((matcher.matches() && matcher.group(METADATA_PROJECT_ID) != null ? 1 : 0) != 0, (String)"Invalid metadata app id: %s", (Object[])new Object[]{metadataAppId});
        String cluster = matcher.group(CLUSTER);
        String projectId = matcher.group(METADATA_PROJECT_ID);
        if (cluster == null) {
            string = projectId;
        } else {
            String string2 = String.valueOf(CLUSTER_DELIMITER);
            string = new StringBuilder(0 + String.valueOf(cluster).length() + String.valueOf(string2).length() + String.valueOf(projectId).length()).append(cluster).append(string2).append(projectId).toString();
        }
        return string;
    }

    public static String appToProjectId(String appId) {
        Matcher patternMatch = APP_ID_REGEX.matcher(appId);
        if (patternMatch.matches()) {
            return patternMatch.group(PROJECT_ID);
        }
        return appId;
    }

    public static String projectIdToApp(String cluster, String projectId) {
        Preconditions.checkArgument((!projectId.contains(CLUSTER_DELIMITER) ? 1 : 0) != 0);
        if (cluster.isEmpty()) {
            return projectId;
        }
        return String.format("%s%s%s", cluster, CLUSTER_DELIMITER, projectId);
    }

    public static String getCluster(String appId) {
        Matcher patternMatch = APP_ID_REGEX.matcher(appId);
        if (patternMatch.matches()) {
            return (String)MoreObjects.firstNonNull((Object)patternMatch.group(CLUSTER), (Object)"");
        }
        return "";
    }

    public static boolean isReserved(String name) {
        return name.length() > 2 * RESERVED_DELIMITER.length() && name.startsWith(RESERVED_DELIMITER) && name.endsWith(RESERVED_DELIMITER);
    }

    public static boolean isReserved(ByteString name) {
        return name.size() > 2 * RESERVED_DELIMITER_BYTES.size() && name.startsWith(RESERVED_DELIMITER_BYTES) && name.endsWith(RESERVED_DELIMITER_BYTES);
    }

    public static Codes.Code getCanonicalCodeForAppError(int appCode) {
        Codes.Code code = (Codes.Code)CANONICAL_ERROR_MAPPING.get((Object)appCode);
        if (code != null) {
            return code;
        }
        return Codes.Code.UNKNOWN;
    }

    public static Code getGoogleRpcCanonicalCodeForAppError(int appCode) {
        return Code.valueOf((int)DatastoreHelper.getCanonicalCodeForAppError(appCode).getNumber());
    }

    public static boolean isEntityValue(OnestoreEntity.Property property) {
        return property.getMeaningEnum().equals((Object)OnestoreEntity.Property.Meaning.ENTITY_PROTO);
    }

    public static Multimap<String, OnestoreEntity.Property> buildPropertyMultimap(OnestoreEntity.EntityProto entity) {
        HashMultimap map = HashMultimap.create();
        for (OnestoreEntity.Property p : entity.propertys()) {
            map.put((Object)p.getName(), (Object)p);
        }
        return map;
    }
}

