/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.datastore.v1.ValueOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.TimestampOrBuilder;
import com.google.appengine.repackaged.com.google.type.LatLngOrBuilder;
import com.google.apphosting.datastore.shared.BaseDatastoreValidator;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.EntityHelper;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EntityV1Validator
extends BaseDatastoreValidator {
    public EntityV1Validator(Config.DatastoreConfig config) {
        super(config);
    }

    public void validateEntities(ValidationConstraint constraint, Iterable<? extends EntityOrBuilder> entities) throws ValidationException {
        for (EntityOrBuilder entityOrBuilder : entities) {
            this.validateEntity(constraint, entityOrBuilder);
        }
    }

    public void validateKeys(ValidationConstraint constraint, Iterable<? extends KeyOrBuilder> keys) throws ValidationException {
        for (KeyOrBuilder keyOrBuilder : keys) {
            this.validateKey(constraint, keyOrBuilder);
        }
    }

    public void validateEntity(ValidationConstraint constraint, EntityOrBuilder entity) throws ValidationException {
        this.validateEntity(constraint, entity, 0, 0);
    }

    private void validateEntity(ValidationConstraint constraint, EntityOrBuilder entity, int prefixLength, int depth) throws ValidationException {
        if (entity.hasKey()) {
            this.validateKey(constraint, (KeyOrBuilder)entity.getKey());
        } else {
            ValidationException.validateAssertion(constraint.allowMissingKey(), "Entity is missing key.", new Object[0]);
        }
        if (depth == 0) {
            for (Value value : entity.getProperties().values()) {
                if (!this.isOrContainsIndexedEntityValue(value)) continue;
                constraint = constraint.withContext(ValidationConstraint.Context.IN_ENTITY_WITH_INDEXED_ENTITY_VALUE);
                break;
            }
        }
        for (Map.Entry entry : entity.getProperties().entrySet()) {
            this.validateProperty(constraint, ByteString.copyFromUtf8((String)((String)entry.getKey())), (Value)entry.getValue(), prefixLength, depth);
        }
    }

    public void validateKey(ValidationConstraint constraint, KeyOrBuilder key) throws ValidationException {
        boolean finalElementComplete;
        ValidationException.validateAssertion(key.hasPartitionId() || constraint.allowMissingPartionId(), "Key is missing partition id.", new Object[0]);
        this.validatePartitionId(constraint, (PartitionIdOrBuilder)key.getPartitionId());
        int numKeyPathElements = key.getPathCount();
        ValidationException.validateAssertion(numKeyPathElements != 0, "Key path is empty.", new Object[0]);
        ValidationException.validateAssertion(numKeyPathElements <= 100, "Key path is too long. Cannot exceed %d elements.", 100);
        int numIncompleteElements = 0;
        block5: for (Key.PathElement element : key.getPathList()) {
            this.validateStringUtf8(element.getKindBytes(), "key path kind");
            this.validateKind(constraint, element.getKindBytes());
            switch (element.getIdTypeCase()) {
                case ID: {
                    ValidationException.validateAssertion(element.getId() != 0L, "Key path id is invalid. Must not be zero.", new Object[0]);
                    continue block5;
                }
                case NAME: {
                    this.validateStringUtf8(element.getNameBytes(), "key path element name");
                    this.validateStringNotEmpty(element.getNameBytes(), "key path element name");
                    this.validateLength(element.getNameBytes(), this.config.getMaxIndexedValueBytes(), "key path element name");
                    if (constraint.allowReservedKey()) continue block5;
                    this.validateStringNotReserved(element.getNameBytes(), "key path element name");
                    continue block5;
                }
                case IDTYPE_NOT_SET: {
                    ++numIncompleteElements;
                    continue block5;
                }
            }
            String string = String.valueOf(element.getIdTypeCase());
            throw new ValidationException(new StringBuilder(22 + String.valueOf(string).length()).append("Unrecognized id_type: ").append(string).toString());
        }
        Key.PathElement finalElement = key.getPath(numKeyPathElements - 1);
        boolean bl = finalElementComplete = finalElement.getIdTypeCase() == Key.PathElement.IdTypeCase.ID || finalElement.getIdTypeCase() == Key.PathElement.IdTypeCase.NAME;
        if (!constraint.allowCompleteKey()) {
            this.validateKeyAssertion(!finalElementComplete, "Key path element must not be complete", key);
        }
        if (!constraint.allowIncompleteKey(this.config.getAllowIncompleteKeyPathsInQueryFilters())) {
            this.validateKeyAssertion(finalElementComplete, "Key path element must not be incomplete", key);
        }
        this.validateKeyAssertion(numIncompleteElements == (finalElementComplete ? 0 : 1), "Key path element must not be incomplete", key);
    }

    public void validatePartitionId(ValidationConstraint constraint, PartitionIdOrBuilder partitionId) throws ValidationException {
        if (partitionId.getProjectIdBytes().isEmpty()) {
            ValidationException.validateAssertion(constraint.allowPartitionMissingProjectId(), "Partition id is missing project id.", new Object[0]);
        } else {
            this.validateStringUtf8(partitionId.getProjectIdBytes(), "project id");
            this.validateProjectId(constraint, partitionId.getProjectId());
        }
        if (!partitionId.getNamespaceId().isEmpty()) {
            this.validatePartitionIdDimensionBytes(partitionId.getNamespaceIdBytes(), "namespace id");
            this.validatePartitionIdDimension(constraint, partitionId.getNamespaceId(), "namespace id");
        }
    }

    public void validateProperty(ValidationConstraint constraint, ByteString propertyName, Value value) throws ValidationException {
        this.validateProperty(constraint, propertyName, value, 0, 0);
    }

    public void validateProperty(ValidationConstraint constraint, ByteString propertyName, Value value, int prefixLength, int depth) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, prefixLength, "");
        this.validateValue(constraint, value, prefixLength + propertyName.size() + ".".length(), depth + 1, propertyName.toStringUtf8());
    }

    public void validateLatLng(LatLngOrBuilder latLng) throws ValidationException {
        EntityV1Validator.validateGeoPoint(latLng.getLatitude(), latLng.getLongitude());
    }

    void validateValue(ValidationConstraint constraint, Value value, int newPrefixLength, int newDepth, String desc) throws ValidationException {
        switch (value.getValueTypeCase()) {
            case NULL_VALUE: 
            case BOOLEAN_VALUE: 
            case INTEGER_VALUE: 
            case DOUBLE_VALUE: {
                break;
            }
            case TIMESTAMP_VALUE: {
                this.validateTimestamp((TimestampOrBuilder)value.getTimestampValue());
                break;
            }
            case KEY_VALUE: {
                this.validateKey(constraint.withContext(ValidationConstraint.Context.IN_KEY_VALUE), (KeyOrBuilder)value.getKeyValue());
                break;
            }
            case STRING_VALUE: {
                if (value.getMeaning() == 17) {
                    this.validateStringUtf8(value.getStringValueBytes(), "blob key value");
                    break;
                }
                this.validateStringUtf8(value.getStringValueBytes(), "string value");
                break;
            }
            case BLOB_VALUE: {
                this.validateLength(value.getBlobValue(), this.config.getMaxRawPropertyBytes(), new StringBuilder(20 + String.valueOf(desc).length()).append("value of property \"").append(desc).append("\"").toString());
                break;
            }
            case GEO_POINT_VALUE: {
                if (value.getMeaning() == 23) break;
                this.validateLatLng((LatLngOrBuilder)value.getGeoPointValue());
                break;
            }
            case ENTITY_VALUE: {
                ValidationException.validateAssertion(newDepth <= this.config.getMaxEntityValueDepth(), "At most %s nested entity values are supported.", this.config.getMaxEntityValueDepth());
                this.validateEntity(constraint.withContext(ValidationConstraint.Context.IN_ENTITY_VALUE), value.getEntityValueOrBuilder(), newPrefixLength, newDepth);
                if (constraint.allowCompoundValues()) break;
                ValidationException.validateAssertion(value.getMeaning() != 0, "An entity value is not allowed", new Object[0]);
                break;
            }
            case ARRAY_VALUE: {
                ValidationException.validateAssertion(constraint.allowCompoundValues(), "A list value is not allowed", new Object[0]);
                ValidationException.validateAssertion(value.getMeaning() == 0, "A Value containing a list_value cannot specify a meaning.", new Object[0]);
                ValidationException.validateAssertion(!value.getExcludeFromIndexes(), "Exclude from indexes cannot be set on a list value", new Object[0]);
                for (Value subValue : value.getArrayValue().getValuesList()) {
                    ValidationException.validateAssertion(subValue.getArrayValue().getValuesCount() == 0, "list_value cannot contain a Value containing another list_value.", new Object[0]);
                    this.validateValue(constraint, subValue, newPrefixLength, newDepth, desc);
                }
                break;
            }
            case VALUETYPE_NOT_SET: {
                ValidationException.validateAssertion(false, "The value \"%s\" does not contain a value.", desc);
                break;
            }
            default: {
                String string = String.valueOf(value.getValueTypeCase());
                throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string).length()).append("Unrecognized value_type: ").append(string).toString());
            }
        }
        this.validateValueMeaningMatchesUnion(value, desc);
        this.validateValueMeaningConstraints(constraint, (ValueOrBuilder)value);
        this.validateValueIndexConstraints(value, desc);
    }

    void validateTimestamp(TimestampOrBuilder timestamp) throws ValidationException {
        ValidationException.validateAssertion(timestamp.getNanos() >= 0, "Timestamp nanos must be non-negative.", new Object[0]);
        ValidationException.validateAssertion(timestamp.getNanos() < 1000000000, "Timestamp nanos must be < 1,000,000,000.", new Object[0]);
    }

    private void validateValueMeaningMatchesUnion(Value value, String desc) throws ValidationException {
        if (value.getMeaning() == 0) {
            return;
        }
        String message = "Value \"%s\" has a meaning %d which does not match %s field.";
        int meaning = value.getMeaning();
        switch (meaning) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: {
                ValidationException.validateAssertion(value.getValueTypeCase() == Value.ValueTypeCase.STRING_VALUE, message, desc, meaning, "string_value");
                break;
            }
            case 16: 
            case 22: {
                ValidationException.validateAssertion(value.getValueTypeCase() == Value.ValueTypeCase.BLOB_VALUE, message, desc, meaning, "blob_value");
                break;
            }
            case 13: {
                ValidationException.validateAssertion(value.getValueTypeCase() == Value.ValueTypeCase.INTEGER_VALUE, message, desc, meaning, "integer_value");
                break;
            }
            case 20: {
                ValidationException.validateAssertion(value.getValueTypeCase() == Value.ValueTypeCase.ENTITY_VALUE, message, desc, meaning, "entity_value");
                break;
            }
            case 18: {
                ValidationException.validateAssertion(value.getValueTypeCase() != Value.ValueTypeCase.TIMESTAMP_VALUE, message, desc, meaning, "timestamp_value");
                ValidationException.validateAssertion(value.getValueTypeCase() != Value.ValueTypeCase.ENTITY_VALUE, message, desc, meaning, "entity_value");
                break;
            }
            case 23: {
                ValidationException.validateAssertion(value.getValueTypeCase() == Value.ValueTypeCase.GEO_POINT_VALUE, message, desc, meaning, "geo_point_value");
                break;
            }
            default: {
                ValidationException.validateAssertion(false, "Unknown value meaning %s.", meaning);
            }
        }
    }

    private void validateValueMeaningConstraints(ValidationConstraint constraint, ValueOrBuilder value) throws ValidationException {
        if (value.getMeaning() == 0) {
            return;
        }
        switch (value.getMeaning()) {
            case 15: 
            case 22: {
                ValidationException.validateAssertion(value.getExcludeFromIndexes(), "Indexed value has meaning %d.", value.getMeaning());
                break;
            }
            case 2: {
                this.validateLength(value.getStringValueBytes(), this.config.getMaxAtomLinkBytes(), "Url value");
                break;
            }
            case 13: {
                ValidationException.validateAssertion(value.getIntegerValue() >= 0L && value.getIntegerValue() <= 100L, "Percent value outside permitted range [0, 100].", new Object[0]);
                break;
            }
            case 20: {
                this.validatePredefinedValueEntity("user", (Map<String, Value.ValueTypeCase>)EntityHelper.PredefinedEntityUserConstants.PROPERTY_MAP, (Set<String>)EntityHelper.PredefinedEntityUserConstants.REQUIRED_PROPERTY_NAME_SET, (EntityOrBuilder)value.getEntityValue());
                break;
            }
            case 18: {
                ValidationException.validateAssertion(constraint.allowIndexOnlyMeaning(), "Projection property cannot be used.", new Object[0]);
            }
        }
    }

    private Map<String, ValueOrBuilder> validatePredefinedValueEntity(String predefinedEntityName, Map<String, Value.ValueTypeCase> allowedProperties, Set<String> requiredPropertyNameSet, EntityOrBuilder entity) throws ValidationException {
        ValidationException.validateAssertion(!entity.hasKey(), "The %s entity has a key.", predefinedEntityName);
        HashMap propertyMap = Maps.newHashMap();
        for (Map.Entry property : entity.getProperties().entrySet()) {
            String propertyName = (String)property.getKey();
            ValidationException.validateAssertion(allowedProperties.containsKey(propertyName), "The %s entity property \"%s\" is not allowed.", predefinedEntityName, propertyName);
            Value value = (Value)property.getValue();
            ValidationException.validateAssertion(value.getArrayValue().getValuesCount() == 0, "The %s entity property \"%s\" is multi-valued.", predefinedEntityName, propertyName);
            boolean isValueRequiredType = value.getValueTypeCase() == allowedProperties.get(propertyName);
            ValidationException.validateAssertion(isValueRequiredType, "The %s entity property \"%s\" is the wrong type.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(value.getMeaning() == 0, "The %s entity property \"%s\" has a meaning.", predefinedEntityName, propertyName);
            ValidationException.validateAssertion(value.getExcludeFromIndexes(), "The %s entity property \"%s\" is indexed.", predefinedEntityName, propertyName);
            propertyMap.put(propertyName, value);
        }
        for (String requiredPropertyName : requiredPropertyNameSet) {
            ValidationException.validateAssertion(propertyMap.containsKey(requiredPropertyName), "The %s entity is missing required property \"%s\".", predefinedEntityName, requiredPropertyName);
        }
        return propertyMap;
    }

    private void validateValueIndexConstraints(Value value, String propertyName) throws ValidationException {
        if (value.getExcludeFromIndexes()) {
            return;
        }
        if (value.getValueTypeCase() == Value.ValueTypeCase.STRING_VALUE && value.getMeaning() != 2) {
            this.validateLength(value.getStringValueBytes(), this.config.getMaxIndexedValueBytes(), new StringBuilder(20 + String.valueOf(propertyName).length()).append("value of property \"").append(propertyName).append("\"").toString());
        } else if (value.getValueTypeCase() == Value.ValueTypeCase.BLOB_VALUE) {
            this.validateLength(value.getBlobValue(), this.config.getMaxIndexedValueBytes(), new StringBuilder(20 + String.valueOf(propertyName).length()).append("value of property \"").append(propertyName).append("\"").toString());
        } else if (value.getValueTypeCase() == Value.ValueTypeCase.ENTITY_VALUE) {
            ValidationException.validateAssertion(value.getMeaning() != 0 || this.config.getEnableIndexedEntityValues(), "Entity value is indexed.", new Object[0]);
        }
    }

    private void validateKeyAssertion(boolean assertion, String message, KeyOrBuilder key) throws ValidationException {
        if (!assertion) {
            String string = Paths.toPathString(key);
            throw new ValidationException(new StringBuilder(2 + String.valueOf(message).length() + String.valueOf(string).length()).append(message).append(": ").append(string).toString());
        }
    }

    private boolean isOrContainsIndexedEntityValue(Value value) {
        if (value.getValueTypeCase() == Value.ValueTypeCase.ENTITY_VALUE && value.getMeaning() == 0) {
            return !value.getExcludeFromIndexes();
        }
        if (value.getValueTypeCase() == Value.ValueTypeCase.ARRAY_VALUE) {
            for (Value listValue : value.getArrayValue().getValuesList()) {
                if (!this.isOrContainsIndexedEntityValue(listValue)) continue;
                return true;
            }
        }
        return false;
    }
}

