/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameter;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpression;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.Projection;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.EntityHelper;
import com.google.apphosting.datastore.shared.EntityProtoConverter;
import com.google.apphosting.datastore.shared.GqlParserConstants;
import com.google.apphosting.datastore.shared.GqlParserTokenManager;
import com.google.apphosting.datastore.shared.ParseException;
import com.google.apphosting.datastore.shared.SimpleCharStream;
import com.google.apphosting.datastore.shared.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GqlParser
implements GqlParserConstants {
    private PartitionId defaultPartitionId;
    private boolean allowLiterals;
    private Version version;
    private Map<String, GqlQueryParameter> nameBindingMap;
    private List<GqlQueryParameter> positionBindingList;
    private boolean[] positionBindingUsedList;
    private Set<PropertyReference> firstV4PropertyReferenceSet = new HashSet<PropertyReference>();
    private static final ImmutableMap<Character, String> SLASHED_CHAR_TRANSLATION_MAP = new ImmutableMap.Builder().put((Object)Character.valueOf('\\'), (Object)"\\").put((Object)Character.valueOf('0'), (Object)"\u0000").put((Object)Character.valueOf('b'), (Object)"\b").put((Object)Character.valueOf('n'), (Object)"\n").put((Object)Character.valueOf('r'), (Object)"\r").put((Object)Character.valueOf('t'), (Object)"\t").put((Object)Character.valueOf('Z'), (Object)"\u001a").put((Object)Character.valueOf('%'), (Object)"\\%").put((Object)Character.valueOf('_'), (Object)"\\_").put((Object)Character.valueOf('\''), (Object)"'").put((Object)Character.valueOf('\"'), (Object)"\"").put((Object)Character.valueOf('`'), (Object)"`").build();
    private static final BaseEncoding BASE64_URL_WITHOUT_PADDING_ENCODING = BaseEncoding.base64Url().omitPadding();
    private static final String DATE_REGEX = "(\\d\\d\\d\\d-\\d\\d-\\d\\d)";
    private static final String TIME_REGEX = "(\\d\\d:\\d\\d:\\d\\d)(?:\\.(\\d{1,6}))?";
    private static final String TIMEZONE_REGEX = "((?:[+-]\\d\\d:\\d\\d)|[zZ])";
    private static final Pattern DATETIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d-\\d\\d-\\d\\d)[tT](\\d\\d:\\d\\d:\\d\\d)(?:\\.(\\d{1,6}))?((?:[+-]\\d\\d:\\d\\d)|[zZ])");
    private static final int DATE_GROUP = 1;
    private static final int TIME_IN_SECONDS_GROUP = 2;
    private static final int PARTIAL_SECONDS_GROUP = 3;
    private static final int TIME_ZONE_GROUP = 4;
    private static final DateFormat DATETIME_FORMAT = GqlParser.createDatetimeDateFormat();
    public GqlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[31];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[3];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public GqlParser(GqlQueryOrBuilder gqlQuery, PartitionId defaultPartitionId, Version version) {
        this(new StringReader(gqlQuery.getQueryString()));
        this.defaultPartitionId = defaultPartitionId;
        this.version = version;
        this.allowLiterals = gqlQuery.getAllowLiterals();
        this.nameBindingMap = gqlQuery.getNamedBindings();
        this.positionBindingList = gqlQuery.getPositionalBindingsList();
        this.positionBindingUsedList = new boolean[this.positionBindingList.size()];
    }

    private GqlQueryParameter lookupNameBinding(String name) throws ParseException {
        GqlQueryParameter param = this.nameBindingMap.get(name);
        if (param == null) {
            this.throwParseException("Absent named binding: %s.", name);
        }
        return param;
    }

    private GqlQueryParameter lookupPositionBinding(long position) throws ParseException {
        if (position > (long)this.positionBindingList.size()) {
            this.throwParseException("Absent positional binding: %d.", position);
        }
        int bindingArrayIndex = (int)position - 1;
        this.positionBindingUsedList[bindingArrayIndex] = true;
        return this.positionBindingList.get(bindingArrayIndex);
    }

    private void verifyEveryPositionBindingUsed() throws ParseException {
        for (int bindingArrayIndex = 0; bindingArrayIndex < this.positionBindingUsedList.length; ++bindingArrayIndex) {
            if (this.positionBindingUsedList[bindingArrayIndex]) continue;
            this.throwParseException("Unused positional binding: %d.", bindingArrayIndex + 1);
        }
    }

    private void checkAllowLiterals(String literalText) throws ParseException {
        if (!this.allowLiterals) {
            this.throwParseException("Disallowed literal: %s.", literalText);
        }
    }

    private String interpretUnquotedName(String unquotedName) throws ParseException {
        return unquotedName;
    }

    private String interpretQuotedName(String quotedName) throws ParseException {
        return GqlParser.deEscapeQuotedText(quotedName, '`');
    }

    private Value interpretStringLiteral(String stringLiteral, char quoteChar) throws ParseException {
        this.checkAllowLiterals(stringLiteral);
        return Value.newBuilder().setStringValue(GqlParser.deEscapeQuotedText(stringLiteral, quoteChar)).build();
    }

    private static String deEscapeQuotedText(String quotedText, char quoteChar) {
        int closingQuoteIndex = quotedText.length() - 1;
        if (quotedText.lastIndexOf(92, closingQuoteIndex) <= 0 && quotedText.lastIndexOf(quoteChar, closingQuoteIndex) <= 0) {
            return quotedText.substring(1, closingQuoteIndex);
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = 1; index < closingQuoteIndex; ++index) {
            char character = quotedText.charAt(index);
            if (character == '\\') {
                char slashedChar = quotedText.charAt(++index);
                buffer.append((String)SLASHED_CHAR_TRANSLATION_MAP.get((Object)Character.valueOf(slashedChar)));
                continue;
            }
            buffer.append(character);
            if (character != quoteChar) continue;
            ++index;
        }
        return buffer.toString();
    }

    private long interpretIntegerLiteral(String integerLiteral) throws ParseException {
        this.checkAllowLiterals(integerLiteral);
        try {
            return Long.parseLong(integerLiteral);
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid integer literal: %s", exception.getMessage());
        }
    }

    private Value interpretIntegerLiteralAsValue(String integerLiteral) throws ParseException {
        return Value.newBuilder().setIntegerValue(this.interpretIntegerLiteral(integerLiteral)).build();
    }

    private double interpretDoubleLiteral(String doubleLiteral) throws ParseException {
        this.checkAllowLiterals(doubleLiteral);
        try {
            return Double.parseDouble(doubleLiteral);
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid double literal: %s", exception.getMessage());
        }
    }

    private Value interpretDoubleLiteralAsValue(String doubleLiteral) throws ParseException {
        return Value.newBuilder().setDoubleValue(this.interpretDoubleLiteral(doubleLiteral)).build();
    }

    private Value interpretBlobText(String blobText) throws ParseException {
        byte[] blob;
        try {
            blob = BASE64_URL_WITHOUT_PADDING_ENCODING.decodeChecked((CharSequence)blobText);
        }
        catch (BaseEncoding.DecodingException exception) {
            throw this.throwParseException("Invalid blob text: \"%s\".", blobText);
        }
        return Value.newBuilder().setBlobValue(ByteString.copyFrom((byte[])blob)).build();
    }

    private Value interpretBlobKeyText(String blobKeyText) {
        return Value.newBuilder().setStringValue(blobKeyText).setMeaning(17).build();
    }

    private static DateFormat createDatetimeDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss XXX");
        dateFormat.setCalendar(new GregorianCalendar());
        dateFormat.setLenient(false);
        return dateFormat;
    }

    private Value interpretDatetimeText(String datetimeText) throws ParseException {
        ParsePosition parsePosition;
        Matcher datetimeMatcher = DATETIME_PATTERN.matcher(datetimeText);
        if (!datetimeMatcher.matches()) {
            throw this.throwParseException("Invalid datetime text (does not match pattern): \"%s\"", datetimeText);
        }
        String dateString = datetimeMatcher.group(1);
        String timeInSecondsString = datetimeMatcher.group(2);
        String partialSecondsString = datetimeMatcher.group(3);
        String timezoneString = datetimeMatcher.group(4);
        long partialSecondsMicroseconds = 0L;
        if (partialSecondsString != null) {
            long partialSecondsNum = Long.parseLong(partialSecondsString);
            for (int counter = partialSecondsString.length(); counter < 6; ++counter) {
                partialSecondsNum *= 10L;
            }
            partialSecondsMicroseconds = partialSecondsNum;
        }
        if (timezoneString.equals("+00:00") || timezoneString.equals("-00:00")) {
            throw this.throwParseException("Invalid datetime text (zero offset must be Z): \"%s\"", datetimeText);
        }
        if (timezoneString.equals("z")) {
            timezoneString = "Z";
        }
        String string = timezoneString;
        String formattedDatetimeString = new StringBuilder(2 + String.valueOf(dateString).length() + String.valueOf(timeInSecondsString).length() + String.valueOf(string).length()).append(dateString).append(" ").append(timeInSecondsString).append(" ").append(string).toString();
        Date date = DATETIME_FORMAT.parse(formattedDatetimeString, parsePosition = new ParsePosition(0));
        if (date == null || parsePosition.getIndex() < formattedDatetimeString.length()) {
            throw this.throwParseException("Invalid datetime text (parse failure): \"%s\"", datetimeText);
        }
        long timestampMilliseconds = date.getTime();
        long timestampMicroseconds = 1000L * timestampMilliseconds + partialSecondsMicroseconds;
        return Value.newBuilder().setTimestampValue(EntityProtoConverter.microsecondsToTimestamp(timestampMicroseconds)).build();
    }

    private GqlQueryParameter interpretBindingSiteWithName(String bindingSiteWithName) throws ParseException {
        String name = bindingSiteWithName.substring(1);
        return this.lookupNameBinding(name);
    }

    private GqlQueryParameter interpretBindingSiteWithPosition(String bindingSiteWithPosition) throws ParseException {
        String integerText = bindingSiteWithPosition.substring(1);
        try {
            long integerAsLong = Long.parseLong(integerText);
            if (integerAsLong == 0L) {
                this.throwParseException("Invalid binding site @0.", new Object[0]);
            }
            return this.lookupPositionBinding(integerAsLong);
        }
        catch (NumberFormatException exception) {
            throw this.throwParseException("Invalid positional binding site: %s", exception.getMessage());
        }
    }

    private List<PropertyReference> determineDistinctOnListForDistinctWithoutOn(List<Projection> projectionList) throws ParseException {
        ArrayList distinctOnList = Lists.newArrayList();
        for (Projection projection : projectionList) {
            if (this.firstV4PropertyReferenceSet.contains(projection.getProperty())) continue;
            distinctOnList.add(projection.getProperty());
        }
        if (distinctOnList.isEmpty()) {
            this.throwParseException("Distinct projection queries with only aggregated properties are not supported.", new Object[0]);
        }
        return distinctOnList;
    }

    private int interpretIntegerValueAsResultCount(String descriptor, Value integerValue) throws ParseException {
        long count = integerValue.getIntegerValue();
        if (count < 0L) {
            this.throwParseException("The %s %d is < 0.", descriptor, count);
        }
        if (count > Integer.MAX_VALUE) {
            this.throwParseException("The %s %d is too large.", descriptor, count);
        }
        return (int)count;
    }

    private ParseException throwParseException(String message, Object ... formatArgList) throws ParseException {
        throw new ParseException(String.format(message, formatArgList));
    }

    public final Query.Builder selector() throws ParseException {
        ImmutableList projectionList;
        Query.Builder resultBuilder = Query.newBuilder();
        boolean isDistinct = false;
        List<PropertyReference> distinctOnList = null;
        this.jj_consume_token(39);
        block0 : switch (this.jj_nt.kind) {
            case 18: {
                this.jj_consume_token(18);
                isDistinct = true;
                switch (this.jj_nt.kind) {
                    case 34: {
                        this.jj_consume_token(34);
                        if (this.version == Version.V4) {
                            throw this.throwParseException("DISTINCT ON not supported.", new Object[0]);
                        }
                        this.jj_consume_token(60);
                        distinctOnList = this.propertyReferenceList();
                        this.jj_consume_token(61);
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 62: {
                this.jj_consume_token(62);
                if (isDistinct && distinctOnList == null) {
                    this.throwParseException("Encountered \"*\" immediately after DISTINCT.", new Object[0]);
                }
                projectionList = ImmutableList.of();
                break;
            }
            case 56: 
            case 57: {
                projectionList = this.aggregatedPropertyReferenceList();
                resultBuilder.addAllProjection(projectionList);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (isDistinct) {
            if (distinctOnList == null) {
                distinctOnList = this.determineDistinctOnListForDistinctWithoutOn((List<Projection>)projectionList);
            }
            resultBuilder.addAllDistinctOn(distinctOnList);
        }
        switch (this.jj_nt.kind) {
            case 21: {
                this.jj_consume_token(21);
                KindExpression kindExpression = this.kind();
                resultBuilder.addKind(kindExpression);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 43: {
                this.jj_consume_token(43);
                Filter filter = this.compoundCondition();
                resultBuilder.setFilter(filter);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 22: {
                this.jj_consume_token(22);
                this.jj_consume_token(13);
                if (this.version != Version.V4) {
                    throw this.throwParseException("GROUP BY not supported.", new Object[0]);
                }
                if (isDistinct) {
                    this.throwParseException("Query specifies both DISTINCT and GROUP BY.", new Object[0]);
                }
                distinctOnList = this.propertyReferenceList();
                resultBuilder.addAllDistinctOn(distinctOnList);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 36: {
                this.jj_consume_token(36);
                this.jj_consume_token(13);
                List<PropertyOrder> orderByList = this.orderedPropertyReferenceList();
                resultBuilder.addAllOrder(orderByList);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 29: {
                this.jj_consume_token(29);
                this.limit(resultBuilder);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 33: {
                this.jj_consume_token(33);
                this.offset(resultBuilder);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        this.verifyEveryPositionBindingUsed();
        return resultBuilder;
    }

    public final Filter compoundCondition() throws ParseException {
        CompositeFilter.Builder compositeFilterBuilder = null;
        Filter condition = this.condition();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            if (compositeFilterBuilder == null) {
                compositeFilterBuilder = CompositeFilter.newBuilder().setOp(CompositeFilter.Operator.AND).addFilters(condition);
            }
            condition = this.condition();
            compositeFilterBuilder.addFilters(condition);
        }
        if (compositeFilterBuilder == null) {
            return condition;
        }
        return Filter.newBuilder().setCompositeFilter(compositeFilterBuilder.build()).build();
    }

    public final Filter condition() throws ParseException {
        Filter filter = this.conditionPropertyFilter();
        return filter;
    }

    public final double numberLiteralAsDouble() throws ParseException {
        switch (this.jj_nt.kind) {
            case 50: {
                Value value = this.integerLiteral();
                return value.getIntegerValue();
            }
            case 51: {
                Value value = this.doubleLiteral();
                return value.getDoubleValue();
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Filter conditionPropertyFilter() throws ParseException {
        PropertyReference propertyReference;
        PropertyFilter.Operator comparator;
        Value value;
        if (this.jj_2_1(2)) {
            value = this.value();
            comparator = this.comparator_with_property_right_op();
            propertyReference = this.propertyReference();
        } else {
            block0 : switch (this.jj_nt.kind) {
                case 56: 
                case 57: {
                    propertyReference = this.propertyReference();
                    switch (this.jj_nt.kind) {
                        case 26: {
                            this.jj_consume_token(26);
                            comparator = PropertyFilter.Operator.EQUAL;
                            value = this.nullValue();
                            break block0;
                        }
                        case 14: 
                        case 23: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: {
                            comparator = this.comparator_with_property_left_op();
                            value = this.value();
                            break block0;
                        }
                    }
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        PropertyFilter propertyFilter = PropertyFilter.newBuilder().setOp(comparator).setProperty(propertyReference).setValue(value).build();
        return Filter.newBuilder().setPropertyFilter(propertyFilter).build();
    }

    public final PropertyFilter.Operator comparator_with_property_left_op() throws ParseException {
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                return PropertyFilter.Operator.EQUAL;
            }
            case 64: {
                this.jj_consume_token(64);
                return PropertyFilter.Operator.LESS_THAN;
            }
            case 65: {
                this.jj_consume_token(65);
                return PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case 66: {
                this.jj_consume_token(66);
                return PropertyFilter.Operator.GREATER_THAN;
            }
            case 67: {
                this.jj_consume_token(67);
                return PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case 14: {
                this.jj_consume_token(14);
                return PropertyFilter.Operator.EQUAL;
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(6);
                return PropertyFilter.Operator.HAS_ANCESTOR;
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PropertyFilter.Operator comparator_with_property_right_op() throws ParseException {
        switch (this.jj_nt.kind) {
            case 63: {
                this.jj_consume_token(63);
                return PropertyFilter.Operator.EQUAL;
            }
            case 64: {
                this.jj_consume_token(64);
                return PropertyFilter.Operator.GREATER_THAN;
            }
            case 65: {
                this.jj_consume_token(65);
                return PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case 66: {
                this.jj_consume_token(66);
                return PropertyFilter.Operator.LESS_THAN;
            }
            case 67: {
                this.jj_consume_token(67);
                return PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case 25: {
                this.jj_consume_token(25);
                return PropertyFilter.Operator.EQUAL;
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(17);
                return PropertyFilter.Operator.HAS_ANCESTOR;
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<Projection> aggregatedPropertyReferenceList() throws ParseException {
        ArrayList propertyExpressionList = Lists.newArrayList();
        Projection propertyExpression = this.aggregatedPropertyReference();
        propertyExpressionList.add(propertyExpression);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 68: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(68);
            propertyExpression = this.aggregatedPropertyReference();
            propertyExpressionList.add(propertyExpression);
        }
        return propertyExpressionList;
    }

    public final Projection aggregatedPropertyReference() throws ParseException {
        PropertyReference propertyReference;
        Projection.Builder resultBuilder = Projection.newBuilder();
        boolean isFirstProjection = false;
        if (this.jj_2_2(2)) {
            Token identifier = this.jj_consume_token(56);
            if (this.version != Version.V4 || !identifier.image.toUpperCase().equals("FIRST")) {
                throw this.throwParseException("Unknown aggregator function \"%s\".", identifier.image);
            }
            isFirstProjection = true;
            this.jj_consume_token(60);
            propertyReference = this.propertyReference();
            this.jj_consume_token(61);
        } else {
            switch (this.jj_nt.kind) {
                case 56: 
                case 57: {
                    propertyReference = this.propertyReference();
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        resultBuilder.setProperty(propertyReference);
        Projection result = resultBuilder.build();
        if (isFirstProjection) {
            this.firstV4PropertyReferenceSet.add(propertyReference);
        }
        return result;
    }

    public final List<PropertyOrder> orderedPropertyReferenceList() throws ParseException {
        ArrayList orderedPropertyReferenceList = Lists.newArrayList();
        PropertyOrder orderedPropertyReference = this.orderedPropertyReference();
        orderedPropertyReferenceList.add(orderedPropertyReference);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 68: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(68);
            orderedPropertyReference = this.orderedPropertyReference();
            orderedPropertyReferenceList.add(orderedPropertyReference);
        }
        return orderedPropertyReferenceList;
    }

    public final PropertyOrder orderedPropertyReference() throws ParseException {
        PropertyOrder.Builder resultBuilder = PropertyOrder.newBuilder();
        PropertyReference propertyReference = this.propertyReference();
        resultBuilder.setProperty(propertyReference);
        resultBuilder.setDirection(PropertyOrder.Direction.ASCENDING);
        block0 : switch (this.jj_nt.kind) {
            case 10: 
            case 16: {
                switch (this.jj_nt.kind) {
                    case 10: {
                        this.jj_consume_token(10);
                        break block0;
                    }
                    case 16: {
                        this.jj_consume_token(16);
                        resultBuilder.setDirection(PropertyOrder.Direction.DESCENDING);
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        return resultBuilder.build();
    }

    public final List<PropertyReference> propertyReferenceList() throws ParseException {
        ArrayList propertyReferenceList = Lists.newArrayList();
        PropertyReference propertyReference = this.propertyReference();
        propertyReferenceList.add(propertyReference);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 68: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(68);
            propertyReference = this.propertyReference();
            propertyReferenceList.add(propertyReference);
        }
        return propertyReferenceList;
    }

    public final void limit(Query.Builder resultBuilder) throws ParseException {
        Object limitObject;
        Object limitObject2 = null;
        switch (this.jj_nt.kind) {
            case 50: 
            case 58: 
            case 59: {
                limitObject = this.resultPosition("limit", BindingConstraint.CURSOR_OR_INTEGER);
                break;
            }
            case 56: {
                Token identifier = this.jj_consume_token(56);
                if (!identifier.image.equalsIgnoreCase("first")) {
                    this.throwParseException("Unexpected name \"%s\" (after LIMIT).", identifier.image);
                }
                this.jj_consume_token(60);
                limitObject = this.resultPosition("limit", BindingConstraint.CURSOR_OR_INTEGER);
                this.jj_consume_token(68);
                limitObject2 = this.resultPosition("limit", limitObject instanceof ByteString ? BindingConstraint.INTEGER : BindingConstraint.CURSOR);
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (limitObject instanceof Integer) {
            Object temp = limitObject;
            limitObject = limitObject2;
            limitObject2 = temp;
        }
        if (limitObject != null) {
            resultBuilder.setEndCursor((ByteString)limitObject);
        }
        if (limitObject2 != null) {
            resultBuilder.getLimitBuilder().setValue(((Integer)limitObject2).intValue());
        }
    }

    public final void offset(Query.Builder resultBuilder) throws ParseException {
        Object offsetCountObject = null;
        Object offsetObject = this.resultPosition("offset", BindingConstraint.CURSOR_OR_INTEGER);
        switch (this.jj_nt.kind) {
            case 69: {
                this.jj_consume_token(69);
                if (offsetObject instanceof Integer) {
                    this.throwParseException("Encountered \"+\" after integer offset.", new Object[0]);
                }
                offsetCountObject = this.resultPosition("offset", BindingConstraint.INTEGER);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        if (offsetObject instanceof Integer) {
            offsetCountObject = offsetObject;
            offsetObject = null;
        }
        if (offsetObject != null) {
            resultBuilder.setStartCursor((ByteString)offsetObject);
        }
        if (offsetCountObject != null) {
            resultBuilder.setOffset(((Integer)offsetCountObject).intValue());
        }
    }

    public final Object resultPosition(String descriptor, BindingConstraint bindingConstraint) throws ParseException {
        switch (this.jj_nt.kind) {
            case 50: {
                Value value = this.integerLiteral();
                if (bindingConstraint == BindingConstraint.CURSOR) {
                    this.throwParseException("Expected %s cursor instead of %s.", descriptor, this.token.image);
                }
                return this.interpretIntegerValueAsResultCount(descriptor, value);
            }
            case 58: 
            case 59: {
                GqlQueryParameter param = this.bindingSite(descriptor, bindingConstraint);
                GqlQueryParameter.ArgTypeCase paramArgTypeCase = param.getArgTypeCase();
                switch (paramArgTypeCase) {
                    case VALUE: {
                        return this.interpretIntegerValueAsResultCount(descriptor, param.getValue());
                    }
                    case CURSOR: {
                        return param.getCursor();
                    }
                }
                this.throwParseException("Unimplemented GQL parameter type \"%s\".", paramArgTypeCase);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final PropertyReference propertyReference() throws ParseException {
        String propertyName = this.name();
        return PropertyReference.newBuilder().setName(propertyName).build();
    }

    public final Value value() throws ParseException {
        switch (this.jj_nt.kind) {
            case 58: 
            case 59: {
                GqlQueryParameter param = this.bindingSite("value", BindingConstraint.VALUE);
                return param.getValue();
            }
            case 56: {
                Value value = this.syntheticLiteral();
                return value;
            }
            case 54: 
            case 55: {
                Value value = this.stringLiteral();
                return value;
            }
            case 50: {
                Value value = this.integerLiteral();
                return value;
            }
            case 51: {
                Value value = this.doubleLiteral();
                return value;
            }
            case 42: {
                Token literal = this.jj_consume_token(42);
                this.checkAllowLiterals(literal.image);
                return EntityHelper.TRUE_V1_VALUE;
            }
            case 20: {
                Token literal = this.jj_consume_token(20);
                this.checkAllowLiterals(literal.image);
                return EntityHelper.FALSE_V1_VALUE;
            }
            case 32: {
                Value value = this.nullValue();
                return value;
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Value nullValue() throws ParseException {
        Token literal = this.jj_consume_token(32);
        this.checkAllowLiterals(literal.image);
        return EntityHelper.NULL_V1_VALUE;
    }

    public final Value syntheticLiteral() throws ParseException {
        Function function;
        Token identifier = this.jj_consume_token(56);
        try {
            function = Function.valueOf(identifier.image.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            throw this.throwParseException("Unknown function \"%s\".", identifier.image);
        }
        this.checkAllowLiterals(identifier.image);
        this.jj_consume_token(60);
        Value result = this.syntheticLiteralContent(function);
        this.jj_consume_token(61);
        return result;
    }

    public final Value syntheticLiteralContent(Function function) throws ParseException {
        if (function == Function.KEY) {
            Value value = this.keySyntheticLiteralContent(this.defaultPartitionId);
            return value;
        }
        switch (this.jj_nt.kind) {
            case 54: 
            case 55: {
                Value value = this.stringLiteral();
                String string = value.getStringValue();
                switch (function) {
                    case BLOB: {
                        return this.interpretBlobText(string);
                    }
                    case DATETIME: {
                        return this.interpretDatetimeText(string);
                    }
                    case BLOBKEY: {
                        if (this.version != Version.V4) break;
                        return this.interpretBlobKeyText(string);
                    }
                }
                throw this.throwParseException("Unimplemented function \"%s\".", new Object[]{function});
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Value keySyntheticLiteralContent(PartitionId defaultPartitionId) throws ParseException {
        Key.Builder keyBuilder = Key.newBuilder().setPartitionId(defaultPartitionId);
        PartitionId partitionId = this.partitionIdSubSyntheticLiteral(defaultPartitionId);
        keyBuilder.setPartitionId(partitionId);
        this.keyPath(keyBuilder);
        return Value.newBuilder().setKeyValue(keyBuilder.build()).build();
    }

    public final PartitionId partitionIdSubSyntheticLiteral(PartitionId defaultPartitionId) throws ParseException {
        PartitionId.Builder partitionIdBuilder = null;
        while (this.jj_2_3(2)) {
            Token identifier = this.jj_consume_token(56);
            if (partitionIdBuilder == null) {
                partitionIdBuilder = PartitionId.newBuilder();
            }
            boolean isProject = identifier.image.equalsIgnoreCase("dataset");
            boolean isNamespace = identifier.image.equalsIgnoreCase("namespace");
            if (isProject) {
                if (!partitionIdBuilder.getProjectId().isEmpty()) {
                    this.throwParseException("A key may have at most one project.", new Object[0]);
                }
                if (!partitionIdBuilder.getNamespaceId().isEmpty()) {
                    this.throwParseException("A key's project must precede its namespace.", new Object[0]);
                }
            } else if (isNamespace) {
                if (!partitionIdBuilder.getNamespaceId().isEmpty()) {
                    this.throwParseException("A key may have at most one namespace.", new Object[0]);
                }
            } else {
                this.throwParseException("Unknown partition dimension \"%s\".", identifier.image);
            }
            this.jj_consume_token(60);
            Value nameValue = this.stringLiteral();
            String name = nameValue.getStringValue();
            if (isProject) {
                partitionIdBuilder.setProjectId(name);
            } else if (isNamespace) {
                partitionIdBuilder.setNamespaceId(name);
            }
            this.jj_consume_token(61);
            this.jj_consume_token(68);
        }
        if (partitionIdBuilder == null) {
            return defaultPartitionId;
        }
        if (partitionIdBuilder.getProjectId().isEmpty()) {
            partitionIdBuilder.setProjectId(defaultPartitionId.getProjectId());
        }
        return partitionIdBuilder.build();
    }

    public final void keyPath(Key.Builder keyBuilder) throws ParseException {
        Key.PathElement keyPathElement = this.keyPathElement();
        keyBuilder.addPath(keyPathElement);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 68: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(68);
            keyPathElement = this.keyPathElement();
            keyBuilder.addPath(keyPathElement);
        }
    }

    public final Key.PathElement keyPathElement() throws ParseException {
        Key.PathElement.Builder keyPathElementBuilder = Key.PathElement.newBuilder();
        KindExpression kindExpression = this.kind();
        keyPathElementBuilder.setKind(kindExpression.getName());
        this.jj_consume_token(68);
        switch (this.jj_nt.kind) {
            case 50: {
                Value id = this.integerLiteral();
                keyPathElementBuilder.setId(id.getIntegerValue());
                break;
            }
            case 54: 
            case 55: {
                Value name = this.stringLiteral();
                keyPathElementBuilder.setName(name.getStringValue());
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return keyPathElementBuilder.build();
    }

    public final Value stringLiteral() throws ParseException {
        switch (this.jj_nt.kind) {
            case 54: {
                Token literal = this.jj_consume_token(54);
                return this.interpretStringLiteral(literal.image, '\'');
            }
            case 55: {
                Token literal = this.jj_consume_token(55);
                return this.interpretStringLiteral(literal.image, '\"');
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Value integerLiteral() throws ParseException {
        Token literal = this.jj_consume_token(50);
        return this.interpretIntegerLiteralAsValue(literal.image);
    }

    public final Value doubleLiteral() throws ParseException {
        Token literal = this.jj_consume_token(51);
        return this.interpretDoubleLiteralAsValue(literal.image);
    }

    public final GqlQueryParameter bindingSite(String descriptor, BindingConstraint bindingConstraint) throws ParseException {
        GqlQueryParameter param;
        Token site;
        switch (this.jj_nt.kind) {
            case 58: {
                site = this.jj_consume_token(58);
                param = this.interpretBindingSiteWithName(site.image);
                break;
            }
            case 59: {
                site = this.jj_consume_token(59);
                param = this.interpretBindingSiteWithPosition(site.image);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        GqlQueryParameter.ArgTypeCase argTypeCase = param.getArgTypeCase();
        switch (bindingConstraint) {
            case VALUE: {
                if (argTypeCase == GqlQueryParameter.ArgTypeCase.VALUE) break;
                this.throwParseException("Binding site %s for %s bound to non-value parameter.", site.image, descriptor);
                break;
            }
            case CURSOR: {
                if (argTypeCase == GqlQueryParameter.ArgTypeCase.CURSOR) break;
                this.throwParseException("Binding site %s for %s bound to non-cursor parameter.", site.image, descriptor);
                break;
            }
            case INTEGER: {
                if (argTypeCase == GqlQueryParameter.ArgTypeCase.VALUE) break;
                this.throwParseException("Binding site %s for %s bound to non-value parameter.", site.image, descriptor);
                break;
            }
            case CURSOR_OR_INTEGER: {
                if (argTypeCase == GqlQueryParameter.ArgTypeCase.CURSOR || argTypeCase == GqlQueryParameter.ArgTypeCase.VALUE) break;
                this.throwParseException("Binding site %s for %s bound to parameter that is neither a cursor nor an integer value.", site.image, descriptor);
            }
        }
        if ((bindingConstraint == BindingConstraint.INTEGER || bindingConstraint == BindingConstraint.CURSOR_OR_INTEGER) && argTypeCase == GqlQueryParameter.ArgTypeCase.VALUE && param.getValue().getValueTypeCase() != Value.ValueTypeCase.INTEGER_VALUE) {
            this.throwParseException("Binding site %s for %s bound to non-integer value parameter.", site.image, descriptor);
        }
        return param;
    }

    public final KindExpression kind() throws ParseException {
        String kindName = this.name();
        return KindExpression.newBuilder().setName(kindName).build();
    }

    public final String name() throws ParseException {
        switch (this.jj_nt.kind) {
            case 56: {
                Token name = this.jj_consume_token(56);
                return this.interpretUnquotedName(name.image);
            }
            case 57: {
                Token quotedName = this.jj_consume_token(57);
                return this.interpretQuotedName(quotedName.image);
            }
        }
        this.jj_la1[30] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_9() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_9()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_10()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_11()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_12()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_13()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_14()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_15()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_16()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_29() {
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_19() {
        return this.jj_scan_token(65);
    }

    private final boolean jj_3R_31() {
        return this.jj_scan_token(59);
    }

    private final boolean jj_3R_18() {
        return this.jj_scan_token(64);
    }

    private final boolean jj_3R_30() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_16() {
        return this.jj_3R_29();
    }

    private final boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_19()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_20()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_21()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_22()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_23()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_17() {
        return this.jj_scan_token(63);
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_28() {
        return this.jj_scan_token(51);
    }

    private final boolean jj_3R_14() {
        return this.jj_scan_token(42);
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_28();
    }

    private final boolean jj_3R_23() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_12() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_27() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_22() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3R_25() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_scan_token(60);
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_3R_8();
    }

    private final boolean jj_3R_11() {
        return this.jj_3R_26();
    }

    private final boolean jj_3R_21() {
        return this.jj_scan_token(67);
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_33() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3R_10() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_20() {
        return this.jj_scan_token(66);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 262144, 0, 0x200000, 0, 0x400000, 0, 0x20000000, 0, 128, 0, 0x4804000, 0, 0x804000, 0x2800000, 0, 0, 0, 66560, 66560, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{4, 0, 0x43000000, 0, 2048, 0, 16, 0, 2, 0, 786432, Integer.MIN_VALUE, 0x3000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0x3000000, 0, 0, 0, 0, 0xD040000, 0, 0xC040000, 231474177, 0xC00000, 0, 0xC40000, 0xC00000, 0xC000000, 0x3000000};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 15, 15, 16, 0, 16, 0, 0, 16, 0, 32, 0, 0, 0, 16, 0, 0, 0, 0};
    }

    public GqlParser(InputStream stream) {
        this(stream, null);
    }

    public GqlParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new GqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public GqlParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new GqlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public GqlParser(GqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(GqlParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 31; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[70];
        for (i = 0; i < 70; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 31; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 70; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 3; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        GqlParser.jj_la1_0();
        GqlParser.jj_la1_1();
        GqlParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private static enum BindingConstraint {
        VALUE,
        CURSOR,
        INTEGER,
        CURSOR_OR_INTEGER;

    }

    private static enum Function {
        BLOB,
        BLOBKEY,
        DATETIME,
        KEY;

    }

    public static enum Version {
        V4,
        V1;

    }
}

