/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.LoadingCache;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationResult;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.rpc.Code;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.CloudDatastoreV1ServiceValidator;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.Config;
import com.google.apphosting.datastore.shared.DatastoreHelper;
import com.google.apphosting.datastore.shared.DatastoreProtoConverter;
import com.google.apphosting.datastore.shared.DatastoreServiceProtoConverter;
import com.google.apphosting.datastore.shared.EntityV1Validator;
import com.google.apphosting.datastore.shared.EntityV3V1Converter;
import com.google.apphosting.datastore.shared.EntityV4Converter;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.UserValueObfuscator;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;

@ServiceProvider(value=LocalRpcService.class)
public class LocalCloudDatastoreV1Service
extends AbstractLocalRpcService {
    public static final String PACKAGE = "cloud_datastore_v1";
    public static final ProjectIdAppIdResolver RESOLVER = new ProjectIdAppIdResolver(){

        @Override
        public String toAppId(String projectId) throws InvalidConversionException {
            if (projectId.isEmpty()) {
                return ApiProxy.getCurrentEnvironment().getAppId();
            }
            return DatastoreHelper.projectIdToApp(this.getCluster(), projectId);
        }

        @Override
        public String toProjectId(String appId) {
            String cluster = this.getCluster();
            Preconditions.checkArgument((cluster.isEmpty() || appId.startsWith(cluster) ? 1 : 0) != 0);
            return DatastoreHelper.appToProjectId(appId);
        }

        private String getCluster() {
            return DatastoreHelper.getCluster(ApiProxy.getCurrentEnvironment().getAppId());
        }
    };
    private static final Collection<OnestoreEntity.CompositeIndex> EMPTY_INDEX_COLLECTION = Collections.emptySet();
    private static final boolean NO_IN_MEMORY_OPERATIONS = false;
    static final EntityV4Converter ENTITY_V4_CONVERTER = new EntityV4Converter(false, UserValueObfuscator.IDENTITY);
    private static final Config.DatastoreConfig LOCAL_CONFIG = Config.DatastoreConfig.newBuilder().addAllReservedKindsToAllow(LocalDatastoreService.RESERVED_KIND_WHITELIST).build();
    static final DatastoreServiceProtoConverter LOCAL_SERVICE_CONVERTER = new DatastoreServiceProtoConverter(new DatastoreProtoConverter(ENTITY_V4_CONVERTER, LOCAL_CONFIG)){

        @Override
        public DatastorePb.Transaction toV3Transaction(ByteString transactionBytes, String app) throws InvalidConversionException {
            try {
                return (DatastorePb.Transaction)DatastorePb.Transaction.parser().parseFrom(transactionBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toTransactionBytes(DatastorePb.Transaction transactionV3) {
            return transactionV3.toByteString();
        }

        @Override
        public DatastorePb.Cursor toV3Cursor(ByteString queryHandleV4) throws InvalidConversionException {
            try {
                return (DatastorePb.Cursor)DatastorePb.Cursor.parser().parseFrom(queryHandleV4);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidConversionException(e);
            }
        }

        @Override
        public ByteString toV4QueryHandle(DatastorePb.Cursor cursorV3) {
            return cursorV3.toByteString();
        }
    };
    private static final CloudDatastoreV1ServiceValidator LOCAL_VALIDATOR = new CloudDatastoreV1ServiceValidator(new CloudDatastoreV1Validator(new EntityV1Validator(LOCAL_CONFIG)));

    public String getPackage() {
        return PACKAGE;
    }

    public AllocateIdsResponse allocateIds(LocalRpcService.Status status, AllocateIdsRequest req) {
        DatastorePb.AllocateIdsResponse respV3;
        AllocateIdsResponse.Builder respBuilder = AllocateIdsResponse.newBuilder();
        try {
            LOCAL_VALIDATOR.validateAllocateIdsRequest((AllocateIdsRequestOrBuilder)req);
            DatastorePb.AllocateIdsRequest reqV3 = new DatastorePb.AllocateIdsRequest();
            reqV3.setSize((long)req.getKeysCount());
            respV3 = (DatastorePb.AllocateIdsResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.AllocateIds, (MessageLite)reqV3, DatastorePb.AllocateIdsResponse.parser());
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        if (respV3.getEnd() - respV3.getStart() + 1L < (long)req.getKeysCount()) {
            throw LocalCloudDatastoreV1Service.invalidArgument("could not allocate sufficent ids");
        }
        long i = respV3.getStart();
        for (Key reqKey : req.getKeysList()) {
            Key.Builder respKey;
            try {
                respKey = EntityV3V1Converter.INSTANCE.toV1Key(RESOLVER, EntityV3V1Converter.INSTANCE.toV3Reference(RESOLVER, (KeyOrBuilder)reqKey));
            }
            catch (InvalidConversionException e) {
                throw LocalCloudDatastoreV1Service.internalError(e);
            }
            respKey.getPathBuilder(respKey.getPathCount() - 1).setId(LocalDatastoreService.toScatteredId(i++));
            respBuilder.addKeys(respKey);
        }
        return respBuilder.build();
    }

    public BeginTransactionResponse beginTransaction(LocalRpcService.Status status, BeginTransactionRequest req) {
        try {
            LOCAL_VALIDATOR.validateBeginTransactionRequest((BeginTransactionRequestOrBuilder)req);
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        DatastorePb.BeginTransactionRequest reqV3 = new DatastorePb.BeginTransactionRequest().setApp(LocalCloudDatastoreV1Service.getAppId()).setAllowMultipleEg(true);
        DatastorePb.Transaction internalResp = (DatastorePb.Transaction)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)reqV3, DatastorePb.Transaction.parser());
        try {
            return LOCAL_SERVICE_CONVERTER.toV1BeginTransactionResponse(internalResp).build();
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.internalError(e);
        }
    }

    private static LoadingCache<OnestoreEntity.Reference, Boolean> newExistenceCache(final DatastorePb.Transaction transactionV3) {
        Preconditions.checkNotNull((Object)transactionV3);
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<OnestoreEntity.Reference, Boolean>(){

            public Boolean load(OnestoreEntity.Reference key) throws Exception {
                DatastorePb.GetRequest get = new DatastorePb.GetRequest().setTransaction(transactionV3);
                get.addKey(key);
                DatastorePb.GetResponse res = (DatastorePb.GetResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)get, DatastorePb.GetResponse.parser());
                return res.getEntity(0).hasEntity();
            }
        });
    }

    public CommitResponse commit(LocalRpcService.Status status, CommitRequest req) {
        CommitResponse.Builder builder = CommitResponse.newBuilder();
        try {
            LOCAL_VALIDATOR.validateCommitRequest(false, (CommitRequestOrBuilder)req);
            boolean hasTransaction = !req.getTransaction().isEmpty();
            ByteString transaction = hasTransaction ? req.getTransaction() : null;
            LoadingCache<OnestoreEntity.Reference, Boolean> existenceCache = hasTransaction ? LocalCloudDatastoreV1Service.newExistenceCache(LOCAL_SERVICE_CONVERTER.toV3Transaction(req.getTransaction(), LocalCloudDatastoreV1Service.getAppId())) : null;
            this.applyMutationList(req.getMutationsList(), transaction, existenceCache, builder);
            if (hasTransaction) {
                DatastorePb.CommitResponse commitRes = (DatastorePb.CommitResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3Transaction(req.getTransaction(), LocalCloudDatastoreV1Service.getAppId()), DatastorePb.CommitResponse.parser());
                builder.setIndexUpdates(builder.getIndexUpdates() + commitRes.getCost().getIndexWrites());
            }
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        return builder.build();
    }

    public RollbackResponse rollback(LocalRpcService.Status status, RollbackRequest req) {
        try {
            LOCAL_VALIDATOR.validateRollbackRequest((RollbackRequestOrBuilder)req);
            LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Rollback, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3Transaction((RollbackRequestOrBuilder)req, LocalCloudDatastoreV1Service.getAppId()), ApiBasePb.VoidProto.parser());
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        return RollbackResponse.getDefaultInstance();
    }

    public LookupResponse get(LocalRpcService.Status status, LookupRequest request) {
        return this.lookup(status, request);
    }

    public LookupResponse lookup(LocalRpcService.Status status, LookupRequest request) {
        DatastorePb.GetResponse internResp;
        try {
            LOCAL_VALIDATOR.validateLookupRequest((LookupRequestOrBuilder)request);
            internResp = (DatastorePb.GetResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Get, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3GetRequest(RESOLVER, (LookupRequestOrBuilder)request, LocalCloudDatastoreV1Service.getAppId()), DatastorePb.GetResponse.parser());
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        try {
            return LOCAL_SERVICE_CONVERTER.toV1LookupResponse(RESOLVER, internResp).build();
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.internalError(e);
        }
    }

    private RunQueryRequest normalizeRunQueryRequest(RunQueryRequest request) throws ValidationException, InvalidConversionException {
        if (request.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.GQL_QUERY) {
            LOCAL_VALIDATOR.getDatastoreV1Validator().validateGqlQuery((GqlQueryOrBuilder)request.getGqlQuery());
            request = RunQueryRequest.newBuilder((RunQueryRequest)request).setQuery(LOCAL_SERVICE_CONVERTER.getDatastoreProtoConverter().toV1Query((GqlQueryOrBuilder)request.getGqlQuery(), request.getPartitionId())).clearGqlQuery().build();
        }
        return request;
    }

    public RunQueryResponse runQuery(LocalRpcService.Status status, RunQueryRequest request) {
        DatastorePb.QueryResult internResp;
        RunQueryRequest normalizedRequest;
        try {
            normalizedRequest = this.normalizeRunQueryRequest(request);
            LOCAL_VALIDATOR.validateRunQueryRequest(normalizedRequest);
            internResp = (DatastorePb.QueryResult)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.RunQuery, (MessageLite)LOCAL_SERVICE_CONVERTER.toV3Query(RESOLVER, (RunQueryRequestOrBuilder)normalizedRequest, false, EMPTY_INDEX_COLLECTION), DatastorePb.QueryResult.parser());
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        catch (ValidationException e) {
            throw LocalCloudDatastoreV1Service.invalidArgument(e);
        }
        try {
            return LOCAL_SERVICE_CONVERTER.toV1RunQueryResponse(RESOLVER, internResp, request.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.GQL_QUERY ? normalizedRequest.getQuery() : null).build();
        }
        catch (InvalidConversionException e) {
            throw LocalCloudDatastoreV1Service.internalError(e);
        }
    }

    private static boolean exists(LoadingCache<OnestoreEntity.Reference, Boolean> existenceCache, OnestoreEntity.Reference key) {
        try {
            return (Boolean)existenceCache.get((Object)key);
        }
        catch (ExecutionException e) {
            throw LocalCloudDatastoreV1Service.internalError(e);
        }
    }

    private int insert(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn, LoadingCache<OnestoreEntity.Reference, Boolean> existenceCache) throws InvalidConversionException {
        Preconditions.checkArgument((txn == null == (existenceCache == null) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Paths.hasIncompleteLastElement(entity.getKey()) ? 1 : 0) != 0);
        if (txn == null) {
            txn = (DatastorePb.Transaction)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)new DatastorePb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastorePb.Transaction.parser());
            this.insert(entity, txn, LocalCloudDatastoreV1Service.newExistenceCache(txn));
            return ((DatastorePb.CommitResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)txn, DatastorePb.CommitResponse.parser())).getCost().getIndexWrites();
        }
        if (LocalCloudDatastoreV1Service.exists(existenceCache, entity.getKey())) {
            throw LocalCloudDatastoreV1Service.invalidArgument("entity already exists");
        }
        DatastorePb.PutRequest put = new DatastorePb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        DatastorePb.PutResponse resp = (DatastorePb.PutResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)put, DatastorePb.PutResponse.parser());
        if (existenceCache != null) {
            existenceCache.put((Object)entity.getKey(), (Object)true);
        }
        return resp.getCost().getIndexWrites();
    }

    private DatastorePb.PutResponse upsert(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn, LoadingCache<OnestoreEntity.Reference, Boolean> existenceCache) {
        Preconditions.checkArgument((txn == null == (existenceCache == null) ? 1 : 0) != 0);
        DatastorePb.PutRequest put = new DatastorePb.PutRequest();
        if (txn != null) {
            put.setTransaction(txn);
        }
        put.addEntity(entity);
        DatastorePb.PutResponse resp = (DatastorePb.PutResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)put, DatastorePb.PutResponse.parser());
        if (existenceCache != null && !Paths.hasIncompleteLastElement(entity.getKey())) {
            existenceCache.put((Object)entity.getKey(), (Object)true);
        }
        return resp;
    }

    private int update(OnestoreEntity.EntityProto entity, DatastorePb.Transaction txn, LoadingCache<OnestoreEntity.Reference, Boolean> existenceCache) throws InvalidConversionException {
        Preconditions.checkArgument((txn == null == (existenceCache == null) ? 1 : 0) != 0);
        if (txn == null) {
            txn = (DatastorePb.Transaction)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.BeginTransaction, (MessageLite)new DatastorePb.BeginTransactionRequest().setApp(entity.getKey().getApp()), DatastorePb.Transaction.parser());
            this.update(entity, txn, LocalCloudDatastoreV1Service.newExistenceCache(txn));
            return ((DatastorePb.CommitResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Commit, (MessageLite)txn, DatastorePb.CommitResponse.parser())).getCost().getIndexWrites();
        }
        if (!LocalCloudDatastoreV1Service.exists(existenceCache, entity.getKey())) {
            throw LocalCloudDatastoreV1Service.invalidArgument("no entity to update");
        }
        DatastorePb.PutRequest put = new DatastorePb.PutRequest().setTransaction(txn);
        put.addEntity(entity);
        return ((DatastorePb.PutResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Put, (MessageLite)put, DatastorePb.PutResponse.parser())).getCost().getIndexWrites();
    }

    private int delete(OnestoreEntity.Reference key, DatastorePb.Transaction txn, LoadingCache<OnestoreEntity.Reference, Boolean> existenceCache) {
        Preconditions.checkArgument((txn == null == (existenceCache == null) ? 1 : 0) != 0);
        DatastorePb.DeleteRequest delete = new DatastorePb.DeleteRequest();
        if (txn != null) {
            delete.setTransaction(txn);
        }
        delete.addKey(key);
        DatastorePb.DeleteResponse resp = (DatastorePb.DeleteResponse)LocalCloudDatastoreV1Service.makeV3Call(DatastorePb.DatastoreService_3.Method.Delete, (MessageLite)delete, DatastorePb.DeleteResponse.parser());
        if (existenceCache != null) {
            existenceCache.put((Object)key, (Object)false);
        }
        return resp.getCost().getIndexWrites();
    }

    private void applyMutationList(List<Mutation> mutationList, ByteString v1Txn, LoadingCache<OnestoreEntity.Reference, Boolean> existenceCache, CommitResponse.Builder response) throws InvalidConversionException {
        DatastorePb.Transaction txn = v1Txn == null ? null : LOCAL_SERVICE_CONVERTER.toV3Transaction(v1Txn, LocalCloudDatastoreV1Service.getAppId());
        int indexUpdates = 0;
        block6: for (Mutation mutation : mutationList) {
            MutationResult.Builder resultBuilder = response.addMutationResultsBuilder();
            switch (mutation.getOperationCase()) {
                case INSERT: {
                    DatastorePb.PutResponse putResp;
                    OnestoreEntity.EntityProto entityV3 = EntityV3V1Converter.INSTANCE.toV3Entity(RESOLVER, (EntityOrBuilder)mutation.getInsert());
                    if (Paths.hasIncompleteLastElement(entityV3.getKey())) {
                        putResp = this.upsert(entityV3, txn, existenceCache);
                        indexUpdates += putResp.getCost().getIndexWrites();
                        resultBuilder.setKey(EntityV3V1Converter.INSTANCE.toV1Key(RESOLVER, putResp.getKey(0)));
                        continue block6;
                    }
                    indexUpdates += this.insert(entityV3, txn, existenceCache);
                    continue block6;
                }
                case UPSERT: {
                    OnestoreEntity.EntityProto entityV3 = EntityV3V1Converter.INSTANCE.toV3Entity(RESOLVER, (EntityOrBuilder)mutation.getUpsert());
                    DatastorePb.PutResponse putResp = this.upsert(entityV3, txn, existenceCache);
                    indexUpdates += putResp.getCost().getIndexWrites();
                    if (!Paths.hasIncompleteLastElement(entityV3.getKey())) continue block6;
                    resultBuilder.setKey(EntityV3V1Converter.INSTANCE.toV1Key(RESOLVER, putResp.getKey(0)));
                    continue block6;
                }
                case UPDATE: {
                    OnestoreEntity.EntityProto entityV3 = EntityV3V1Converter.INSTANCE.toV3Entity(RESOLVER, (EntityOrBuilder)mutation.getUpdate());
                    indexUpdates += this.update(entityV3, txn, existenceCache);
                    continue block6;
                }
                case DELETE: {
                    OnestoreEntity.Reference keyV3 = EntityV3V1Converter.INSTANCE.toV3Reference(RESOLVER, (KeyOrBuilder)mutation.getDelete());
                    indexUpdates += this.delete(keyV3, txn, existenceCache);
                    continue block6;
                }
            }
            throw new Error("Unexpected mutation operation.");
        }
        response.setIndexUpdates(indexUpdates);
    }

    private static ApiProxy.ApplicationException invalidArgument(Throwable cause) {
        return LocalCloudDatastoreV1Service.invalidArgument(cause.getMessage());
    }

    private static ApiProxy.ApplicationException invalidArgument(String message) {
        return new CanonicalCodeException(Code.INVALID_ARGUMENT, message, 1);
    }

    private static ApiProxy.ApplicationException internalError(Throwable cause) {
        return new CanonicalCodeException(Code.INTERNAL, cause.getMessage(), 3);
    }

    private static <T> T makeV3Call(DatastorePb.DatastoreService_3.Method method, MessageLite req, Parser<T> respParser) {
        return LocalCloudDatastoreV1Service.makeV3Call(method, req, respParser, true);
    }

    static <T> T makeV3Call(DatastorePb.DatastoreService_3.Method method, MessageLite req, Parser<T> respParser, boolean translateToCanonicalErrorCode) {
        byte[] responseBytes;
        try {
            responseBytes = ApiProxy.makeSyncCall((String)"datastore_v3", (String)method.name(), (byte[])req.toByteArray());
        }
        catch (ApiProxy.ApplicationException e) {
            if (translateToCanonicalErrorCode) {
                throw new CanonicalCodeException(DatastoreHelper.getGoogleRpcCanonicalCodeForAppError(e.getApplicationError()), e.getErrorDetail(), e.getApplicationError());
            }
            throw e;
        }
        try {
            return (T)respParser.parseFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw LocalCloudDatastoreV1Service.internalError(e);
        }
    }

    static String getAppId() {
        return ApiProxy.getCurrentEnvironment().getAppId();
    }

    static class CanonicalCodeException
    extends ApiProxy.ApplicationException {
        private final int originalApplicationError;

        public CanonicalCodeException(Code canonicalCode, String errorDetail, int datastoreV3Error) {
            super(canonicalCode.getNumber(), errorDetail);
            this.originalApplicationError = datastoreV3Error;
        }

        public int getOriginalApplicationError() {
            return this.originalApplicationError;
        }
    }
}

