/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.DatabaseName;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashSet;

public class CloudDatastoreV1ServiceValidator {
    private final CloudDatastoreV1Validator validatorV1;
    private static final ValidationConstraint LOOKUP_CONSTRAINT = ValidationConstraint.LOOKUP.withContext(ValidationConstraint.Context.PRENORMALIZATION);
    private static final ValidationConstraint ALLOCATE_ID_CONSTRAINT = ValidationConstraint.ALLOCATE_ID.withContext(ValidationConstraint.Context.PRENORMALIZATION);
    private static final ValidationConstraint QUERY_CONSTRAINT = ValidationConstraint.QUERY.withContext(ValidationConstraint.Context.PRENORMALIZATION);

    public CloudDatastoreV1ServiceValidator(CloudDatastoreV1Validator validatorV1) {
        this.validatorV1 = validatorV1;
    }

    public CloudDatastoreV1Validator getDatastoreV1Validator() {
        return this.validatorV1;
    }

    public void validateCommitRequest(boolean isTrusted, CommitRequestOrBuilder req) throws ValidationException {
        DatabaseName dbName = this.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        boolean hasTransaction = !req.getTransaction().isEmpty();
        this.validatorV1.validateCommitMode(req.getMode(), hasTransaction);
        for (Mutation mutation : req.getMutationsList()) {
            ValidationConstraint constraint = CloudDatastoreV1Validator.constraintForMutation(mutation).withContext(isTrusted, ValidationConstraint.Context.PRENORMALIZATION);
            this.validatorV1.validateMutation(constraint, dbName, mutation);
        }
        if (!hasTransaction) {
            HashSet completeKeysSeen = Sets.newHashSetWithExpectedSize((int)req.getMutationsCount());
            for (Mutation mutation : req.getMutationsList()) {
                Key key = CloudDatastoreV1ServiceValidator.getKey(mutation);
                if (Paths.hasIncompleteLastElement(key)) continue;
                ValidationException.validateAssertion(completeKeysSeen.add(key), "A non-transactional commit may not contain multiple mutations affecting the same entity.", new Object[0]);
            }
        }
    }

    private static Key getKey(Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return mutation.getInsert().getKey();
            }
            case UPDATE: {
                return mutation.getUpdate().getKey();
            }
            case UPSERT: {
                return mutation.getUpsert().getKey();
            }
            case DELETE: {
                return mutation.getDelete();
            }
        }
        throw new ValidationException("Mutation is missing operation.");
    }

    public void validateLookupRequest(LookupRequestOrBuilder req) throws ValidationException {
        DatabaseName databaseName = this.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        this.validatorV1.getEntityValidator().validateKeys(LOOKUP_CONSTRAINT, databaseName, req.getKeysList());
    }

    public void validateAllocateIdsRequest(AllocateIdsRequestOrBuilder req) throws ValidationException {
        DatabaseName databaseName = this.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        this.validatorV1.getEntityValidator().validateKeys(ALLOCATE_ID_CONSTRAINT, databaseName, req.getKeysList());
    }

    public void validateRunQueryRequest(RunQueryRequest req) throws ValidationException {
        DatabaseName databaseName = this.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        this.validatorV1.getEntityValidator().validateDatabaseNameMatches(databaseName, req.getPartitionId().getProjectIdBytes(), req.getPartitionId().getDatabaseIdBytes());
        Preconditions.checkArgument((req.getQueryTypeCase() != RunQueryRequest.QueryTypeCase.GQL_QUERY ? 1 : 0) != 0, (Object)"RunQueryRequest not normalized");
        this.validatorV1.getEntityValidator().validatePartitionId(QUERY_CONSTRAINT, req.getPartitionIdOrBuilder());
        ValidationException.validateAssertion(req.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.QUERY, "one of fields Query.query and Query.gql_query must be set", new Object[0]);
        this.validatorV1.validateQuery(QUERY_CONSTRAINT, req.getReadOptionsOrBuilder().getReadConsistency() == ReadOptions.ReadConsistency.STRONG, (QueryOrBuilder)req.getQuery());
    }

    public void validateRollbackRequest(RollbackRequestOrBuilder req) throws ValidationException {
        this.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        ValidationException.validateAssertion(!req.getTransaction().isEmpty(), "transaction required", new Object[0]);
    }

    public void validateBeginTransactionRequest(BeginTransactionRequestOrBuilder req) throws ValidationException {
        this.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
    }

    private DatabaseName createAndValidateRequiredDatabaseName(ByteString projectId, ByteString databaseId) throws ValidationException {
        ValidationException.validateAssertion(!projectId.isEmpty(), "missing project id in header", new Object[0]);
        return this.validatorV1.getEntityValidator().createAndValidateDatabaseName(projectId, databaseId);
    }
}

