/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.DevQueue;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.appengine.api.taskqueue.dev.UrlFetchJobDetail;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.DevSocketImplFactory;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.QueueXml;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.spi.TriggerFiredBundle;

class DevPushQueue
extends DevQueue {
    static final int DEFAULT_BUCKET_SIZE = 5;
    private final Scheduler scheduler;
    private final String baseUrl;
    private final Clock clock;
    private final LocalTaskQueueCallback callback;

    @Override
    TaskQueuePb.TaskQueueMode.Mode getMode() {
        return TaskQueuePb.TaskQueueMode.Mode.PUSH;
    }

    DevPushQueue(QueueXml.Entry queueXmlEntry, Scheduler scheduler, String baseUrl, Clock clock, LocalTaskQueueCallback callback) {
        super(queueXmlEntry);
        this.scheduler = scheduler;
        this.baseUrl = baseUrl;
        this.clock = clock;
        this.callback = callback;
        if (queueXmlEntry.getRate() != null) {
            if (queueXmlEntry.getRate() == 0.0) {
                try {
                    scheduler.pauseTriggerGroup(this.getQueueName());
                }
                catch (SchedulerException e) {
                    throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INTERNAL_ERROR.getValue(), e.getMessage());
                }
            }
        } else {
            throw new RuntimeException("Rate must be specified for push queue.");
        }
    }

    private synchronized String scheduleTask(TaskQueuePb.TaskQueueAddRequest addRequest) {
        String taskName = addRequest.hasTaskName() && !addRequest.getTaskName().isEmpty() ? addRequest.getTaskName() : DevPushQueue.genTaskName();
        try {
            if (this.scheduler.getJobDetail(taskName, this.getQueueName()) != null) {
                throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.TASK_ALREADY_EXISTS.getValue());
            }
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INTERNAL_ERROR.getValue(), e.getMessage());
        }
        TaskQueuePb.TaskQueueRetryParameters retryParams = this.getRetryParameters(addRequest);
        long etaMillis = addRequest.getEtaUsec() / 1000L;
        SimpleTrigger trigger = new SimpleTrigger(taskName, this.getQueueName());
        trigger.setStartTime(new Date(etaMillis));
        JobDetail jd = this.newUrlFetchJobDetail(taskName, this.getQueueName(), addRequest, retryParams);
        try {
            this.scheduler.scheduleJob(jd, trigger);
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INTERNAL_ERROR.getValue(), e.getMessage());
        }
        return taskName;
    }

    JobDetail newUrlFetchJobDetail(String taskName, String queueName, TaskQueuePb.TaskQueueAddRequest addRequest, TaskQueuePb.TaskQueueRetryParameters retryParams) {
        for (TaskQueuePb.TaskQueueAddRequest.Header header : addRequest.headers()) {
            String host;
            if (!header.getKey().equals("Host") || (host = header.getValue()) == null || !host.startsWith("localhost:")) continue;
            String string = String.valueOf(host);
            return new UrlFetchJobDetail(taskName, queueName, addRequest, string.length() != 0 ? "http://".concat(string) : new String("http://"), this.callback, this.queueXmlEntry, retryParams);
        }
        return new UrlFetchJobDetail(taskName, queueName, addRequest, this.baseUrl, this.callback, this.queueXmlEntry, retryParams);
    }

    @Override
    TaskQueuePb.TaskQueueAddResponse add(TaskQueuePb.TaskQueueAddRequest addRequest) {
        if (addRequest.getMode() != TaskQueuePb.TaskQueueMode.Mode.PUSH.getValue()) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_MODE.getValue());
        }
        if (!addRequest.getQueueName().equals(this.getQueueName())) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_REQUEST.getValue());
        }
        String taskName = this.scheduleTask(addRequest);
        TaskQueuePb.TaskQueueAddResponse addResponse = new TaskQueuePb.TaskQueueAddResponse();
        if (!addRequest.hasTaskName() || addRequest.getTaskName().isEmpty()) {
            addRequest.setTaskName(taskName);
            addResponse.setChosenTaskName(taskName);
        }
        return addResponse;
    }

    List<String> getSortedJobNames() throws SchedulerException {
        String[] jobNames = this.scheduler.getJobNames(this.getQueueName());
        List<String> jobNameList = Arrays.asList(jobNames);
        Collections.sort(jobNameList);
        return jobNameList;
    }

    @Override
    QueueStateInfo getStateInfo() {
        ArrayList<QueueStateInfo.TaskStateInfo> taskInfoList = new ArrayList<QueueStateInfo.TaskStateInfo>();
        try {
            for (String jobName : this.getSortedJobNames()) {
                Trigger[] triggers;
                UrlFetchJobDetail jd = (UrlFetchJobDetail)this.scheduler.getJobDetail(jobName, this.getQueueName());
                if (jd == null || (triggers = this.scheduler.getTriggersOfJob(jobName, this.getQueueName())).length == 0) continue;
                if (triggers.length != 1) {
                    String string = this.getQueueName();
                    throw new IllegalStateException(new StringBuilder(37 + String.valueOf(jobName).length() + String.valueOf(string).length()).append("Multiple triggers for task ").append(jobName).append(" in queue ").append(string).toString());
                }
                long execTime = triggers[0].getStartTime().getTime();
                taskInfoList.add(new QueueStateInfo.TaskStateInfo(jd.getName(), execTime, jd.getAddRequest(), this.clock));
            }
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INTERNAL_ERROR.getValue());
        }
        Collections.sort(taskInfoList, new Comparator<QueueStateInfo.TaskStateInfo>(){

            @Override
            public int compare(QueueStateInfo.TaskStateInfo t1, QueueStateInfo.TaskStateInfo t2) {
                return Long.compare(t1.getEtaMillis(), t2.getEtaMillis());
            }
        });
        return new QueueStateInfo(this.queueXmlEntry, taskInfoList);
    }

    @Override
    boolean deleteTask(String taskName) {
        try {
            return this.scheduler.deleteJob(taskName, this.getQueueName());
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INTERNAL_ERROR.getValue());
        }
    }

    @Override
    void flush() {
        try {
            for (String name : this.scheduler.getJobNames(this.getQueueName())) {
                this.scheduler.deleteJob(name, this.getQueueName());
            }
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INTERNAL_ERROR.getValue());
        }
    }

    private JobExecutionContext getExecutionContext(UrlFetchJobDetail jobDetail) {
        SimpleTrigger trigger = new SimpleTrigger(jobDetail.getTaskName(), jobDetail.getQueueName());
        trigger.setJobDataMap(jobDetail.getJobDataMap());
        TriggerFiredBundle bundle = new TriggerFiredBundle(jobDetail, trigger, null, false, null, null, null, null);
        return new JobExecutionContext(this.scheduler, bundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean runTask(String taskName) {
        Job job;
        JobExecutionContext context;
        try {
            UrlFetchJobDetail jd = (UrlFetchJobDetail)this.scheduler.getJobDetail(taskName, this.getQueueName());
            if (jd == null) {
                return false;
            }
            context = this.getExecutionContext(jd);
            job = (Job)jd.getJobClass().newInstance();
        }
        catch (SchedulerException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
        boolean callerMode = DevSocketImplFactory.setSocketNativeMode((boolean)true);
        try {
            job.execute(context);
        }
        catch (JobExecutionException e) {
            String string = this.getQueueName();
            logger.log(Level.SEVERE, new StringBuilder(35 + String.valueOf(taskName).length() + String.valueOf(string).length()).append("Exception executing task ").append(taskName).append(" on queue ").append(string).toString(), e);
        }
        catch (RuntimeException rte) {
            String string = this.getQueueName();
            logger.log(Level.SEVERE, new StringBuilder(35 + String.valueOf(taskName).length() + String.valueOf(string).length()).append("Exception executing task ").append(taskName).append(" on queue ").append(string).toString(), rte);
        }
        finally {
            DevSocketImplFactory.setSocketNativeMode((boolean)callerMode);
        }
        return true;
    }
}

